#!/usr/bin/php -e

<?php
/** Chargement des fichiers de config */
if( !@include_once("../../../"."libconf/app_conf.php") ) {
  if( !@include_once("../../"."libconf/app_conf.php") ) {
    if( !@include_once("../"."libconf/app_conf.php") ) {
      require_once(""."libconf/app_conf.php");
    }
  }
}

// initialisation des langues, nécessaire si $tabLg n'est pas défini dans le fichier app_conf.php
require_once(ALK_ALKANET_ROOT_PATH."lib/lib_locales.php");
$bFrontOffice = false;
initAlkLocale();

require_once(ALK_ALKANET_ROOT_PATH."lib/app_conf_alkanet.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkrequest.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php");

/** 
 * Pour s'assurer qu'on est en PHP_CLI, on vérifie l'existance des paramètres argc/argv normalement toujours et uniquement disponible dans ce mode
 */
ini_set('register_argc_argv', 0);
if( PHP_SAPI != "cli" ) {
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");
  writeHTTP404();
  exit();
}

define("ALK_B_ATYPE_ESPACE", true);
AlkFactory::loadConstants(array(-1), array(-1), array(-1));

$oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_IEDIT);

$mode   = ( isset($argv[1]) ? $argv[1] : "" );
$iFirst = ( isset($argv[2]) ? $argv[2] : "0" );
$iLast  = ( isset($argv[3]) ? $argv[3] : "-1" );

switch ( $mode ) {
  case "data" :
    echo "[".date("d/m/Y H:m:s", time())."] Début indexation des documents de ".$iFirst." jusqu'à ".( $iLast != -1 ? $iLast : "la fin" )." ... \n";
    $oDsData = $oQuery->getDs("select DATA_ID from IEDIT_DATA where DATATYPE_ID=".ALK_ATYPE_ID_DOC, $iFirst, $iLast);
//    print_r($oDsData);die();
    $i = 0;
    while ( $oDrData = $oDsData->getRowIter() ) {
      $data_id = $oDrData->getValueName("DATA_ID");
      $oQuery->indexData("IEDIT_DATA", $data_id);
      echo "[".date("d/m/Y H:m:s", time())."]     Indexation de la donnée data_id=".$data_id." effectuée \n";
      $i++;
    }
    echo "[".date("d/m/Y H:m:s", time())."] Fin indexation des documents de ".$iFirst." jusqu'à ".( $iLast != -1 ? $iLast : "la fin" ).", ".$i." documents réindexés \n";
  break;
  case "pj" :
    echo "[".date("d/m/Y H:m:s", time())."] Début indexation des pièce-jointes de ".$iFirst." jusqu'à ".( $iLast != -1 ? $iLast : "la fin" )." ... \n";
    $oSearchSolr = $oQuery->initSearcherSolr();
    if ( !is_null($oSearchSolr) ){
      $strSql = "select pj.*, ac.CONT_ID" .
        " from IEDIT_PJ pj" .
        " inner join IEDIT_DATA d on d.DATA_ID=pj.DATA_ID" .
        " inner join SIT_APPLI_CONT ac on ac.APPLI_ID=d.APPLI_ID";
      $oDsPj = $oQuery->getDs($strSql, $iFirst, $iLast);
//      print_r($oDsPj);die();
      $i = 0;
      while ( $oDrPj = $oDsPj->getRowIter() ) {
        $pj_id = $oDrPj->getValueName("PJ_ID");
        $data_id = $oDrPj->getValueName("DATA_ID");
        $agent_id = $oDrPj->getValueName("PJ_AGENTCREA");
        $strFileName = $oDrPj->getValueName("PJ_FILE");
        $strDirUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_IEDIT, true).$oDrPj->getValueName("CONT_ID")."/";
        if ( file_exists(ALK_ALKANET_ROOT_PATH.$strDirUpload.$strFileName) ) {
          // rien à faire
        } else if ( file_exists(ALK_ALKANET_ROOT_PATH.$strDirUpload."pj/".$strFileName) ) {
          $strDirUpload .= "pj/";
        } else if ( file_exists(ALK_ALKANET_ROOT_PATH.$strDirUpload."visuel/".$strFileName) ) {
          $strDirUpload .= "visuel/";
        } else {
          $strDirUpload = "";
        }
        if ( $strDirUpload ) {
          $bRes = $oSearchSolr->AddPj($pj_id, "IEDIT_PJ", $data_id, "data_pj", $agent_id, ALK_ALKANET_ROOT_PATH, $strDirUpload, $strFileName, "", "");
          if ( $bRes ) {
            echo "[".date("d/m/Y H:m:s", time())."]     SUCESS : Indexation du fichier \"".$strFileName."\" de la pièce-jointe pj_id=".$pj_id." effectuée \n";
          } else {
            echo "[".date("d/m/Y H:m:s", time())."]     WARNING : Indexation du fichier \"".$strFileName."\" de la pièce-jointe pj_id=".$pj_id." non effectuée, echec ou extension non prise en compte \n";
          }
        } else {
          echo "[".date("d/m/Y H:m:s", time())."]     ECHEC : le fichier \"".$strFileName."\" de la pièce-jointe pj_id=".$pj_id." n'existe pas \n";
        }
        $i++;
      }
      echo "[".date("d/m/Y H:m:s", time())."] Fin indexation des pièces-jointes de ".$iFirst." jusqu'à ".( $iLast != -1 ? $iLast : "la fin" ).", ".$i." pièces-jointes réindexées \n";
    } else {
      echo "[".date("d/m/Y H:m:s", time())."] Erreur SearcherSolr \n";
    }
  break;
  default :
    echo "data|pj [iFirst] [iLast] \n";
  break;
}
?>
