<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

define("ALK_B_ATYPE_ANNU", true);

// cle etrangere cont_id sur table sit_profil (créé avant SIT_CONTENEUR) 
$tabFk["sit_profil"] = array(
  "fk_sitprofil_contid" => array("ffk" => "cont_id", "tpk" => "sit_conteneur", "fpk" => "cont_id"),
  );
 
// Table : SIT_LISTE, Gestion des listes de diffusion
//liste_prive : =0 publique pour cont_id
//              =1 publique à tous les espace accessibles
//              =2 privée pour cont_id
//              =3 privée à tous les espaces accessibles
// liste_type : =0 liste diff (mes listes), 
//              =1 liste circulaire (module synd), 
//              =2 liste abonnement à une catégorie ou donnée (liste implicite)
//              =3 liste d'abonnement explicite (lettre d'information)
$tabTable["sit_liste"] = array(
  "liste_id"          => array("type" => "int", "dn" => "NOT NULL"),
  "liste_intitule_fr" => array("type" => "varchar(80)", "dn" => ""),
  "liste_intitule_en" => array("type" => "varchar(80)", "dn" => ""),
  "liste_desc_fr"     => array("type" => "varchar(4000)", "dn" => ""),
  "liste_desc_en"     => array("type" => "varchar(4000)", "dn" => ""),
  "liste_prive"       => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "liste_lock"        => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "liste_valide"      => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "agent_id"          => array("type" => "int", "dn" => ""),
  "cont_id"           => array("type" => "int", "dn" => "NOT NULL"),
  "liste_type"        => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  );
$tabPk["sit_liste"]["pk_sit_liste"] = "liste_id";

$tabIdx["sit_liste"] = array(
  "sitliste_agentid_fk" => "agent_id",
  "sitliste_contid_fk" => "cont_id",
  );

$tabFk["sit_liste"] = array(
  "fk_sitliste_agentid" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_sitliste_contid" => array("ffk" => "cont_id", "tpk" => "sit_conteneur", "fpk" => "cont_id"),
  );

$tabSeq["seq_sit_liste"] = "10";

// table sit_liste_sliste
$tabTable["sit_liste_sliste"] = array(
  "liste_id"   => array("type" => "int", "dn" => "NOT NULL"),
  "sliste_id"  => array("type" => "int", "dn" => "NOT NULL"),
  );
$tabPk["sit_liste_sliste"]["pk_sit_liste_sliste"] = "liste_id, sliste_id";

$tabIdx["sit_liste_sliste"] = array(
  "sitsliste_listeid_fk"  => "liste_id",
  "sitsliste_slisteid_fk" => "sliste_id",
  );

$tabFk["sit_liste_sliste"] = array(
  "fk_sitsliste_listeid"  => array("ffk" => "liste_id",  "tpk" => "sit_liste", "fpk" => "liste_id"),
  "fk_sitsliste_slisteid" => array("ffk" => "sliste_id", "tpk" => "sit_liste", "fpk" => "liste_id"),
  );

// Table : SIT_ABONNE : liste des abonnées par application
$tabTable["sit_abonne"] = array(
  "abonne_id" => array("type" => "int", "dn" => "NOT NULL"),
  "abonne_nom" => array("type" => "varchar(150)", "dn" => ""),
  "abonne_prenom" => array("type" => "varchar(150)", "dn" => ""),
  "abonne_pseudo" => array("type" => "varchar(150)", "dn" => ""),
  "abonne_adresse" => array("type" => "varchar(255)", "dn" => ""),
  "abonne_cp" => array("type" => "varchar(50)", "dn" => ""),
  "abonne_ville" => array("type" => "varchar(200)", "dn" => ""),
  "abonne_pays" => array("type" => "varchar(200)", "dn" => ""),
  "abonne_mail" => array("type" => "varchar(255)", "dn" => ""),
  "abonne_tel" => array("type" => "varchar(100)", "dn" => ""),
  "abonne_pwd" => array("type" => "varchar(80)", "dn" => ""),
  "abonne_date_inscr" => array("type" => "datetime", "dn" => ""),
  "abonne_valide" => array("type" => "int", "dn" => ""),
  "abonne_date_desinscr" => array("type" => "datetime", "dn" => ""),
  "agent_id" => array("type" => "int", "dn" => "default ".ALK_USER_ID_INTERNET." not null"),
  "abonne_desc" => array("type" => "varchar(255)", "dn" => "")
  );
$tabPk["sit_abonne"]["pk_sit_abonne"] = "abonne_id";
$tabIdx["sit_abonne"] = array(
  "sitabonne_agentid_fk" => "agent_id",
  );
$tabFk["sit_abonne"] = array(
  "fk_agentid_sitabonne" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );
$tabSeq["seq_sit_abonne"] = "10";

// sit_abonne_liste
$tabTable["sit_abonne_liste"] = array(
  "abonne_id" => array("type" => "int", "dn" => "NOT NULL"),
  "liste_id" => array("type" => "int", "dn" => "NOT NULL"),
  "abonneliste_date" => array("type" => "datetime", "dn" => ""),
  "abonneliste_auto" => array("type" => "int", "dn" => "default 0"),
  );

$tabPk["sit_abonne_liste"]["pk_sit_abonne_liste"] = "abonne_id,liste_id";

$tabIdx["sit_abonne_liste"] = array(
  "abonneliste_abonneid_fk" => "abonne_id",
  "abonneliste_listeid_fk" => "liste_id",
  );

$tabFk["sit_abonne_liste"] = array(
  "fk_abonneliste_abonneid" => array("ffk" => "abonne_id", "tpk" => "sit_abonne", "fpk" => "abonne_id"),
  "fk_abonneliste_listeid" => array("ffk" => "liste_id", "tpk" => "sit_liste", "fpk" => "liste_id"),
  );

// Type application
$tabIns[] = "INSERT INTO SIT_APPLI_TYPE (ATYPE_ID, ATYPE_ID_DIST, ATYPE_INTITULE, ATYPE_ABREV, ATYPE_URL, ATYPE_URL_ADMIN, ATYPE_URL_SITE,".
  " ATYPE_DROIT, ATYPE_DISPO, ATYPE_DESC, ATYPE_URL_TARGET, ATYPE_COMPATIBLE, ATYPE_LOGO, ATYPE_ADMIN_LOGO)".
  " VALUES(1, -1, 'Annuaire', 'annu', '', '', NULL, 0, 0, '', '', 1, 'picto01_annuaire.gif', '')";

$tabIns[] = "insert into SIT_ABONNE (ABONNE_ID, AGENT_ID, ABONNE_NOM, ABONNE_PRENOM, ABONNE_MAIL, ABONNE_PWD, ABONNE_PSEUDO)
  select a.AGENT_ID, a.AGENT_ID, a.AGENT_NOM, a.AGENT_PRENOM, a.AGENT_MAIL, a.AGENT_PWD, a.AGENT_LOGIN
  from SIT_AGENT a
  where AGENT_ID=1";

$tabIns[] = "update SIT_ABONNE set ABONNE_VALIDE = 1 where AGENT_ID = 1";

//   Constante PHP
$tabIns[] = "delete from SIT_CONSTANTE where ATYPE_ID=1";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (-1,-1,'ALK_B_ATYPE_ANNU','true',3,'Module installé',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)".
  " values (1,-1,'ALK_B_ANNU_ADMIN_ANIM','false',3,'".$dbConn->analyseSql("Possibilité d'administrer l'annuaire par un animateur")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_MISSION_PROFIL1','false',3,'Mission restreint aux admins principaux ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_SEND_MAIL','true',3,'Envoi mail sur gestion annuaire',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_FILTER_MISSION','true',3,'Filtre sur mission sur sélection multiple annuaire ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_MAJ_PROFIL','false',3,'Permettre au admin service de gérer les profils personnalisés ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_MISSION','true',3,'Prise en compte des missions ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_SERV_NIV_MAX','4',1,'Niveau de recherche max sur les service = 0,1,2 ou 3 ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_ORGA','true',3,'Organigramme des services accessibles ',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_USER_CHANGE_LOGIN','true',3,'".$dbConn->analyseSql("L'utilisateur peut changer son login")."',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_USER_CHANGE_PWD','true',3,'".$dbConn->analyseSql("L'utilisateur peut changer son mot de passe")."',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_LG_MIN_PWD','3',1,'Longueur minimale pour un mot de passe ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_LG_MAX_PWD','10',1,'Longueur maximale pour un mot de passe ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_LG_MAX_LOGIN','255',1,'Longueur maximale pour un identifiant de connexion',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_ANIM_ADD_ANIM','false',3,'".$dbConn->analyseSql("Possibilité d'attribuer le privilège animateur dans l'annuaire")."',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_SERVICE_ETAT','true',3,'Choix type état ou non (type état par défaut) ',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_COLLECT_PWD_SIT','true',3,'SIT est le mot de passe par défaut pour collectivité locales ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_COLLECT_OLD_PWD','COLLECTIVI',0,'Sigle de service à remplacer par SIT ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_COLLECT_NEW_PWD','SIT',0,'Nouveau mot de passe par défaut pour les collectivités ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_FONCTION','false',3,'Gestion des fonctions',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_TRIGRAMME','False',3,'Champ trigramme accessible',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_AFFECTTERRITOIRE','False',3,'Champ territoire accessible',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_CH_FONCTION','true',3,'Champ fonction accessible', 2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_DEFAULTPWD','PART',0,'Mot de passe par défaut',2)";
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID, APPLI_ID, CONST_INTITULE,  CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN)
 VALUES(1, -1, 'ALK_B_ANNU_IMPORT_EMAIL', 'false', 'Possibilité de mettre à jour les courriels par import', 3, 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_IMPORTEXPORT','true',3,'Présence de l''onglet import/export',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_PWD_ENCRYPTION','md5',0,'Encryptage du mot de passe',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_PWD_SENDMAIL','false',3,'Possibilité envoi mot de passe en clair par mail',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_ANNU_LG_MAX_PSEUDO','20',1,'Longueur maximale pour un pseudo abonné',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_LOGIN_USE_MAIL','false',3,'Utilisation du mail comme login',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_AGENT_GENERIC','false',3,'Permet de définir si la création de comptes génériques est possibles ou non',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (-1,-1,'ALK_B_ANNU_LSDIF_SIMPLE_ADD', 'false', 3, 'Utiliser la sélection multiple avec 1 seul champ filtre : nom', 2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_ABONNES','true',3,'Prise en compte des abonnés ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) 
 values (1,-1,'ALK_B_ANNU_SERVICE_LOGO','false',3,'".$dbConn->analyseSql("Permettre à l'utilisateur de sélectionner un logo pour un service")."',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)
 values (1,-1,'ALK_B_ANNU_CLOISONNEMENT_SERVICE','false',3,'Permettre le cloisonnement des informations entre services',2)";

//   Mailing

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES ('ANNU_AJOUT_UTIL', 'Envoyé après création d un compte utilisateur', '{\$apptitle} : {\$msgTitle}', ".
  "'<html><p>{\$dest},<br/><br/>".
  "{\$msg}".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES ('ANNU_MODIF_PARAM_CON', 'Envoyé après modification des paramètres de connexion', '{\$apptitle} : {\$msgTitle}', ".
  "'<html><p>{\$dest},<br/><br/>".
  "{\$msg}".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";
  
$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES ('ANNU_INIT_PARAM_CON', 'Envoyé après réinitialisation des paramètres de connexion', '{\$apptitle} : {\$msgTitle}', ".
  "'<html><p>{\$dest},<br/><br/>".
  "{\$msg}".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES ('ANNU_UTIL_VALIDE', 'Envoyé après validation d un compte utilisateur', '{\$apptitle} : {\$msgTitle}', ".
  "'<html><p>{\$dest},<br/><br/>".
  "{\$msg}".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";
  
$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES ('ANNU_UTIL_ACTIVE', 'Envoyé après activation d un compte utilisateur', '{\$apptitle} : {\$msgTitle}', ".
  "'<html><p>{\$dest},<br/><br/>".
  "{\$msg}".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)".
  " VALUES ('ANNU_UTIL_REFUS', 'Envoyé après refus de créer un compte utilisateur', '{\$apptitle} : {\$msgTitle}', ".
  "'<html><p>{\$dest},<br/><br/>".
  "{\$msg}".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

?>
