<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(AlkFactory::getModulePath(ALK_ATYPE_ID_ANNU)."classes/alkimportannu.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormImportUser
 * 
 * Classe d'import de l'Annuaire
 */
class AlkHtmlFormImportUser extends AlkHtmlForm {

  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formImportUser"); 
    
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $cont_id = AlkRequest::getToken("cont_id", -1);
    $strParam = "cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_ADMIN.
      "&iSheet=".ALK_SHEET_IMPORTEXPORT."&iSSheet=".ALK_SHEET_IMPORT_USER."&iMode=".$iMode;    
    $strAction = ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParam);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, $strAction);    
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */  
  public function doSql() { }  
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $iSendMailUser = AlkRequest::_POST("sendMailUser", "0");
    
    $this->oAppli->setSendMail($iSendMailUser=="1");
    
    $ag_id = AlkFactory::getSProperty("user_id", "-1");;
    $urlFileError = AlkFactory::getUploadUrl(ALK_ATYPE_ID_ANNU).$ag_id."_err.txt";
    $strFileError = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU).$ag_id."_err.txt";
    $urlFileWarning = AlkFactory::getUploadUrl(ALK_ATYPE_ID_ANNU).$ag_id."_warning.txt";
    $strFileWarning = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU).$ag_id."_warning.txt";
    delFile($strFileError);
    delFile($strFileWarning);
    
    $pathFile = "";
    $strFileName = "";
    
    //if( $fin != "1" ) {
    //  $strParam = "cont_appli_id=".$cont_appli_id."&cont_id=".$cont_id;
    
    //  if( $iMode != "annuler" ) {
        //upload du fichier
        $strFileName = DoUpload("imp_fic", $ag_id."_", AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU, true), 0, "");
        if( !is_string($strFileName))
          $strFileName = "";
        if( $strFileName!="" )
          $pathFile = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU).$strFileName;
    //  }
    //}
    $strFichier_Import = AlkFactory::getUploadPath(ALK_ATYPE_ID_ANNU).$strFileName;
    $strFichier_Erreur = $strFileError;
    $strFichier_Warning = $strFileWarning; 
    
    $tabProfils = $this->oAppli->oQuery->GetDs_champsImport("SIT_PROFIL where CONT_ID=0","PROFIL_ID", "PROFIL_INTITULE");
    $tabMissions = $this->oAppli->oQuery->GetDs_champsImport("SIT_MISSION","MISSION_INTITULE","MISSION_ID");
    $tabServs2 = $this->oAppli->oQuery->GetDs_champsImport("SIT_SERVICE where SERVICE_NIVEAU=2","SERVICE_INTITULE","SERVICE_ID");
    $tabServs3 = $this->oAppli->oQuery->GetDs_champsImport("SIT_SERVICE where SERVICE_NIVEAU=3","SERVICE_INTITULE","SERVICE_ID");
    $tabServs4 = $this->oAppli->oQuery->GetDs_champsImport("SIT_SERVICE where SERVICE_NIVEAU=4","SERVICE_INTITULE","SERVICE_ID");
    $tabServs1 = $this->oAppli->oQuery->GetDs_champsImport("SIT_SERVICE where SERVICE_NIVEAU=1","SERVICE_INTITULE_COURT","SERVICE_ID");
    
    $intSeparateur = 9;
    $tabImport = array (
                        array("name" => "MODE", "oblig" => 1,"type" =>array("S","M","C") ,"lg" => 0,"index" => 0 ,"mode" => 1),
                        array("name" => "CLE", "oblig" => 1, "type" => "numeric","lg" => 10,"index" => 0 ,"mode" => 0),
                        array("name" => "PROFIL", "oblig" => 1, "type" => $tabProfils, "lg" => 10,"index" => 0 ,"mode" => 2),
                        array("name" => "PRIV", "oblig" => 0, "type" => "numeric","lg" => 10,"index" => 0 ,"mode" => 0),
                        array("name" => "CIVILITE", "oblig" => 0, "type" => array("M","Mme","Mlle"),"lg" => 0,"index" => 0 ,"mode" => 1),
                        array("name" => "NOM", "oblig" => 1, "type" => "string","lg" => 100,"index" => 0 ,"mode" => 0),
                        array("name" => "PRENOM", "oblig" => 1, "type" => "string","lg" => 40,"index" => 0 ,"mode"=> 0),
                        array("name" => "PWD", "oblig" => 0, "type" => "string","lg" => 40,"index" => 0 ,"mode"=> 0),
                        array("name" => "FONCTION", "oblig" => 0, "type" => "string","lg" => 255,"index" => 0 ,"mode" => 0),
                        array("name" => "LOGIN", "oblig" => 1, "type" => "string","lg" => 20,"index" => 0 ,"mode" => 0),
                        array("name" => "ADRESSE_1", "oblig" => 0, "type" => "string","lg" => 50,"index" => 0 ,"mode" => 0),
                        array("name" => "ADRESSE_2", "oblig" => 0, "type" => "string","lg" => 50,"index" => 0 ,"mode" => 0),
                        array("name" => "ADRESSE_3", "oblig" => 0, "type" => "string","lg" => 50,"index" => 0 ,"mode" => 0),
                        array("name" => "CODE_POSTAL", "oblig" => 0, "type" => "string","lg" => 10,"index" => 0 ,"mode" => 0),
                        array("name" => "VILLE", "oblig" => 0, "type" => "string","lg" => 50,"index" => 0 ,"mode" => 0),
                        array("name" => "PAYS", "oblig" => 0, "type" => "string","lg" => 50,"index" => 0 ,"mode" => 0),
                        array("name" => "ADR_DESC", "oblig" => 0, "type" => "string","lg" => 4000,"index" => 0 ,"mode" => 0),
                        array("name" => "TEL_FIXE", "oblig" => 0, "type" => "string","lg" => 30,"index" => 0 ,"mode" => 0),
                        array("name" => "TEL_POSTE", "oblig" => 0, "type" => "string","lg" => 30,"index" => 0 ,"mode" => 0),
                        array("name" => "FAX", "oblig" => 0, "type" => "string","lg" => 30,"index" => 0 ,"mode" => 0),
                        array("name" => "TEL_MOBILE", "oblig" => 0, "type" => "string","lg" => 30,"index" => 0,"mode" => 0),
                        array("name" => "MEL", "oblig" => 0, "type" => "string","lg" => 255,"index" => 0 ,"mode" => 0),
                        array("name" => "COMMENTAIRE", "oblig" => 0, "type" => "string","lg" => 4000,"index" => 0 ,"mode" => 0),
                        array("name" => "VALIDE", "oblig" => 0, "type" => array("0","1"),"lg" => 10,"index" => 0 ,"mode" => 1),
                        array("name" => "SERV_NIV1", "oblig" => 1, "type" => $tabServs1,"lg" => 40,"index" => 0 ,"mode" => 2 ),
                        array("name" => "SERV_NIV2", "oblig" => 0, "type" => $tabServs2,"lg" => 255,"index" => 0 ,"mode" => 2 ),
                        array("name" => "SERV_NIV3", "oblig" => 0, "type" => $tabServs3,"lg" => 255,"index" => 0 ,"mode" => 2 ),
                        array("name" => "SERV_NIV4", "oblig" => 0, "type" => $tabServs4,"lg" => 255,"index" => 0 ,"mode" => 2 ),
                        array("name" => "MISSION1", "oblig" => 0, "type" => $tabMissions,"lg" => 255,"index" => 0 ,"mode" => 2 ),
                        array("name" => "MISSION2", "oblig" => 0, "type" => $tabMissions,"lg" => 255,"index" => 0 ,"mode" => 2 ),
                        array("name" => "MISSION3", "oblig" => 0, "type" => $tabMissions,"lg" => 255,"index" => 0 ,"mode" => 2 ),
                        );
    set_time_limit(0);
    $bTes = true;
    $intTes = 1;
    $tabSup = array("CLE", "LOGIN");
    $tabAjout = array ("PROFIL", "SERV_NIV1");
    $tabModif = array();
    $objErreur = new AlkImportError($strFichier_Erreur);
    $objWarning = new AlkImportWarning($strFichier_Warning);
  	$objoQuery  = $this->oAppli->oQuery;
  	$objoQueryAction = $this->oAppli->oQueryAction;
  	$objoSpace	= $this->oAppli->getProperty("oSpace");
  	$objoAppli  = $this->oAppli;
    $objImport = new AlkImportAnnu($strFichier_Import, $tabImport, $tabSup, $tabAjout, $tabModif, 
                                   $objErreur,$objWarning, $objoQuery, $objoQueryAction, 
                                   $objoSpace, $objoAppli);
    
    $iTes = 0;
    $intTest = $objImport->parseFile($intSeparateur);
    if( $intTest == 0 ) {
      $intTes = $objImport->parseLines($intSeparateur);
      if( $intTes == 0 ) {
        $iTes = $objImport->integrate($intSeparateur);
      }
    }
    
    $this->setLabel("Importation des agents dans l'annuaire");
    
    $strHtml = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>";
    if( $intTes == 0 && $iTes == 0 ) {
      $strHtml .= "Importation effectuée avec succès.";
    } else {
      if( $intTes > 0 ) {
        $strHtml .= "Importation non effectuée pour cause de fichier mal formaté.";
      }
      if( $iTes > 0 ) {
        $strHtml .= "Importation effectuée avec des alertes ou des erreurs.";    
      }
      $bFileAlert = file_exists($strFichier_Warning) && is_file($strFichier_Warning);
      $bFileError = file_exists($strFichier_Erreur) && is_file($strFichier_Erreur);
    
      if( $bFileAlert || $bFileError ) {
        $strHtml .= "<br/><span style='color:red;'>Attention</span> : Vous pouvez consulter ";
        if( $bFileAlert ) {
          $oLink = AlkHtmlFactory::getHtmlButton($urlFileWarning, "les alertes", "", true, "_blank");
          $strHtml .= $oLink->getHtml();
          if( $bFileError )
            $strHtml .= " et ";
        }
        if( $bFileError ) {
          $oLink = AlkHtmlFactory::getHtmlButton($urlFileError, "les erreurs", "", true, "_blank");
          $strHtml .= $oLink->getHtml();
        }
        $strHtml .= ".";
      }
    }
    $strHtml .= "</div>";
    
    $oBlock = $this->addBlock("blockMsg", "", "");
    $otext = AlkHtmlFactory::getHtml($strHtml);
    $oBlock->addCtrl($otext, ALK_HTMLFORM_1L1C);
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_11_import.htm"); 
  }  
}
?>