<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormMissionForm
 * 
 * Classe de gestion formulaire de mission de l'Annuaire
 */
class AlkHtmlFormMissionForm extends AlkHtmlForm 
{
  protected $mission_intitule;
  protected $mission_id;
  protected $strParam;
  
  /**
   *  constructeur par défaut
   * @param oAppli Référence sur l'application associée 
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formMissionForm"); 
    $this->strParam = "&page=".AlkRequest::getToken("page", "1").
      "&strRecherche=".AlkRequest::getToken("strRecherche", "");

    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strParam  = "cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_ADMIN.
      "&iSheet=".ALK_SHEET_MISSION."&iSSheet=".ALK_SHEET_FORM."&iMode=".$iModeForm.$this->strParam;    
    $strAction = ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParam);

    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction); 
  }

   /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   *  iTypeInit  Type de récupération
   */
  protected function setData($iTypeInit)
  {	 
    $mission_id = AlkRequest::getToken("mission_id", AlkRequest::_REQUESTint("mission_id", "-1"));
    
    $this->mission_id       = new AlkFormData($this, "mission_id", $mission_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);     
    $this->mission_intitule = new AlkFormData($this, "mission_intitule", "", ALK_SQL_TEXT);  
  
    $tabData = array(null);
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oDsData = $this->oAppli->oQuery->GetDs_ficheMission($mission_id);
      $tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
      
    foreach ($tabData as $oDrData){
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
    $this->mission_rang->value = $this->mission_id->value;
  }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_MISSION, ALK_SHEET_LIST, $this->strParam);   
    $tabReturn = $this->getTabQuery(array(mb_strtoupper($this->mission_id->name)));
    
    $strTable = "SIT_MISSION"; 
   
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD:
      $this->oAppli->oQueryAction->addWithTabQuery($this, $tabReturn, $strTable);
      break;
      
    case ALK_FORM_MODE_UPDATE:        
      $this->oAppli->oQueryAction->updateWithTabQuery($this, $tabReturn, $strTable, array());
      break;

    case ALK_FORM_MODE_DEL:
      $this->oAppli->oQueryAction->delData($this->mission_id, $strTable);
      break;
    }
     
    return ALK_ALKANET."?token=".$strToken;
  }  
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
 
    $iTxtWidth = 48;
     
    $strTitle = ( $this->iMode == ALK_FORM_MODE_ADD
                  ? _t("Cr&eacute;ation d'une nouvelle mission")
                  : _t("Modification de l'intitul&eacute; d'une mission"));
    
    $oHide = AlkHtmlFactory::getHtmlHidden($this->mission_id);
   
    $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->mission_intitule, _t("Intitulé"), 1, $iTxtWidth, 80);
    $oCtrlTxt->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);

    $oBlock = $this->addBlock("block_mission", $strTitle, "", "100", "390", true);
    $oBlock->addCtrl($oCtrlTxt);
    
    $this->addValidButton("", "", _t("Valider"), _t("Valider la mission"));
    $this->addCancelButton(ALK_TYPESHEET_ADMIN, ALK_SHEET_MISSION, ALK_SHEET_LIST, $this->strParam);
  }
  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_06_mission_form.htm"); 
  }  
}

?>