<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."excel/Workbook.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormRechercheForm
 * 
 * Classe de recherche de l'Annuaire
 */
class AlkHtmlFormRechercheForm extends AlkHtmlForm 
{
  /** dataset contenant le résultat de recherche */
  public $dsSearch;

  /** controles des critères */
  protected $service_id;
  protected $rdept_id;
  protected $rserv1_id;
  protected $rserv2_id;
  protected $rserv3_id;
  protected $rserv4_id;
  protected $ragent_nom;
  protected $rprofil_id;
  protected $rmission_id;
  protected $rliste_id;
  protected $respaceCur;
  protected $ragent_valide;

  /* paramètres du formulaire */
  protected $page;
  protected $nbEltParPage;
  protected $bSearch;
  protected $ragent_adminauth;
  protected $ragent_priv;

  /**
   *  construct par défaut
   * @param oAppli Référence sur l'application en cours
   */  
  public function __construct(AlkAppli $oAppli)
  {   
    parent::__construct($oAppli, "formSearch"); 
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE);     
    $strAction = ALK_ALKANET."?token=".$strToken;
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, $strAction);    
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) 
  { 
    $cont_id  = AlkRequest::getToken("cont_id", "-1");
    $agent_id = AlkFactory::getSProperty("user_id", "-1");
    $dept_id  = -1;//AlkFactory::getSProperty("dept_id", "-1");
    if(defined("ALK_B_ANNU_CLOISONNEMENT_SERVICE") && ALK_B_ANNU_CLOISONNEMENT_SERVICE==true && !AlkFactory::isAnnuAdminAll())
      $this->service_id = AlkFactory::getSProperty("service_id", -1);
    else
      $this->service_id = -1;
    
    $this->rdept_id          = new AlkFormData($this, "rdept_id",     $dept_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rserv1_id         = new AlkFormData($this, "rserv1_id",    "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rserv2_id         = new AlkFormData($this, "rserv2_id",    "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rserv3_id         = new AlkFormData($this, "rserv3_id",    "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rserv4_id         = new AlkFormData($this, "rserv4_id",    "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->ragent_nom        = new AlkFormData($this, "ragent_nom",     "", ALK_SQL_TEXT);
    $this->rprofil_id        = new AlkFormData($this, "rprofil_id",   "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rmission_id       = new AlkFormData($this, "rmission_id",  "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->rliste_id         = new AlkFormData($this, "rliste_id",    "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->respaceCur        = new AlkFormData($this, "respaceCur",    "0", ALK_SQL_TEXT);
    $this->ragent_valide     = new AlkFormData($this, "ragent_valide", "1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->ragent_adminauth  = new AlkFormData($this, "ragent_adminauth", "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->ragent_priv        = new AlkFormData($this, "ragent_priv", "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    $this->bSearch           = new AlkFormData($this, "bSearch",       "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);

    $this->nbEltParPage = AlkRequest::_GETint("nbItemsPerPage", -1);
    $this->page         = AlkRequest::_GETint("page", -1);
    if( $this->nbEltParPage == -1 ) {
      $this->nbEltParPage = ( isset($_SESSION["alk_annuNbEltParPage"]) ? $_SESSION["alk_annuNbEltParPage"] : ALK_ITEMS_PER_PAGE ) ;
    } 
    $_SESSION["alk_annuNbEltParPage"] = $this->nbEltParPage;

    // init en mode request post
    $this->initData($iTypeInit, null, REQ_POST);
    $this->dsSearch = null;
    if( $this->bSearch->value=="1" ) {
      // on vient de valider la recherche
      $this->bSearch->value = "2";
      // enregistre les critères en session lié à l'espace en cours
      $this->page = 1;
      unset($_SESSION["alk_strSqlExport"]);
      $_SESSION["alk_strSqlExport"] = "";
      $_SESSION["alk_annuSearchCriteria"] = array($cont_id, $this->rserv1_id->value, $this->rserv2_id->value, $this->rserv3_id->value, 
                                                  $this->ragent_nom->value, $this->rmission_id->value, $this->rprofil_id->value, 
                                                  $this->respaceCur->value, $this->ragent_valide->value, $this->rliste_id->value, 
                                                  $this->page, $this->nbEltParPage, $this->rdept_id->value, $this->ragent_adminauth->value, $this->ragent_priv->value);
    } else { 
      // récupération après pagination ou retour sur recherche
      // récupération des anciens critères
      $tabCriteria = ( isset($_SESSION["alk_annuSearchCriteria"]) ? $_SESSION["alk_annuSearchCriteria"] : array() );
      if( !empty($tabCriteria) && count($tabCriteria)==15 && $tabCriteria[0] == $cont_id ) {
        $this->bSearch->value = 1;
        $this->rserv1_id->value     = $tabCriteria[1]; 
        $this->rserv2_id->value     = $tabCriteria[2];
        $this->rserv3_id->value     = $tabCriteria[3];
        $this->ragent_nom->value    = $tabCriteria[4];
        $this->rmission_id->value   = $tabCriteria[5];
        $this->rprofil_id->value    = $tabCriteria[6];
        $this->respaceCur->value    = $tabCriteria[7];
        $this->ragent_valide->value = $tabCriteria[8];
        $this->rliste_id->value     = $tabCriteria[9];
        $page                       = $tabCriteria[10];
        $nbEltParPage               = $tabCriteria[11];
        $this->rdept_id->value      = $tabCriteria[12]; 
        $this->ragent_adminauth->value  = $tabCriteria[13]; 
        $this->ragent_priv->value        = $tabCriteria[14]; 
        
        // vérif de la pagination
        if( $this->page == -1 ) {
          $this->page = ( $page != -1 ? $page : 1 );
          // force le recalcul de la requete
          unset($_SESSION["alk_strSqlExport"]);
        } // sinon pagination en cours

        // vérif du nb elt par page
        if( $this->nbEltParPage != $nbEltParPage ) {
          // force le recalcul de la requete
          unset($_SESSION["alk_strSqlExport"]);
        } // sinon modif du nombre en cours
        
        $tabCriteria[10] = $this->page;
        $tabCriteria[11] = $this->nbEltParPage;

        $_SESSION["alk_annuSearchCriteria"] = $tabCriteria;
      } else {
        // pas de critères
        $this->bSearch->value = 0;
        unset($_SESSION["alk_strSqlExport"]);
        unset($_SESSION["alk_annuSearchCriteria"]);
      }
    }
  }

  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    if( $appli_id == "0" ) {    
      //$tabPublipostage = AlkRequest::_POST("publipostage", array());// liste des agent cochés
      if( !isset($_SESSION["alk_strSqlExport"]) ) 
        return "";
      $this->dsSearch = $this->oAppli->oQuery->getDs($_SESSION["alk_strSqlExport"]);

      $iModeExp = AlkRequest::getToken("iModeExp", "0");
      
      switch( $iModeExp ) {
      case "0"://export texte tabulé
        $this->Export(false);
        break;
        
      case "1":  //export excel  
        $this->Export(true);
        break;
      }
  
      return "";
    }
    else {
      
      //if( $this->bSearch->value != "0" ) { // appel depuis syndication en footerexec
  
        $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
    
        if (isset($_SESSION["alk_strSqlExportSynd"])){
          $strSql = $_SESSION["alk_strSqlExportSynd"];
        } else {
          $strSql = "";
        }
        
        if( $strSql == "" ) return "";
        $dsAgent = $this->oAppli->oQuery->GetDs($strSql);
        $tabListeAgentId = AlkRequest::_POST("listUserId", array());
        $tabKeys = array_flip($tabListeAgentId);
        $cpt = 0;
        while( $drAgent = $dsAgent->getRowIter() ) { 
          $idAgent = $drAgent->getValueName("AGENT_ID");
          $iPub = ( array_key_exists($idAgent, $tabKeys) ? "1" : "0");
            
          $oAppliAnnu->oQueryAction->maj_publipostageAgent($idAgent, $iPub);
        }
     // }
    }
    return "";
  }
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $appli_id = AlkRequest::getToken("appli_id", -1);
  	$agent_id = AlkFactory::getSProperty("user_id", "-1");
  	$this->setData(ALK_INIT_MODE_REQUEST);

    $this->setLabel(_f("Recherche sur l'annuaire %s", ALK_S_DSIT));
    $this->setLabelDesc(_f("Ce formulaire de recherche vous permet de consulter l'annuaire %s à l'aide des critères suivants.", ALK_S_DSIT));

    $this->getBlockCriteria();
    if( $this->bSearch->value != "0" ) {
      if( $appli_id == "0" ) {    
      $this->getBlockResult();
      } else {// appel depuis syndication
        $this->getBlockResultSyndic();
      }
    }

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformrechercheform.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->setTemplate("annu", "alkhtmlformrechercheform.tpl");
  }
 
  /**
   *  Construit puis retourne
   * @return AlkHtmlBlock
   */
  private function getBlockCriteria()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $iSelectWidth = 250;
    $iTxtWidth = 34;

    $oBlockCriteria =& $this->addBlock("blockCriteria", _t("Critères de recherche sur l'annuaire"), "", 100, $iSelectWidth+10, true);

    $oCtrlHide = AlkHtmlFactory::getHtmlHidden($this->bSearch);

    $dsDept = $oQueryAnnu->getDsListeDptForCombo();
    if( $dsDept->getCountTotDr() > 0 ) { 
      $dsDept->setTree("DEPT_ID", "DEPT_PERE");
      $oCtrlSelectDpt = AlkHtmlFactory::getHtmlSelect ($this->rdept_id, _t("Service de"), 1, $iSelectWidth);
      $oCtrlSelectDpt->setProperty("tabValTxtDefault", array("-1", _t("Tous")));
      $oCtrlSelectDpt->setProperty("oValTxt", $dsDept);
      $strParam = "cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_MODIFIER."&iSsheet=".ALK_SHEET_NONE.
        "&iMode=10&niv=0&ida=-1";
      $strToken = AlkRequest::getEncodeParam($strParam);
      $oCtrlSelectDpt->AddEvent("onChange", "ChangeService('".$strToken."', 0)");
      $oBlockCriteria->addCtrl($oCtrlSelectDpt);
    } else {
      $oCtrlHide->addHidden("rdept_id", "-1");
    }

    $tabRServ = array($this->rserv1_id, $this->rserv2_id, $this->rserv3_id, $this->rserv4_id);
    $iServPere = "-1";
    $oCtrlService = array();
    for($iNiv=1; $iNiv<=min(ALK_ANNU_SERV_NIV_MAX, 3); $iNiv++) {
      $oCtrlService[$iNiv-1]  = AlkHtmlFactory::getHtmlSelect($tabRServ[$iNiv-1], "Service niv.".$iNiv, 1, $iSelectWidth);
      $dsSousService = $oQueryAnnu->getDsListeServiceForCombo($iNiv, $iServPere, true, 55, "", $this->rdept_id->value, $this->service_id);
      if( $dsSousService->getCountTotDr() > 0 )
        $oCtrlService[$iNiv-1]->setProperty("tabValTxtDefault", array("-1", _f("Sélectionnez un service de niveau %s",$iNiv)));
      else
        $oCtrlService[$iNiv-1]->setProperty("tabValTxtDefault", array("-1", ""));
      $oCtrlService[$iNiv-1]->setProperty("oValTxt", $dsSousService);
      
      $strParam = "cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_CONSULT."&iSheet=".ALK_SHEET_MODIFIER."&iSsheet=".ALK_SHEET_NONE.
        "&iMode=10&niv=".$iNiv."&ida=-1";
      $strToken = AlkRequest::getEncodeParam($strParam);
      $oCtrlService[$iNiv-1]->AddEvent("onChange", "ChangeService('".$strToken."', ".$iNiv.")");
    
      $oBlockCriteria->addCtrl($oCtrlService[$iNiv-1]);
      $iServPere = $tabRServ[$iNiv-1]->value;
    }
    
    $ragent_nom = AlkHtmlFactory::getHtmlText($this->ragent_nom,  _f("Nom de %s",ALK_S_LAGENT), 1, $iTxtWidth);
    
    $rprofil_id = AlkHtmlFactory::getHtmlSelect($this->rprofil_id, _t("Profil"), 1, $iSelectWidth);
    $rprofil_id->setProperty("tabValTxtDefault", array("-1", ""));
    $rprofil_id->setProperty("oValTxt", $oQueryAnnu->GetDsListProfilForCombo(55, -$cont_id));
    
    $rliste_id = AlkHtmlFactory::getHtmlSelect($this->rliste_id, _t("Liste de diffusion"), 1, $iSelectWidth);
    $rliste_id->setProperty("tabValTxtDefault", array("-1", ""));
    $rliste_id->setProperty("oValTxt", $oQueryAnnu->getDsListes($user_id, $cont_id, true));

    $rmission_id = AlkHtmlFactory::getHtmlSelect($this->rmission_id, _t("Mission"), 1, $iSelectWidth);
    $rmission_id->setProperty("tabValTxtDefault", array("-1", ""));
    $rmission_id->setProperty("oValTxt", $oQueryAnnu->GetDsListMissionForCombo());
    $rmission_id->setHidden(!ALK_B_ANNU_MISSION); 
    
    $tabPriv = array(ALK_PRIV_SPACE_NONE  => _t("Aucun"),
                     ALK_PRIV_ANNU_SERV   => _t("Administrateur annuaire de service"),
                     ALK_PRIV_ANNU_ALL    => _t("Administrateur de tout l'annuaire"),
                     ALK_PRIV_SPACE_ADMIN => _t("Animateur de tous les espaces"),
                     ALK_PRIV_ANNU_ALL+ALK_PRIV_SPACE_ADMIN => _t("Administrateur général"),
               );
    $ragent_priv = AlkHtmlFactory::getHtmlSelect($this->ragent_priv, _t("Privilège"), 1, $iSelectWidth);
    $ragent_priv->setProperty("tabValTxt", $tabPriv);
    $ragent_priv->setProperty("tabValTxtDefault", array("-1", ""));
    
    $tabConn = array("-1" => "",
                     "1"  => _t("Autorisée"),
                     "0"  => _t("Refusée"));
    
    $ragent_adminauth = AlkHtmlFactory::getHtmlSelect($this->ragent_adminauth, _t("Connexion"), 1, $iSelectWidth);
    $ragent_adminauth->setProperty("tabValTxt", $tabConn);

    $respaceCur = AlkHtmlFactory::getHtmlCheckbox($this->respaceCur, _t("Restreindre"));
    $respaceCur->setLabelAfter(" ("._t("aux invités de cet espace").")");
    $ragent_valide = null;
    if( AlkFactory::isSpaceAnimAll() && AlkFactory::isAnnuAdminAll() || AlkFactory::isAnnuAdminServ() || AlkFactory::isAnnuAdminAll() ) {
      $ragent_valide = AlkHtmlFactory::getHtmlSelect($this->ragent_valide, _t("Etat du compte"), 1);
      $tabEtat = array("1"  => _t("Actif"),
                       "0"  => _t("Désactivé"),
                       "-2" => _t("En attente d'activation"));
      $ragent_valide->setProperty("tabValTxt", $tabEtat);
    }

    $oBlockCriteria->addCtrl($oCtrlHide);
    $oBlockCriteria->addCtrl($ragent_nom);
    $oBlockCriteria->addCtrl($rprofil_id);
    $oBlockCriteria->addCtrl($ragent_priv);
    $oBlockCriteria->addCtrl($ragent_adminauth);
    $oBlockCriteria->addCtrl($rliste_id);
    $oBlockCriteria->addCtrl($rmission_id);
    $oBlockCriteria->addCtrl($respaceCur);
    $oBlockCriteria->addCtrl($ragent_valide);
    
    $appli_id = AlkRequest::getToken("appli_id", -1);
    if( $appli_id == "0" ) {    
    $this->addButtonPage("btSearch", "javascript:Valider()", _t("Rechercher"), _t("Executer la recherche"));
      } else {// appel depuis syndication
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_PUBLIER, ALK_SHEET_NONE); 
        $this->addButtonPage("btSearch", "javascript:ValiderSyndication('".$strToken."')", _t("Rechercher"), _t("Executer la recherche"));
      }
  }

  /**    
   * Retourne le block liste pour la recherche syndication
   */
  private function getBlockResultSyndic()
  {
    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $cont_id     = AlkRequest::getToken("cont_id", "-1");
    $user_id     = AlkFactory::getSProperty("user_id");
    $user_priv   = AlkFactory::getSProperty("user_priv");
    $userServ_id = AlkFactory::getSProperty("service_id");

    $strSql = $oQueryAnnu->getSqlListeAgentForSearch($this->oAppli->cont_id, $this->rdept_id->value, $this->rserv1_id->value, 
                                                     $this->rserv2_id->value, $this->rserv3_id->value, $this->ragent_nom->value, 
                                                     $this->rmission_id->value, $this->rprofil_id->value, $this->respaceCur->value, 
                                                     $this->ragent_valide->value, $this->rliste_id->value, "a.AGENT_PUBLIPOSTAGE", 
                                                     $this->ragent_adminauth->value, $this->ragent_priv->value); 
    $_SESSION["alk_strSqlExportSynd"] = $strSql;
    $dsAgent = $oQueryAnnu->GetDs($strSql);//, ($this->page-1)*$this->nbEltParPage, $this->page*$this->nbEltParPage-1);
                   
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_PUBLIER, ALK_SHEET_NONE); 
    $strUrlPagine = ALK_ALKANET."?token=".$strToken;
    $strMsg = _f("Aucune réponse à votre sélection.%nlVeuillez modifier vos critères.", "<br/>");
    $nbElt =  $dsAgent->getCountTotDr();

    $oBlockResult = AlkHtmlFactory::getHtmlList($this, $nbElt, $this->page, $this->nbEltParPage, false, $strUrlPagine, 
                                                $strMsg, false, "blockResult");
   
    $oBlockResult->enableBlock(_t("Résultat de la recherche "), "", "1", "420", true);
                 
    $oBlockResult->SetColumns(array("left", "235"),
                              array("center", "100"),
                              array("center", "80"));
   
    $oCtrlCB = AlkHtmlFactory::getNewHtmlCheckbox($this, 0 , "iCheckAll", 0 ,_t("Tout sélectionner"));
    $oCtrlCB->addEvent("onclick", "SelectAllCB()");
    $txt = $oCtrlCB->getHtml()." "."Publi";
    $oBlockResult->AddTitleRow(_t("Nom Prénom - Tél."), _t("Service"), $txt);

    while( $drAgent = $dsAgent->getRowIter() ) {
      $idAgent       = $drAgent->getValueName("AGENT_ID");
      $idProfil      = $drAgent->getValueName("PROFIL_ID");
      $strNom        = $drAgent->getValueName("AGENT_NOM");
      $strPrenom     = $drAgent->getValueName("AGENT_PRENOM");
      $strSigle      = $drAgent->getValueName("SERVICE_INTITULE_COURT");
      $idServ        = $drAgent->getValueName("SERVICE_ID");
      $strFonction   = $drAgent->getValueName("AGENT_FONCTION");
      $strMail       = $drAgent->getValueName("MAIL");
      $strTel        = $drAgent->getValueName("TEL");
      $strProfil     = $drAgent->getValueName("PROFIL_INTITULE");
      $iPublipostage = $drAgent->getValueName("AGENT_PUBLIPOSTAGE");
      
                
      $strNom .= " ".$strPrenom;
      $oBtMail = AlkHtmlFactory::getHtmlButtonIcon("mailto:".$strMail, "courriel", $strMail);
      $oNom_Agent = AlkHtmlFactory::getHtmlButton("javascript:OpenPopupFiche('agent', ".$idAgent.")", 
                                                  $strNom, _f("Voir la fiche de l'agent %s",$strNom));  

      $strNom = $oBtMail->getHtml()." ".
        $oNom_Agent->getHtml()."<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$strMail.
        ( $strTel!="" ? " - " : "" ).mb_ereg_replace(" ", "", $strTel);
        
      $oNom_Service = AlkHtmlFactory::getHtmlButton("javascript:OpenPopupFiche('service', ".$idServ.")", 
                                                    $strSigle,  _t("Voir la fiche service"));  
      
      $oCtrlCB = AlkHtmlFactory::getNewHtmlCheckbox($this, 0, "listUserId[]", ($iPublipostage == "1" ? $idAgent : 0 ), "", $idAgent);
      $oCtrlCB->checkboxValue = $idAgent;
      $oBlockResult->addRow($strNom, $oNom_Service, $oCtrlCB);
    }
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_PUBLIER, ALK_SHEET_NONE); 
    $this->addButtonPage("btSearch", "javascript:ValiderSyndication('".$strToken."')", _t("Rechercher"), _t("Executer la recherche"));

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_PUBLIER, ALK_SHEET_NONE); 
    $this->addButtonPage("btSyndic", "javascript:Publiposter('".$strToken."')", _t("Poster"), _t("Valider la sélection"));
    $this->addPanel($oBlockResult);
  }

  /**    
   *  Construit puis retourne
   * @return AlkHtmlBlock
   */
  private function getBlockResult()
  {
    $cont_id     = AlkRequest::getToken("cont_id", "-1");
    $user_id     = AlkFactory::getSProperty("user_id", "-1");
    $user_priv   = AlkFactory::getSProperty("user_priv", "0");
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");

    if( $this->bSearch->value == "2" || !isset($_SESSION["alk_strSqlExport"]) ) {
      // validation de recherche
      if(defined("ALK_B_ANNU_CLOISONNEMENT_SERVICE") && ALK_B_ANNU_CLOISONNEMENT_SERVICE==true && !AlkFactory::isAnnuAdminAll()){
      	$this->rserv1_id->value = ($this->rserv1_id->value == -1 ? $userServ_id : $this->rserv1_id->value);
      }
      $strSql = $this->oAppli->oQuery->getSqlListeAgentForSearch($cont_id, $this->rdept_id->value, 
                                                                 $this->rserv1_id->value, $this->rserv2_id->value, 
                                                                 $this->rserv3_id->value, $this->ragent_nom->value, 
                                                                 $this->rmission_id->value, $this->rprofil_id->value, 
                                                                 $this->respaceCur->value, $this->ragent_valide->value, 
                                                                 $this->rliste_id->value, "", $this->ragent_adminauth->value, $this->ragent_priv->value);
      $_SESSION["alk_strSqlExport"] = $strSql;
    } else {
      // pagination ou retour
      $strSql = $_SESSION["alk_strSqlExport"];
    }
    $this->dsSearch = $this->oAppli->oQuery->getDs($strSql, ($this->page-1)*$this->nbEltParPage, $this->page*$this->nbEltParPage-1);
                                        
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE); 
    $strUrlPagine = ALK_ALKANET."?token=".$strToken;
    $strMsg = _f("Aucune réponse à votre sélection.%nlVeuillez modifier vos critères.", "<br/>");
    $nbElt =  $this->dsSearch->getCountTotDr();
    $strS = ( $nbElt>1 ? "s" : "" ); 

    $oBlockResult = AlkHtmlFactory::getHtmlList($this, $nbElt, $this->page, $this->nbEltParPage, 
                                                true, $strUrlPagine, $strMsg, false, "blockResult", true);
    $strTokenXls = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RESULTAT, ALK_SHEET_NONE, "&iModeExp=1");
    $oLinkExportXls = AlkHtmlFactory::getHtmlButtonIcon("javascript:Export('".$strTokenXls."')", "Export XLS", _t("Export excel"));
    $strTokenCsv = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RESULTAT, ALK_SHEET_NONE, "&iModeExp=0");
    $oLinkExportCsv = AlkHtmlFactory::getHtmlButtonIcon("javascript:Export('".$strTokenCsv."')", "Export CSV", _t("Export texte tabulé"));
    $strUrlExport =
      $oLinkExportXls->getHtml().
      //"<a href=\"javascript:Export('".$strTokenXls."')\">Export excel</a> - ".
      $oLinkExportCsv->getHtml();
      //"<a href=\"javascript:Export('".$strTokenCsv."')\">Export texte tabulé</a>"; 
    $oBlockResult->enableBlock(($nbElt==0 ? _t("Aucun") : $nbElt)." "._f("%s %s trouvé%s", ALK_S_AGENT, $strS, $strS)." : ".$strUrlExport, "", "1", "400", true);
                 
    $bAffRightRow = false;
    if( AlkFactory::isAnnuAdminServ() || AlkFactory::isAnnuAdminAll() || ($user_priv & ALK_PRIV_SPACE_ANIM)==ALK_PRIV_SPACE_ANIM ) {
      $oBlockResult->SetColumns(array("left", "235"),
                                array("center", "100"),
                                array("center", "80"));
      
      $oBlockResult->AddTitleRow(_t("Nom Prénom - Tél."), _t("Service"), _t("Actions"));
      $bAffRightRow = true;
    } else {
      $oBlockResult->SetColumns(array("left",   "300"),
                                array("center", "115"));
       
      $oBlockResult->AddTitleRow(_t("Nom Prénom - Tél."), _t("Service"));
    }
  
    while( $drAgent = $this->dsSearch->getRowIter() ) {
      $idAgent     = $drAgent->getValueName("AGENT_ID");
      $idProfil    = $drAgent->getValueName("PROFIL_ID");
      $strNom      = $drAgent->getValueName("AGENT_NOM");
      $strPrenom   = $drAgent->getValueName("AGENT_PRENOM");
      $strSigle    = $drAgent->getValueName("SERVICE_INTITULE_COURT");
      $idServ      = $drAgent->getValueName("SERVICE_ID");
      $service_valide= $drAgent->getValueName("SERVICE_VALIDE");
      $strFonction = $drAgent->getValueName("AGENT_FONCTION");
      $strMail     = $drAgent->getValueName("MAIL");
      $strTel      = $drAgent->getValueName("TEL");
      $strProfil   = $drAgent->getValueName("PROFIL_INTITULE");
                
      $strNom .= " ".$strPrenom;
      $oBtMail = AlkHtmlFactory::getHtmlButtonIcon("mailto:".$strMail, "courriel", $strMail);
      $oNom_Agent = AlkHtmlFactory::getHtmlButton("javascript:OpenPopupFiche('agent', ".$idAgent.")", $strNom, _f("Voir la fiche de l'agent %s", $strNom));  

      $strNom = $oBtMail->getHtml()." ".
        $oNom_Agent->getHtml().
        ( $strTel!="" ? " - " : "" ).mb_ereg_replace(" ", "", $strTel);
        
      $oNom_Service = AlkHtmlFactory::getHtmlButton("javascript:OpenPopupFiche('service', ".$idServ.")", $strSigle,  
                      _t("Voir la fiche service"));  
                         
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ($idAgent==$user_id ? ALK_SHEET_FICHE : ALK_SHEET_MODIFIER), 
                                          ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_UPDATE."&agent_id=".$idAgent);

      $strBt = "&nbsp;";
      if( $bAffRightRow == true && $service_valide==1 ) { 
        if( AlkFactory::isAnnuAdminAll() || AlkFactory::isAnnuAdminServ() && $userServ_id==$idServ ) {
          $oModifier = AlkHtmlFactory::getHtmlButtonIcon(ALK_ALKANET."?token=".$strToken, 
                                                         "Modifier", _f("Modifier la fiche de l'agent %s",
                                                         $drAgent->getValueName("AGENT_NOM")." ".$drAgent->getValueName("AGENT_PRENOM")));
          $strBt = $oModifier->getHtml();
        }
        
        if( ($user_priv & ALK_PRIV_SPACE_ANIM) == ALK_PRIV_SPACE_ANIM ) {
          $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                 "&iSheet=".ALK_SHEET_USERRIGHT."&iSSheet=".ALK_SHEET_LIST."&agent_id=".$idAgent);
          $oAfficher = AlkHtmlFactory::getHtmlButtonIcon("javascript:openUserRights('".$strToken."')", 
                                                         "Afficher", _f("Afficher les droits de l'agent %s",
                                                          $drAgent->getValueName("AGENT_NOM")." ".$drAgent->getValueName("AGENT_PRENOM")));
          $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                 "&iSheet=".ALK_SHEET_USERRIGHT."&agent_id=".$idAgent);
          $oGerer = AlkHtmlFactory::getHtmlButtonIcon("javascript:openUserRights('".$strToken."')", "Droits", _f("Gérer des droits de l'agent %s",
                    $drAgent->getValueName("AGENT_NOM")." " .$drAgent->getValueName("AGENT_PRENOM")));

          $strBt = ( $strBt != "&nbsp;" ? $strBt."&nbsp;" : "" ).$oAfficher->getHtml()."&nbsp;".$oGerer->getHtml();
        }
        $oBlockResult->addRow($strNom, $oNom_Service, $strBt);
      } else {
        $oBlockResult->addRow($strNom, $oNom_Service);
      }
    }
    $this->addPanel($oBlockResult);
  }
 
  /**
   *  function d'initialisation appelé par la function export
   */
  private function HeaderingText($filename, $bExcel=true) 
  { 
    $strType = ( $bExcel ? "application/vnd.ms-excel" : "text/plain" );
    AffHeaderFileDownload("", $filename, 0, $strType);
  }
  
  /**
   *  function d'exportation de la liste des agents 
   */
  private function Export($bExcel)
  {
    set_time_limit(300); // 5mn
    
    $ag_id = AlkFactory::getSProperty("user_id", "-1");
    $strExtension = ($bExcel==true ? "xls" : "txt");
    $urlFileExport = $this->oAppli->getProperty("strUrlUpload").$ag_id."_exp.".$strExtension;
    $strFileExport = $this->oAppli->getProperty("strPathUpload").$ag_id."_exp.".$strExtension;
  
    // HTTP headers
    $this->HeaderingText($ag_id."_exp.".$strExtension, $bExcel);
    
    // Destruction de l'export precedent
    if( file_exists($strFileExport) && is_file($strFileExport) ) {
      @unlink($strFileExport);
    }
    $strSep = "\t";
    $strRetLigne = "\r\n";
    
    if ($bExcel==true) {
      // Creating a workbook
      $workbook = new Workbook("-");
      
      // Creating the first worksheet
      $worksheet1 =& $workbook->add_worksheet('Utilisateurs');
      
      // Creating the formats
      $oFormatHeader =& $workbook->add_format();
      $oFormatHeader->set_border(2);
      $oFormatHeader->set_align('center');
      $oFormatHeader->set_color('black');
      
      $oFormatValue =& $workbook->add_format();
      $oFormatValue->set_border(1);
      $oFormatValue->set_color('black');
      
      $iCol = 0;
      $iRow = 0;
      $iHeightRow = 20;
      $iWidthCol = 15;
    }
    
    $tabReference = array("MODE","CLE","PROFIL","PRIV","CIVILITE","NOM","PRENOM",
                          "FONCTION","COMMENTAIRE","VALIDE", "TYPE", "LOGIN",
                          "ADRESSE_1", "ADRESSE_2", "ADRESSE_3", "CODE_POSTAL", "VILLE", "PAYS", "ADR_DESC",
                          "TEL_FIXE","TEL_POSTE","FAX","MEL","TEL_MOBILE",
                          "SERV_NIV1","SERV_NIV2","SERV_NIV3","SERV_NIV4",
                          "MISSION1","MISSION2","MISSION3");
    
    for ($k=0; $k<count($tabReference); $k++) {
      if($bExcel==true){
        $worksheet1->set_row($iRow, $iHeightRow);
        $worksheet1->set_column($iRow, $iCol, $iWidthCol);
        $worksheet1->write_string($iRow, $iCol, mb_convert_encoding($tabReference[$k], ALK_EXPORT_ENCODING, ALK_HTML_ENCODING), $oFormatHeader);
        $iCol++;
      } else {
        echo $tabReference[$k].$strSep;
      }
    }
    
    if( $bExcel==true ) {
      $iCol = 0;
      $iRow++;
    } else {
      echo $strRetLigne;
    }
    
    $strSql = "select distinct ag.*, adr.* ".
      " from SIT_AGENT ag".
      "  inner join (".$_SESSION["alk_strSqlExport"].") agselect on ag.AGENT_ID=agselect.AGENT_ID".
      "  left join SIT_ADRESSE adr on ag.AGENT_ID=adr.AGENT_ID";
    $dsAgent = $this->oAppli->oQuery->GetDs($strSql);
    
    $cpt = 0;
    while( $drAgent = $dsAgent->getRowIter() ) {
      $strMode = "";
      $idAgent        = $drAgent->getValueName("AGENT_ID");
      $profil_id      = $drAgent->getValueName("PROFIL_ID");
      $agent_priv     = $drAgent->getValueName("AGENT_PRIV");
      $agent_civilite = mb_convert_encoding($drAgent->getValueName("AGENT_CIVILITE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_nom      = mb_convert_encoding($drAgent->getValueName("AGENT_NOM"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_prenom   = mb_convert_encoding($drAgent->getValueName("AGENT_PRENOM"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_fonction = mb_convert_encoding($drAgent->getValueName("AGENT_FONCTION"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_desc     = mb_convert_encoding($drAgent->getValueName("AGENT_DESC"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_valide   = mb_convert_encoding($drAgent->getValueName("AGENT_VALIDE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_type     = mb_convert_encoding($drAgent->getValueName("AGTYPE_ID"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_login    = mb_convert_encoding($drAgent->getValueName("AGENT_LOGIN"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $adr_adr1       = mb_convert_encoding($drAgent->getValueName("ADR_ADR1"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $adr_adr2       = mb_convert_encoding($drAgent->getValueName("ADR_ADR2"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $adr_adr3       = mb_convert_encoding($drAgent->getValueName("ADR_ADR3"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $adr_post       = mb_convert_encoding($drAgent->getValueName("ADR_POST"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $adr_ville      = mb_convert_encoding($drAgent->getValueName("ADR_VILLE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $adr_pays       = mb_convert_encoding($drAgent->getValueName("ADR_PAYS"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $adr_desc       = mb_convert_encoding($drAgent->getValueName("ADR_DESC"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_tel      = mb_convert_encoding($drAgent->getValueName("AGENT_TEL"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_telposte = mb_convert_encoding($drAgent->getValueName("AGENT_TELPOSTE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_mail     = mb_convert_encoding($drAgent->getValueName("AGENT_MAIL"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_mobile   = mb_convert_encoding($drAgent->getValueName("AGENT_MOBILE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
      $agent_fax      = mb_convert_encoding($drAgent->getValueName("AGENT_FAX"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
    
      if( $bExcel==true ) {
        $worksheet1->set_row($iRow, $iHeightRow);
        $worksheet1->write_string($iRow, $iCol, $strMode , $oFormatValue);
        $iCol++;
        $worksheet1->write_number($iRow, $iCol, $idAgent , $oFormatValue);
        $iCol++;
        $worksheet1->write_number($iRow, $iCol, $profil_id , $oFormatValue);
        $iCol++;
        $worksheet1->write_number($iRow, $iCol, $agent_priv , $oFormatValue);
        $iCol++;
        $agent_civilite = mb_ereg_replace($strSep, " ", $agent_civilite);
        $worksheet1->write_string($iRow, $iCol, $agent_civilite , $oFormatValue);
        $iCol++;
        $agent_nom = mb_ereg_replace($strSep, " ", $agent_nom);
        $worksheet1->write_string($iRow, $iCol, $agent_nom , $oFormatValue);
        $iCol++;
        $agent_prenom = mb_ereg_replace($strSep, " ", $agent_prenom);
        $worksheet1->write_string($iRow, $iCol, $agent_prenom , $oFormatValue);
        $iCol++;
        $agent_fonction = mb_ereg_replace($strSep, " ", $agent_fonction);
        $worksheet1->write_string($iRow, $iCol, $agent_fonction , $oFormatValue);
        $iCol++;
        $agent_desc = mb_ereg_replace($strSep, " ", $agent_desc);
        $agent_desc = mb_ereg_replace("\r\n", " ", $agent_desc);
        $agent_desc = mb_ereg_replace("\n\r", " ", $agent_desc);
        $agent_desc = mb_ereg_replace("\n", " ", $agent_desc);
        $agent_desc = mb_ereg_replace("\r", " ", $agent_desc);
        $worksheet1->write_string($iRow, $iCol, $agent_desc , $oFormatValue);
        $iCol++;
        $agent_valide = mb_ereg_replace($strSep, " ", $agent_valide);
        $worksheet1->write_number($iRow, $iCol, $agent_valide , $oFormatValue);
        $iCol++;
        $agent_type = mb_ereg_replace($strSep, " ", $agent_type);
        $worksheet1->write_number($iRow, $iCol, $agent_type , $oFormatValue);
        $iCol++;
        $agent_login = mb_ereg_replace($strSep, " ", $agent_login);
        $worksheet1->write_string($iRow, $iCol, $agent_login , $oFormatValue);
        $iCol++;
        $adr_adr1 = mb_ereg_replace($strSep, " ", $adr_adr1);
        $worksheet1->write_string($iRow, $iCol, $adr_adr1 , $oFormatValue);
        $iCol++;
        $adr_adr2 = mb_ereg_replace($strSep, " ", $adr_adr2);
        $worksheet1->write_string($iRow, $iCol, $adr_adr2 , $oFormatValue);
        $iCol++;
        $adr_adr3 = mb_ereg_replace($strSep, " ", $adr_adr3);
        $worksheet1->write_string($iRow, $iCol, $adr_adr3 , $oFormatValue);
        $iCol++;
        $adr_post = mb_ereg_replace($strSep, " ", $adr_post);
        $worksheet1->write_string($iRow, $iCol, $adr_post , $oFormatValue);
        $iCol++;
        $adr_ville = mb_ereg_replace($strSep, " ", $adr_ville);
        $worksheet1->write_string($iRow, $iCol, $adr_ville , $oFormatValue);
        $iCol++;
        $adr_pays = mb_ereg_replace($strSep, " ", $adr_pays);
        $worksheet1->write_string($iRow, $iCol, $adr_pays , $oFormatValue);
        $iCol++;
        $adr_desc = mb_ereg_replace($strSep, " ", $adr_desc);
        $worksheet1->write_string($iRow, $iCol, $adr_desc , $oFormatValue);
        $iCol++;
        $agent_tel = mb_ereg_replace($strSep, " ", $agent_tel);
        $worksheet1->write_string($iRow, $iCol, $agent_tel , $oFormatValue);
        $iCol++;
        $agent_telposte = mb_ereg_replace($strSep, " ", $agent_telposte);
        $worksheet1->write_string($iRow, $iCol, $agent_telposte , $oFormatValue);
        $iCol++;
        $agent_fax = mb_ereg_replace($strSep, " ", $agent_fax);
        $worksheet1->write_string($iRow, $iCol, $agent_fax, $oFormatValue);
        $iCol++;
        $agent_mail = mb_ereg_replace($strSep, " ", $agent_mail);
        $worksheet1->write_string($iRow, $iCol, $agent_mail, $oFormatValue);
        $iCol++;
        $agent_mobile = mb_ereg_replace($strSep, " ", $agent_mobile);
        $worksheet1->write_string($iRow, $iCol, $agent_mobile, $oFormatValue);
        $iCol++;
      } else {
        echo $strMode.$strSep.$idAgent.$strSep.$profil_id.$strSep.$agent_priv.$strSep.
          $agent_civilite.$strSep.$agent_nom.$strSep.$agent_prenom.$strSep.
          $agent_fonction.$strSep.$agent_desc.$strSep.$agent_valide.$strSep.$agent_type.$strSep.$agent_login.$strSep.
          $adr_adr1.$strSep.$adr_adr2.$strSep.$adr_adr3.$strSep.$adr_post.$strSep.$adr_ville.$strSep.$adr_pays.$strSep.$adr_desc.$strSep.
          $agent_tel.$strSep.$agent_telposte.$strSep.$agent_fax.$strSep.$agent_mail.$strSep.$agent_mobile.$strSep;
      }
      
      // Service
      $tabServ = array("", "", "", "", "");
    
      $dsService = $this->oAppli->oQuery->getDsListServiceByAgent($idAgent);
      while( $drService = $dsService->getRowIter() ) {
        $iNivServ = $drService->getValueName("SERVICE_NIVEAU");
        if( $iNivServ == 1 ) {
          $strServ = mb_convert_encoding($drService->getValueName("SERVICE_INTITULE_COURT"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
        } else {
          $strServ = mb_convert_encoding($drService->getValueName("SERVICE_INTITULE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
        }
        $tabServ[$iNivServ] = $strServ;
      }  
    
      for($i=1; $i<5; $i++) {
        if($bExcel==true){
          $worksheet1->write_string($iRow, $iCol, $tabServ[$i] , $oFormatValue);
          $iCol++;
        } else {
          echo $tabServ[$i].$strSep;
        }
      }
      
      // Mission
      $tabMission = array("", "", "", "");
    
      $dsMission = $this->oAppli->oQuery->GetDsListeMissionByAgentForCombo($idAgent, true);
      $cpt = 1;
      while( ($drMission=$dsMission->getRowIter()) && $cpt<=3 ) {
        $strMission = mb_convert_encoding($drMission->getValueName("MISSION_INTITULE"), ALK_EXPORT_ENCODING, ALK_HTML_ENCODING);
        $tabMission[$cpt] = $strMission;
        $cpt++;
      }
    
      for($i=1; $i<4; $i++) {
        if($bExcel==true){
          $worksheet1->write_string($iRow, $iCol, $tabMission[$i] , $oFormatValue);
          $iCol++;
        } else {
          echo $tabMission[$i].$strSep;
        }
      }
    
      if($bExcel==true){
        $iCol = 0;
        $iRow++;
      } else {
        echo $strRetLigne;
      }
    }
    
    if($bExcel==true){
      $workbook->close();
    }
    
    //Redirection du fichier vers l'utilisateur
    if( file_exists($strFileExport) ) {
      readfile($strFileExport) ;
    }
  } 
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    if ($this->iSheet == ALK_SHEET_RECHERCHE){
      return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_01_recherche_form.htm"); 
    }
    else {
    	return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_01_recherche_list.htm"); 
    }
  } 
    
}
?>