<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopUpUserFiche
 * 
 * Classe de gestion des abonnements des abonnés
 */
 
class AlkHtmlPopUpAbonnementFiche extends AlkHtmlForm
{
  
  protected $tableauAboList;
  protected $oAppliEspace;
  protected $tabFilsGlobal;
  protected $tabFilsGlobalPage;
  protected $nbLignes;
  protected $abonne_id;
  protected $oQueryIedit;
  protected $oQueryGEdit;
  
  public function __construct(AlkAppli $oAppli)
  {
    $this->bCollab = AlkRequest::getToken("bCollab", AlkRequest::_REQUESTint("bCollab", 0));
    $this->urlReturn = AlkRequest::getToken("urlReturn", AlkRequest::_REQUESTint("urlReturn", ""));
    
    parent::__construct($oAppli, "popupAbonnementFiche", ( $this->bCollab == 0 ? _t("Gestion des abonnements de l'abonné") : "" )); 
    
    $this->abonne_id = AlkRequest::getToken("abonne_id", -1);
    $strTokenList = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&abonne_id=".$this->abonne_id);
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, ALK_ALKANET."?token=".$strTokenList);
        
    if (!defined("ALK_B_ATYPE_ESPACE")) define("ALK_B_ATYPE_ESPACE", true);
    $this->oAppliEspace = AlkFactory::getAppli(ALK_ATYPE_ID_ESPACE);
    
    if (!defined("ALK_B_ATYPE_IEDIT")) define("ALK_B_ATYPE_IEDIT", true);
    if (!defined("ALK_B_ATYPE_GEDIT")) define("ALK_B_ATYPE_GEDIT", true);
    $this->oQueryIedit = AlkFactory::getQuery(ALK_ATYPE_ID_IEDIT);
    $this->oQueryGEdit = AlkFactory::getQuery(ALK_ATYPE_ID_GEDIT);
  }
  
    /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit){ }
  
  /**
   *  Traitement du formulaire
   */
  public function doSql() {
    
    $this->setData(ALK_INIT_MODE_REQUEST);
    
    // récupération de la liste des classif et des data_id mis en hidden
    
    // récupération des autres données
    $all_listes     = AlkRequest::_REQUEST("all_listes", array());
    $selected     = AlkRequest::_REQUEST("selected", array());
    
    $this->addAbonnement($all_listes, $selected); 
    
    $strUrlReturn = "";
    if ( $this->urlReturn != "" ) {
      $strUrlReturn = urldecode($this->urlReturn);
    } else {
      $strToken = $this->oAppli->getToken ($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&bCollab=".$this->bCollab."&abonne_id=".$this->abonne_id);
      $strUrlReturn = ALK_ALKANET."?token=".$strToken;
    }
    return $strUrlReturn;
  } 
  
  /**
   *  Retourne le titre de la poup
   * @return string
   */
  public function getTitle()
  {
    return _t("Gestion des abonnements");
  }

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    if ( $this->bCollab == 0 ) {
      $oBlock = $this->addBlockAbonnement();
    } else {
      $oBlock = $this->addBlockTBD();
    }
    
    // chargement des js
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_layer.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_treeview.js");
    /*$this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupabonnement.js");*/
    
    
    $strHtmlJs = "";
    
    $strHtmlJs .= " function GetCheckBox(iChecked, idFolder){
            var strHtml = '';
            var tabSplit = new String(iChecked).split('_');
            var iChecked = tabSplit[0];
            var iCheckbox = tabSplit[1];
            var value = (tabSplit.length>2 ? tabSplit[2] : -1);
            if( iChecked != -1 && iCheckbox==1) {
              strHtml = \"<input type='hidden' name='all_listes\" + idFolder + \"[liste_id]' value='\"+value+\"'/>\";
              strHtml += \"<input type='checkbox' name='selected\" + idFolder + \"[liste_id]' value='\"+value+\"' \";
              if( iChecked==1 ) strHtml += \" checked\";
              if( iChecked==2 ) strHtml += \" disabled\";
              strHtml += \" onclick=\\\"javascript:cocherCase('".$this->getName()."', this)\\\"/>&nbsp;\";" .
            "}
            return strHtml;
          }";
        
    $this->addJs($strHtmlJs);
    $this->addJs("function initJQuery(){ \$(document).ready(function(){\$('#layer').treeview(); }); }");
    $this->addOnLoad("AffTreeview();initJQuery();");
    
    $strHtml = '<ul id="layer" >&nbsp;</ul>';
    $varCtrl = AlkHtmlFactory::getHtml($strHtml);
    $oBlock->addCtrl($varCtrl);

    if ( $this->nbLignes == 0 ) {    	
      $varCtrl2 = AlkHtmlFactory::getHtml("<div class='txtHelp' style='text-align:center;'> ".
                                               _t("Pas d'informations disponibles à l'abonnement")."</div>");
      $oBlock->addCtrl($varCtrl2, ALK_HTMLFORM_1L1C);
    }
    
    // gestion des boutons 
    if ($this->nbLignes >0){
      $strTokenAbo = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&abonne_id=".$this->abonne_id."&bCollab=".$this->bCollab."&urlReturn=".$this->urlReturn);     
      $oButton = $this->addButtonPage("oBtV","javascript:Valider('".$strTokenAbo."','".$this->getName()."')", _t("Valider"), _t("Valider les modifications"));
      $this->addSubmitButton($oButton);
      $this->addButtonPage("oBtMM",( $this->urlReturn != "" ? urldecode($this->urlReturn) : ALK_ALKANET."?token=".$strTokenAbo), _t("Réinitialiser"), _t("Effacer les sélections"));
    }
    if ( $this->iTypeSheet == ALK_TYPESHEET_POPUP ) {
      $this->addButtonPage("oBtClose", "javascript:closeWindow();", _t("Fermer"), _t("Fermer la fenêtre"));
    }
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlpopupabonnement.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.treeview.js");
    $this->addClassCss("tabList", "align:center");
    $this->addScriptCss("../../".ALK_ROOT_CLASSE."form/treeview.css");
  
  }
  
  /**
   * Ajoute en block abonnement permettant la gestion des abonnements de l'utilisateur connecté
   */
  protected function addBlockAbonnement()
  {
    $this->tableauAboList = $this->oAppliEspace->getListAbonnements();
    
    $this->nbLignes = 0; // compte le nbre d'éléments affichés
    $user_id = AlkFactory::getSProperty("user_id", -1);
    $cont_id = AlkRequest::getToken("cont_id", -1);
    $user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    
    $Hidden = AlkHtmlFactory::getNewHtmlHidden($this, "abonne_id", $this->abonne_id);
        
    $this->setLabelDesc(_t("Pour améliorer la lisibilité, il est conseillé d'utiliser les filtres"));
    
    $strHtmlJs = "";
    
    $strHtmlJs .= " var objTreeview = null; ".
      "function AffTreeview() { ".
      "  objTreeview = new Treeview(document, 'layer', 1);";
    
       
    // création du bloc 
    $oBlock = $this->addBlock("block_Abonnement", "", "", 100, 520);
    
    // réception des variables
    $filter_espace  = AlkRequest::_REQUESTint("filter_espace", (isset($_SESSION["filter_espace"]) ? $_SESSION["filter_espace"]:$cont_id));
    $filter_appli   = AlkRequest::_REQUESTint("filter_appli", (isset($_SESSION["filter_appli"]) ? $_SESSION["filter_appli"]:"-1"));
    $_SESSION["filter_espace"]   = $filter_espace;
    $_SESSION["filter_appli"]    = $filter_appli;
       
    // champ de sélection sur les espaces
    $tabCont = array();
    $dsEspace = $this->oAppliEspace->oQuery->GetDs_listeEspaceByAgentForArbo($user_id, false, -1, true);
    while ($drEspace = $dsEspace->getRowIter()){
      $cont_id_param           = $drEspace->getValueName("ID");
      if ($cont_id_param==0)
        continue;
      $tabCont[$cont_id_param] = $drEspace->getValueName("NOM");
    }
    $oCtrlFilterA = AlkHtmlFactory::getNewHtmlSelect(null, "0", "filter_espace", $filter_espace, "Espaces", 1, 220);
    $oCtrlFilterA->setProperty("tabValTxt",$tabCont);
    $oCtrlFilterA->addEvent("onchange", "document.popupAbonnementFiche.filter_appli.value=-1;document.popupAbonnementFiche.submit();");
   
    // champ de sélection sur les appli
    $dsAppli  = $this->oAppliEspace->oQuery->getDs_listeAppliAgentByEspace($user_id, $filter_espace);
    $oCtrlFilterC = AlkHtmlFactory::getNewHtmlSelect(null, "0", "filter_appli", $filter_appli, "Applications", 1, 220);
    $oCtrlFilterC->addEvent("onchange", "document.popupAbonnementFiche.submit();");
    $tabAppli = array();
    while($drAppli = $dsAppli->getRowIter()){
      $atype_id    = $drAppli->getValueName("ATYPE_ID");
      if  (! ($atype_id == ALK_ATYPE_ID_GEDIT || $atype_id == ALK_ATYPE_ID_IEDIT || $atype_id == ALK_ATYPE_ID_LSDIF))
        continue;
      $appli_id = $drAppli->getValueName("APPLI_ID");
      $tabAppli[$appli_id] = $drAppli->getValueName("APPLI_INTITULE");
    }  
    $oCtrlFilterC->setProperty("tabValTxt",$tabAppli);
    $oCtrlFilterC->setProperty("tabValTxtDefault",array(-1, "tous"));
    $oCtrlFilterA->addCtrl($oCtrlFilterC);
    $oBlock->addCtrl($oCtrlFilterA);
    
    $this->addVarJs("ALK_ATYPE_ID_GEDIT", ALK_ATYPE_ID_GEDIT);
    $this->addVarJs("ALK_ATYPE_ID_IEDIT", ALK_ATYPE_ID_IEDIT);
    
    // cas lsdif : calcul des listes par Espace
    $tabAppliLsDif = array();
    $dsAppli  = $this->oAppliEspace->oQuery->getDs_listeAppliAgentByEspace($user_id, $filter_espace);
    while($drAppli = $dsAppli->getRowIter()){
      $atype_id = $drAppli->getValueName("ATYPE_ID");
      $appli_id = $drAppli->getValueName("APPLI_ID");
      if ($atype_id == ALK_ATYPE_ID_LSDIF){
        $tabAppliLsDif[$appli_id]["NAME"] = $drAppli->getValueName("APPLI_INTITULE");
        
        // recherche de listes
        // BUG FIX : MTO 26/11/2012 : récupère les listes de type "liste diff" ($liste_type=0) et "liste d'abonnement explicite (lettre d'information)" ($liste_type=3) pour lequels l'utilisateur connecté a les droits de visualisation (=> passage des paramtères $user_id, AlkFactory::isSpaceAnimAll() et AlkFactory::isSpaceAnim())
        $dsListe = $this->oAppli->oQuery->getDsListes($user_id, $cont_id, true, 0, -1, AlkFactory::isSpaceAnimAll(), AlkFactory::isSpaceAnim(), true, "0, 3"); 
        while($drListe = $dsListe->getRowIter()){
          $tabAppliLsDif[$appli_id][$drListe->getValueName("LISTE_ID")] = $drListe->getValueName(AlkFactory::getDBCurrentLanguageField("LISTE_INTITULE"));
        }
       break;
      }
    }
     $this->tableauAboList[ALK_ATYPE_ID_LSDIF] = $tabAppliLsDif;
    
    // affichage des abonnements par appli
    $iDroitLink = 2;
    $iDroitAction = 0;
         
    // traitement du noeud Espace
    $strIntitule = "<strong>Espace : ".$tabCont[$filter_espace]."</strong>";
    $idFils = $filter_espace;
    $iNiv   = -2;
    $strUrl ="";
    $iChecked ="-1";
   
    $strIntitule = str_replace("<br/>","",$strIntitule);
    $strIntitule = preg_replace( "/\"/", "'", $strIntitule);
    $strIntitule = preg_replace( "/'/", "\'", $strIntitule);
   
    $strIdFils = "[".$filter_espace."]";
    $strIdPere = "";
   
    $strHtmlJs .= "\n objTreeview.AddFolder(\"".$strIdFils."\", \"".$strIdPere."\", \"".$strIntitule."\", ".$iNiv.", ".
    $iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\", ".$iChecked.");";
     
    foreach($this->tableauAboList as  $atype_id => $tabAppliDesc) {
      switch($atype_id){
       case ALK_ATYPE_ID_GEDIT:
       case ALK_ATYPE_ID_IEDIT:
       case ALK_ATYPE_ID_COLLAB:
        $strSql = $tabAppliDesc;
        $dsNoeud = $this->oAppliEspace->oQuery->getDs($strSql);
        $nbNoeud = $dsNoeud->getCountTotDr();
        $strArbre = "";
        $idRoot = "0";
        $i = 0;
        while( $drNoeud = $dsNoeud->getRowIter() )  {
         $idFils = $drNoeud->getValueName("ID");
         $idRoot = ( $idRoot == "0" ? $idFils : $idRoot );
         $idPere = $drNoeud->getValueName("ID_PERE");
         $iNiv   =  $drNoeud->getValueName("NIV")-1;
         $iDroit = $drNoeud->getValueName("RIGHT_ID");
         $cont_id = $drNoeud->getValueName("CONT_ID");
         $appli_id = $drNoeud->getValueName("APPLI_ID");
         $arbre    = $drNoeud->getValueName("ARBRE");
         $liste_id = $drNoeud->getValueName("LISTE_ID");
         $type     = $drNoeud->getValueName("TYPE");
         $hasCheckbox = $drNoeud->getValueName("ABONNEMENT");
         
         $strGlue ="";
                  
         if ($filter_appli != -1 && $appli_id != $filter_appli)
           continue;
         if ($filter_appli == -1 && $filter_espace != $cont_id)
           continue;
         
         $i++;
           
         if ($i==1){
           // traitement du noeud Appli
           $strIntitule = "<strong><i>Application : ".$this->oAppliEspace->oQuery->GetStr_applicationIntitule($appli_id)."</i></strong>";
           $strUrl ="";
           $iCheckedAppli ="-1";
           
           $strIntitule =$strIntitule;
           $strIntitule = str_replace("<br/>","",$strIntitule);
           $strIntitule = preg_replace( "/\"/", "'", $strIntitule);
           $strIntitule = preg_replace( "/'/", "\'", $strIntitule);
           
           $strIdFils = "[".$filter_espace."][".$atype_id."]";
           $strIdPere = "[".$filter_espace."]";
           
           $strHtmlJs .= "\n objTreeview.AddFolder(\"".$strIdFils."\", \"".$strIdPere."\", \"".$strIntitule."\", -1, ".
           $iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\", ".$iCheckedAppli.");";
         }
         
         if ($atype_id == ALK_ATYPE_ID_IEDIT || $atype_id == ALK_ATYPE_ID_COLLAB){
           $strNom = $drNoeud->getValueName(AlkFactory::getDBCurrentLanguageField("INTITULE"));
           if ($type=="DATA") {
              $arbre.= $idFils."-";
           }
           else if ($type=="CLASSIF"){
             $strGlue = "Classification  : ";
           }
               
         }// fin traitement particulier iedit
         
         $strNom = $drNoeud->getValueName("NOM");
         $strNom = $strGlue.$strNom;       
         $strNom = str_replace("<br/>","",$strNom);
         $strNom = preg_replace( "/\"/", "'", $strNom);
         $strNom = preg_replace( "/'/", "\'", $strNom);
         
         $tabArbre = explode("-", $arbre);
         $strIdFils = $strIdPere = "[".$filter_espace."][".$atype_id."]";
         foreach($tabArbre as $element){
           if ($element != "" && $element !="0") {
             $strIdFils .= "[".$element."]";
             if ($element != $idFils)
               $strIdPere .= "[".$element."]";
           }
         }
         
         // il s'agit d'une liste, on vérifie que l'agent appartient à la liste
         $dsAbonne = $this->oAppli->oQuery->getDsAbonnesByListe($liste_id, true, 0, -1, false, false, $this->abonne_id);
         if ($drAbonne = $dsAbonne->getRowIter()){
           $abonne_param = $liste_id;
         }else {
           $abonne_param = -1;
         }

         $iChecked = "'".($abonne_param != -1 ? "1" : "0")."_".$hasCheckbox."_".$liste_id."'";
         
         if ($atype_id == ALK_ATYPE_ID_GEDIT)
           $strUrl = $this->oQueryGEdit->getPageUrl($idFils, "", true);
         else
           $strUrl ="";  
         $strHtmlJs .= "\n objTreeview.AddFolder(\"".$strIdFils."\", \"".$strIdPere."\", \"".$strNom."\", ".$iNiv.", ".
         $iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\", ".$iChecked.");";
         
         $this->addOnload("cocherCase('".$this->getName()."', this)");
       }
       $this->nbLignes+= $i;
     break;
        
    case ALK_ATYPE_ID_LSDIF:
      $i = 0;
      foreach($tabAppliDesc as $appli_id =>$tabValues){
          if ($filter_appli != -1 && $appli_id != $filter_appli)
            continue;
          $i++;
          if ($i==1){
           // traitement du noeud Appli
           $strIntitule = "<strong><i>Application ".$tabValues["NAME"]."</i></strong>";
           $strUrl ="";
           $iChecked ="-1";
           
           $strIntitule = str_replace("<br/>","",$strIntitule);
           $strIntitule = preg_replace( "/\"/", "'", $strIntitule);
           $strIntitule = preg_replace( "/'/", "\'", $strIntitule);
           
           $strIdFils = "[".$filter_espace."][".$atype_id."]";
           $strIdPere = "[".$filter_espace."]";
           
           $strHtmlJs .= "\n objTreeview.AddFolder(\"".$strIdFils."\", \"".$strIdPere."\", \"".$strIntitule."\", -1, ".
           $iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\", ".$iChecked.");";
         }
        $hasCheckbox = "1";
        foreach($tabValues as $liste_id => $list_name){
          if (is_numeric($liste_id)){
            // il s'agit d'une liste, on vérifie que l'agent appartient à la liste
            $dsAbonne = $this->oAppli->oQuery->getDsAbonnesByListe($liste_id, true, 0, -1, false, false, $this->abonne_id);
            if ($drAbonne = $dsAbonne->getRowIter()){
              $abonne_param = $liste_id;
            }else {
              $abonne_param = -1;
            }
            
             $iChecked = "'".($abonne_param != -1 ? "1" : "0")."_".$hasCheckbox."_".$liste_id."'";
            $strUrl ="";
           
            $list_name = str_replace("<br/>","",$list_name);
            $list_name = preg_replace( "/\"/", "'", $list_name);
            $list_name = preg_replace( "/'/", "\'", $list_name);
           
            $strIdFils = "[".$filter_espace."][".$atype_id."][".$liste_id."]";
            $strIdPere = "[".$filter_espace."][".$atype_id."]";
           
            $strHtmlJs .= "\n objTreeview.AddFolder(\"".$strIdFils."\", \"".$strIdPere."\", \"".$list_name."\", -1, ".
            $iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\", ".$iChecked.");";
          }
        } // fin parcours des listes
       }
       $this->nbLignes+= $i;
     break;
     }
    }
    
    $strHtmlJs .= " /* paramétrage */".
    " objTreeview.classLinkFolder = '';".
    " objTreeview.classTextFolder = '';".
    " objTreeview.classLinkDoc = '';".
    " objTreeview.classTextDoc = '';".
    " objTreeview.imgNodeOpen  = '';".
    " objTreeview.imgNodeClose = '';".
  
    " objTreeview.bShowNode = false;".
    " objTreeview.bCanShowHideNode = false;".
    " objTreeview.strNodeName = ' applications';".
    " objTreeview.iSizeIcon = '16';".
  
    " /* affichage */".
    
    " objTreeview.OpenAll();".
    "}";
    
    $this->addJs($strHtmlJs);
    
    $oBlock->addCtrl($Hidden);
    
    return $oBlock;
  }
  
  /**
   * Ajoute un block tableau de bord des abonnements sur les dossiers et documents de l'utilisateur lui permettant uniquement de se désabonner
   */
  protected function addBlockTBD()
  {
    $this->nbLignes = 0; // compte le nbre d'éléments affichés
    $user_id = AlkFactory::getSProperty("user_id", -1);
    $cont_id_current = AlkRequest::getToken("cont_id", -1);
    
    $strHtmlJs = "";
    
    $strHtmlJs .= " var objTreeview = null; ".
      "function AffTreeview() { ".
      "  objTreeview = new Treeview(document, 'layer', 1);";
    
    $oBlock = $this->addBlock("block_tdb", _t("Abonnements"), "", 100, 520);
    
    $oQueryCollab = AlkFactory::getQuery(ALK_ATYPE_ID_COLLAB);
    
    $strSql = $oQueryCollab->getListAbonnements($user_id, array(ALK_ATYPE_ID_DOC));
    
    $dsNoeud = $this->oAppliEspace->oQuery->getDs($strSql);
    $nbNoeud = $dsNoeud->getCountTotDr();
    $strArbre = "";
    $idRoot = "0";
    $i = 0;
    while( $drNoeud = $dsNoeud->getRowIter() )  {
      $idFils = $drNoeud->getValueName("ID");
      $idRoot = ( $idRoot == "0" ? $idFils : $idRoot );
      $idPere = $drNoeud->getValueName("ID_PERE");
      $iNiv   =  $drNoeud->getValueName("NIV")-1;
      $iDroit = $drNoeud->getValueName("RIGHT_ID");
      $cont_id = $drNoeud->getValueName("CONT_ID");
      $appli_id = $drNoeud->getValueName("APPLI_ID");
      $arbre    = $drNoeud->getValueName("ARBRE");
      $liste_id = $drNoeud->getValueName("LISTE_ID");
      $type     = $drNoeud->getValueName("TYPE");
      $hasCheckbox = $drNoeud->getValueName("ABONNEMENT");
      
      if ($cont_id_current != $cont_id)
        continue;
      
      $i++;
      
      if ($type=="DATA") {
        $arbre.= $idFils."-";
      }
      $strNom = $drNoeud->getValueName("NOM");
      $strNom = str_replace("<br/>","",$strNom);
      $strNom = preg_replace( "/\"/", "'", $strNom);
      $strNom = preg_replace( "/'/", "\'", $strNom);
      
      $tabArbre = explode("-", $arbre);
      $strIdFils = $strIdPere = "[".$cont_id_current."][".ALK_ATYPE_ID_COLLAB."]";
      foreach($tabArbre as $element){
        if ($element != "" && $element !="0") {
          $strIdFils .= "[".$element."]";
          if ($element != $idFils)
            $strIdPere .= "[".$element."]";
        }
      }
      
      // il s'agit d'une liste, on vérifie que l'agent appartient à la liste
      $dsAbonne = $this->oAppli->oQuery->getDsAbonnesByListe($liste_id, true, 0, -1, false, false, $this->abonne_id);
      if ($drAbonne = $dsAbonne->getRowIter()){
        $abonne_param = $liste_id;
      }else {
        $abonne_param = -1;
      }
      
      $iChecked = "'".($abonne_param != -1 ? "1_".$hasCheckbox."_".$liste_id : "-1")."'";
      
      $strHtmlJs .= "\n objTreeview.AddFolder(\"".$strIdFils."\", \"".$strIdPere."\", \"".$strNom."\", ".$iNiv.", \"2\", \"0\", \"\", \"\", ".$iChecked.");";
      
      $this->addOnload("cocherCase('".$this->getName()."', this)");
    }
    $this->nbLignes+= $i;
    
    $strHtmlJs .= " /* paramétrage */".
    " objTreeview.classLinkFolder = '';".
    " objTreeview.classTextFolder = '';".
    " objTreeview.classLinkDoc = '';".
    " objTreeview.classTextDoc = '';".
    " objTreeview.imgNodeOpen  = '';".
    " objTreeview.imgNodeClose = '';".
  
    " objTreeview.bShowNode = false;".
    " objTreeview.bShowRoot = false;".
    " objTreeview.bCanShowHideNode = false;".
    " objTreeview.bViewHeader = false;".
    " objTreeview.strNodeName = ' applications';".
    " objTreeview.iSizeIcon = '16';".
  
    " /* affichage */".
    
    " objTreeview.OpenAll();".
    "}";
    
    $this->addJs($strHtmlJs);
    
    return $oBlock;
  }
  
  /**
   * effectue les enregistrements des abonnements pour les pages et les données iedit
   */
  protected function addAbonnement($all_listes, $selected){
    // même structure d'arborescence entre all_listes et selected
    // les identifiants de liste (dans all ou selected) ont pour clé "liste_id"
    foreach ($all_listes as $cle => $tabValuesCle){
      if ($cle=="liste_id"){
        $liste_id = $tabValuesCle;
        $this->oAppli->oQueryAction->delAbonnement($this->abonne_id, $liste_id);
        if ( in_array($liste_id, $selected) )
          $this->oAppli->oQueryAction->addAbonnement($this->abonne_id, $liste_id);
      }else if ( is_array($tabValuesCle)){
        $this->addAbonnement($all_listes[$cle], (array_key_exists($cle, $selected) ? $selected[$cle] : array()));
      }
    }
  }
}