<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopUpUserFiche
 * 
 * Classe de gestion des user de l' Annuaire'
 */
class AlkHtmlPopUpUserFiche extends AlkHtmlForm
{
  /**
   *  Constructeur par défaut
   * @param oAppli Référence sur l'appli associée
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "popupUserFiche","Fiche agent"); 
    $this->setProperties(ALK_FORM_MODE_READ, ALK_FORM_METHOD_POST, "");   
  } 
   
  /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit){ }
  
  /**
   *  Traitement du formulaire
   */
  public function doSql() { }  
  
  /**
   *  Retourne le titre de la poup
   * @return string
   */
  public function getTitle()
  {
    return _f("Fiche %s",ALK_S_AGENT);
  }

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");
    $this->addScriptCss("../".ALK_ROOT_MODULE."annu/templates/annu.css");
    
    $agent_id = AlkRequest::_GETint("aid", "-1");
    $iUpdate  = AlkRequest::_GETint("u", "1");

    $dsAgent = $this->oAppli->oQuery->getDS_ficheAgent($agent_id);
    if( !($drAgent = $dsAgent->getRowIter()) ) {
      $this->addOnload("windowClose()");
      return;
    }

    //info sur l'agent
    $agent_civilite = $drAgent->getValueName("AGENT_CIVILITE");
    $agent_priv     = $drAgent->getValueName("AGENT_PRIV");
    $agent_nom      = $drAgent->getValueName("AGENT_NOM");
    $agent_prenom   = $drAgent->getValueName("AGENT_PRENOM");
    $agent_fonction = $drAgent->getValueName("AGENT_FONCTION");
    $agent_desc     = $drAgent->getValueName("AGENT_DESC");
    $agent_photo    = $drAgent->getValueName("AGENT_PHOTO");
    $profil_id      = $drAgent->getValueName("PROFIL_ID");
    $profil_intitule= $drAgent->getValueName("PROFIL_INTITULE");
    $service_id     = $drAgent->getValueName("SERVICE_ID");
    $adr_adr1       = $drAgent->getValueName("ADR_ADR1");
    $adr_adr2       = $drAgent->getValueName("ADR_ADR2");
    $adr_adr3       = $drAgent->getValueName("ADR_ADR3");
    $adr_post       = $drAgent->getValueName("ADR_POST");
    $adr_ville      = $drAgent->getValueName("ADR_VILLE");
    $adr_pays       = $drAgent->getValueName("ADR_PAYS");
    $agent_mail     = $drAgent->getValueName("AGENT_MAIL");
    $agent_tel      = $drAgent->getValueName("AGENT_TEL");
    $agent_telposte = $drAgent->getValueName("AGENT_TELPOSTE");
    $agent_fax      = $drAgent->getValueName("AGENT_FAX");
    $agent_mobile   = $drAgent->getValueName("AGENT_MOBILE");
    $agent_date_valid = $drAgent->getValueName("AGENT_DATE_VALID");
    
    $bUpdate = ( $user_id==$agent_id ||
                 AlkFactory::isAnnuAdminAll() ||
                 AlkFactory::isAnnuAdminServ() && $service_id==$userServ_id );
    
    $bAdr = ( trim($adr_adr1.$adr_adr2.$adr_adr3.$adr_post.$adr_ville.$adr_pays) != "" );
    
    $agent_date_valid = mb_split(',', $agent_date_valid);
    /** identité */
    $strHtml = "<ul class='userIdent'>".
      "<li class='ident'>".trim($agent_civilite." ".$agent_prenom." ".$agent_nom." ( id : ".$agent_id.")")."</li>".
      ( $agent_fonction != "" ? "<li class='info'>".$agent_fonction."</li>" : "" ).
      ( $agent_desc != "" ? "<li class='info'>".$agent_desc."</li>" : "" ).
      ( $agent_date_valid   != "" ? "<br/><span class='dateCreation'>"._t("Date d'inscription")." : </span>".$agent_date_valid[0] : "" ).
      ( $bAdr
        ? "<li class='adr'>".
          ( $adr_adr1 != "" ? $adr_adr1."<br/>" : "" ).
          ( $adr_adr2 != "" ? $adr_adr2."<br/>" : "" ).
          ( $adr_adr3 != "" ? $adr_adr3."<br/>" : "" ).
          trim($adr_post." ".$adr_ville.( $adr_pays!="" ? " (".$adr_pays.")" : "" )).
          "</li>"
        : "" ).
      "<li class='mail'><a href=\"mailto:".$agent_mail."\">".$agent_mail."</a></li>".
      "<li class='tel'>".( $agent_tel!="" ? $agent_tel : "n.c." ).
      ( $agent_telposte != "" ? "<span class='fax'>"._t("Poste")." : </span>".$agent_telposte : "" ).  
      ( $agent_fax      != "" ? "<span class='fax'>"._t("Fax")." : </span>".$agent_fax : "" ).
      ( $agent_mobile   != "" ? "<span class='mobile'>"._t("Mobile")." : </span>".$agent_mobile : "" ).
      "</li>";

    $strHtml .= "</ul>"; 
    $strHtmlProfil = "<ul class='userIdent group'>";
    
    /** privilège */
    $strHtmlPriv = 
      ( ($agent_priv & ALK_PRIV_ANNU_SERV) == ALK_PRIV_ANNU_SERV 
        ? _t("Administrateur annuaire de service")."<br/>"
        : "" ).
      ( ($agent_priv & ALK_PRIV_ANNU_ALL) == ALK_PRIV_ANNU_ALL
        ? _t("Administrateur de tout l'annuaire")."<br/>"
        : "" ).
      (  ($agent_priv & ALK_PRIV_SPACE_VIEWER) == ALK_PRIV_SPACE_VIEWER
         ? _t("Accès consultatif à tous les espaces")."<br/>"
         : "" ).
      (  ($agent_priv & ALK_PRIV_SPACE_ADMIN) == ALK_PRIV_SPACE_ADMIN
         ? _t("Animateur de tous les espaces")."<br/>"
         : "" );

    if( $strHtmlPriv != "" ) {
      $strHtmlPriv = mb_substr($strHtmlPriv, 0, -5);
      $strHtmlProfil .= "<li class='priv'>". $strHtmlPriv."</li>";
    }

    /** Profils */
    $strHtmlProfil .= "<li class='group1'>".$profil_intitule."</li>";

    $dsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, false, 255);
    $strTmp = "";
    while( $drProfil = $dsProfil->getRowIter() ) {
      $profil_intitule = $drProfil->getValueName("PROFIL_INTITULE");
      $strTmp .= $profil_intitule."<br/>";
    }
    if( $strTmp != "" ) {
      $strTmp = mb_substr($strTmp, 0, -5);
      $strHtmlProfil .= "<li class='group2'>".$strTmp."</li>";
    }
      
    /** Missions */
    $dsMission = $this->oAppli->oQuery->GetDslisteMissionByAgentForCombo($agent_id, true);
    $strHtmlMission = "";
    while( $drMission = $dsMission->getRowIter() ) {
      $strMission = $drMission->getValueName("MISSION_INTITULE");
      $strHtmlMission .= $strMission."<br/>";
    }
    if( $strHtmlMission != "" ) {
      $strHtmlMission = mb_substr($strHtmlMission, 0, -5);
      $strHtmlProfil .= "<li class='mission'>".$strHtmlMission."</li>";
    }
    $strHtmlProfil .= "</ul>";

    /** filiation */
    $strHtmlServ = "<ul class='userIdent serv'>";

    $dsServ = $this->oAppli->oQuery->getDsListServiceByAgent($agent_id);
    $idServNiv1 = -1; 
    $iNiv = 1;
    while( $drServ = $dsServ->getRowIter() ) {
      $idServ = $drServ->getValueName("SERVICE_ID");
      $strServ = $drServ->getValueName("SERVICE_INTITULE");
    
      if( $idServNiv1 == -1 ) {
        $idServNiv1 = $idServ;
      }
      
      $strHtmlServ .= ( $iNiv > 1 ? "<ul class='level'>" : "" );
      if ($iUpdate == 1) {
        $strHtmlServ .= "<li><a title=\""._f("voir la fiche du service %s", $strServ)."\" href=\"javascript:OpenPopupFiche('service', ".$idServ.");\">".$strServ."</a></li>";
      }else {
        $strHtmlServ .= "<li>".$strServ."</li>";
      }       
      
      $iNiv++;
    }

    for($i=1; $i<$iNiv; $i++) {
      $strHtmlServ .= "</ul>";
    }

    $urlUpload = AlkFactory::getUploadUrl(ALK_ATYPE_ID_ANNU);
    $strHtmlPhoto = "";
    if( $agent_photo != "" ) {
      $strHtmlPhoto = "<img src='".$urlUpload.$agent_photo."' height='100' width='75' alt='Photo identité'/>";
    }

    $oCtrlIdent   = AlkHtmlFactory::getHtml($strHtml, "", "ctrlIdent");
    $oCtrlServ    = AlkHtmlFactory::getHtml($strHtmlServ);
    $oCtrlProfil   = AlkHtmlFactory::getHtml($strHtmlProfil, "", "ctrlProfil");
    $oCtrlPhoto = AlkHtmlFactory::getHtml($strHtmlPhoto, "", "ctrlPhoto");
    
    $oBlockIdent = $this->addBlock("blockIdent", "", "", "5", "435");
    $oBlockIdent->addCtrl($oCtrlIdent);
    $oBlockIdent->addCtrl($oCtrlProfil);
    $oBlockIdent->addCtrl($oCtrlPhoto);
    $oBlockIdent->setTemplate("annu", "alkhtmlblockuserident.tpl");
    
    
    $oBlockServ = $this->addBlock("blockServ", _t("Filiation"), "", "5", "435", true);
    $oBlockServ->addCtrl($oCtrlServ, ALK_HTMLFORM_1L1C);
    
    /** Elements spécifiques aux applications de l'espace */
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    if ( !is_null($oSpace) && (defined("ALK_B_ATYPE_ACL") && ALK_B_ATYPE_ACL==true))
      $oSpace->callService($this->oAppli->atype_id, "getHtmlAnnuUserForm", $this, $this, $agent_id);
    
    if ($iUpdate==1){
      if( ($user_priv & ALK_PRIV_ANNU_ALL) == ALK_PRIV_ANNU_ALL ||
        ($user_priv & ALK_PRIV_ANNU_SERV) == ALK_PRIV_ANNU_SERV && $userServ_id==$idServNiv1 ||
        $agent_id==$user_id ) {
        $iSheet = ( $user_id == $agent_id ? ALK_SHEET_FICHE : ALK_SHEET_MODIFIER );
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, $iSheet, ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_UPDATE."&agent_id=".$agent_id);
        $oBtUpdt = $this->addButtonPage("btUpdate", "javascript:closeAllWindow('".$strToken."')", _t("Modifier"), _t("Modifier la fiche"));
      }
    }
    $oBtClose = $this->addButtonPage("btClose", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));
  }
    
}

?>