<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopupUserList
 * 
 * Classe de selection multiple d'utilisateur de l'Annuaire
 */
class AlkHtmlPopupUserList extends AlkHtmlForm 
{
  /**
   *  Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formUserList"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

   /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql() { return ""; }
  
  /**
   *  Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return _t("Sélectionner un agent de l'annuaire");
  }
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $iWidthTxt = 40;
    $iWidthSelect = 360;
    $iWidthLabel = 140;
    $iWidthCtrl = 370;

    $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    
    $cont_id = AlkRequest::getToken("cont_id", "-1"); 

    // filtre les utilisateurs sur cet espace si <>""
    $cont_id_filtre = AlkRequest::getToken("cont_id_filtre", "");

    // url de traitement de l'ajout simple
    $url = AlkRequest::getToken("url", "");          

    // niveau d'erreur
    $erreur = AlkRequest::getToken("erreur", "");

    // element de type select qui doit recevoir le texte et la valeur de la selection
    $dest = AlkRequest::getToken("dest", "");

    // element de type input texte qui doit recevoir le texte de la selection
    $destTxt = AlkRequest::getToken("destTxt", "");

    // element de type input hidden qui doit recevoir la valeur de la selection
    $destId = AlkRequest::getToken("destId", "");

    $strToken = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER_LIST.
                                           "&cont_id_filtre=".$cont_id_filtre."&erreur=".$erreur."&dest=".$dest."&destTxt=".$destTxt.
                                           "&destId=".$destId."&url=".$url);

    $agent_nom = new AlkFormData($this, "agent_nom", AlkRequest::_POST("agent_nom", ""));
    
    $oCtrlTxt = AlkHtmlFactory::getHtmlText($agent_nom, _t("Nom recherché"), 1, $iWidthTxt, 40);
    $oBtRech = AlkHtmlFactory::getHtmlButtonIcon("javascript:onChangeFiltre('".$strToken."');", "rechercher", _t("Valider le filtre"), true);
    $oCtrlTxt->addCtrl($oBtRech);

    $strHtml = "<div class='txtNormal'>" .
      _t("Tapez les premières lettres du nom recherché.")."<br>".
      _t("Pour rechercher une partie d'un nom, tapez % en première position.")."</div>";
    $oCtrlHtml = AlkHtmlFactory::getHtml($strHtml);

    $nbAgent = 0;
    $strLabel = _t("Liste des agents filtrés");
    if( $agent_nom->value != "" ) {
      $oDF = new AlkFormData($this, "ag_liste", "");

      $oCtrlSelect = AlkHtmlFactory::getHtmlSelect($oDF, "", 1, $iWidthSelect);
      $dsAgent = $oQuery->getDs_listeAgentByEspace($agent_nom->value, $cont_id_filtre);
      $oCtrlSelect->setProperty("oValTxt", $dsAgent);
      $oCtrlSelect->setProperty("strFieldValue", "AGENT_ID");
      $oCtrlSelect->setProperty("strFieldText", "NOM");
      $nbAgent = $dsAgent->getCountDr();
      $oCtrlSelect->setLabelAfter("<div class='txtNormal'>"._f("Sélectionnez l'agent souhaité dans la liste ci-dessous%nlpuis cliquez sur le bouton Sélectionner", "<br/>")."</div>");
      $strLabel .= "<br>("._nf("%s réponse", "%s réponses", $nbAgent).")";
    } else {
      $oCtrlSelect = AlkHtmlFactory::getHtml(_t("Aucune réponse."));
    }
    $oCtrlSelect->setLabel($strLabel);

    $oBlock = $this->addBlock("block_1", "", "", $iWidthLabel, $iWidthCtrl, false);
    $oBlock->addCtrl($oCtrlTxt);
    $oBlock->addCtrl($oCtrlHtml);
    $oBlock->addCtrl($oCtrlSelect);
    
    if ( $nbAgent>0 ) {
      $this->addButtonPage("bt_1", "javascript:ajoutSimple();", _t("Sélectionner"), _t("Sélectionner l'agent"));
    }
    else {
      $this->addButtonPage("bt_1", "javascript:onChangeFiltre('".$strToken."');", _t("Rechercher"), _t("Valider le filtre"));
    }
    $this->addButtonPage("bt_2", "javascript:closeWindow()", _t("Fermer"), _t("Abandonner la sélection puis fermer la fenêtre"));

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlpopupuserlist.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->addOnload("onLoadFormUserList()");

    $strHtmlJs = 
      " var oOpener = null;".
      " var obS = null;".
      " var obId = null;".
      " var obTxt = null;".
      " var strUrl = \"\";".
      " function onLoadFormUserList() {".
      "   var f = document.formUserList;".
      "   oOpener = GetWindowOpener();".
      "   if( oOpener==null ) { return; }".
      ( $dest != ""    ? " obS = oOpener.".$dest.";"      : "" ).
      ( $destId != ""  ? " obId = oOpener.".$destId.";"   : "" ).
      ( $destTxt != "" ? " obTxt = oOpener.".$destTxt.";" : "" ).
      ( $url != ""     ? " strUrl = \"".$url."\";"        : "" ).
      ( $erreur == 1 ? " alkAlert(\"Personne déjà présente !\");" : "" ).
      ( $erreur == 2 ? " alkAlert(\"Votre sélection est vide !\");" : "" ).
      " f.agent_nom.focus();".
      " f.agent_nom.select();".
      " }";
    $this->addJs($strHtmlJs);
  }
  
}

?>