<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopupUsersList
 * 
 * Classe de selection multiple d'utilisateur de l'Annuaire
 */
class AlkHtmlPopupUsersProfil extends AlkHtmlForm 
{
  /**
   *  Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formUsersList"); 
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

   /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) 
  {
    $this->FILTRE_PROFIL_ID  = AlkRequest::getToken("FILTRE_PROFIL_ID", AlkRequest::_REQUEST("FILTRE_PROFIL_ID", "-1"));
    $this->listUsersId = AlkRequest::_REQUEST("listUsersId", array());

    $this->user_id = AlkFactory::getSProperty("user_id", "-1");
    $this->cont_id = $this->oAppli->cont_id; 

    // filtre les utilisateurs sur cet espace si <>""
    $this->cont_id_filtre = AlkRequest::getToken("cont_id_filtre", "");
    $this->cont_id_profil = ( $this->cont_id_filtre != "" ? -$this->cont_id_filtre : -$this->cont_id );

    // exclu les utilisateurs appartenant à cet espace si <>""
    $this->cont_id_exclude = AlkRequest::getToken("cont_id_exclude", "");

    // exclu les utilisateurs appartenant à cet espace si <>""
    $this->profil_id_exclude = AlkRequest::getToken("profil_id_exclude", "-1");

    // filtre les utilisateurs ayant accès à cette application si <>""
    $this->appli_id_filtre = AlkRequest::getToken("appli_id_filtre", "");

    // token pour reafficher la page opener sur fermeture de popup
    $this->tokenClose = AlkRequest::getToken("tokenClose", "");

    // facultatif : =1 pour afficher les administrateurs principaux dans la liste des profils
    $this->iAffAdmin = AlkRequest::getToken("iAffAdmin", "0");

    $this->strParam = "&FILTRE_PROFIL_ID=".$this->FILTRE_PROFIL_ID."&cont_id_filtre=".$this->cont_id_filtre."&appli_id_filtre=".$this->appli_id_filtre.
      "&cont_id_exclude=".$this->cont_id_exclude."&profil_id_exclude=".$this->profil_id_exclude.
      "&iAffAdmin=".$this->iAffAdmin.
      "&tokenClose=".$this->tokenClose;
  }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql() 
  {
    $this->setData(ALK_INIT_MODE_REQUEST); 
    foreach ($this->listUsersId as $agent_id){
      $this->oAppli->oQueryAction->delAgentProfil($agent_id, $this->FILTRE_PROFIL_ID);
    }
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_PROFIL, ALK_SHEET_NONE, $this->strParam);
    return ALK_ALKANET."?token=".$strToken;
  }

  /**
   *  Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  {
    return _f("Liste des % associés au profil", ALK_S_AGENTS);
  }
  
  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);

    $FILTRE_NOM        = AlkRequest::_REQUEST("FILTRE_NOM", "");
    $FILTRE_SERVICE_ID = AlkRequest::_REQUEST("FILTRE_SERVICE_ID", "");
    $FILTRE_ESPACE     = AlkRequest::_REQUESTint("FILTRE_ESPACE", "0");
    $FILTRE_MISSION_ID = AlkRequest::_REQUEST("FILTRE_MISSION_ID", "0");
    $FILTRE_LISTE_ID   = AlkRequest::_REQUEST("FILTRE_LISTE_ID", "-1");
    $FILTRE_PRIV_ID    = AlkRequest::_REQUEST("FILTRE_PRIV_ID", "-1");
    if( $FILTRE_SERVICE_ID == "" ) $FILTRE_SERVICE_ID = "-1";

    $oHide = AlkHtmlFactory::getNewHtmlHidden(null, "FILTRE_PROFIL_ID", $this->FILTRE_PROFIL_ID);
    
    $bFiltreEspace = ( $this->appli_id_filtre!="" || $this->cont_id_filtre!="" || $this->cont_id_exclude!="" ? false : true );
    $bFiltreLsDif  = true;
    $bFiltreMission = ALK_B_ANNU_FILTER_MISSION;
    $bAffAdmin = ( $this->iAffAdmin == "1" );

    $oCtrlTxtNom = AlkHtmlFactory::getNewHtmlText(null, 0, "FILTRE_NOM", $FILTRE_NOM, "&nbsp;Nom", 1, 16, 16);
    $oQueryAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);  
    $oCtrlSelectProfil = AlkHtmlFactory::getNewHtmlSelect(null, 1, "TXT_FILTRE_PROFIL_ID", $this->FILTRE_PROFIL_ID, "Profil", 1, 190);
    $oCtrlSelectProfil->setProperty("tabValTxtDefault", array("0", " Tous les profils"));
    $oCtrlSelectProfil->setProperty("oValTxt", $oQueryAnnu->oQuery->getDsListProfilForCombo(28, $this->cont_id_profil, $this->profil_id_exclude));


    $this->setLabelDesc(_t("Afin de limiter l'affichage, il est recommand&eacute; d'utiliser les fonctions de filtre.")."<br/>".
                        _f("Les %s supprimés sont ceux dont la case sera coch&eacute;e.", mb_strtolower(ALK_S_AGENTS))."<br/>".
                        _f("Cliquez sur Supprimer pour retirer du profil les %s",mb_strtolower(ALK_S_AGENTS_SELS)).".<br/>" .
                            "<br/><b>"._t("Profil")." : ".$oCtrlSelectProfil->getHtml()."</b>");
    $oCtrlSelectService = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_SERVICE_ID", $FILTRE_SERVICE_ID, "Service", 1, 160);
    $oCtrlSelectService->setProperty("tabValTxtDefault", array("-1", _t("Tous les services")));
    $oCtrlSelectService->setProperty("oValTxt", $oQueryAnnu->oQuery->getDsListeServiceForCombo("1", "-1", false, 18));

    $strFiltreEspace = "";
    if( $bFiltreEspace ) {
      $oCtrlCBEspace = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "FILTRE_ESPACE", $FILTRE_ESPACE, _t("Restreindre à cet espace"));
      $strFiltreEspace = $oCtrlCBEspace->getLabel()." : ".$oCtrlCBEspace->getHtml();
    }

    $oCtrlCBAll = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "iCheckAll", 0, "");
    $oCtrlCBAll->addEvent("onclick", "SelectAllCB()");

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_PROFIL, ALK_SHEET_NONE, $this->strParam);
    $oBtAdd    = AlkHtmlFactory::getHtmlButtonPage("javascript:ValiderSuppression('".$strToken."');", _t("Supprimer"), _f("Retirer du profil les % cochés", ALK_S_AGENTS));
    $oBtFiltre = AlkHtmlFactory::getHtmlButtonPage("javascript:ValiderFiltre('".$strToken."')", _t("Filtrer"), _t("Exécuter le filtre"));

    /** tableau contenant les éléments de filtre */
    /** tableau des utilisateurs à sélectionner */
    $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    $dsAgent = $oQuery->getDsListUsers($FILTRE_NOM, $this->FILTRE_PROFIL_ID, $FILTRE_SERVICE_ID, $FILTRE_MISSION_ID, 
                                       $this->cont_id_filtre, $this->cont_id, $FILTRE_ESPACE, $bFiltreEspace, 
                                       $this->cont_id_exclude, $this->appli_id_filtre, $this->iAffAdmin, $FILTRE_LISTE_ID, 
                                       $FILTRE_PRIV_ID, $this->profil_id_exclude);
    $nbElt = $dsAgent->getCountTotDr();
    $page = 1;

    $nbEltFilter = 1;
    $oTabFilter = AlkHtmlFactory::getHtmlList($this, $nbElt, 1, 1, false, "", "", false, "tabFilter");
    $oTabFilter->setProperty("bSelectNbElts", false);
   
    $oTabFilter->setColumns(array("left", 540), array("center",120));

    $oTabFilter->addTitleRow(_f("Nombre % filtré : %s", ALK_S_DAGENT, $nbElt), $oBtFiltre->getHtml());
    $oTabFilter->addRow(array($oCtrlTxtNom->getLabel()." : ".$oCtrlTxtNom->getHtml()."&nbsp;&nbsp;&nbsp;&nbsp;". 
                              $oCtrlSelectService->getLabel()." : ".$oCtrlSelectService->getHtml().$oHide->getHtml(), 2, 1));

    if( $bFiltreLsDif ) {
      $oCtrlSelectLsDif = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_LISTE_ID", $FILTRE_LISTE_ID, _t("Liste de diffusion"), 1, 340);
      $oCtrlSelectLsDif->setProperty("tabValTxtDefault", array("-1", " Aucune"));
      $oCtrlSelectLsDif->setProperty("oValTxt", $this->oAppli->oQuery->getDsListes($this->user_id, $this->cont_id, true));
      $oTabFilter->addRow(array($oCtrlSelectLsDif->getlabel()." : ".$oCtrlSelectLsDif->getHtml().
                                "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$strFiltreEspace, 2, 1));
      $nbEltFilter++;
    }

    $strMissionPriv = "";
    if( $this->iAffAdmin == "1" ) {
      $oCtrlSelectPriv = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_PRIV_ID", $FILTRE_PRIV_ID, _t("Privilèges"), 1);
      $tabPriv = array("-1"                 => _t("Aucun filtre"),
                       ALK_PRIV_SPACE_USER  => _t("Utilisateur"),
                       ALK_PRIV_ANNU_SERV   => _t("Admin. annuaire de service"),
                       ALK_PRIV_ANNU_ALL    => _t("Admin. de tout l'annuaire"),
                       ALK_PRIV_SPACE_ADMIN => _t("Anim. de tous les espaces"),
                       ALK_PRIV_SPACE_ADMIN+
                       ALK_PRIV_ANNU_ALL    => _t("Administrateur général"));
      $oCtrlSelectPriv->setProperty("tabValTxt", $tabPriv);
      $strMissionPriv = $oCtrlSelectPriv->getLabel()." : ".$oCtrlSelectPriv->getHtml();
    }
    
    if( $bFiltreMission ) {
      $iWidth = ( $this->iAffAdmin == "1" ? 350 : 390 );
      $oCtrlSelectMission = AlkHtmlFactory::getNewHtmlSelect(null, 0, "FILTRE_MISSION_ID", $FILTRE_MISSION_ID, _t("Mission"), 1, $iWidth);
      $oCtrlSelectMission->setProperty("tabValTxtDefault", array("0", _t(" Toutes les missions")));
      $oCtrlSelectMission->setProperty("oValTxt", $this->oAppli->oQuery->getDsListMissionForCombo(55));
      $strMissionPriv = $oCtrlSelectMission->getlabel()." : ".$oCtrlSelectMission->getHtml().
        ( $strMissionPriv != "" ? "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" : "" ).$strMissionPriv;
    }
    if( $strMissionPriv != "" ) {
      $oTabFilter->addRow(array($strMissionPriv, 2, 1));
      $nbEltFilter++;
    }

    $oTabFilter->setNbTotItems($nbEltFilter);

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_PROFIL, ALK_SHEET_NONE, $this->strParam);

    $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, $page, ($nbElt==0 ? 1 : $nbElt), false, ALK_ALKANET."?token=".$strToken, 
                                            _f("Aucun %s n'est associé au profil.", ALK_S_AGENT), false, "tabUsers", false);
   
    $oTabPage->setColumns(array("left", 240), array("left", 180), array("left", 180), array("center", 50));

    $oTabPage->addTitleRow(array("<div align='right'>".$oBtAdd->getHtml()."</div>", 4, 1));
    $oTabPage->addTitleRow(_t("Nom Prénom"), _t("Service"), _t("Profil principal"), $oCtrlCBAll->getHtml());
       
    $cpt = 0;
    while( $drAgent = $dsAgent->getRowIter() ) {
      $agent_id = $drAgent->getValueName("ID");
      $agent_nom = $drAgent->getValueName("NOM");
      $strProfil = $drAgent->getValueName("PROFIL");
      $idService = $drAgent->getValueName("IDSERVICE");
      $strService = $drAgent->getValueName("SERVICE");

      $strUser = "";      
      $oCtrlCB = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "listUsersId[]", -1, "", $agent_id);
      
      $strUser = '<a title="'._f("voir la fiche de l'agent %s", $agent_nom).
                  '" href="javascript:OpenPopupFiche(\'agent\', '.$agent_id.');" >'.$agent_nom.'</a>'.$strUser;
      $strServ = '<a title="'._t("voir la fiche service").
                 '" href="javascript:OpenPopupFiche(\'service\', '.$idService.');">'.$strService.'</a>';

      $oTabPage->addRow($strUser, $strServ, $strProfil, $oCtrlCB->getHtml());
    }

    $this->addPanel($oTabFilter);
    $this->addPanel($oTabPage);

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlpopupuserslist.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->setTemplate("annu", "alkhtmlpopupuserslist.tpl");  

  }
}
?>