<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimport.class.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimportwarning.class.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimporterror.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkImportAnnu
 * 
 * Classe d'import pour l'annuaire
 */
class AlkImportAnnu extends AlkImport
{
	
  /** reference sur l'application */
  protected $oAppli;
	
	/**
   *  Constructeur de la classe Import : initialisation des attributs de Import.
   *
   * @param strFichier_Import Emplacement  du fichier d'import
   * @param tabImport  Tableau contenant les proprietés des  colonnes
   * @param tabSup  Tableau contenant les colonnes obligatoires pour la suppression
   * @param tabAjoutt  Tableau contenant les colonnes obligatoires pour l'ajouts
   * @param objErreur  Nom de l'objet  ImportErreur
   */
	function AlkImportAnnu($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                         $tabModif, &$obj_Erreur,&$objWarning, &$oQuery, &$oQueryAction, &$oSpace, &$oAppli)
	{
		parent::__construct($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                        $tabModif, $obj_Erreur,$objWarning, $oQuery, $oQueryAction, $oSpace );
    $this->oAppli = $oAppli;
	}
	
  /**
   *  Fonction qui rend un tableaux de champs valeurs.
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return tabChampsData  un tableau de champs valeurs
   */
	function getChampsData($tabLigne, $tabCopy, $tabLigneRef, $bUpdate=false)
	{
    if( !$bUpdate ) { 
      // mode ajout
      $tabChampsData = array("AGENT_ID"      => "-1", "AGENT_PRIV"   => "-1", "PROFIL_ID"      => "-1", "AGENT_CIVILITE" => "",
                             "AGENT_NOM"     => "",   "AGENT_PRENOM" => "",   "AGENT_FONCTION" => "",   "AGENT_LOGIN"    => "",
                             "ADR_ADR1"      => "",   "ADR_ADR2"     => "",   "ADR_ADR3"       => "",   "ADR_POST"       => "", "ADR_VILLE" => "", "ADR_PAYS" => "", "ADR_DESC" => "",
                             "AGENT_DESC"    => "",   "AGENT_VALIDE" => "0",  "AGENT_MAIL"     => "",   "AGENT_TEL"      => "",
                             "AGENT_TELPOSTE"=> "",   "AGENT_MOBILE" => "",   "AGENT_PWD"      => "",   "AGENT_FAX"      => "",
                             "AGTYPE_ID"     => "0");
      $tabChampsServ = array("SERV_NIV1" => "-1", "SERV_NIV2" => "-1", "SERV_NIV3" => "-1", "SERV_NIV4" => "-1");
    } else {
      // mode modif
      $tabChampsData = array("AGENT_ID"      => "-2", "AGENT_PRIV"   => "-2", "PROFIL_ID"      => "-2", "AGENT_CIVILITE" => "-2",
                             "AGENT_NOM"     => "-2", "AGENT_PRENOM" => "-2", "AGENT_FONCTION" => "-2", "AGENT_LOGIN"    => "-2",
                             "ADR_ADR1"      => "-2", "ADR_ADR2"     => "-2", "ADR_ADR3"       => "-2", "ADR_POST"       => "-2", "ADR_VILLE" => "-2", "ADR_PAYS" => "-2", "ADR_DESC" => "-2",
                             "AGENT_DESC"    => "-2", "AGENT_VALIDE" => "-2", "AGENT_MAIL"     => "-2", "AGENT_TEL"      => "-2",
                             "AGENT_TELPOSTE"=> "-2", "AGENT_MOBILE" => "-2", "AGENT_PWD"      => "",   "AGENT_FAX"      => "-2",
                             "AGTYPE_ID"     => "-2");
      $tabChampsServ = array("SERV_NIV1" => "-2", "SERV_NIV2" => "-2", "SERV_NIV3" => "-2", "SERV_NIV4" => "-2");
    }
    
		$tabChampsCom = array_fill(0, 7, "");
		$tabChampsMiss = array("MISSION1"  => "-1", "MISSION2"  => "-1", "MISSION3"  => "-1");
		$tabChamps = array();

		if (in_array("CLE",$tabLigneRef) && ($tabLigne[$tabCopy["CLE"]] != "")) 
      $tabChampsData["AGENT_ID"] = $tabLigne[$tabCopy["CLE"]];

		if (in_array("PROFIL",$tabLigneRef) && ($tabLigne[$tabCopy["PROFIL"]] != "")) 
      $tabChampsData["PROFIL_ID"] = $tabLigne[$tabCopy["PROFIL"]];

    if (in_array("PRIV",$tabLigneRef) && ($tabLigne[$tabCopy["PRIV"]] != "")) 
      $tabChampsData["AGENT_PRIV"] = $tabLigne[$tabCopy["PRIV"]];

		if (in_array("CIVILITE",$tabLigneRef) && ($tabLigne[$tabCopy["CIVILITE"]] != "")) 
      $tabChampsData["AGENT_CIVILITE"] = $tabLigne[$tabCopy["CIVILITE"]];

		if (in_array("NOM", $tabLigneRef) && ($tabLigne[$tabCopy["NOM"]] != "")) 
      $tabChampsData["AGENT_NOM"] = $tabLigne[$tabCopy["NOM"]];

		if (in_array("PRENOM",$tabLigneRef) && ($tabLigne[$tabCopy["PRENOM"]] != "")) 
      $tabChampsData["AGENT_PRENOM"] = $tabLigne[$tabCopy["PRENOM"]];

		if (in_array("PWD",$tabLigneRef) && ($tabLigne[$tabCopy["PWD"]] != "")) 
      $tabChampsData["AGENT_PWD"] = $tabLigne[$tabCopy["PWD"]];
      
    if (in_array("FONCTION",$tabLigneRef) && ($tabLigne[$tabCopy["FONCTION"]] != "")) 
      $tabChampsData["AGENT_FONCTION"] = $tabLigne[$tabCopy["FONCTION"]];

		if (in_array("LOGIN",$tabLigneRef) && ($tabLigne[$tabCopy["LOGIN"]] != "")) 
      $tabChampsData["AGENT_LOGIN"] = $tabLigne[$tabCopy["LOGIN"]];

    if (in_array("ADRESSE_1",$tabLigneRef) && ($tabLigne[$tabCopy["ADRESSE_1"]] != "")) 
      $tabChampsData["ADR_ADR1"] = $tabLigne[$tabCopy["ADRESSE_1"]];

    if (in_array("ADRESSE_2",$tabLigneRef) && ($tabLigne[$tabCopy["ADRESSE_2"]] != "")) 
      $tabChampsData["ADR_ADR2"] = $tabLigne[$tabCopy["ADRESSE_2"]];

    if (in_array("ADRESSE_3",$tabLigneRef) && ($tabLigne[$tabCopy["ADRESSE_3"]] != "")) 
      $tabChampsData["ADR_ADR3"] = $tabLigne[$tabCopy["ADRESSE_3"]];

    if (in_array("CODE_POSTAL",$tabLigneRef) && ($tabLigne[$tabCopy["CODE_POSTAL"]] != "")) 
      $tabChampsData["ADR_POST"] = $tabLigne[$tabCopy["CODE_POSTAL"]];
      
    if (in_array("VILLE",$tabLigneRef) && ($tabLigne[$tabCopy["VILLE"]] != "")) 
      $tabChampsData["ADR_VILLE"] = $tabLigne[$tabCopy["VILLE"]];

    if (in_array("PAYS",$tabLigneRef) && ($tabLigne[$tabCopy["PAYS"]] != "")) 
      $tabChampsData["ADR_PAYS"] = $tabLigne[$tabCopy["PAYS"]];

    if (in_array("ADR_DESC",$tabLigneRef) && ($tabLigne[$tabCopy["ADR_DESC"]] != "")) 
      $tabChampsData["ADR_DESC"] = $tabLigne[$tabCopy["ADR_DESC"]];

		if (in_array("TEL_FIXE",$tabLigneRef) && ($tabLigne[$tabCopy["TEL_FIXE"]] != "")) 
      $tabChampsData["AGENT_TEL"] = $tabLigne[$tabCopy["TEL_FIXE"]];

    if (in_array("TEL_POSTE",$tabLigneRef) && ($tabLigne[$tabCopy["TEL_POSTE"]] != "")) 
      $tabChampsData["AGENT_TELPOSTE"] = $tabLigne[$tabCopy["TEL_POSTE"]];

		if (in_array("FAX",$tabLigneRef) && ($tabLigne[$tabCopy["FAX"]] != "")) 
      $tabChampsData["AGENT_FAX"] = $tabLigne[$tabCopy["FAX"]];

		if (in_array("TEL_MOBILE",$tabLigneRef) && ($tabLigne[$tabCopy["TEL_MOBILE"]] != "")) 
      $tabChampsData["AGENT_MOBILE"] = $tabLigne[$tabCopy["TEL_MOBILE"]];

		if (in_array("MEL",$tabLigneRef) && ($tabLigne[$tabCopy["MEL"]] != "")) 
      $tabChampsData["AGENT_MAIL"] = $tabLigne[$tabCopy["MEL"]];

		if (in_array("COMMENTAIRE",$tabLigneRef) && ($tabLigne[$tabCopy["COMMENTAIRE"]] != "")) 
      $tabChampsData["AGENT_DESC"] = $tabLigne[$tabCopy["COMMENTAIRE"]];

		if (in_array("VALIDE",$tabLigneRef) && ($tabLigne[$tabCopy["VALIDE"]] != "")) 
      $tabChampsData["AGENT_VALIDE"] = $tabLigne[$tabCopy["VALIDE"]];

    if (in_array("TYPE",$tabLigneRef) && ($tabLigne[$tabCopy["TYPE"]] != "")) 
      $tabChampsData["AGTYPE_ID"] = $tabLigne[$tabCopy["TYPE"]];

    if( in_array("SERV_NIV1", $tabLigneRef) && ($tabLigne[$tabCopy["SERV_NIV1"]] != "") ) {
      $tabChampsServ["SERV_NIV1"] = $this->oQuery->getstr_serviceIdByNameByParent($tabLigne[$tabCopy["SERV_NIV1"]], "-1", "1");

      if( in_array("SERV_NIV2", $tabLigneRef) && ($tabLigne[$tabCopy["SERV_NIV2"]] != "") ) {
        $tabChampsServ["SERV_NIV2"] = $this->oQuery->getstr_serviceIdByNameByParent($tabLigne[$tabCopy["SERV_NIV2"]], $tabChampsServ["SERV_NIV1"], "2");
        if( in_array("SERV_NIV3", $tabLigneRef) && ($tabLigne[$tabCopy["SERV_NIV3"]] != "") ) {
          $tabChampsServ["SERV_NIV3"] = $this->oQuery->getstr_serviceIdByNameByParent($tabLigne[$tabCopy["SERV_NIV3"]], $tabChampsServ["SERV_NIV2"], "3");
          if( in_array("SERV_NIV4", $tabLigneRef) && ($tabLigne[$tabCopy["SERV_NIV4"]] != "") ) {
            $tabChampsServ["SERV_NIV4"] = $this->oQuery->getstr_serviceIdByNameByParent($tabLigne[$tabCopy["SERV_NIV4"]], $tabChampsServ["SERV_NIV3"], "4");
          }
        }
      }
    }
        
		if( in_array("MISSION1", $tabLigneRef) && ($tabLigne[$tabCopy["MISSION1"]] != "") ) 
		  $tabChampsMiss["MISSION1"] = $this->getIdChamp($tabLigne[$tabCopy["MISSION1"]], $this->tabAlkImportCol[20]["type"]);
		
		if( in_array("MISSION2",$tabLigneRef) && ($tabLigne[$tabCopy["MISSION2"]] != "") ) 
      $tabChampsMiss["MISSION2"] = $this->getIdChamp($tabLigne[$tabCopy["MISSION2"]], $this->tabAlkImportCol[21]["type"]);

		if( in_array("MISSION3",$tabLigneRef) && ($tabLigne[$tabCopy["MISSION3"]] != "") ) 
      $tabChampsMiss["MISSION3"] = $this->getIdChamp($tabLigne[$tabCopy["MISSION3"]], $this->tabAlkImportCol[22]["type"]);
		
		return 	$tabChamps = array($tabChampsData, $tabChampsCom, $tabChampsServ, $tabChampsMiss);
	}
	
  /**
   *  Fonction insertion de la ligne courante .
   *
   * @param tabLigne     Tableau contenant ligne courante
   * @param tabCopy      Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @param t            numéro de la ligne
   * @return vrai si ibsertion faux sinon
   */
	function insert($tabLigne, $tabCopy, $tabLigneRef, $t)
	{
		$tabChamps = $this->getChampsData($tabLigne, $tabCopy, $tabLigneRef);
    $iWarning = 0;

		$tabChampsData = $tabChamps[0];
		$tabChampsCom  = $tabChamps[1];
		$tabChampsServ = $tabChamps[2];
		$tabChampsMiss = $tabChamps[3];

    $profil_id = $tabChampsData["PROFIL_ID"];
    if( $profil_id == "-1" ) {
      $strMes = "Alerte : Ligne ".$t.", le profil n'est pas reconnu. Profil utilisateur attribué.";
      $this->obj_Warning->erreur(7, $strMes);      
      $iWarning++;
    }
    
    $agent_priv = $tabChampsData["AGENT_PRIV"];
    if( $agent_priv == "-1" ) {
      $strMes = "Alerte : Ligne ".$t.", le privilège n'est pas reconnu. Privilège simple utilisateur attribué.";
      $this->obj_Warning->erreur(7, $strMes);      
      $iWarning++;
      $tabChampsData["AGENT_PRIV"] = "0";
    } elseif( $agent_priv != "0" ) {
      $agent_priv = ($agent_priv & (ALK_PRIV_ANNU_SERV+ALK_PRIV_SPACE_ADMIN+ALK_PRIV_ANNU_ALL));
      if( ($agent_priv & ALK_PRIV_ANNU_SERV)==ALK_PRIV_ANNU_SERV ) {
        if( !AlkFactory::isAnnuAdminAll() ) {
          $strMes = "Alerte : Ligne ".$t.", privilège suffisant pour attribuer le privilège administrateur de service annuaire. Privilège simple utilisateur attribué.";
          $this->obj_Warning->erreur(7, $strMes);      
          $iWarning++;
          $tabChampsData["AGENT_PRIV"] = "0";
        }
      } elseif( ($agent_priv & ALK_PRIV_ANNU_ALL)==ALK_PRIV_ANNU_ALL ) {
        if( !(AlkFactory::isSpaceAnimAll() && AlkFactory::isAnnuAdminAll()) ) {
          $strMes = "Alerte : Ligne ".$t.", privilège suffisant pour attribuer le privilège administrateur de tout l'annuaire. Privilège simple utilisateur attribué.";
          $this->obj_Warning->erreur(7, $strMes);      
          $iWarning++;
          $tabChampsData["AGENT_PRIV"] = "0";
        }
      } elseif( ($agent_priv & ALK_PRIV_SPACE_ADMIN)==ALK_PRIV_SPACE_ADMIN ) {
        if( !(AlkFactory::isSpaceAnimAll() && AlkFactory::isAnnuAdminAll()) ) {
          $strMes = "Alerte : Ligne ".$t.", privilège suffisant pour attribuer le privilège animateur de tous les espaces. Privilège simple utilisateur attribué.";
          $this->obj_Warning->erreur(7, $strMes);      
          $iWarning++;
          $tabChampsData["AGENT_PRIV"] = "0";
        }
      }
    }

    // agent ajoutable si service de niveau 1 ok
    $id_Serv1 = $tabChampsServ["SERV_NIV1"];
    if(defined("ALK_B_ANNU_CLOISONNEMENT_SERVICE") && ALK_B_ANNU_CLOISONNEMENT_SERVICE==true && !AlkFactory::isAnnuAdminAll())
    	$user_ServId = AlkFactory::getSProperty("service_id", -1);
    else
    	$user_ServId = -1;
    if( $id_Serv1 == "-1" || ($user_ServId != -1 && ($id_Serv1 != $user_ServId))) {
      $strMes = "Erreur : Ligne ".$t.", le service ".$tabLigne[$tabCopy["SERV_NIV1"]]." n'existe pas. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }

    // vérifie si l'agent n'existe pas déjà par le nom, prénom et service
    $agent_id = $this->oQuery->getStr_agentIdByNomPrenomServId($tabChampsData["AGENT_NOM"], 
                                                               $tabChampsData["AGENT_PRENOM"], 
                                                               $tabChampsServ["SERV_NIV1"]);
    if( $agent_id != "-1" ) {
      $strMes = "Erreur : Ligne ".$t.", une fiche utilisateur semblable existe déjà. Risque de doublon. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }

		// préparation du tableau pour requeter l'ajout : force tous les champs en type chaine
    unset($tabChampsData["AGENT_ID"]);
    foreach($tabChampsData as $key=>$value) {
      $tabChampsData[$key] = array(ALK_SQL_TEXT, $value);
    }
    // réajuste les types numériques
    $tabFieldNum = array("PROFIL_ID", "AGENT_PRIV", "AGENT_VALIDE", "AGTYPE_ID");
    foreach($tabFieldNum as $value) {
      $tabChampsData[$value][0] = ALK_SQL_NUMBER;
    }
    
    $tabChampsData["SERVICE_ID"] = array(ALK_SQL_NUMBER, $tabChampsServ["SERV_NIV1"]); 
    $tabChampsData["SERV_NIV2"]  = array(ALK_SQL_NUMBER, $tabChampsServ["SERV_NIV2"]);
    $tabChampsData["SERV_NIV3"]  = array(ALK_SQL_NUMBER, $tabChampsServ["SERV_NIV3"]);
    $tabChampsData["SERV_NIV4"]  = array(ALK_SQL_NUMBER, $tabChampsServ["SERV_NIV4"]);
    $tabChampsData["IMPORT_ADD"] = array(ALK_SQL_NUMBER, 1);
    
    $tabQuery["field"] = $tabChampsData;
    $agent_id = $this->oAppli->addUser($tabQuery);
    
    if( $agent_id == "-1" ) {
      $strMes = "Erreur : Ligne ".$t.", impossible d'ajouter la fiche utilisateur. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);      
      return 2;
    }

		// ajout des missions
		foreach($tabChampsMiss as $strKey => $mission_id) {
      if( in_array($strKey, $tabLigneRef) && $tabLigne[$tabCopy[$strKey]] != "" && $mission_id == "-1" ) {
        $strMes = "Alerte : Ligne ".$t.", impossible d'associer la valeur de ".$strKey." à la fiche utilisateur.";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
     }
    }
    $this->oQueryAction->delAddAgentMission($agent_id, $tabChampsMiss);			

		//ajout service
    $iNiv = 1;
		foreach($tabChampsServ as $strKey => $service_id) {
      if( in_array($strKey, $tabLigneRef) && $tabLigne[$tabCopy[$strKey]] != "" && $service_id == "-1" ) {
        $strMes = "Alerte : Ligne ".$t.", impossible d'associer le service de niveau ".$iNiv." à la fiche utilisateur.";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
      $iNiv++;
    }    

    if( $iWarning != 0 ) {
			return 1;
		}
		return 0;
	}
	
	/**
   *  Fonction de modification de la ligne courante dans la base .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si ibsertion faux sinon
   */
	function update($tabLigne, $tabCopy, $tabLigneRef,$t)
	{
		$tabChamps = $this->getchampsData($tabLigne, $tabCopy, $tabLigneRef, true);

		$tabChampsData = $tabChamps[0];
		$tabChampsCom  = $tabChamps[1];
		$tabChampsServ = $tabChamps[2];
		$tabChampsMiss = $tabChamps[3];

    $iWarning = 0;
    // retrouve agent_id si pas explicite
    if( $tabChampsData["AGENT_ID"] == "-2" || $tabChampsData["AGENT_ID"]=="-1" ) {
      $agent_id = $this->oQuery->getStr_agentIdByNomPrenomServId($tabChampsData["AGENT_NOM"], 
                                                                 $tabChampsData["AGENT_PRENOM"], 
                                                                 $tabChampsServ["SERV_NIV1"]);
    } else {
      $agent_id = $tabChampsData["AGENT_ID"];
    }

    // charge la fiche
		$dsAgent = $this->oQuery->GetDs_ficheAgent($agent_id);
		if( $drAgent = $dsAgent->getRowIter() ) {
			$aProfil_id = $profil_id = $drAgent->getValueName("PROFIL_ID");
			$service_id     = $drAgent->getValueName("SERVICE_ID");
      $agent_civilite = $drAgent->getValueName("AGENT_CIVILITE");	
      $agent_nom      = $drAgent->getValueName("AGENT_NOM");	
      $agent_prenom   = $drAgent->getValueName("AGENT_PRENOM");	
      //$agent_prenom   = $drAgent->getValueName("AGENT_PWD");
      $agent_fonction = $drAgent->getValueName("AGENT_FONCTION");	
      $agent_desc     = $drAgent->getValueName("AGENT_DESC");	
      $aAgent_valide  = $agent_valide   = $drAgent->getValueName("AGENT_VALIDE");
      $aAgent_type    = $agent_type     = $drAgent->getValueName("AGTYPE_ID");
      $agent_login    = $drAgent->getValueName("AGENT_LOGIN"); 
      $agent_mail     = $drAgent->getValueName("AGENT_MAIL"); 
      $agent_tel      = $drAgent->getValueName("AGENT_TEL");
      $agent_telposte = $drAgent->getValueName("AGENT_TELPOSTE");  
      $agent_fax      = $drAgent->getValueName("AGENT_FAX"); 
      $agent_mobile   = $drAgent->getValueName("AGENT_MOBILE"); 
      $adr_adr1       = $drAgent->getValueName("ADR_ADR1");  
      $adr_adr2       = $drAgent->getValueName("ADR_ADR2");  
      $adr_adr3       = $drAgent->getValueName("ADR_ADR3");
      $adr_post       = $drAgent->getValueName("ADR_POST");
      $adr_ville      = $drAgent->getValueName("ADR_VILLE");
      $adr_pays       = $drAgent->getValueName("ADR_PAYS");
      $adr_desc       = $drAgent->getValueName("ADR_DESC");
      $aAgent_priv = $agent_priv = $drAgent->getValueName("AGENT_PRIV");
		} else {      
      $strMes = "Erreur : Ligne ".$t.", fiche utilisateur non trouvée pour modification. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }
    
		if( $tabChampsData["AGENT_CIVILITE"] != "-2" ) $agent_civilite = $tabChampsData["AGENT_CIVILITE"];
		if( $tabChampsData["AGENT_NOM"]      != "-2" ) $agent_nom      = $tabChampsData["AGENT_NOM"];
		if( $tabChampsData["AGENT_PRENOM"]   != "-2" ) $agent_prenom   = $tabChampsData["AGENT_PRENOM"];
    //if( $tabChampsData["AGENT_PWD"]      != "-2" ) $agent_prenom   = $tabChampsData["AGENT_PWD"];
		if( $tabChampsData["AGENT_FONCTION"] != "-2" ) $agent_fonction = $tabChampsData["AGENT_FONCTION"];
		if( $tabChampsData["AGENT_DESC"]     != "-2" ) $agent_desc     = $tabChampsData["AGENT_DESC"];
		if( $tabChampsData["AGENT_VALIDE"]   != "-2" ) $agent_valide   = $tabChampsData["AGENT_VALIDE"];
    	if( $tabChampsData["AGTYPE_ID"]      != "-2" ) $agent_type  = $tabChampsData["AGTYPE_ID"];
		if( $tabChampsData["PROFIL_ID"]      != "-2" ) $profil_id      = $tabChampsData["PROFIL_ID"];
    	if( $tabChampsData["AGENT_PRIV"]     != "-2" ) {
	      $agent_priv     = $tabChampsData["AGENT_PRIV"];
	      $agent_priv = ($agent_priv & (ALK_PRIV_ANNU_SERV+ALK_PRIV_SPACE_ADMIN+ALK_PRIV_ANNU_ALL));
	    }
	    if( $tabChampsData["ADR_ADR1"]       != "-2" ) $adr_adr1       = $tabChampsData["ADR_ADR1"];
	    if( $tabChampsData["ADR_ADR2"]       != "-2" ) $adr_adr2       = $tabChampsData["ADR_ADR2"];
	    if( $tabChampsData["ADR_ADR3"]       != "-2" ) $adr_adr3       = $tabChampsData["ADR_ADR3"];
	    if( $tabChampsData["ADR_POST"]       != "-2" ) $adr_post       = $tabChampsData["ADR_POST"];
	    if( $tabChampsData["ADR_VILLE"]      != "-2" ) $adr_ville      = $tabChampsData["ADR_VILLE"];
	    if( $tabChampsData["ADR_PAYS"]       != "-2" ) $adr_pays       = $tabChampsData["ADR_PAYS"];
	    if( $tabChampsData["ADR_DESC"]       != "-2" ) $adr_desc       = $tabChampsData["ADR_DESC"];
	    
	    if( $tabChampsData["AGENT_TEL"]      != "-2" ) $agent_tel      = $tabChampsData["AGENT_TEL"];
	    if( $tabChampsData["AGENT_TELPOSTE"] != "-2" ) $agent_telposte = $tabChampsData["AGENT_TELPOSTE"];
	    if( $tabChampsData["AGENT_FAX"]      != "-2" ) $agent_fax      = $tabChampsData["AGENT_FAX"];
	    if( $tabChampsData["AGENT_MOBILE"]   != "-2" ) $agent_mobile   = $tabChampsData["AGENT_MOBILE"];
	    if( $tabChampsData["AGENT_MAIL"]     != "-2" ) $agent_mail     = $tabChampsData["AGENT_MAIL"];
	    // reste AGENT_ID et AGENT_LOGIN non modifiable
	
	    if( !(AlkFactory::isSpaceAnimAll() && AlkFactory::isAnnuAdminAll()) ) {
	      if( $tabChampsData["PROFIL_ID"] != "-2" ) {
	        $strMes = "Alerte : Ligne ".$t.", privilège insuffisant pour modifier le profil par import. Modification abandonnée.";
	        $this->obj_Warning->erreur(7, $strMes);      
	        $iWarning++;
	        $profil_id = $aProfil_id;
	      }
	      if( $tabChampsData["AGENT_PRIV"] != "-2" ) {
	        $strMes = "Alerte : Ligne ".$t.", privilège insuffisant pour modifier le privilège par import. Modification abandonnée.";
	        $this->obj_Warning->erreur(7, $strMes);      
	        $iWarning++;
	        $agent_priv = $aAgent_priv;
	      }
	      if( $tabChampsData["AGENT_VALIDE"] != "-2"  ) {
	        $strMes = "Alerte : Ligne ".$t.", privilège insuffisant pour modifier la validité du compte par import. Modification abandonnée.";
	        $this->obj_Warning->erreur(7, $strMes);      
	        $iWarning++;
	        $agent_valide = $aAgent_valide;
	      }
	      if( $tabChampsData["AGTYPE_ID"] != "-2"  ) {
	        $strMes = "Alerte : Ligne ".$t.", privilège insuffisant pour modifier le type du compte par import. Modification abandonnée.";
	        $this->obj_Warning->erreur(7, $strMes);      
	        $iWarning++;
	        $agent_type = $aAgent_type;
	      }
    	}
    
    $tabChampsData["AGENT_CIVILITE"] = $agent_civilite;
    $tabChampsData["AGENT_NOM"]      = $agent_nom;
    $tabChampsData["AGENT_PRENOM"]   = $agent_prenom;
    //$tabChampsData["AGENT_PWD"]      = $agent_prenom;
    $tabChampsData["AGENT_FONCTION"] = $agent_fonction;
    $tabChampsData["AGENT_DESC"]     = $agent_desc;
    $tabChampsData["AGENT_VALIDE"]   = $agent_valide;
    $tabChampsData["AGENT_VALIDEMEM"]= $aAgent_valide;
    $tabChampsData["AGTYPE_ID"]      = $agent_type;
    $tabChampsData["PROFIL_ID"]      = $profil_id;
    $tabChampsData["PROFIL_IDMEM"]   = $aProfil_id;
    $tabChampsData["AGENT_PRIV"]     = $agent_priv;
    $tabChampsData["AGENT_TEL"]      = $agent_tel;
    $tabChampsData["AGENT_TELPOSTE"] = $agent_telposte;
    $tabChampsData["AGENT_FAX"]      = $agent_fax;
    $tabChampsData["AGENT_LOGIN"]    = $agent_login;
    $tabChampsData["AGENT_LOGINMEM"] = $agent_login;
    $tabChampsData["AGENT_MOBILE"]   = $agent_mobile;
    $tabChampsData["AGENT_MAIL"]     = $agent_mail;
    $tabChampsData["AGENT_ID"]       = $agent_id;
    $tabChampsData["ADR_ADR1"]       = $adr_adr1;
    $tabChampsData["ADR_ADR2"]       = $adr_adr2;
    $tabChampsData["ADR_ADR3"]       = $adr_adr3;
    $tabChampsData["ADR_POST"]       = $adr_post;
    $tabChampsData["ADR_VILLE"]      = $adr_ville;
    $tabChampsData["ADR_PAYS"]       = $adr_pays;
    $tabChampsData["ADR_DESC"]       = $adr_desc;
    $tabChampsData["SERVICE_ID"]     = $service_id;

    // préparation du tableau pour requeter la modif : force tous les champs en type chaine
    foreach($tabChampsData as $key=>$value) {
      $tabChampsData[$key] = array(ALK_SQL_TEXT, $value);
    }
    // réajuste les types numériques
    $tabFieldNum = array("AGENT_ID", "PROFIL_ID", "AGENT_PRIV", "AGENT_VALIDE", "SERVICE_ID", "AGTYPE_ID");
    foreach($tabFieldNum as $value) {
      $tabChampsData[$value][0] = ALK_SQL_NUMBER;
    }
    $tabChampsData["ALK_B_IMPORT"] = array(ALK_SQL_NUMBER, 1);
    $agent_id_import = $tabChampsData["AGENT_ID"]; 
    unset($tabChampsData["AGENT_ID"]);

    $tabQuery["field"] = $tabChampsData;    
    $tabQuery["pk"]["AGENT_ID"] = array(ALK_SQL_NUMBER, $agent_id);

    $this->oAppli->UpdateUser($agent_id, $tabQuery);

		// verifie si service niv1 ok
    $bServOk = true;
    if( $service_id != $tabChampsServ["SERV_NIV1"] && ($agent_id_import == "-2" || $agent_id_import=="-1")) {
      $strMes = "Alerte : Ligne ".$t.", il n'est pas permis de modifier le service".
        " de niveau 1 par l'import. Modification de la filiation abandonnée.";
      $this->obj_Warning->erreur(7, $strMes);      
      $iWarning++;
      $bServOk = false;
    }

    if( $bServOk == true ) {
      // filiation
      if( $tabChampsServ["SERV_NIV2"] != "-2" ) {
        if( $tabChampsServ["SERV_NIV2"] != "-1" ) {
          // filiation niv 2
          $this->oQueryAction->delAddFiliation($agent_id, 2, $service_id, $tabChampsServ["SERV_NIV2"], "-1", "-1");
          if( $tabChampsServ["SERV_NIV3"] != "-2" ) {
            if( $tabChampsServ["SERV_NIV3"] != "-1" ) {
              // filiation niv 3
              $this->oQueryAction->delAddFiliation($agent_id, 3, $service_id, $tabChampsServ["SERV_NIV2"], 
                                                    $tabChampsServ["SERV_NIV3"], "-1");
              if( $tabChampsServ["SERV_NIV4"] != "-2" ) {
                if( $tabChampsServ["SERV_NIV4"] != "-1" ) {                  
                  // filiation niv 4
                  $this->oQueryAction->delAddFiliation($agent_id, 4, $service_id, $tabChampsServ["SERV_NIV2"], 
                                                        $tabChampsServ["SERV_NIV3"], $tabChampsServ["SERV_NIV4"]);
                } else {
                  $strMes = "Alerte : Ligne ".$t.", le service de niveau 4 n'est pas reconnu.".
                    " Filiation sur ce niveau abandonnée.";
                  $this->obj_Warning->erreur(7, $strMes);
                  $iWarning++;
                }
              }
            } else {
              $strMes = "Alerte : Ligne ".$t.", le service de niveau 3 n'est pas reconnu.".
                " Filiation sur ce niveau abandonnée.";
              $this->obj_Warning->erreur(7, $strMes);
              $iWarning++;
            }
          }
        } else {
          $strMes = "Alerte : Ligne ".$t.", le service de niveau 2 n'est pas reconnu.".
            " Filiation sur ce niveau abandonnée.";
          $this->obj_Warning->erreur(7, $strMes);      
          $iWarning++;
        }
      }
    }

		// modif des missions
    // pas de modif, uniquement des ajouts
		foreach($tabChampsMiss as $strKey => $mission_id) {
      if( in_array($strKey, $tabLigneRef) && $tabLigne[$tabCopy[$strKey]] != "" && $mission_id == "-1" ) {
        $strMes = "Alerte : Ligne ".$t.", impossible d'associer la valeur de ".
          $strKey." à la fiche utilisateur.";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
    }
    $this->oQueryAction->delAddAgentMission($agent_id, $tabChampsMiss, false);
    			
    if( $iWarning != 0 ) {
			return 2;
		}
  	return 0;
	}
	
	/**
   *  Fonction de suppresion de la ligne courante dans la base .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si insertion faux sinon
   */
	function delete($tabLigne, $tabCopy, $tabLigneRef,$t)
	{
		$tabChamps = $this->getchampsData($tabLigne, $tabCopy, $tabLigneRef);

		$tabChampsData = $tabChamps[0];
		$agent_id = $tabChampsData["AGENT_ID"];		
		$agent_login = $tabChampsData["AGENT_LOGIN"];

		$dsAgent = $this->oQuery->GetDs_ficheAgent($agent_id);
		if( $drAgent = $dsAgent->getRowIter() ) {
			$agent_login_base = $drAgent->getValueName("AGENT_LOGIN");			
		} else {
      $strMes = "Erreur : Ligne ".$t.", impossible de supprimer la fiche utilisateur. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);      
      return 2;
		}
		
		if( strtoupper(trim($agent_login)) == strtoupper(trim($agent_login_base)) ) {
			$this->oAppli->DelUser($agent_id, ALK_B_SIT_REGION);
		} else {
			$strMes = "Alerte : La ligne ".$t.", impossible de supprimer la fiche utilisateur. Login incorrect. Ligne rejetée.";
			$this->obj_Erreur->erreur(7,$strMes);
			return 2;
		}
    return 0;
	}
	
	/**
   *  retourne la reference d'un champ..
   *
   * @param  champ  l'intitule du champs
   * @param  tabType tableau contenant le champs 
   * @return tabRes[0] la reference recherche dans la tabType et celle de la premiere case.
   */
	function getIdChamp($champ,$tabType)
	{
		$tabRes = array_keys($tabType, $champ);
    if( count($tabRes) > 0 ) 
      return $tabRes[0];
    return -1;
	}
	
}

?>
