<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimport.class.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimportwarning.class.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimporterror.class.php");
//include_once(ALK_ROOT_LIB."lib_fiche_agent.php");

//if( ALK_B_AGENT_SEND_MAIL_ANNU==true ) {
//	include_once("../../classes/mail/alkmail.class.php");
//	include_once(ALK_ROOT_LIB."lib_mail_agent.php");
//}

/**
 * @package Alkanet_Module_Annu
 * @class AlkImportAnnuServ
 * 
 * Classe d'import des services pour l'annuaire
 */
class AlkImportAnnuServ extends AlkImport
{
  
	protected $oAppli;
	
	/**
   *  Constructeur de la classe Import : initialisation des attributs de Import.
   *
   * @param strFichier_Import Emplacement  du fichier d'import
   * @param tabImport  Tableau contenant les proprietés des  colonnes
   * @param tabSup  Tableau contenant les colonnes obligatoires pour la suppression
   * @param tabAjoutt  Tableau contenant les colonnes obligatoires pour l'ajouts
   * @param objErreur  Nom de l'objet  ImportErreur
   */
	function AlkImportAnnuServ($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                         $tabModif, &$obj_Erreur,&$objWarning, &$oQuery, &$oQueryAction, &$oSpace , &$oAppli)
	{
		parent::__construct($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                      $tabModif, $obj_Erreur,$objWarning, $oQuery, $oQueryAction, $oSpace );
                      
    $this->oAppli = $oAppli;
	}
	
  /**
   *  Fonction qui rend un tableaux de champs valeurs.
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return tabChampsData  un tableau de champs valeurs
   */
	function getChampsData($tabLigne, $tabCopy, $tabLigneRef, $bUpdate=false)
	{
    if( $bUpdate == false ) {
      // mode ajout
      $tabChampsData = array("SERVICE_ID"     => "-1", "SERVICE_INTITULE"      => "-1", "SERVICE_INTITULE_COURT" => "", "SERVICE_NIVEAU"  => "",
                             "SERVICE_ADRESSE" => "",   "SERVICE_TEL" => "",   "SERVICE_FAX"    => "", "SERVICE_EMAIL" => "",
                             "SERVICE_WEB" => "", "SERVICE_ETAT" => "0", "DEPT_ID" => "0", 
                             "SERVICE_LDAP" => "0", "SERVICE_LDAPDN" => "", "SERVICE_LDAPUID" => "");
      $tabChampsServ = array("SERV_NIV1" => "-1", "SERV_NIV2" => "-1", "SERV_NIV3" => "-1", "SERV_NIV4" => "-1");
    } else {
      // mode modif
      $tabChampsData = array("SERVICE_ID"     => "-2", "SERVICE_INTITULE"      => "-2", "SERVICE_INTITULE_COURT" => "-2", "SERVICE_NIVEAU"  => "-2",
                             "SERVICE_ADRESSE" => "-2", "SERVICE_TEL" => "-2", "SERVICE_FAX"    => "-2", "SERVICE_EMAIL" => "-2",
                             "SERVICE_WEB" => "-2","SERVICE_ETAT" => "-2", "DEPT_ID" => "-2", 
                             "SERVICE_LDAP" => "-2", "SERVICE_LDAPDN" => "-2", "SERVICE_LDAPUID" => "-2");
      $tabChampsServ = array("SERV_NIV1" => "-2", "SERV_NIV2" => "-2", "SERV_NIV3" => "-2", "SERV_NIV4" => "-2");
    }
		$tabChamps = array();

		/**
		$sit_idUser = $_SESSION["sit_idUser"];
		$sit_idUserService = $_SESSION["sit_idUserService"];
		$sit_idUserProfil = $_SESSION["sit_idUserProfil"];
		*/
		if( isset($tabLigne[$tabCopy["CLE"]]) && 
        $tabLigne[$tabCopy["CLE"]] != "" ) 
      $tabChampsData["SERVICE_ID"] = $tabLigne[$tabCopy["CLE"]];
      
		if( isset($tabLigne[$tabCopy["INTITULE"]]) && 
        $tabLigne[$tabCopy["INTITULE"]] != "" ) 
      $tabChampsData["SERVICE_INTITULE"] = $tabLigne[$tabCopy["INTITULE"]];
      
		if( isset($tabLigne[$tabCopy["INTITULE_COURT"]]) && 
        $tabLigne[$tabCopy["INTITULE_COURT"]] != "" ) 
      $tabChampsData["SERVICE_INTITULE_COURT"] = $tabLigne[$tabCopy["INTITULE_COURT"]];
      
		if( isset($tabLigne[$tabCopy["SERVICE_NIVEAU"]]) && 
        $tabLigne[$tabCopy["SERVICE_NIVEAU"]] != "" ) 
      $tabChampsData["SERVICE_NIVEAU"] = $tabLigne[$tabCopy["SERVICE_NIVEAU"]];
      
		if( isset($tabLigne[$tabCopy["ADRESSE"]]) && 
        $tabLigne[$tabCopy["ADRESSE"]] != "" ) 
      $tabChampsData["SERVICE_ADRESSE"] = $tabLigne[$tabCopy["ADRESSE"]];
      
		if( isset($tabLigne[$tabCopy["TEL"]]) && 
        $tabLigne[$tabCopy["TEL"]] != "" ) 
      $tabChampsData["SERVICE_TEL"] = $tabLigne[$tabCopy["TEL"]];
      
		if( isset($tabLigne[$tabCopy["FAX"]]) && 
        $tabLigne[$tabCopy["FAX"]] != "" ) 
      $tabChampsData["SERVICE_FAX"] = $tabLigne[$tabCopy["FAX"]];
      
		if( isset($tabLigne[$tabCopy["EMAIL"]]) && 
        $tabLigne[$tabCopy["EMAIL"]] != "" ) 
      $tabChampsData["SERVICE_EMAIL"] = $tabLigne[$tabCopy["EMAIL"]];
      
		if( isset($tabLigne[$tabCopy["WEB"]]) && 
        $tabLigne[$tabCopy["WEB"]] != "" ) 
      $tabChampsData["SERVICE_WEB"] = $tabLigne[$tabCopy["WEB"]];
      
		if( isset($tabLigne[$tabCopy["ETAT"]]) && 
        $tabLigne[$tabCopy["ETAT"]] != "") 
      $tabChampsData["SERVICE_ETAT"] = $tabLigne[$tabCopy["ETAT"]];

    if( isset($tabLigne[$tabCopy["DEPT_ID"]]) && 
        $tabLigne[$tabCopy["DEPT_ID"]] != "" ) 
      $tabChampsData["DEPT_ID"] = $tabLigne[$tabCopy["DEPT_ID"]];
      
    if( isset($tabLigne[$tabCopy["SERVICE_LDAP"]]) && 
        $tabLigne[$tabCopy["SERVICE_LDAP"]] != "") 
      $tabChampsData["SERVICE_LDAP"] = $tabLigne[$tabCopy["SERVICE_LDAP"]];

    if( isset($tabLigne[$tabCopy["SERVICE_LDAPDN"]]) && 
        $tabLigne[$tabCopy["SERVICE_LDAPDN"]] != "") 
      $tabChampsData["SERVICE_LDAPDN"] = $tabLigne[$tabCopy["SERVICE_LDAPDN"]];

    if( isset($tabLigne[$tabCopy["SERVICE_LDAPUID"]]) && 
        $tabLigne[$tabCopy["SERVICE_LDAPUID"]] != "") 
      $tabChampsData["SERVICE_LDAPUID"] = $tabLigne[$tabCopy["SERVICE_LDAPUID"]];

    if( isset($tabLigne[$tabCopy["SERVICE_NIVEAU1"]]) &&  
        $tabLigne[$tabCopy["SERVICE_NIVEAU1"]] != "" ) {
      $tabChampsServ["SERVICE_NIV1"] = $tabLigne[$tabCopy["SERVICE_NIVEAU1"]];
      if( isset($tabLigne[$tabCopy["SERVICE_NIVEAU2"]]) && 
          $tabLigne[$tabCopy["SERVICE_NIVEAU2"]] != "" ) {
        $tabChampsServ["SERVICE_NIV2"] = $tabLigne[$tabCopy["SERVICE_NIVEAU2"]];
        if( isset($tabLigne[$tabCopy["SERVICE_NIVEAU3"]]) && 
            $tabLigne[$tabCopy["SERVICE_NIVEAU3"]] != "" ) {
          $tabChampsServ["SERVICE_NIV3"] = $tabLigne[$tabCopy["SERVICE_NIVEAU3"]];
          if( isset($tabLigne[$tabCopy["SERVICE_NIVEAU4"]]) && 
              $tabLigne[$tabCopy["SERVICE_NIVEAU4"]] != "" ) {
            $tabChampsServ["SERVICE_NIV4"] = $tabLigne[$tabCopy["SERVICE_NIVEAU4"]];
          }
        }
      }
    }
		
		return 	$tabChamps = array($tabChampsData, $tabChampsServ);
	}
	
  /**
   *  Fonction insertion de la ligne courante .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si ibsertion faux sinon
   */
	function insert($tabLigne, $tabCopy, $tabLigneRef, $t)
	{
		$tabChamps = $this->getChampsData($tabLigne, $tabCopy, $tabLigneRef);

		$tabChampsData = $tabChamps[0];
		$tabChampsServ = $tabChamps[1];

    $service_niveau         = $tabChampsData["SERVICE_NIVEAU"];
    $service_intitule       = $tabChampsData["SERVICE_INTITULE"];
    $service_intitule_court = ($service_niveau==1? $tabChampsData["SERVICE_INTITULE_COURT"]:"");
    $service_adresse        = $tabChampsData["SERVICE_ADRESSE"];
    $service_tel            = $tabChampsData["SERVICE_TEL"];
    $service_fax            = $tabChampsData["SERVICE_FAX"];
    $service_email          = $tabChampsData["SERVICE_EMAIL"];
    $service_web            = $tabChampsData["SERVICE_WEB"];
    $service_etat           = ( $service_niveau==1 ? $tabChampsData["SERVICE_ETAT"] : "" );
    $dept_id                = ( $service_niveau==1 ? $tabChampsData["DEPT_ID"]      : "" );
    $service_ldap           = $tabChampsData["SERVICE_LDAP"];
    $service_ldapdn         = $tabChampsData["SERVICE_LDAPDN"];
    $service_ldapuid        = $tabChampsData["SERVICE_LDAPUID"];
    
    //impossibilité d'ajouter un service de niveau 0
    if( $service_niveau == "0" ) {
      $strMes = "Alerte : Ligne ".$t.", il est impossible de créer un service de niveau 0. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;      
    }
    
    if( $service_intitule_court == "" && $service_niveau==1 ) {
      $strMes = "Alerte : Ligne ".$t.", il est impossible de créer un service de niveau 1 sans intitulé court. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;      
    }
    
    //recherche le nom de père direct
    $strIntitulePere=($service_niveau==1? $this->oQuery->get_IntituleServ0() : $tabChampsServ["SERV_NIV".($service_niveau-1)]);

    // vérifie si le service n'existe pas déjà par son intitule, son niveau, l'intitulé du père
    $service_id = $this->oQuery->get_IdServByIntituleNivPere($service_intitule, $service_niveau,$strIntitulePere);                                                            
    if( $service_id != "-1" ) {
      $strMes = "Erreur : Ligne ".$t.", une fiche service semblable existe déjà. Risque de doublon. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }

    // construction de l'arbre de filiation : uniquement pour rechercher l'id du père sans se tromper de branche
    $intitulePere = $this->oQuery->get_IntituleServ0();
    $service_pere = $this->oQuery->get_IdServ0();
    
    for ($i=1; $i<$service_niveau; $i++){
    	$serv_nivx = $tabChampsServ["SERVICE_NIV".$i];
    	if ($serv_nivx==""){
	      $strMes = "Erreur : Ligne ".$t.", Intitulé du niveau ".$service_niveau." absent. Ligne rejetée.";
	      $this->obj_Erreur->erreur(7, $strMes);
	      return 2;   		
    	}
    	
    	$idFils=$this->oQuery->get_IdServByIntituleNivPere($serv_nivx, $i , $intitulePere);
    	if ($idFils==-1){
 	      $strMes = "Erreur : Ligne ".$t.",Mauvaise filiation. Ligne rejetée.";
	      $this->obj_Erreur->erreur(7, $strMes);
	      return 2;   	   		
    	}

    	$intitulePere  = $serv_nivx;
    	$service_pere  = $idFils;
    }
    
    $service_etat= ( $service_niveau>1 ? $this->oQuery->GetStrServiceEtat($service_pere) : $service_etat );
    $dsServPere = $this->oQuery->GetDs_ficheService($service_pere);
	 
	  //ajout du service	 
 	  $service_id = $this->oQueryAction->addServiceImport($dsServPere, $service_pere, $service_intitule, 
   																							        $service_intitule_court, 
  																							        $service_adresse, $service_tel, $service_fax, $service_email,
  																							        $service_web, $service_etat, 0, -1, -1,
                                                        $dept_id, $service_ldap, $service_ldapdn, $service_ldapuid);
		
    if( $service_id == "-1" ) {
      $strMes = "Erreur : Ligne ".$t.", impossible d'ajouter la fiche service. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }

		return 0;
		
	}
	
	/**
   *  Fonction de modification de la ligne courante dans la base .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si ibsertion faux sinon
   */
	function update($tabLigne, $tabCopy, $tabLigneRef,$t)
	{
		$tabChamps = $this->getchampsData($tabLigne, $tabCopy, $tabLigneRef);

		$tabChampsData = $tabChamps[0];
		$tabChampsServ = $tabChamps[1];
		
    $service_id = $tabChampsData["SERVICE_ID"];
		$service_intitule = $tabChampsData["SERVICE_INTITULE"];

    // charge la fiche
		$dsService = $this->oQuery->GetDs_ficheService($service_id);
		if( $drService = $dsService->getRowIter() ) {
      $dept_id                = $drService->getValueName("DEPT_ID");
			$service_niveau         = $drService->getValueName("SERVICE_NIVEAU");
			$service_intitule_base  = $drService->getValueName("SERVICE_INTITULE");
			$service_intitule_court = $drService->getValueName("SERVICE_INTITULE_COURT");
			$service_adresse        = $drService->getValueName("SERVICE_ADRESSE");
			$service_tel            = $drService->getValueName("SERVICE_TEL");	
      $service_fax            = $drService->getValueName("SERVICE_FAX");	
      $service_email          = $drService->getValueName("SERVICE_EMAIL");	
      $service_web            = $drService->getValueName("SERVICE_WEB");
      $service_etat           = $drService->getValueName("SERVICE_ETAT");
      $service_ldap           = $drService->getValueName("SERVICE_LDAP");
      $service_ldapdn         = $drService->getValueName("SERVICE_LDAPDN");
      $service_ldapuid        = $drService->getValueName("SERVICE_LDAPUID");
		} else {      
      $strMes = "Erreur : Ligne ".$t.", fiche service ".$service_id." non trouvée pour modification. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }
    
    if ($service_niveau==0){
      $strMes = "Erreur : Ligne ".$t.", le service ".$service_id." est le service racine. Il n'est pas modifiable. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;  	
    }
    
 		if( strtoupper(trim($service_intitule)) != strtoupper(trim($service_intitule_base)) ) {
			$strMes = "Erreur : Ligne ".$t.", impossible de modifier la fiche service. Intitulé incorrect. Ligne rejetée.";
			$this->obj_Erreur->erreur(7,$strMes);
			return 2;
		}
    
    if( $service_intitule_court == "" && $service_niveau==1 ) {
      $strMes = "Alerte : Ligne ".$t.", le champ intitulé court pour un service de niveau 1 est obligatoire. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;      
    }
				
		if( $tabChampsData["SERVICE_ADRESSE"] != "-2" ) $service_adresse = $tabChampsData["SERVICE_ADRESSE"];
		if( $tabChampsData["SERVICE_TEL"]     != "-2" ) $service_tel     = $tabChampsData["SERVICE_TEL"];
		if( $tabChampsData["SERVICE_FAX"]     != "-2" ) $service_fax     = $tabChampsData["SERVICE_FAX"];
		if( $tabChampsData["SERVICE_EMAIL"]   != "-2" ) $service_email   = $tabChampsData["SERVICE_EMAIL"];
		if( $tabChampsData["SERVICE_WEB"]     != "-2" ) $service_web     = $tabChampsData["SERVICE_WEB"];
		
    if( $tabChampsData["SERVICE_ETAT"]    != "-2" ) {
      $service_etat    = $tabChampsData["SERVICE_ETAT"];
    } else {
      $service_etat = "-1"; // pas de modif
    }
    if( $tabChampsData["SERVICE_LDAP"]    != "-2" ) $service_ldap    = $tabChampsData["SERVICE_LDAP"];
    if( $tabChampsData["SERVICE_LDAPDN"]  != "-2" ) $service_ldapdn  = $tabChampsData["SERVICE_LDAPDN"];
    if( $tabChampsData["SERVICE_LDAPUID"] != "-2" ) $service_ldapuid = $tabChampsData["SERVICE_LDAPUID"];
    if( $tabChampsData["DEPT_ID"]         != "-2" ) { 
      $dept_id = $tabChampsData["DEPT_ID"]; // modif uniquement si user_id=user alkante
    } else {
      $dept_id = "-1"; // pas de modif
    } 
    
    $iWarning = 0;
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    if( $dept_id != "-1" && $user_id==ALK_USER_ID_ADMINALK ) {
      $strMes = "Alerte : Ligne ".$t.", impossible de modifier le champ dept_id. Seul l'administrateur Alkante y est autorisé.";
      $this->obj_Warning->erreur(7, $strMes);   
      $iWarning++;
    }
    if( $service_etat != "-1" && $user_id==ALK_USER_ID_ADMINALK ) {
      $strMes = "Alerte : Ligne ".$t.", impossible de modifier le champ etat. Seul l'administrateur Alkante y est autorisé.";
      $this->obj_Warning->erreur(7, $strMes);   
      $iWarning++;
    }   
    if( $service_ldap != "1" && $tabChampsData["SERVICE_LDAP"] != "-2" ) {
      $service_ldap    = "0";
      $service_ldapdn  = "";
      $service_ldapuid = "";
    }
    
    $this->oQueryAction->updateServiceImport($service_id, $service_intitule_base, $service_intitule_court, 
                                             $service_adresse, $service_tel, $service_fax, $service_email,
                                             $service_web, "", -1, -1, $service_etat,
                                             $dept_id, $service_ldap, $service_ldapdn, $service_ldapuid);

    if( $iWarning > 0 ) {
      return 1; 
    }
    
		return 0;
	}
	
	/**
   *  Fonction de suppresion de la ligne courante dans la base .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si insertion faux sinon
   */
	function delete($tabLigne, $tabCopy, $tabLigneRef,$t)
	{
		$tabChamps = $this->getchampsData($tabLigne, $tabCopy, $tabLigneRef);

		$tabChampsData = $tabChamps[0];
		$service_id = $tabChampsData["SERVICE_ID"];		
		$service_intitule = $tabChampsData["SERVICE_INTITULE"];

		$dsService = $this->oQuery->GetDs_ficheService($service_id);
		if( $drService = $dsService->getRowIter() ) {
			$service_intitule_base = $drService->getValueName("SERVICE_INTITULE");			
		} else {
      $strMes = "Erreur : Ligne ".$t.", impossible de supprimer la fiche service. La clé ".$service_id." n'existe pas. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);      
      return 2;
		}
		
		if( strtoupper(trim($service_intitule)) == strtoupper(trim($service_intitule_base)) ) {
			$bres=$this->oQueryAction->delService($service_id);
			if ($bres==false){
				$strMes = "Erreur : Ligne ".$t.", impossible de supprimer la fiche service. Violation de contrainte. Ligne rejetée.";
				$this->obj_Erreur->erreur(7,$strMes);
				return 2;
			}
		} else {
			$strMes = "Erreur : Ligne ".$t.", impossible de supprimer la fiche service. Intitulé incorrect. Ligne rejetée.";
			$this->obj_Erreur->erreur(7,$strMes);
			return 2;
		}
    return 0;
	}
	
	/**
   *  retourne la reference d'un champ..
   *
   * @param  champ  l'intitule du champs
   * @param  tabType tableau contenant le champs 
   * @return tabRes[0] la reference recherche dans la tabType et celle de la premiere case.
   */
	function getIdChamp($champ,$tabType)
	{
		$tabRes = array_keys($tabType, $champ);
    if( count($tabRes) > 0 ) 
      return $tabRes[0];
    return -1;
	}
	
}

?>
