/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * Interfaces : Pages de listes
 * Liens de suppression sur les listes
 */
function DelData(strToken, strMsg)
{
  Confirmation(ALK_ALKANET_SQL+"?token="+strToken,
               "Veuillez confirmer la suppression de "+strMsg+" ?");
}


/* ######################################## alkhtmlformabonne.class.php ######################################## */
/**
 * Interfaces : Liste des abonnés (valides ou non) / Fichier alkhtmlformabonne.class.php
 * Soumet le formulaire pour le champ de recherche
 */
function FiltrerAbonneList()
{
  var f = document.formAbonne;
  f.action = "";
  f.submit();
}

function Valider(strToken, bSearch)
{
  var f = document.formAbonne;
  if( bSearch ) f.bSearch.value = 1;
  f.action = ALK_ALKANET+"?token="+strToken;
  f.submit();
}

function Export(strToken)
{
  OpenFooterExec(ALK_ALKANET_SQL+"?token="+strToken);
}
function onClickCBAll()
{
  var f = document.formAbonne;

  var oCb = f.elements["cbAbonneId[]"];
  if( !oCb ) return;
  if( typeof(oCb.length)=="undefined" ) {
    oCb.checked = f.cbAll.checked;
  } else {
    for(i=0; i<oCb.length; i++) {
      oCb[i].checked = f.cbAll.checked;
    }
  }
}

function onChangeCbAction(oThis, strToken)
{
  var f = document.formAbonne;
  if( oThis.selectedIndex == 0 ) return;

  var bSelect = false;
  var oCb = f.elements["cbAbonneId[]"];
  if( !oCb ) return;
  if( typeof(oCb.length)=="undefined" ) {
    bSelect = oCb.checked;
  } else {
    for(i=0; i<oCb.length; i++) {
      bSelect = bSelect || oCb[i].checked;
    }
  }
  if( !bSelect ) {
    oThis.selectedIndex = 0;
    alkAlert("Vous devez sélectionner des abonnés avant d'appliquer une action.\n"+
          "Si l'action ne correspond pas à l'état de l'abonné, aucun danger, rien ne se passera.");
    return;
  }
  
  var bConfirm = false;
  if( oThis.selectedIndex == 1 ) {
    // activation
    bConfirm = alkConfirm("Veuillez confirmer l'activation des abonnés\n"+
                          "sélectionnés en attente d'activation ?");
  } else if( oThis.selectedIndex == 2 ) {
    // désactivation
    bConfirm = alkConfirm("Veuillez confirmer la désactivation des abonnés\n"+
                          "sélectionnés actifs ou en attente de validation ?");
  } else if( oThis.selectedIndex == 3 ) {
    // réactivation
    bConfirm = alkConfirm("Veuillez confirmer la réactivation\n"+
                          "des abonnés sélectionnés désactivés ?");
  } else if( oThis.selectedIndex == 4 ) {
    // suppression
    bConfirm = alkConfirm("Veuillez confirmer la suppression des abonnés\n"+
                          "sélectionnés désactivés ou en attente de validation ?");
  }
  if( bConfirm && oThis.selectedIndex > 0 ) {
    f.action = ALK_ALKANET_SQL+"?token="+strToken+"&a="+oThis.selectedIndex;
    f.submit();
  }
}

/**
 * vérfication unicité des pseudo et mails
 */
function checkLogin(formName, tabTypes){
	var bAlert = true;
	if ( arguments.length>2 ) bAlert = arguments[2];
	var form = eval("document."+formName);
	var bResult = true;
	for (var i=0; i<tabTypes.length && bResult; i++){
		var type = tabTypes[i];
		var uType = type.substring(0, 1).toUpperCase() + type.substring(1).toLowerCase();
	  var strToken = document.getElementById("token"+uType).value;
	  var strChamp = "abonne_"+type.toLowerCase();
	  
		var oValueChamp = document.getElementById(strChamp).value;
		var strParam = "&m="+oValueChamp;
	  var oAjax = new AlkAjax('nameUpdateLdap', 'fnLoadVerifParametre', ALK_FORM_METHOD_GET, 
	                          ALK_ALKANET_SQL+'?token='+strToken+strParam, null, false);
	  
	  bResult = bResult && fnLoadVerifParametre(oAjax.getReturnValue(), bAlert);
	}
  return bResult;
}

function fnLoadVerifParametre(strJs, bAlertAny){
   var tabRes = eval("("+strJs+")");
   var strIntitule = "";
   var iLogin=0;
   var strChamp ="";
   
    if(tabRes && tabRes.length != 0){
    	strIntitule = tabRes.intitule;
    	iLogin   = tabRes.iLogin;
    	strNewValeur = tabRes.new_valeur;
    	strChamp     = tabRes.champ;
    }
   if (iLogin=="1"){
     alert ("Le " +strIntitule+ " choisi est déjà utilisé par un autre abonné."+
                  (strChamp=="abonne_pseudo" ? " Une nouvelle proposition vous a été faite" : ""));
     if (strNewValeur !="")
       document.getElementById(strChamp).value = strNewValeur;
     return false;
   }
   if ( bAlertAny ){
   	 alert("Votre proposition est correcte.");
   }
   return true;
}

var nbClickVal = 0;
function checkAllLogin(strTokenUpdate, formName){
  var form = eval("document."+formName);
  
  var res = ( window.AlkVerifCtrl ? AlkVerifCtrl(form) : true );
  if ( res && !checkLogin(formName, ["pseudo", "mail"], false) ){
  	return false;
  }
  if( res && nbClickVal == 0 ) {
    nbClickVal++; 
	  form.action = ALK_ALKANET_SQL+"?token="+strTokenUpdate;
	  return true;
  }
  return false;
}

/**
 * Ajoute des abonnés à une liste
 */
function ajoutSimple(formName, strToken)
{
  var f = eval("document."+formName);
  var oCtrlUserList = f.ctrlUserList;

  if( oCtrlUserList && oCtrlUserList.value=="" ) { alkAlert("La liste des destinataires n'est pas renseignée."); f.oCtrlUserList.focus(); return }

  if( oCtrlUserList && oCtrlUserList.value!="" ) {
    f.action = ALK_ALKANET_SQL+'?token='+strToken;
    f.submit();
  } 
}

