<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Tif
Module d'administration de bordereaux tourinfrance.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."dico/classes/alkdicofactory.class.php";

/**
 * @package Alkanet_Module_Tif
 * 
 * @class AlkDicoTif
 * @brief Déclaration de la gestion des dictionnaires de Tif
 */
class AlkDicoCrbn_Cat extends AlkDicoFactory
{

  /**
   * Constructeur
   *
   * @param oAppli Référence de l'applicaton contenant le dictionnaire
   */
  public function __construct(&$oAppli)
  {
    parent::__construct($oAppli);  
  }
  
  /**
   * Initialisation de la déclaration des tables dictionnaires
   */
  protected function _initTabDico()
  {
  	$dbConn = AlkFactory::getDbConn();
  	$tabChampField = array("CHAMP_COLONNE", "CHAMP_LONGUEUR", "CHAMP_REQUIRED", "CHAMP_HTML", "CHAMP_SQL_COMBO_SQL");
  	$dsDico = $this->oAppli->oQuery->getListDico();

  	while($drDico = $dsDico->getRowIter()){
  		$dico_id 	= $drDico->getValueName("DICO_ID");
  		$dico_table	= $drDico->getValueName("DICO_TABLE");
      //if($dico_table != "sous_thematiques"){
        $this->tabDico[$dico_table] = array(
    			"title"		=> $drDico->getValueName("DICO_INTITULE"),
    			"search"	=> array("pattern" => html_entity_decode($drDico->getValueName("DICO_PATTERN"))),	
        );
    		$strColTitle	= $drDico->getValueName("DICO_COLONNESLIST");
    		$strColTitle	= " return array(array(\"".str_replace("::", "\", \"", str_replace("|", "\"), array(\"", $strColTitle))."\"));";
    		$tabCol = eval($strColTitle);
    		$this->tabDico[$dico_table]["search"]["titles"] = $tabCol;
    		if($drDico->getValueName("DICO_ORDERBY") != "")
    			$this->tabDico[$dico_table]["search"]["orderBy"] = $drDico->getValueName("DICO_ORDERBY");
    		if($drDico->getValueName("DICO_SELECTSQL") != "")
    			$this->tabDico[$dico_table]["search"]["sql"] = mb_convert_encoding(html_entity_decode($drDico->getValueName("DICO_SELECTSQL")), ALK_SGBD_ENCODING);
    		$dsChamp = $this->oAppli->oQuery->getListColonnesByDico($dico_id);
    		while($drChamp = $dsChamp->getRowIter()){
    			if($drChamp->getValueName("CHAMP_LONGUEUR") != ""){
            foreach($tabChampField as $field){
    					$array = array();
    					parse_str(html_entity_decode($drChamp->getValueName($field)), $array);
    					if(implode(array_values($array)) == "")
    						$value = $drChamp->getValueName($field);
    					else
    						$value = $array;
    					$this->tabDico[$dico_table][html_entity_decode($drChamp->getValueName("CHAMP_INTITULE"))][] = $value;

              
              
    				}
    			}else{
    				$this->tabDico[$dico_table][html_entity_decode($drChamp->getValueName("CHAMP_INTITULE"))] = html_entity_decode($drChamp->getValueName("CHAMP_COLONNE"));
    			}
    	}
    }
  }
}
?>