<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimport.class.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimportwarning.class.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimporterror.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."crbn_cat/lib/app_conf_crbn_cat.php");

/**
 * @package Alkanet_Module_CrbnCat
 * @class AlkImportEtude
 * 
 * Classe d'import pour l'annuaire
 */
class AlkImportEtude extends AlkImport
{
	
  /** reference sur l'application */
  protected $oAppli;
	
	/**
   *  Constructeur de la classe Import : initialisation des attributs de Import.
   *
   * @param strFichier_Import Emplacement  du fichier d'import
   * @param tabImport  Tableau contenant les proprietés des  colonnes
   * @param tabSup  Tableau contenant les colonnes obligatoires pour la suppression
   * @param tabAjoutt  Tableau contenant les colonnes obligatoires pour l'ajouts
   * @param objErreur  Nom de l'objet  ImportErreur
   */
	function AlkImportEtude($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                         $tabModif, &$obj_Erreur,&$objWarning, &$oQuery, &$oQueryAction, &$oSpace, &$oAppli)
	{
		parent::__construct($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                        $tabModif, $obj_Erreur,$objWarning, $oQuery, $oQueryAction, $oSpace );
    $this->oAppli = $oAppli;
	}
	
  /**
   *  Fonction qui rend un tableaux de champs valeurs.
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return tabChampsData  un tableau de champs valeurs
   */
	function getChampsData($tabLigne, $tabCopy, $tabLigneRef, $bUpdate=false)
	{
		$tabChamps = array();
		$tabChampsEtude = array();
		$tabChampsCommanditaire = array();
		$tabChampsPrincipalTheme = array();
		$tabChampsPrincipalSubTheme = array();
		$tabChampsSecondaryTheme = array(); 
		$tabChampsSecondarySubTheme = array(); 
		$tabChampsIconography = array();
		$tabChampsDocumentType = array(); 
		$tabChampsTypologie = array();
		$tabChampsMethodology = array();
		$tabChampsEtudePartenaire = array();
		
		if (in_array("dc:title",$tabLigneRef) && ($tabLigne[$tabCopy["dc:title"]] != "")) 
      $tabChampsEtude["etude_intitule"] = $tabLigne[$tabCopy["dc:title"]];
    
    if (in_array("dc:rights",$tabLigneRef) && ($tabLigne[$tabCopy["dc:rights"]] != "")) 
      $tabChampsEtude["etude_droit"] = $tabLigne[$tabCopy["dc:rights"]];
      
    if (in_array("dc:publisher",$tabLigneRef) && ($tabLigne[$tabCopy["dc:publisher"]] != "")) 
      $tabChampsEtude["etude_auteurs"] = $tabLigne[$tabCopy["dc:publisher"]];
      
    if (in_array("dc:creator",$tabLigneRef) && ($tabLigne[$tabCopy["dc:creator"]] != "")) 
      $tabChampsEtude["etude_redacteurs"] = $tabLigne[$tabCopy["dc:creator"]];
      
    if (in_array("dc:subject",$tabLigneRef) && ($tabLigne[$tabCopy["dc:subject"]] != "")) 
      $tabChampsEtude["etude_mots_cles"] = $tabLigne[$tabCopy["dc:subject"]];
      
    if (in_array("dc:owner",$tabLigneRef) && ($tabLigne[$tabCopy["dc:owner"]] != "")) 
      $tabChampsCommanditaire = explode("#",$tabLigne[$tabCopy["dc:owner"]]);
      
    if (in_array("dc:contact",$tabLigneRef) && ($tabLigne[$tabCopy["dc:contact"]] != "")) 
      $tabChampsEtude["etude_contact"] = $tabLigne[$tabCopy["dc:contact"]];
      
    if (in_array("dc:description",$tabLigneRef) && ($tabLigne[$tabCopy["dc:description"]] != "")) 
      $tabChampsEtude["etude_resume"] = $tabLigne[$tabCopy["dc:description"]];

      if (in_array("dct:created",$tabLigneRef) && ($tabLigne[$tabCopy["dct:created"]] != "")) 
      $tabChampsEtude["etude_annee_achevement"] = $tabLigne[$tabCopy["dct:created"]];
      
    if (in_array("dct:modified",$tabLigneRef) && ($tabLigne[$tabCopy["dct:modified"]] != "")) 
      $tabChampsEtude["etude_annee_maj"] = $tabLigne[$tabCopy["dct:modified"]];
      
    if (in_array("dct:dateSubmitted",$tabLigneRef) && ($tabLigne[$tabCopy["dct:dateSubmitted"]] != "")) 
      $tabChampsEtude["etude_date_publication"] = $tabLigne[$tabCopy["dct:dateSubmitted"]];
      
    if (in_array("dc:identifier",$tabLigneRef) && ($tabLigne[$tabCopy["dc:identifier"]] != "")) 
      $tabChampsEtude["etude_isrn"] = $tabLigne[$tabCopy["dc:identifier"]];
      
    if (in_array("dc:principal_keywords_theme",$tabLigneRef) && ($tabLigne[$tabCopy["dc:principal_keywords_theme"]] != "")) 
      $tabChampsPrincipalTheme = explode("#", $tabLigne[$tabCopy["dc:principal_keywords_theme"]]);
    
    if (in_array("dc:principal_keywords_subtheme",$tabLigneRef) && ($tabLigne[$tabCopy["dc:principal_keywords_subtheme"]] != "")) 
      $tabChampsPrincipalSubTheme = explode("#", $tabLigne[$tabCopy["dc:principal_keywords_subtheme"]]);
     
    if (in_array("dc:secondary_keywords_theme",$tabLigneRef) && ($tabLigne[$tabCopy["dc:secondary_keywords_theme"]] != "")) 
      $tabChampsSecondaryTheme = explode("#", $tabLigne[$tabCopy["dc:secondary_keywords_theme"]]);
    
    if (in_array("dc:secondary_keywords_subtheme",$tabLigneRef) && ($tabLigne[$tabCopy["dc:secondary_keywords_subtheme"]] != "")) 
      $tabChampsSecondarySubTheme = explode("#", $tabLigne[$tabCopy["dc:secondary_keywords_subtheme"]]);
    
    if (in_array("dc:booklet",$tabLigneRef) && ($tabLigne[$tabCopy["dc:booklet"]] != "")) 
      $tabChampsEtude["etude_desc_nb_fascicules"] = $tabLigne[$tabCopy["dc:booklet"]];
    
    if (in_array("dc:page",$tabLigneRef) && ($tabLigne[$tabCopy["dc:page"]] != "")) 
      $tabChampsEtude["etude_desc_nb_pages"] = $tabLigne[$tabCopy["dc:page"]];
    
    if (in_array("dc:iconography",$tabLigneRef) && ($tabLigne[$tabCopy["dc:iconography"]] != "")) 
      $tabChampsIconography = explode("#", $tabLigne[$tabCopy["dc:iconography"]]);

    if (in_array("dc:type",$tabLigneRef) && ($tabLigne[$tabCopy["dc:type"]] != "")) 
      $tabChampsDocumentType = explode("#", $tabLigne[$tabCopy["dc:type"]]);
      
    if (in_array("dc:typology",$tabLigneRef) && ($tabLigne[$tabCopy["dc:typology"]] != "")) 
      $tabChampsTypologie = explode("#", $tabLigne[$tabCopy["dc:typology"]]);
    
    if (in_array("dc:cost",$tabLigneRef) && ($tabLigne[$tabCopy["dc:cost"]] != "")) 
      $tabChampsEtude["etude_cout"] = $tabLigne[$tabCopy["dc:cost"]];
    
    if (in_array("dc:methodology",$tabLigneRef) && ($tabLigne[$tabCopy["dc:methodology"]] != "")) 
      $tabChampsMethodology = explode("#", $tabLigne[$tabCopy["dc:methodology"]]);
      
    if (in_array("dc:partner",$tabLigneRef) && ($tabLigne[$tabCopy["dc:partner"]] != "")) 
      $tabChampsEtudePartenaire = explode("#", $tabLigne[$tabCopy["dc:partner"]]);
    
    if (in_array("dc:cote",$tabLigneRef) && ($tabLigne[$tabCopy["dc:cote"]] != "")) 
      $tabChampsEtude["etude_cote"] = $tabLigne[$tabCopy["dc:cote"]];
    
    if (in_array("dc:period",$tabLigneRef) && ($tabLigne[$tabCopy["dc:period"]] != "")) 
      $tabChampsEtude["etude_prod_periode"] = $tabLigne[$tabCopy["dc:period"]];
    
    if (in_array("dc:author",$tabLigneRef) && ($tabLigne[$tabCopy["dc:author"]] != "")) 
      $tabChampsEtude["etude_redacteur"] = $tabLigne[$tabCopy["dc:author"]];
    
    if (in_array("dc:primary_area",$tabLigneRef) && ($tabLigne[$tabCopy["dc:primary_area"]] != "")) 
      $tabChampsEtude["etude_perimetre_principal_intitule"] = $tabLigne[$tabCopy["dc:primary_area"]];

    if (in_array("dc:secondary_area",$tabLigneRef) && ($tabLigne[$tabCopy["dc:secondary_area"]] != "")) 
      $tabChampsEtude["etude_perimetre_secondaire_intitule"] = $tabLigne[$tabCopy["dc:secondary_area"]];
    if (in_array("dc:etude_url",$tabLigneRef) && ($tabLigne[$tabCopy["dc:etude_url"]] != "")) 
      $tabChampsEtude["etude_url"] = $tabLigne[$tabCopy["dc:etude_url"]];  
      
    return array($tabChampsEtude, $tabChampsCommanditaire, $tabChampsPrincipalTheme, 
		             $tabChampsPrincipalSubTheme, $tabChampsSecondaryTheme, $tabChampsSecondarySubTheme, 
		             $tabChampsIconography, $tabChampsDocumentType, $tabChampsTypologie,
		             $tabChampsMethodology,$tabChampsEtudePartenaire);
	}
	
  /**
   *  Fonction insertion de la ligne courante .
   *
   * @param tabLigne     Tableau contenant ligne courante
   * @param tabCopy      Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @param t            numéro de la ligne
   * @return vrai si ibsertion faux sinon
   */
	function insert($tabLigne, $tabCopy, $tabLigneRef, $t)
	{
		$tabChamps = $this->getChampsData($tabLigne, $tabCopy, $tabLigneRef);
    $iWarning = 0;
    $ag_id = AlkFactory::getSProperty("user_id", ALK_USER_ID_INTERNET);
    $this->modeImport = AlkRequest::_REQUESTint("contenuFile", 1); // si 1 -> import notrmal si 0 -> import simule : pas d'insertion en base
		$tabChampsEtude = $tabChamps[0];
		$tabChampsCommanditaire = $tabChamps[1];
		$tabChampsPrincipalTheme = $tabChamps[2];
		$tabChampsSecondaryTheme = $tabChamps[4];
		$tabChampsIconography = $tabChamps[6];
		$tabChampsDocumentType = $tabChamps[7];
    $tabChampsTypologie = $tabChamps[8];
    $tabChampsMethodology = $tabChamps[9];
		$tabChampsEtudePartenaire = $tabChamps[10];
		
		//vérification des champs texte obligatoires et vides
	  if(!array_key_exists("etude_intitule", $tabChampsEtude)){
      $strMes = "Erreur : Ligne ".$t.", le champ dc:title n'est pas rempli. Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }
	  if(!array_key_exists("etude_auteurs", $tabChampsEtude)){
      $strMes = "Erreur : Ligne ".$t.", le champ dc:publisher n'est pas rempli. Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }
	  if(!array_key_exists("etude_resume", $tabChampsEtude)){
      $strMes = "Erreur : Ligne ".$t.", le champ dc:description n'est pas rempli. Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }
	  if(!array_key_exists("etude_perimetre_principal_intitule", $tabChampsEtude)){
      $strMes = "Erreur : Ligne ".$t.", le champ dc:primary_area n'est pas rempli. Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }
    
	  if(!array_key_exists("etude_annee_achevement", $tabChampsEtude)){
      $strMes = "Erreur : Ligne ".$t.", le champ dct:created n'est pas rempli. Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }
    
		if(!in_array($tabChampsEtude["etude_droit"], $GLOBALS["tabDroits"])){
			$strMes = "Erreur : Ligne ".$t.", le champ dc:rights ne correspond pas à un enregistrement autorisé(\"libre de droit\", \"interne au service\"). Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
		}else{
			$tabChampsEtude["etude_droit"] = array_search($tabChampsEtude["etude_droit"], $GLOBALS["tabDroits"]);
		}
		
		$dsContact = $this->oAppli->oQuery->getServiceByName($tabChampsEtude["etude_contact"]);
		if($drContact = $dsContact->getRowIter()){
			$tabChampsEtude["etude_contact_service_id"]=  $drContact->getValueName("SERVICE_ID");
		}else{
			$strMes = "Erreur : Ligne ".$t.", le champ dc:contact ne correspond pas à un enregistrement de l'annuaire. Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
		}
		
		
    //vérification des commanditaires / liste existante
    $tabCommanditaireService_id = array();
    foreach($tabChampsCommanditaire as $key=>$value){
      $dsCommanditaire = $this->oAppli->oQuery->getServiceByName($value);	
      if($drCommanditaire = $dsCommanditaire->getRowIter()){
      	$tabCommanditaireService_id[] =  $drCommanditaire->getValueName("SERVICE_ID");
      }else{
      	$strMes = "Alerte : Ligne ".$t.", le commanditaire ".$value." n'est pas reconnu dans la liste. L'association de ce commanditaire à l'étude est rejetée";
	      $this->obj_Warning->erreur(7, $strMes);      
	      $iWarning++;
      }
    }
    if(empty($tabCommanditaireService_id)){
    	$strMes = "Erreur : Ligne ".$t.", le champ dc:owner ne contient pas de commanditaires reconnus. Ce champ est obligatoire. Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
    }
    
    //vérification des partenaires / liste existante
    $tabPartenaireService_id = array();
    foreach($tabChampsEtudePartenaire as $key=>$value){
      $dsPartenaire = $this->oAppli->oQuery->getServiceByName($value); 
      if($drPartenaire = $dsPartenaire->getRowIter()){
        $tabPartenaireService_id[] =  $drPartenaire->getValueName("SERVICE_ID");
      }else{
        $strMes = "Alerte : Ligne ".$t.", le partenaire ".$value." n'est pas reconnu dans la liste. L'association de ce partenaire à l'étude est rejetée";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
    }
    
    //thematiques / obligatoire en principal
    
    $tabPThematique = array();   
    foreach($tabChampsPrincipalTheme as $key=>$value){
      $dsThematique = $this->oAppli->oQuery->getDsByTableName(" thematique where thematique_intitule ilike '".$this->oAppli->oQuery->dbConn->AnalyseSql($value)."'"); 
      if($drThematique = $dsThematique->getRowIter()){
        $tabPThematique[] =  $drThematique->getValueName("thematique_id");
      }else{
        $strMes = "Alerte : Ligne ".$t.", la thématique principale ".$value." n'est pas reconnue dans la liste. L'association de la thématique à l'étude est rejetée";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
    }
	  if(empty($tabPThematique)){
      $strMes = "Erreur : Ligne ".$t.", le champ dc:principal_keywords_theme ne contient pas de thématiques reconnus. Ce champ est obligatoire. Ligne rejetée";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;
	  }
	
    $tabSThematique = array();
    foreach($tabChampsSecondaryTheme as $key=>$value){
      $dsThematique = $this->oAppli->oQuery->getDsByTableName(" thematique where thematique_intitule ilike '".$this->oAppli->oQuery->dbConn->AnalyseSql($value)."'"); 
      if($drThematique = $dsThematique->getRowIter()){
        $tabSThematique[] =  $drThematique->getValueName("thematique_id");
      }else{
        $strMes = "Alerte : Ligne ".$t.", la thématique secondaire ".$value." n'est pas reconnue dans la liste. L'association de la thématique à l'étude est rejetée";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
    }
    //TODO sous-thematiques
    
	  $tabIconographie = array();
    foreach($tabChampsIconography as $key=>$value){
      $dsIconographie = $this->oAppli->oQuery->getDsByTableName(" iconographie where iconographie_intitule ilike '".$this->oAppli->oQuery->dbConn->AnalyseSql($value)."'"); 
      if($drIconographie = $dsIconographie->getRowIter()){
        $tabIconographie[] =  $drIconographie->getValueName("iconographie_id");
      }else{
        $strMes = "Alerte : Ligne ".$t.", l'iconographie ".$value." n'est pas reconnue dans la liste. L'association de l'iconographie à l'étude est rejetée";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
    }
    
    
	  $tabDocType = array();
    foreach($tabChampsDocumentType as $key=>$value){
      $dsDocType = $this->oAppli->oQuery->getDsByTableName(" document_type where document_type_intitule ilike '".$this->oAppli->oQuery->dbConn->AnalyseSql($value)."'"); 
      if($drDocType = $dsDocType->getRowIter()){
        $tabDocType[] =  $drDocType->getValueName("document_type_id");
      }else{
        $strMes = "Alerte : Ligne ".$t.", le type de document ".$value." n'est pas reconnu dans la liste. L'association du type de document à l'étude est rejetée";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
    }
    
    
	  $tabTypologie = array();
    foreach($tabChampsTypologie as $key=>$value){
      $dsTypologie = $this->oAppli->oQuery->getDsByTableName(" typologie where typologie_intitule ilike '".$this->oAppli->oQuery->dbConn->AnalyseSql($value)."'"); 
      if($drTypologie = $dsTypologie->getRowIter()){
        $tabTypologie[] =  $drTypologie->getValueName("typologie_id");
      }else{
        $strMes = "Alerte : Ligne ".$t.", la typologie ".$value." n'est pas reconnue dans la liste. L'association de la typologie à l'étude est rejetée";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
    }
    
	  $tabMethodologie = array();
    foreach($tabChampsMethodology as $key=>$value){
      $dsMethodologie = $this->oAppli->oQuery->getDsByTableName(" methodologie where methodologie_intitule ilike '".$this->oAppli->oQuery->dbConn->AnalyseSql($value)."'");
      if($drMethodologie = $dsMethodologie->getRowIter()){
        $tabMethodologie[] =  $drMethodologie->getValueName("methodologie_id");
      }else{
        $strMes = "Alerte : Ligne ".$t.", la méthodologie ".$value." n'est pas reconnue dans la liste. L'association de la méthodologie à l'étude est rejetée";
        $this->obj_Warning->erreur(7, $strMes);      
        $iWarning++;
      }
    }
    //ajout de l'étude
    if($this->modeImport == 1){
      $etude_id = $this->oAppli->oQueryAction->addEtude($tabChampsEtude, $ag_id);
      $this->oAppli->oQueryAction->addEtudeCommanditaire($tabCommanditaireService_id, $etude_id);
      $this->oAppli->oQueryAction->addEtudePartenaires($tabPartenaireService_id, $etude_id);
      $this->oAppli->oQueryAction->addEtudeThematique($tabPThematique, $etude_id);
      $this->oAppli->oQueryAction->addEtudeThematique($tabSThematique, $etude_id, 2);
      $this->oAppli->oQueryAction->addIconographie($tabIconographie, $etude_id);
      $this->oAppli->oQueryAction->addDocumentType($tabDocType, $etude_id);
      $this->oAppli->oQueryAction->addTypologie($tabTypologie, $etude_id);
      $this->oAppli->oQueryAction->addMethodologie($tabMethodologie, $etude_id);
       
      //sauvegarde XML en base pour requetage 
      $strXmlEtude = $this->oAppli->ExportXml($etude_id, 0);
      $this->oAppli->oQueryAction->updateEtudeXml($etude_id, $strXmlEtude);
      $strFichier_Import = "";
      if (is_dir($GLOBALS["rootDirPath"]."/".$t)){
      	$dir = $GLOBALS["rootDirPath"]."/".$t;
  
      	$doc = getTabFilesByDir($dir);
      	
      	createDir(ALK_ALKANET_ROOT_PATH."upload/crbn_cat/".$this->oAppli->cont_id);
      	$bImage = false;
      	$docFile="";
      	foreach($doc as $key=>$value){
      		if(getFileExtension($key)=="pdf"){
      			//copie du fichier
      		  copy($dir."/".$value, ALK_ALKANET_ROOT_PATH."upload/crbn_cat/".$this->oAppli->cont_id."/".$value);
      			if(substr($value, 0, 2)=="CC"){// import de fichiers "cahiers des charges"
              $pj_id = $this->oAppli->oQuery->AddPj("etude_pj", $etude_id, "data_pj_cc", $ag_id,
                  ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", 0, true, $value, false);
            }        
      		  else{   		  
              $pj_id = $this->oAppli->oQuery->AddPj("etude_pj", $etude_id, "data_pj_pdf", $ag_id,
                                          ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", 0, true, $value, false);
              $docFile = ALK_ALKANET_ROOT_PATH."upload/crbn_cat/".$this->oAppli->cont_id."/".$value;                           
      			}
      		}elseif(getFileExtension($key)=="jpg"){
      			$bImage = true;
      			copy($dir."/".$value, ALK_ALKANET_ROOT_PATH."upload/crbn_cat/".$this->oAppli->cont_id."/".$value);
      			$pj_id = @$this->oAppli->oQuery->AddPj("etude_pj", $etude_id, "data_pj_vignette", $ag_id,
                                          ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", 0, true, $value, false);
      		}
      	}
      	//génération auto d'une image
        if($bImage==false && $docFile!=""){
          if(file_exists($docFile)){
            //$fileImage = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT).$drData->getValueName("pj_agentcrea")."/vignette.jpeg";
            $fileImage = AlkFactory::getUploadPath(ALK_ATYPE_ID_CRBN_CAT).$this->oAppli->cont_id."/vignette.jpeg";
            exec("convert ".$file."[0] ".$fileImage, $tabError);             
            if(empty($tabError) && file_exists($fileImage)){
              $pj_id = $this->oAppli->oQuery->AddPj("etude_pj", $etude_id, "data_pj_vignette", $ag_id,
                                      ALK_ALKANET_ROOT_PATH, "upload/crbn_cat/".$this->oAppli->cont_id."/", 0, true, "vignette.jpeg", false);
            }
          }
        }
      }
    }
    if( $iWarning != 0 ) {
			return 1;
		}
		return 0;
	}
	
	/**
   *  Fonction de modification de la ligne courante dans la base .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si ibsertion faux sinon
   */
	function update($tabLigne, $tabCopy, $tabLigneRef,$t)
	{
		
	}
	
	/**
   *  Fonction de suppresion de la ligne courante dans la base .
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return vrai si insertion faux sinon
   */
	function delete($tabLigne, $tabCopy, $tabLigneRef,$t)
	{

	}
	
	/**
   *  retourne la reference d'un champ..
   *
   * @param  champ  l'intitule du champs
   * @param  tabType tableau contenant le champs 
   * @return tabRes[0] la reference recherche dans la tabType et celle de la premiere case.
   */
	function getIdChamp($champ,$tabType)
	{
		$tabRes = array_keys($tabType, $champ);
    if( count($tabRes) > 0 ) 
      return $tabRes[0];
    return -1;
	}
	
}

?>
