<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Dico
Module fournissant les pages d'administration de dictionnaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * @package Alkanet_Module_Dico
 * 
 * @class AlkAppliDico
 * @brief Classe de l'application dictionnaire
 *        Classe regroupant des fonctionnalités d'un dictionnaire
 */
class AlkAppliDico extends AlkAppli
{

  /** tableau contenant la déclaration du dictionnaire */
  protected $tabDico;
  
  /**
   * Constructeur par défaut
   *
   * @param oSpace Référence vers l'objet de l'espace en cours
   */  
  public function __construct($appli_id)
  {
    parent::__construct(ALK_ATYPE_ID_DICO, $appli_id);
    
    $this->tabDico = array();
  }
  
  /**
   * Destructeur par défaut
   */
  public function __destruct() { }

  /**
   *  Vérifie les droits spécifiques à l'application
   *        Retourne vrai si l'utilisateur connecté possède les droits, faux sinon
   * @return booleen
   */
  public function verifSecuAppli()
  { 
    return true;
  }
  
  /**
   * Retourne l'objet Panel correspondant au iSheet et iSSheet sélectionné
   * 
   * @param oAppliFrom    AlkAppli   Application appelant cette fonction (principe call services par dérivation)
   * @return AlkHtmlPanel
   */
  public function getPanel(AlkAppli $oAppliFrom=null)
  {  
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."dico/classes/alkhtmldico.class.php");
    $oPanel = new AlkHtmlDico($this);
    $oPanel->setDataDico($this->tabDico);

    return $oPanel; 
  }

  /**
   * Fonction virtuelle appelée par le constructeur permettant d'initialiser 
   * le tableau this->tabSheets
   */
  public function setTabSheets() { /** rien à faire */ } 
  
  /**
   * Mémorise la déclaration du dictionnaire associé
   * 
   * @param tabDico  tableau contenant la déclaration du dictionnaire
   */
  public function setDataDico($tabDico)
  {
    $this->tabDico = $tabDico; 
  }
  
}

?>