<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Editeur
Module éditeur basé sur fckeditor.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_Editeur
 * @class AlkQueryEditeur
 * Contient les requêtes de type sélection du module éditeur
 */
class AlkQueryEditeur extends AlkQuery 
{
  
  /**
   * Constructeur par défaut
   * @param dbConn   Référence sur l'objet de connexion de type AlkDb
   */

  public function __construct(&$oDb)
  {
    parent::__construct($oDb);
  }

  /**
   *  obtention d'un contenu
   *
   * @param int idEnt identifiant du contenu (séparé par des | si clés multiples)
   * @param string strTable nom de la table
   * @param string strChampHtml nom du champ de la table contenant le contenu
   * @param string strChampId identifiant du contenu (séparé par des | si clés multiples)
   *
   * @return string contenu
   */
  public function getContenu($idEnt, $strTable, $strChampHtml, $strChampId) 
  {
    $strContenu = "";     
    $tabChampId = explode("|", $strChampId);
    $tabId = explode("|", $idEnt);
      
    $strSql = "select ".$strChampHtml." from ".$strTable;
      
    // gestion des cles multiples
    $i = 0;
    $strWhere = "";
    foreach ($tabChampId as $strChamp) {
      $strWhere .= ( $strWhere != "" ? " and " : "" ).$strChamp."=".$tabId[$i];
      $i++;
    }
    $strSql .= ( $strWhere != "" ? " where ".$strWhere : "" );
      	
    $dsContenu = $this->dbConn->initDataset($strSql);
    
    if( $drContenu = $dsContenu->GetRowIter() ) {
      if ($drContenu->GetValueName($strChampHtml) != "")
        $strContenu = mb_ereg_replace("\"", "'", $drContenu->GetValueName($strChampHtml));
      $strContenu = $drContenu->GetValueName($strChampHtml);
    }
    
    // gestion des liens
    $oAppliEditeur = AlkFactory::getAppli(ALK_ATYPE_ID_EDITEUR);
    if ( $oAppliEditeur ) {
      $strContenu = $oAppliEditeur->buildLinks($strContenu, array("bWithRootUrl" => true));
    }
    
    return $strContenu;
  }

  /**
   * Retourne le dataset d'un contenu gedit d'un bloc donné
   * @param bloc_id   Identifiant du bloc
   * @return AlkDs
   */
  public function getContenuByBlocId($bloc_id)
  {
    $strSql = "select *".
      " from GEDIT_01_CONTENU".
      " where BLOC_ID=".$bloc_id;
    return $this->dbConn->initDataset($strSql);
  }
  
  /**
   * 
   */
  public function getDsDbFichier($fichier_id=-1, $fichier_path="")
  {
    $oQueryActionEditeur = AlkFactory::getQueryAction(ALK_ATYPE_ID_EDITEUR);
    $strSql = "select * from EDITEUR_FICHIER" .
      " where 1=1" .
      ( $fichier_id != -1   ? " and FICHIER_ID=".$fichier_id : " " ) .
      ( $fichier_path != "" ? " and FICHIER_PATH='".$oQueryActionEditeur->removeFirstSlash($fichier_path)."'" : "" );
    return $this->dbConn->initDataSet($strSql);
  }
}
?>