<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Editeur
Module éditeur basé sur fckeditor.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_Editeur
 * @class AlkQueryEditeurAction
 * Ensemble des requetes actions liées à l'application éditeur
 */
class AlkQueryEditeurAction extends AlkQuery
{

  /**
   * Constructeur par défaut
   * @param oDb  Référence sur l'objet de connexion de type AlkDb
   */
  function __construct(&$oDb)
  {
    parent::__construct($oDb);
  }
    
  /**
   *  Modifie le contenu editorial d'une information identifiée par les paramètres
   *
   * @param idEnt         Id ou liste d'id de l'information contenan le contenu edit
   * @param strTable      table sql où le contenu edit doit être enregistré
   * @param strChampsHtml Nom du champ dans la table contenu le contenu edit
   * @param strTextHtml   texte edit à enregistrer
   * @param strChampId    Nom du champ id ou liste de champ id associé à idEnt
   * @return boolean False si KO, true sinon
   */
  function updateContenu($idEnt, $strTable, $strChampsHtml, $strTextHtml, $strChampId) 
  {
    $tabChampId = explode("|", $strChampId);
    $tabId = explode("|", $idEnt);
    
    $strSql = "update ".$strTable." set ".
      $strChampsHtml." = ".$this->dbConn->getCLob($strChampsHtml, $strTextHtml, false).
      " where 1=1";
      
    // gestion des cles multiples
    $i = 0;
    foreach ($tabChampId as $strChamp) {
      $strSql .= " and ".$strChamp."='".$tabId[$i]."'";
      $i++;
    }
    
    $tabCLob = array($strChampsHtml => $strTextHtml);

    $res = $this->dbConn->executeSql($strSql, true, $tabCLob) ;
    return $res;
  }
  
  /**
   * traitement du chemin du fichier
   * @param $path chemin du fichier
   * @return chemin du fichier traité
   */
  function removeFirstSlash($path="")
  {
    $path = $this->dbConn->analyseSql(trim($path));
    if ( substr($path, 0, 1) == "/" ) {
      $path = substr($path, 1);
    }
    return $path;
  }
  
  /**
   * ajoute une occurence de fichier si celle-ci n'existe pas
   * @param $fichier_path emplacement du fichier
   * @return integer identifiant de l'occurence du fichier
   */
  function addDbFichier($fichier_path="")
  {
    $strSql = "select FICHIER_ID from EDITEUR_FICHIER where FICHIER_PATH='".$this->removeFirstSlash($fichier_path)."'";
    $oDsFichier = $this->dbConn->initDataSet($strSql);
    if ( $oDrFichier = $oDsFichier->getRowIter() ) {
      $fichier_id = $oDrFichier->getValueName("FICHIER_ID");
    } else {
      $fichier_id = $this->dbConn->getNextId("EDITEUR_FICHIER", "FICHIER_ID", "SEQ_EDITEUR_FICHIER");
      $strSql = "insert into EDITEUR_FICHIER (FICHIER_ID, FICHIER_PATH) values (".$fichier_id.", '".$this->removeFirstSlash($fichier_path)."')";
      $this->dbConn->executeSql($strSql);
    }
    return $fichier_id;
  }
  
  /**
   * supprime une occurence de fichier
   * @param $fichier_path emplacement du fichier
   */
  function delDbFichier($dossier_path="")
  {
    $strSql = "delete from EDITEUR_FICHIER where FICHIER_PATH='".$this->removeFirstSlash($dossier_path)."'";
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * supprime les occurence de fichier qui n'existe plus
   */
  function cleanDbFichier()
  {
    $strSql = "select FICHIER_ID, FICHIER_PATH from EDITEUR_FICHIER";
    $oDsFichier = $this->dbConn->initDataSet($strSql);
    while ( $oDrFichier = $oDsFichier->getRowIter() ) {
      $fichier_id = $oDrFichier->getValueName("FICHIER_ID");
      $fichier_path = $oDrFichier->getValueName("FICHIER_PATH");
      if ( !file_exists(ALK_ALKANET_ROOT_PATH.$fichier_path) ) {
        $this->delDbFichier($fichier_path);
      }
    }
  }
  
  /**
   * supprime une(des) occurence(s) de fichier
   * @param $fichier_path emplacement du(des) fichier(s)
   */
  function delDbDossier($dossier_path="")
  {
    $strSql = "delete from EDITEUR_FICHIER where FICHIER_PATH like '".$this->removeFirstSlash($dossier_path)."%'";
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * modifie des emplacements d'occurences de fichier
   * @param $old_path ancien emplacement
   * @param $new_path nouvel emplacement
   * @param $fichier_path emplacement du(des) fichier(s)
   */
  function replaceDbFichierPath($old_path, $new_path, $fichier_path)
  {
    $strSql = "update EDITEUR_FICHIER set FICHIER_PATH=replace(FICHIER_PATH, '".$this->removeFirstSlash($old_path)."', '".$this->removeFirstSlash($new_path)."') where FICHIER_PATH like '".$this->removeFirstSlash($fichier_path)."%'";
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * duplique des emplacements d'occurences de fichier
   * @param $old_path ancien emplacement
   * @param $new_path nouvel emplacement
   * @param $fichier_path emplacement du(des) fichier(s)
   */
  function duplicateDbFichierPath($old_path, $new_path, $fichier_path)
  {
    $strSql = "select FICHIER_PATH from EDITEUR_FICHIER where FICHIER_PATH like '".$this->removeFirstSlash($fichier_path)."%'";
    $oDsFichier = $this->dbConn->initDataSet($strSql);
    while ( $oDrFichier = $oDsFichier->getRowIter() ) {
      $new_fichier_path = $oDrFichier->getValueName("FICHIER_PATH");
      $this->addDbFichier(str_replace($this->removeFirstSlash($old_path), $this->removeFirstSlash($new_path), $new_fichier_path));
    }
  }
}

?>