<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * la version 3.5.0_RELEASE correspond à la marquée 3.4.5
 */
$strNum = "3.5.0";
$tabIns[$strNum][] = "";

/**
 * LGD : alkhtmlformespace.class.php : ajout de nouveaux champs pour la gestion des groupes de travail 
 *      - notion de thematique ou typologie de grpoupe de travail(liste deroulante : creation d'une table SIT_CONT_TYPE) + nouveau champ "cont_type_id" associé à sit_conteneur
 *    Creation d'un champ cont_type_id dans sit_conteneur pour pointer sur un type d'espace
 *    Creation de la table SIT_CONT_TYPE + insertions : permettant de qualifier des espaces (ex. espace collab, espace éditorial, GED..).
 * MTO : alkappliespace.class.php : modif addUserToSpace() et removeUserFromSpace() => appel des méthodes sur l'application Annuaire
 * BFE : alkhtmlpopupcreateuser.class.ph : Ajout de la création de service pour l'inscription
 * BFE : corrections compatibilités pHP 5.3 (ereg_replace)
 */

$strNum = "3.5.1";
// table : SIT_CONT_TYPE : permet de qualifier des types d'espace
$tabTable[$strNum]["sit_cont_type"] = array (
  "type_id" => array (
    "type" => "int",
    "dn" => "NOT NULL"
  ),
  "type_intitule" => array (
    "type" => "varchar(100)",
    "dn" => ""
  )
);
$tabPk[$strNum]["sit_cont_type"]["pk_sit_cont_type"] = "type_id";

$tabSeq[$strNum]["seq_sit_cont_type"] = "10";

$tabAlterTable[$strNum]["sit_conteneur"] = array (
  array (
    "action" => "add",
    "column" => "cont_type_id",
    "type" => "int",
    "length" => "",
    "default" => "0",
    "nullable" => -1
  ),
  array (
    "action" => "add",
    "column" => "cont_objet",
    "type" => "varchar",
    "length" => "255",
    "default" => "",
    "nullable" => 0
  )
);

$tabIns[$strNum][] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
"VALUES( -1, -1, 'ALK_B_GRP_TRAV_OBJET', 'true', 'Possibilité d afficher le controle objet dans la gestion des grp de travail dans la version RESPIRE V2', 3, 0)";

/**
 * LGD : alkhtmlpopupcreateuser.class.php : addValidator Required sur la pj de la chartes d'adhesion
 *       alkhtmlpopupaskguestuser.class.php : modif de l'intitule "Saisir vos motivation" par "Ajouter un commentaire" pour la participation aux GT
 * BFE : alkappliespace.class.php : ajout de la méthode getHelp permettant d'obtenir l'intitulé de la rubrique d'aide associée à l'appli
 */
$strNum = "3.5.2";
$tabIns[$strNum][] = "";

/**
 * BFE : alkquery.class.php : ajout de CONT_ARCHIVE dans getDs_listeAppliByAgentEspace
 */
$strNum = "3.5.3";
$tabIns[$strNum][] = "";

/**
 * VDR : ajout constante pour limiter le nombre de statistiques
 * MTO : alkhtmlpopupaskguestuser.class.php : ajout champs "dest" => "Animateur du groupe de travail"
 */
$strNum = "3.5.4";
$tabIns[$strNum][] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
"VALUES( -1, -1, 'ALK_ITEM_PER_STATS', '10', '" . $dbConn->analyseSql("Nombre de valeur maximale accepté pour afficher les graphiques des statistiques") . "', 1, 0)";

/**
 * LGD : alkhtmlformplaniform.class.php : pour la creation d'une tache planifiee, ajout d'une liste déroulante permettant de choisir une appli_id à partir du atype_id et du cont_id
 *     : alkhtmlformplanfilist.class.php : filtre de la liste des taches planifiees sur l'espace courant
 *     : alkqueryespace.class.php getDs_listeCronTask : on a laissé un filtre sur sct.CONT_ID=0 de façon à ce que les anciennes taches ne soient pas affectée par la mise à jour.
 */
$strNum = "3.5.5";
$tabIns[$strNum][] = "";

/**
 * EGD : 02_espace.sql.php : mise en place de la constante ALK_B_MEDIA_SHARED permettant de gérer tous les fichiers envoyer sur le serveur pour un même espace dans le même répertoire(/upload/espace).
 */
$strNum = "3.5.6";
$tabIns[$strNum][] = "";
$tabIns[$strNum][] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
"VALUES( -1, -1, 'ALK_B_MEDIA_SHARED', 'false', '" . $dbConn->analyseSql("Permet pour un même espace de gérer tous les fichiers envoyer sur le serveur dans un même répertoire") . "', 3, 0)";

/**
 * MTO : alkhtmlpopupaskguestuser.class.php : corrections syntaxiques + ajout boutons "Fermer"
 *                                            optimisations :
 *                                              - modifications permettant de récupérer le nom du groupe de travail en requête (évite les problèmes de caractères spéciaux)
 *                                              - le cont_id utilisé est celui de l'espace courant => inutile de le fournir et de le récupérer en POST
 *                                              - vérification de l'existence du groupe de travail avant envoi de la demande
 * EGD : alkhtmlformtableaubordform.class.php : Modification de setContents() pour remplacer la chaine "/libconf/templates/" par la constante ALK_ROOT_TEMPLATE déjà défini dans /lib/app_conf_alkanet.php avec cette même valeur
 */
$strNum = "3.5.7";
$tabIns[$strNum][] = "";

/**
 * EGD : alkqueryespace.class.php : ajout de la methode userIsAnimateurOfSpace($user_id, $cont_id) renvoyant un booleen indiquant si le user_id est animateur de l'espace cont_id
 * MTO : alkhtmlformespace.class.php : modif fonction addBlockProprietes() => ajout du paramètre bCbVisible pour afficher ou non la case à cocher "Visible"
 *     : alkappliespace.class.php : modif fonction updateSpace() => ajout appel à la fonction syncEspaceListe() de l'annuaire pour synchroniser la liste de diffusion des utilisateurs d'un espace (compatible module Annu >= 3.5.10)
 * ALC : alkhtmlformespace.class.php : passage de php 5.3 à php 5.4
 *     + alkhtmlformparametreform.class.php
 *     + alkappliespace.class.php
 */
$strNum = "3.5.8";
$tabIns[$strNum][] = "";

/**
 * EMA : Intégration du Jquery DATATABLE 
 * EGD : alkqueryespace.class.php : Modification de GetDs_listeEspace() pour renvoyer aussi le CONT_INTITULE_COURT
 * MTO : alkhtmlforminvitationform.class.php : modification de la signature du mail d'envoi des invitations à un groupe de travail => utilisation de la constante ALK_APP_NAME
 *     : alkappliespace.class.php : modification de la casse de l'appel à la fonction sendMailToAdmin()
 *     : alkqueryespace_action.class.php : complétion de la fonction delAppli() => réinitialisation des associations des pages
 *     : requête de réinitialisation des associations des pages avec des applis inexistantes
 * BFE : alkhtmlformuserlist.class.php : non pagination de la requete pour compatibilité datatable
 * BFE : alkqueryespace.class.php : GetDs_listeAgentByEspace : suppression de la présentation de la civilité pour compatibilité datatable (tri)
 */
$strNum = "3.5.9";
$tabIns[$strNum][] = "UPDATE GEDIT_01_PAGE SET PAGE_APPLIID=-1 WHERE PAGE_APPLIID NOT IN (SELECT APPLI_ID FROM SIT_APPLI)";

/**
 * EMA : Corrections Jquery DATATABLE 
 *     : alkhtmlformuserlist.js : correction fonction ajout()
 *     : alkhtmlformuserlist.class.php : mise en place du mode server processing
 * MTO : ajout des champs CONT_ROOT_FRONT_URL_FR, CONT_ROOT_FRONT_URL_EN, CONT_ROOT_ADMIN_URL_FR et CONT_ROOT_ADMIN_URL_EN dans la table SIT_CONTENEUR
 *     : alkhtmlforminvitationform.class.php : modification de la signature du mail d'envoi des invitations à un groupe de travail => utilisation de la constante ALK_APP_TITLE à la place de ALK_APP_NAME
 */
$strNum = "3.5.10";
$tabIns[$strNum][] = "";

$tabAlterTable[$strNum]["sit_conteneur"] = array(
  array("action" => "add", 
        "column" => "CONT_ROOT_FRONT_URL_FR", 
        "type" => "varchar", "length" => "255", "default" => "", "nullable"  => 0,
  ),
  array("action" => "add", 
        "column" => "CONT_ROOT_FRONT_URL_EN", 
        "type" => "varchar", "length" => "255", "default" => "", "nullable"  => 0,
  ),
  array("action" => "add", 
        "column" => "CONT_ROOT_ADMIN_URL_FR", 
        "type" => "varchar", "length" => "255", "default" => "", "nullable"  => 0,
  ),
  array("action" => "add", 
        "column" => "CONT_ROOT_ADMIN_URL_EN", 
        "type" => "varchar", "length" => "255", "default" => "", "nullable"  => 0,
  ),
);
/**
 * EMA : corrections jquery datatable
 *     : remplacement des constantes définissant les chemins vers les modues, /templates/, classes/form, classes/pattern
 * MTO : alkhtmlpopupcreateuser.class.php : réintégration de la prise en compte du fichier upload/mode_emploi_intro.txt 
 * EGD : alkhtmlformespace.class.php : ajout à l'interface de controle permettant la saisie du domaine de l'espace
 *     : alkqueryespace_action.class.php : 
 *     : alkqueryespace.class.php : Ajout des méthodes 
 *     + getDs_ListEspaceByRootContUrl() : permet de récupérer la liste des espaces correspondant à un domaine
 *     + getEspaceIDByRootContUrl() : permet de récupérer l'ID du premier espace correspondant au domaine
 *     + getEspaceRootContUrlByID() : permet de récupérer le domaine de l'espace dont on passe le cont_id
 */
 $strNum = "3.5.11";
 $tabIns[$strNum][] = "";
 
 $tabTable[$strNum]["sit_appli_option"] = array(
     "option_id"             => array("type" => "int", "dn" => "NOT NULL"),
     "appli_id"              => array("type" => "int", "dn" => "NOT NULL"),
     "option_alias"          => array("type" => "varchar(80)", "dn" => "NOT NULL"),
     "option_intitule"       => array("type" => "varchar(255)", "dn" => ""),
     "option_desc"           => array("type" => "text", "dn" => ""),
     "option_activee"        => array("type" => "int", "dn" => "DEFAULT 0"),
     "option_droits_avances" => array("type" => "int", "dn" => "DEFAULT 0")
 );
 $tabPk[$strNum]["sit_appli_option"]["pk_sit_appli_option"] = "option_id";
 $tabFk[$strNum]["sit_appli_option"] = array(
     "fk_sit_appli_option_sit_appl" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
 );
 $tabSeq[$strNum]["seq_sit_appli_option"] = "10";
 
 // ressource ACL de type "option d'application"
 $tabIns[$strNum][] = "INSERT INTO alk_ressourcetype (RESSTYPE_ID, RESSTYPE_NAME_FR, RESSTYPE_NAME_EN, TAPPLI_ID, RESSTYPE_ALIAS) VALUES (2, 'Option d''application', 'Application option', 0, 'RESSTYPE_ESPACE_OPTIONAPPLI');";
 $tabIns[$strNum][] = "insert into ACL_ROLE (ROLE_ID, ROLE_NAME_FR, ROLE_NAME_EN, ROLE_MASK, ROLE_ALIAS) VALUES(4, 'Option activée', 'Activated Option', 127, 'ROLE_ESPACE_OPTIONAPPLI')";
 $tabIns[$strNum][] = "insert into ACL_ROLE_RESSTYPE values (4, 2); ";
 
 /**
  * EMA : ajout nouvelle classe alkhtmlformoptionsform.class.php pour la gestion des droits sur les options
  *     : ajout librairie alkhtmlformoptionsform.js
  *     : alkhtmlformapplilist.class.php
  *     : alkquery_action : Ajout updateOptionsToAppli()
  * VLC : alkqueryespace.class.php : getDs_listeAppliAgentByEspace() -> le module ACL a été enlevé de la requête pour qu'il n'apparaisse pas dans le menu
  * EGD : alkhtmlformapplilist.class.php : ajout d'un test pour savoir si l'on affiche le bouton option de paramètrage du menu ACL
  */
   $strNum = "3.5.12";
   $tabIns[$strNum][] = "";
   
  /**
  * EGD : alkqueryespace.class.php : ajout de la fonction Is_CollabSpace() qui prend en paramètre le cont_id pour déterminer si il s'agit d'un espace collaboratif
  *       + en se basant sur l'application par défaut qui est toujours de type ALK_ATYPE_ID_COLLAB (87) lorsque l'on est sur un espace collaboratif
  *     : alkhtmlpopupguestuser.class.php + alkhtmlpopupaskguestuser.class.php + alkhtmlforminvitationform.class.php :
  *       { Modifification des messages si l'on ne se trouve pas sur un espace collaboratif }
  */
   $strNum = "3.5.13";
   $tabIns[$strNum][] = "";
?>