<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

define("ALK_B_ATYPE_ESPACE", true);

// table : SIT_VERSION
$tabTable["sit_version"] = array(
  "vers_name"       => array("type" => "varchar(40)", "dn" => "NOT NULL"),
  "vers_version"    => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "vers_date"       => array("type" => "datetime", "dn" => "NOT NULL"),
  "vers_level"      => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "vers_desc"      => array("type" => "text", "dn" => ""),
  );

//   Table : SIT_APPLI_TYPE                                    
$tabTable["sit_appli_type"] = array(
  "atype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "atype_id_dist" => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  "atype_intitule" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "atype_abrev" => array("type" => "varchar(12)", "dn" => ""),
  "atype_url" => array("type" => "varchar(255)", "dn" => ""),
  "atype_url_admin" => array("type" => "varchar(255)", "dn" => ""),
  "atype_url_site" => array("type" => "varchar(255)", "dn" => ""),
  "atype_droit" => array("type" => "int", "dn" => "NOT NULL"),
  "atype_dispo" => array("type" => "int", "dn" => "NOT NULL"),
  "atype_desc" => array("type" => "varchar(4000)", "dn" => ""),
  "atype_url_target" => array("type" => "varchar(255)", "dn" => ""),
  "atype_compatible" => array("type" => "int", "dn" => ""),
  "atype_logo" => array("type" => "varchar(255)", "dn" => ""),
  "atype_admin_logo" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["sit_appli_type"]["pk_sit_appli_type"] = "atype_id";

//  Table : SIT_CONSTANTE
$tabTable["sit_constante"] = array(
  "atype_id" => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  "appli_id" => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  "cont_id" => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  "const_intitule" => array("type" => "varchar(64)", "dn" => "NOT NULL"),
  "const_valeur" => array("type" => "varchar(4000)", "dn" => ""),
  "const_label" => array("type" => "varchar(255)", "dn" => ""),
  "const_type" => array("type" => "int", "dn" => ""),
  "const_admin" => array("type" => "int", "dn" => "DEFAULT 0"),
  "const_level" => array("type" => "int", "dn" => "DEFAULT 0"),
  "const_bloc" => array("type" => "varchar(255)", "dn" => ""),
  
  );

$tabPk["sit_constante"]["pk_sit_constante"] = "atype_id, appli_id, cont_id,const_intitule";

//   Table : SIT_APPLI_DROIT                                   
$tabTable["sit_appli_droit"] = array(
  "appli_droit_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_droit_intitule" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  );

$tabPk["sit_appli_droit"]["pk_sit_appli_droit"] = "appli_droit_id";

//  Table : SIT_APPLI                                         
$tabTable["sit_appli"] = array(
  "appli_id" => array("type" => "int", "dn" => "NOT NULL"),
  "atype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_intitule" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "appli_logo" => array("type" => "varchar(255)", "dn" => ""),
  "appli_rang" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "agent_idcrea" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_idmaj" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_datecrea" => array("type" => "datetime", "dn" => ""),
  "appli_datemaj" => array("type" => "datetime", "dn" => ""),
  "appli_liee"    => array("type" => "int", "dn" => "")
  );

$tabPk["sit_appli"]["pk_sit_appli"] = "appli_id";

$tabIdx["sit_appli"] = array(
  "sit_appli_agentidc_fk" => "agent_idcrea",
  "sit_appli_agentidm_fk" => "agent_idmaj",
  "sit_appli_appli_type_fk" => "atype_id",
  );

$tabFk["sit_appli"] = array(
  "fk_sit_appl_sit_appli_sit_appl" => array("ffk" => "atype_id", "tpk" => "sit_appli_type", "fpk" => "atype_id"),
  "fk_sit_appli_agentidc" => array("ffk" => "agent_idcrea", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_sit_appli_agentidm" => array("ffk" => "agent_idmaj", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );

$tabSeq["seq_sit_appli"] = "10";

/*
   Table : SIT_APPLI_PARAM
   TYPE : 0=TEXT, 1=int, 2=date
*/
$tabTable["sit_appli_param"] = array(
  "param_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id" => array("type" => "int", "dn" => ""),
  "param_field" => array("type" => "varchar(80)", "dn" => ""),
  "param_type" => array("type" => "int", "dn" => "DEFAULT 0"),
  "param_vtext" => array("type" => "varchar(2000)", "dn" => ""),
  "param_vint" => array("type" => "int", "dn" => ""),
  "param_vdate" => array("type" => "datetime", "dn" => ""),
  );
  
$tabPk["sit_appli_param"]["pk_sit_appli_param"] = "param_id";

$tabIdx["sit_appli_param"] = array(
  "sitappliparam_appliid_fk" => "appli_id",
  );

$tabFk["sit_appli_param"] = array(
  "fk_sitappliparam_appliid" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
  );

$tabSeq["seq_sit_appli_param"] = "10";

//   Table : SIT_CONTENEUR                                     
$tabTable["sit_conteneur"] = array(
  "cont_id" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_id" => array("type" => "int", "dn" => ""),
  "agent_id_maj" => array("type" => "int", "dn" => ""),
  "cont_intitule" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "cont_intitule_court" => array("type" => "varchar(40)", "dn" => ""),
  "cont_alias" => array("type" => "varchar(40)", "dn" => ""),
  "cont_public" => array("type" => "int", "dn" => "NOT NULL"),
  "cont_desc" => array("type" => "varchar(4000)", "dn" => ""),
  "cont_logo" => array("type" => "varchar(255)", "dn" => ""),
  "cont_logo2" => array("type" => "varchar(255)", "dn" => ""),
  "cont_bandeau" => array("type" => "varchar(255)", "dn" => ""),
  "cont_niveau" => array("type" => "int", "dn" => "NOT NULL"),
  "cont_arbre" => array("type" => "varchar(4000)", "dn" => ""),
  "cont_pere" => array("type" => "int", "dn" => "NOT NULL"),
  "cont_effacable" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "cont_rang" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "cont_date_crea" => array("type" => "datetime", "dn" => ""),
  "cont_date_maj" => array("type" => "datetime", "dn" => ""),
  "cont_appli_defaut" => array("type" => "int", "dn" => "DEFAULT 0"),
  "cont_reserve" => array("type" => "int", "dn" => "DEFAULT 0"),
  "cont_type" => array("type" => "varchar(40)", "dn" => "DEFAULT 'Standard_v2'"),
  "cont_css" => array("type" => "varchar(255)", "dn" => "DEFAULT 'alkanetstandard_v2.css'"),
  "cont_home_site" => array("type" => "varchar(255)", "dn" => ""),
  "cont_visible" => array("type" => "int", "dn" => "DEFAULT 0"),
  "cont_archive" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "cont_type_id" => array("type" => "int", "dn"=> "default 0"),
  "cont_objet" => array("type" => "varchar(255)", "dn" =>""),
  "cont_root_front_url_fr" => array("type" => "varchar(255)", "dn" =>""),
  "cont_root_front_url_en" => array("type" => "varchar(255)", "dn" =>""),
  "cont_root_admin_url_fr" => array("type" => "varchar(255)", "dn" =>""),
  "cont_root_admin_url_en" => array("type" => "varchar(255)", "dn" =>""),
  );
  
$tabPk["sit_conteneur"]["pk_sit_conteneur"] = "cont_id";

$tabIdx["sit_conteneur"] = array(
  "createur_cont_fk" => "agent_id",
  "modifeur_cont_fk" => "agent_id_maj",
  );

$tabFk["sit_conteneur"] = array(
  "fk_sitcontmodifeur_sitagent" => array("ffk" => "agent_id_maj", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_sit_cont_createur__sit_agen" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );

$tabSeq["seq_sit_conteneur"] = "10";

//   Table : SIT_DEPT_CONT                                    
$tabTable["sit_dept_cont"] = array(
  "cont_id" => array("type" => "int", "dn" => "NOT NULL"),
  "dept_id" => array("type" => "int", "dn" => "NOT NULL"),
  );
  
$tabPk["sit_dept_cont"]["pk_sit_dept_cont"] = "cont_id, dept_id";

$tabIdx["sit_dept_cont"] = array(
  "sitdeptcont_contid_fk" => "cont_id",
  "sitdeptcont_deptid_fk" => "dept_id",
  );
  
$tabFk["sit_dept_cont"] = array(
  "fk_sitdeptcont_contid" => array("ffk" => "cont_id", "tpk" => "sit_conteneur", "fpk" => "cont_id"),
  "fk_sitdeptcont_deptid" => array("ffk" => "dept_id", "tpk" => "sit_dept", "fpk" => "dept_id"),
  );

//   Table : SIT_APPLI_CONT                                    
$tabTable["sit_appli_cont"] = array(
  "cont_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sit_appli_cont"]["pk_sit_appli_cont"] = "cont_id, appli_id";

$tabIdx["sit_appli_cont"] = array(
  "lien_18_fk" => "cont_id",
  "lien_19_fk" => "appli_id",
  );

$tabFk["sit_appli_cont"] = array(
  "fk_sit_appl_lien_18_sit_cont" => array("ffk" => "cont_id", "tpk" => "sit_conteneur", "fpk" => "cont_id"),
  "fk_sit_appl_lien_19_sit_appl" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
  );

//   Table : SIT_PROFIL_APPLI                                   
$tabTable["sit_profil_appli"] = array(
  "profil_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_droit_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sit_profil_appli"]["pk_sit_profil_appli"] = "profil_id, appli_id";

$tabIdx["sit_profil_appli"] = array(
  "lien_80_fk" => "profil_id",
  "lien_81_fk" => "appli_id",
  "lien_82_fk" => "appli_droit_id",
  );

$tabFk["sit_profil_appli"] = array(
  "fk_sit_prof_lien_80_sit_profil" => array("ffk" => "profil_id", "tpk" => "sit_profil", "fpk" => "profil_id"),
  "fk_sit_prof_lien_81_sit_appl" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
  "fk_sit_prof_lien_82_sit_appl" => array("ffk" => "appli_droit_id", "tpk" => "sit_appli_droit", "fpk" => "appli_droit_id"),
  );

//   Table : SIT_AGENT_CONT                                    
$tabTable["sit_agent_cont"] = array(
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "cont_id" => array("type" => "int", "dn" => "NOT NULL"),
  "cont_admin" => array("type" => "int", "dn" => "NOT NULL"),
  "cont_visible" => array("type" => "int", "dn" => "DEFAULT 1"),
  "cont_droit" => array("type" => "int", "dn" => "DEFAULT 0"),
  );

$tabPk["sit_agent_cont"]["pk_sit_agent_cont"] = "agent_id, cont_id";

$tabIdx["sit_agent_cont"] = array(
  "lien_42_fk" => "agent_id",
  "lien_43_fk" => "cont_id",
  );

$tabFk["sit_agent_cont"] = array(
  "fk_sit_agen_lien_42_sit_agen" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_sit_agen_lien_43_sit_cont" => array("ffk" => "cont_id", "tpk" => "sit_conteneur", "fpk" => "cont_id"),
  );

//   Table : SIT_AGENT_APPLI                                   
$tabTable["sit_agent_appli"] = array(
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_droit_id" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sit_agent_appli"]["pk_sit_agent_appli"] = "agent_id, appli_id";

$tabIdx["sit_agent_appli"] = array(
  "lien_60_fk" => "agent_id",
  "lien_61_fk" => "appli_id",
  );

$tabFk["sit_agent_appli"] = array(
  "fk_sit_agen_lien_60_sit_agen" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  "fk_sit_agen_lien_61_sit_appl" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
  );

//   Table : SIT_STATISTIQUE                                    
$tabTable["sit_statistique"] = array(
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "mois_connexion" => array("type" => "int", "dn" => "NOT NULL"),
  "annee_connexion" => array("type" => "int", "dn" => "NOT NULL"),
  "nb_connexion" => array("type" => "int", "dn" => ""),
  "type_connexion" => array("type" => "int", "dn" => "NOT NULL"),
  "id_type_connexion" => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sit_statistique"]["pk_sit_stat"] = "agent_id, mois_connexion, annee_connexion, type_connexion, id_type_connexion";

//   Table : SIT_DATATYPE
$tabTable["sit_datatype"] = array(
  "datatype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "atype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "datatype_intitule" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "table_ref" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "table_alias" => array("type" => "varchar(10)", "dn" => "NOT NULL"),
  "field_pk" => array("type" => "varchar(80)", "dn" => "NOT NULL"),
  "fields_text" => array("type" => "text", "dn" => "NOT NULL"),
  "selecting_where" => array("type" => "text", "dn" => ""),
  "select_appli_id" => array("type" => "text", "dn" => ""),
  "select_atype_id" => array("type" => "text", "dn" => ""),
  "datatype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_geoloc" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "appli_search" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "appli_mdata" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  "appli_stat" => array("type" => "int", "dn" => "DEFAULT 1 NOT NULL"),
  );

$tabPk["sit_datatype"]["pk_sit_datatype"] = "datatype_id";

$tabIdx["sit_datatype"] = array(
  "sitdatatype_atypeid_fk" => "atype_id",
  );

$tabFk["sit_datatype"] = array(
  "fk_sitdatatype_atypeid" => array("ffk" => "atype_id", "tpk" => "sit_appli_type", "fpk" => "atype_id"),
  );


//   Table : SIT_LOG_ACTION                                   
$tabTable["sit_log_action"] = array(
  "action_id" => array("type" => "int", "dn" => "NOT NULL"),
  "action_intitule" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["sit_log_action"]["pk_sit_log_action"] = "action_id";

//   Table : SIT_STAT_ACTION                                   
$tabTable["sit_stat_action"] = array(
  "action_id" => array("type" => "int", "dn" => "NOT NULL"),
  "action_intitule" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["sit_stat_action"]["pk_sit_stat_action"] = "action_id";

//   Table : SIT_STAT_APPLI                                   
$tabTable["sit_stat_appli"] = array(
  "atype_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "datatype_id" => array("type" => "int", "dn" => "default -1 NOT NULL"),
  "data_id"     => array("type" => "int", "dn" => "default -1 NOT NULL"),
  "agent_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "stat_mois"   => array("type" => "int", "dn" => "NOT NULL"),
  "stat_annee"  => array("type" => "int", "dn" => "NOT NULL"),
  "action_id"   => array("type" => "int", "dn" => "NOT NULL"),
  "stat_date"   => array("type" => "datetime", "dn" => "NOT NULL"),
  "stat_nombre" => array("type" => "int", "dn" => "default 1 not null"),
  );
$tabPk["sit_stat_appli"]["pk_sit_stat_appli"] = "atype_id, appli_id, datatype_id, data_id, agent_id, stat_mois, stat_annee, stat_date, action_id";

//   Table : SIT_CRON_ACTION
$tabTable["sit_cron_action"] = array(
  "atype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "action_id" => array("type" => "int", "dn" => "NOT NULL"),
  "action_intitule" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
  "action_desc" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
);

$tabPk["sit_cron_action"]["pk_sit_cron_action"] = "action_id";

$tabIdx["sit_cron_action"] = array(
  "sitcronaction_atypeid_fk" => "atype_id",
);

$tabFk["sit_cron_action"] = array(
  "fk_sitcronaction_atypeid" => array("ffk" => "atype_id", "tpk" => "sit_appli_type", "fpk" => "atype_id"),
);

//   Table : SIT_CRON_TASK
$tabTable["sit_cron_task"] = array(
  "task_id" => array("type" => "int", "dn" => "NOT NULL"),
  "task_datecrea" => array("type" => "datetime", "dn" => "NOT NULL"),
  "cont_id" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "atype_id" => array("type" => "int", "dn" => "NOT NULL"),
  "appli_id" => array("type" => "int", "dn" => "DEFAULT -1 NOT NULL"),
  "action_id" => array("type" => "int", "dn" => "NOT NULL"),
  "task_typetask" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "task_date" => array("type" => "datetime", "dn" => ""),
  "task_jourssemaine" => array("type" => "int", "dn" => "DEFAULT 0"),
  "task_joursmois" => array("type" => "int", "dn" => "DEFAULT 0"),
  "task_mois" => array("type" => "int", "dn" => "DEFAULT 0"),
  "task_typetime" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
  "task_time" => array("type" => "varchar(5)", "dn" => ""),
  "task_datelastexec" => array("type" => "datetime", "dn" => ""),
  "task_encours" => array("type" => "int", "dn" => "DEFAULT 0 NOT NULL"),
);

$tabPk["sit_cron_task"]["pk_sit_cron_task"] = "task_id";

$tabSeq["seq_sit_cron_task"] = "10";

$tabIdx["sit_cron_task"] = array(
  "sitcrontask_contid_fk" => "cont_id",
  "sitcrontask_atypeid_fk" => "atype_id",
  "sitcrontask_actionid_fk" => "action_id",
);

$tabFk["sit_cron_task"] = array(
  "fk_sitcrontask_contid" => array("ffk" => "cont_id", "tpk" => "sit_conteneur", "fpk" => "cont_id"),
  "fk_sitcrontask_atypeid" => array("ffk" => "atype_id", "tpk" => "sit_appli_type", "fpk" => "atype_id"),
  "fk_sitcrontask_actionid" => array("ffk" => "action_id", "tpk" => "sit_cron_action", "fpk" => "action_id"),
);

//   Sequence DATA_PJ

$tabSeq["seq_data_pj"] = "1000";

//   Table : DATA_PJDOWNLOAD
$tabTable["data_pjdownload"] = array(
  "pj_id" => array("type" => "int", "dn" => "NOT NULL"),
  "agent_id" => array("type" => "int", "dn" => "NOT NULL"),
  "download_date" => array("type" => "datetime", "dn" => "NOT NULL"),
  );

$tabPk["data_pjdownload"]["pk_data_pjdownload"] = "pj_id, agent_id, download_date";

$tabIdx["data_pjdownload"] = array(
  "pjdownload_agentid_fk" => "agent_id",
  "pjdownload_pjid_fk" => "pj_id",
  );
  
$tabFk["data_pjdownload"] = array(
  "fk_pjdownload_agentid" => array("ffk" => "agent_id", "tpk" => "sit_agent", "fpk" => "agent_id"),
  );

//   Table : SIT_MAILING
$tabTable["sit_mailing"] = array(
  "mail_cle" => array("type" => "varchar(50)", "dn" => "NOT NULL"),
  "mail_desc" => array("type" => "varchar(255)", "dn" => ""),
  "mail_sujet" => array("type" => "varchar(255)", "dn" => ""),
  "mail_msg" => array("type" => "text", "dn" => ""),
  "mail_pj" => array("type" => "varchar(255)", "dn" => ""),
  );

$tabPk["sit_mailing"]["pk_sit_mailing"] = "mail_cle";


// table SIT_EPHEMERIDE
$tabTable["sit_ephemeride"] = array(
  "eph_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "eph_saint" => array("type" => "varchar(255)", "dn" => ""),
  "eph_mois"  => array("type" => "int", "dn" => "NOT NULL"),
  "eph_jour"  => array("type" => "int", "dn" => "NOT NULL"),
  );

$tabPk["sit_ephemeride"]["pk_sit_ephemeride"] = "eph_id";

// table SIT_TAG
$tabTable["sit_tag"] = array(
  "tag_lgid" => array("type" => "int", "dn" => "NOT NULL"),
  "tag_intitule" => array("type" => "varchar(255)", "dn" => "NOT NULL"),
);
$tabPk["sit_tag"]["pk_sit_tag"] = "tag_lgid, tag_intitule";

// table SIT_CONT_TYPE
$tabTable["sit_cont_type"] = array(
  "type_id"   => array("type" => "int", "dn" => "NOT NULL"),    
  "type_intitule"  => array("type" => "varchar(100)", "dn" => "")
  );
$tabPk["sit_cont_type"]["pk_sit_cont_type"] = "type_id";

$tabSeq["seq_sit_cont_type"] = "10";

  
// vue sur les droits utilisateurs
$tabView["v_user_right"] = " (CONT_ID, CONT_ADMIN, USER_ID, APPLI_ID, RIGHT_ID) as
select agc.CONT_ID, agc.CONT_ADMIN, aa.AGENT_ID, aa.APPLI_ID, aa.APPLI_DROIT_ID as RIGHT_ID
from SIT_AGENT_APPLI aa
  inner join SIT_APPLI_CONT ac on ac.APPLI_ID=aa.APPLI_ID
  inner join SIT_AGENT_CONT agc on (agc.AGENT_ID=aa.AGENT_ID and agc.CONT_ID=ac.CONT_ID)";

$tabView["v_user_space_profil"] = "(USER_ID, USER_NAME, SERVICE_ID, SERVICE_SIGLE, PROFIL_ID, CONT_ID) as
select a.AGENT_ID, ".$dbConn->getConcat("a.AGENT_NOM", "' '", "a.AGENT_PRENOM")." as USER_NAME, 
  s.SERVICE_ID, s.SERVICE_INTITULE_COURT, ap.PROFIL_ID, ac.CONT_ID
from SIT_AGENT a
  inner join SIT_AGENT_CONT ac on a.AGENT_ID=ac.AGENT_ID
  inner join SIT_AGENT_PROFIL ap on a.AGENT_ID=ap.AGENT_ID
  inner join SIT_AGENT_SERVICE ase on a.AGENT_ID=ase.AGENT_ID
  inner join SIT_SERVICE s on ase.SERVICE_ID=s.SERVICE_ID
where a.AGENT_VALIDE>=0 and s.SERVICE_NIVEAU=1
order by USER_NAME";

$tabView["v_profil_right_space"] = "(CONT_ID, APPLI_ID, APPLI_INTITULE, PROFIL_ID, PROFIL_INTITULE, RIGHT_ID ) as
select ac.CONT_ID, a.APPLI_ID, a.APPLI_INTITULE, p.PROFIL_ID, p.PROFIL_INTITULE, pa.APPLI_DROIT_ID
from SIT_APPLI_CONT ac
  inner join SIT_APPLI a on ac.APPLI_ID=a.APPLI_ID
  inner join SIT_PROFIL_APPLI pa on ac.APPLI_ID=pa.APPLI_ID
  inner join SIT_PROFIL p on pa.PROFIL_ID=p.PROFIL_ID";

$tabView["v_user_right_space"] = "(USER_ID, CONT_ID, PROFIL_ID, PROFIL_INTITULE, APPLI_ID, APPLI_INTITULE, DROIT_ID ) as
select ap.AGENT_ID, ac.CONT_ID, p.PROFIL_ID, p.PROFIL_INTITULE, 
  a.APPLI_ID, a.APPLI_INTITULE, pa.APPLI_DROIT_ID
from SIT_AGENT_PROFIL ap
  inner join SIT_PROFIL_APPLI pa on ap.PROFIL_ID=pa.PROFIL_ID
  inner join SIT_PROFIL p on ap.PROFIL_ID=p.PROFIL_ID
  inner join SIT_APPLI_CONT ac on pa.APPLI_ID=ac.APPLI_ID
  inner join SIT_APPLI a on pa.APPLI_ID=a.APPLI_ID
union
select ap.AGENT_ID, ac.CONT_ID, -1 as PROFIL_ID,  ' ' as PROFIL_INTITULE, 
  a.APPLI_ID, a.APPLI_INTITULE, max(pa.APPLI_DROIT_ID) as APPLI_DROIT_ID
from SIT_AGENT_PROFIL ap
  inner join SIT_PROFIL_APPLI pa on ap.PROFIL_ID=pa.PROFIL_ID
  inner join SIT_APPLI_CONT ac on pa.APPLI_ID=ac.APPLI_ID
  inner join SIT_APPLI a on pa.APPLI_ID=a.APPLI_ID
  group by ap.AGENT_ID, ac.CONT_ID, a.APPLI_ID, a.APPLI_INTITULE
union
select aa.AGENT_ID, ac.CONT_ID, -2 as PROFIL_ID,  ' ' as PROFIL_INTITULE,
  a.APPLI_ID, a.APPLI_INTITULE, aa.APPLI_DROIT_ID
from SIT_AGENT_APPLI aa
  inner join SIT_APPLI_CONT ac on aa.APPLI_ID=ac.APPLI_ID
  inner join SIT_APPLI a on aa.APPLI_ID=a.APPLI_ID";

 // Table : sit_agent_conn : liste des abonnées par application
$tabTable["sit_agent_conn"] = array(
  "agent_id"    => array("type" => "int", "dn" => "NOT NULL"),
  "session_id"  => array("type" => "varchar(200)", "dn" => "NOT NULL"),
  "date_conn"   => array("type" => "datetime", "dn" => ""),
  "cont_id"     => array("type" => "int", "dn" => ""),
  "appli_id"    => array("type" => "int", "dn" => "")
  );
$tabPk["sit_agent_conn"]["pk_sit_agent_conn"] = "agent_id,session_id";
$tabIdx["sit_agent_conn"] = array(
  "sit_agent_conn_agent_id_fk"   => "agent_id",
  "sit_agent_conn_session_id_fk" => "session_id",
);

// Table : sit_appli_option : liste des options d'applications
$tabTable["sit_appli_option"] = array(
    "option_id"             => array("type" => "int", "dn" => "NOT NULL"),
    "appli_id"              => array("type" => "int", "dn" => "NOT NULL"),
    "option_alias"          => array("type" => "varchar(80)", "dn" => "NOT NULL"),
    "option_intitule"       => array("type" => "varchar(255)", "dn" => ""),
    "option_desc"           => array("type" => "text", "dn" => ""),
    "option_activee"        => array("type" => "int", "dn" => "DEFAULT 0"),
    "option_droits_avances" => array("type" => "int", "dn" => "DEFAULT 0")
);
$tabPk["sit_appli_option"]["pk_sit_appli_option"] = "option_id";
$tabFk["sit_appli_option"] = array(
  "fk_sit_appli_option_sit_appl" => array("ffk" => "appli_id", "tpk" => "sit_appli", "fpk" => "appli_id"),
  );
$tabSeq["seq_sit_appli_option"] = "10";

// ressource ACL de type "option d'application"
$tabIns[] = "INSERT INTO alk_ressourcetype VALUES (2, 'Option d'application, 'Application option', 0);";

// insert initial : SIT_APPLI_DROIT , SIT_APPLI_TYPE
$tabIns[] = "insert into SIT_APPLI_DROIT (APPLI_DROIT_ID , APPLI_DROIT_INTITULE) values (0 , 'Aucun')";
$tabIns[] = "insert into SIT_APPLI_DROIT (APPLI_DROIT_ID , APPLI_DROIT_INTITULE) values (1 , 'Consultation')";
$tabIns[] = "insert into SIT_APPLI_DROIT (APPLI_DROIT_ID , APPLI_DROIT_INTITULE) values (2 , 'Administration')";
$tabIns[] = "insert into SIT_APPLI_DROIT (APPLI_DROIT_ID , APPLI_DROIT_INTITULE) values (4 , 'Administration avec publication')";

// espace de travail par défaut
$tabIns[] = "insert into SIT_CONTENEUR (CONT_ID, AGENT_ID, CONT_INTITULE, CONT_PUBLIC, CONT_DESC, CONT_LOGO, CONT_NIVEAU, CONT_ARBRE,".
  " CONT_PERE, CONT_EFFACABLE, CONT_RANG, CONT_DATE_CREA, CONT_APPLI_DEFAUT, CONT_INTITULE_COURT, CONT_DATE_MAJ, AGENT_ID_MAJ)".
  " values (0 , 1 , 'racine' , 1 , '' , '' , 0 , '-0-' , -1 , 0 , 1 , ".$dbConn->getDateCur()." , 0 , '', ".$dbConn->getDateCur().", 1)";

$tabIns[] = "insert into SIT_CONTENEUR (CONT_ID, AGENT_ID, CONT_INTITULE, CONT_PUBLIC, CONT_DESC, CONT_LOGO, CONT_NIVEAU, CONT_ARBRE,".
  " CONT_PERE, CONT_EFFACABLE, CONT_RANG, CONT_DATE_CREA, CONT_APPLI_DEFAUT, CONT_INTITULE_COURT, CONT_DATE_MAJ, AGENT_ID_MAJ)".
  " values (1 , 1 , 'Alkanet' , 1 , 'Bienvenue sur Alkanet' , '' , 1 , '-0-1-' , 0 , 0 , 1 , ".$dbConn->getDateCur()." , 0 , 'Alkanet', ".
  $dbConn->getDateCur().", 1)";

$tabIns[] = "insert into SIT_AGENT_CONT (AGENT_ID , CONT_ID , CONT_ADMIN) values (1 , 1 , 1)";
$tabIns[] = "insert into SIT_DEPT_CONT (DEPT_ID, CONT_ID) values (0, 1)";

//   Inserts Table : SIT_LOG_ACTION
$tabIns[] = "insert into SIT_LOG_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('0', '')";
$tabIns[] = "insert into SIT_LOG_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('1', 'Connexion')";        
$tabIns[] = "insert into SIT_LOG_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('2', 'Consultation')";     
$tabIns[] = "insert into SIT_LOG_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('3', 'Téléchargement')";   
$tabIns[] = "insert into SIT_LOG_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('4', 'Administration')";
$tabIns[] = "insert into SIT_LOG_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('5', 'Génération de PDF')";

//   Inserts Table : SIT_STAT_ACTION
$tabIns[] = "insert into SIT_STAT_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('0', '')";
$tabIns[] = "insert into SIT_STAT_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('1', 'Consultation')";        
$tabIns[] = "insert into SIT_STAT_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('2', 'Modification')";     
$tabIns[] = "insert into SIT_STAT_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('3', 'Suppression')";   
$tabIns[] = "insert into SIT_STAT_ACTION (ACTION_ID, ACTION_INTITULE) VALUES ('4', 'Téléchargement')";

//   Constante PHP
$tabIns[] = "delete from SIT_CONSTANTE";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) ".
            " values (-1,-1,'ALK_S_AGENTS_SELS','Agents sélectionnés',0,'Texte remplaçant : Agents sélectionnés',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_DAGENTS_AFFS','d''agents affichés',0,'Texte remplaçant : d''agents affichés',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_DAGENT','d''agent',0,'Texte remplaçant : d''agent',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) values " .
            "(-1,-1,'ALK_S_AGENT','agent',0,'Texte remplaçant : agent',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
             "values (-1,-1,'ALK_S_AGENT2','Agent',0,'Texte remplaçant : Agent',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_AGENTS','agents',0,'Texte remplaçant : agents',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_1AGENT','un agent',0,'Texte remplaçant : un agent',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_LAGENT','l''agent',0,'Texte remplaçant : l''agent',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) values " .
            "(-1,-1,'ALK_S_CAGENT','cet agent',0,'Texte remplaçant : cet agent',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
           "values (-1,-1,'ALK_S_D1NAGENT','".$dbConn->analyseSql("d'un nouvel agent")."',0,'".$dbConn->analyseSql("Texte remplaçant : d'un nouvel agent")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_LAGENT2','".$dbConn->analyseSql("L'agent")."',0,'Texte remplaçant : L''agent',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) values " .
            "(-1,-1,'ALK_S_1NAGENT','un nouvel agent',0,'Texte remplaçant : ALK_S_1NAGENT',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_LAGENT_SEL','l''agent sélectionné',0,'Texte remplaçant : ALK_S_LAGENT_SEL',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) values " .
            "(-1,-1,'ALK_S_SERV_ETAT','Etat',0,'Texte remplaçant : ALK_S_SERV_ETAT',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_SERV_DTYPEETAT','de type Etat',0,'Texte remplaçant : ALK_S_SERV_DTYPEETAT',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_SERV_DLETAT','".$dbConn->analyseSql("de l'Etat")."',0,'Texte remplaçant : ALK_S_SERV_DLETAT',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) values " .
            "(-1,-1,'ALK_S_SIT',' SIT',0,'Texte remplaçant : ALK_S_SIT',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_S_DSIT',' du SIT',0,'Texte remplaçant : ALK_S_DSIT',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_STR_ORGA_SERV1','Organigramme des services',0,'Texte remplaçant : ALK_STR_ORGA_SERV1',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_STR_ORGA_SERV2','".$dbConn->analyseSql("Afficher l'organigramme des services")."',0,'Texte remplaçant : ALK_STR_ORGA_SERV2',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
             "values (-1,-1,'ALK_STR_ORGA_SERV3','".$dbConn->analyseSql("Afficher l'organigramme")."',0,'Texte remplaçant : ALK_STR_ORGA_SERV3',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_STR_ORGA_SERV4','Organigramme',0,'Texte remplaçant : ALK_STR_ORGA_SERV4',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_APP_NAME','Alkanet',0,'Nom du projet',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_APP_VERSION','1.0.1',0,'Version du projet',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_APP_TITLE','Alkanet',0,'Titre du site',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_APP_COPYRIGHT','Alkante',0,'Copyright',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_URL_ON_LOGO','',0,'Url de redirection sur le logo du site',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_URL_IDENTIFICATION','".$dbConn->analyseSql(" ALK_ROOT_URL.'/index.php'")."',4,'".$dbConn->analyseSql("Url d'identification ")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_UPLOAD_TEMPLATE_C','template_c',0,'Répertoire génération des templates (pas de slash à la fin)',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) values " .
            "(-1,-1,'ALK_UPLOAD_CACHE','cache/',0,'Répertoire génération de fichiers temporaires',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_BTIMAGE','false',3,'Afficher les buttons graphiques de type Page et Form ',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_BTIMAGE_ICON','true',3,'Afficher les buttons graphiques de type Icon',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_B_SIT_REGION','false',3,'Est un SIT régional',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_B_ATYPE_ESPACE','true',3,'Module installé',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1,-1,'ALK_B_XSLT_PROCESS','true',3,'Transformation XML XSLT prise en charge par le PHP',0)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
            "values (-1, -1,'ALK_ITEMS_PER_PAGE','20',1,'Nombre de page par page par défaut',2)";
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
            "VALUES( -1, -1, 'ALK_B_UPLOAD_FTP', 'false', 'Possibilité pour envoyer des fichiers >8Mo par ftp', 3, 0)";
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
           "VALUES( -1, -1, 'ALK_UPLOAD_FTP_PATH', '/ftp/', 'Chemin physique du répertoire FTP par rapport à la racine du site (slash avant et après)', 0, 0)";
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
            "VALUES( -1, -1, 'ALK_B_UPLOAD_SWF', 'false', 'Possibilité upload avec plugin flash', 3, 0)";
$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
            "VALUES( -1, -1, 'ALK_B_UPLOAD_CGI', 'true', 'Possibilité upload avec ajax et perl cgi', 3, 0)";

$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
            "VALUES( -1, -1, 'ALK_B_UPLOAD_FILEMANAGER', 'true', 'Possibilité upload exploration du filemanager', 3, 0)";
            
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
           "values (0,-1,'ALK_B_SPACE_LINK','false',3,'Raccourci vers espace de travail installé. ',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
          "values (0,-1,'ALK_B_SPACE_BIBLIO_IMG','false',3,'Bibliothèque images pour espace de travail. ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
          "values (0,-1,'ALK_B_SPACE_TEST_NAME','false',3,'Test longueur intitulé espace de travail. ',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
           "values (0,-1,'ALK_B_SPACE_REMOVE_PRIV_ADMINALL','false',3,'Possibilité de retirer les privilèges aux admins principaux ',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) values " .
            "(0,-1,'ALK_B_SPACE_SEND_MAIL','true',3,'Envoi de mail sur gestion espace ',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_TYPE','false',3,'Gérer les types espaces ',0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_ADMIN_ANIM','true',3,'Administrer les espaces par un animateur ',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_ANIM_ADD_ANIM','true',3,'".$dbConn->analyseSql("Possibilité pour un animateur d'ajouter d'autre animateur ")."',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_SPACE_TAILLE_LOGO1',' 80x24px',0,'Texte indiquant la taille du logo 1 pour un espace',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_SPACE_TAILLE_LOGO2',' 80x24px',0,'Texte indiquant la taille du logo 2 pour un espace',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_SPACE_TAILLE_BANDEAU',' 740x76px',0,'Texte indiquant la taille du bandeau haut pour un espace',2)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_SPACE_PRIVE_VISIBLE','false',3,'".$dbConn->analyseSql("Possibilité d'avoir des espaces privés visibles avec possibilité de s'y inviter")."',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_STAT_APPLI', 'false',3,'Accès aux statistiques par application', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_MENTION', 'true',3,'Notion espace utilisée par Extranet', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_MENU_VISIBLE', 'true', 3, 'Possibilité de masquer des espaces non utiles dans le menu', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_DOWNLOAD_PJ', 'true', 3,'Effectue le download via php', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)" .
    " values (0,-1,'ALK_B_INSCRIPTION_SERV_NIV2', 'false', 3, 'Accès au service de niveau 2 pour popup inscription', 1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_SHEETSEARCH', 'true', 3, 'Accès onglet recherche', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_SHEETTABLEBORD', 'false', 3, 'Accès onglet tableau de bord', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_SHEETPLAN', 'true', 3, 'Accès onglet plan', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)" .
    " values (0,-1,'ALK_B_SPACE_SHEETPROP', 'true', 3, 'Accès onglet propriétés', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_SHEETANIM', 'true', 3, 'Accès onglet animateur', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_SHEETPROFIL', 'true', 3, 'Accès onglet profil', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (0,-1,'ALK_B_SPACE_SHEETSTAT', 'true', 3, 'Accès onglet statistiques', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (-1, -1,'ALK_B_SECURE_MODE', 'true', 3, 'Utilisation des codes de sécurité', 1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values (-1, -1,'ALK_ESPACE_APPLIDEFAULTRIGHT', '1', 1, 'Droit affecté par défaut aux profils des nouvelles applis', 1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)" .
  " values (0, -1,'ALK_B_SPACE_ADMIN_ALL_DEPT', 'false', 3, 'Limiter les animateurs de tous les espaces aux departements',1)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)" .
  " values (0,-1,'ALK_B_SPACE_ANIM_VIEW_STAT_ONLY','false',3,'".$dbConn->analyseSql("Possibilité pour un animateur de ne voir que les stats")."',2)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values ( -1, -1, 'ALK_CMD_XLS2CSV', '/usr/bin/xls2csv', 0, 'Commande xls2csv', 0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values ( -1, -1, 'ALK_CMD_SENDMAIL', '/usr/sbin/sendmail', 0, 'Commande sendmail', 0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values ( -1, -1, 'ALK_CMD_PHP', '/usr/bin/php', 0, 'Commande php cli', 0)";
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values ( -1, -1, 'ALK_CMD_WKHTMLTOPDF', '/usr/local/bin/wkhtmltopdf', 0, 'Commande wkhtml2pdf', 0)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN) " .
    "values ( -1, -1, 'ALK_CRON_INTERVAL', 15, 1, 'Interval de lancement en minutes de la tâche CRON qui scrute et exécute les tâches planifiées', 0)";


$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (1, 'St Abel', 8, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (2, 'St Achille', 5, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (3, 'Ste Adèle', 12, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (4, 'St Adelphe', 9, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (5, 'Ste Agathe', 2, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (6, 'Ste Agnes', 1, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (7, 'St Aimé', 9, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (8, 'Ste Aimée', 2, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (9, 'St Alain', 9, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (10, 'St Alban', 6, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (11, 'St Albert', 11, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (12, 'Ste Alda', 4, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (13, 'St Alexandre', 4, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (14, 'St Alexis', 2, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (15, 'St Alfred', 8, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (16, 'Ste Alice', 12, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (17, 'Ste Aline', 10, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (18, 'St Alix', 1, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (19, 'St Alphonse', 8, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (20, 'Ste Amandine', 7, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (21, 'St Ambroise', 12, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (22, 'Ste Amédée', 3, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (23, 'St Amour', 8, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (24, 'St André', 11, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (25, 'Ste Angèle', 1, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (26, 'St Anicet', 4, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (27, 'Ste Anne', 7, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (28, 'St Anselme', 4, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (29, 'St Anthelme', 6, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (30, 'St Antoine', 7, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (31, 'Ste Antoinette', 2, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (32, 'St Apollinaire', 9, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (33, 'Ste Apolline', 2, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (34, 'St Aristide', 8, 31)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (35, 'St Armand', 12, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (36, 'Ste Armelle', 8, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (37, 'St Arnaud', 2, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (38, 'St Arsène', 7, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (39, 'St Aubin', 3, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (40, 'Ste Aude', 11, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (41, 'Ste Audrey', 6, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (42, 'Ste Augusta', 11, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (43, 'St Augustin', 8, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (44, 'St Augustin de Cantorbéry', 5, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (45, 'Avent', 11, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (46, 'St Aymar', 5, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (47, 'Ste Barbara', 12, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (48, 'St Barnabé', 6, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (49, 'St Barnard', 1, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (50, 'St Barthélemy', 8, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (51, 'St Bartolome', 8, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (52, 'St Basile', 1, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (53, 'St Baudouin', 10, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (54, 'Ste Béatrice', 2, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (55, 'Ste Bénédicte', 3, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (56, 'St Benjamin', 3, 31)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (57, 'St Benoît', 7, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (58, 'St Benoît-Joseph Labre', 4, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (59, 'St Bérenger', 5, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (60, 'Ste Bernadette', 2, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (61, 'St Bernard', 8, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (62, 'St Bernardin', 5, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (63, 'Ste Berthe', 7, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (64, 'Ste Bertille', 11, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (65, 'St Bertrand', 9, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (66, 'Ste Bienvenue', 10, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (67, 'St Blaise', 2, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (68, 'Ste Blanche', 10, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (69, 'Ste Blandine', 6, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (70, 'St Brice', 11, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (71, 'Ste Brigitte', 7, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (72, 'St Boris', 5, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (73, 'St Bruno', 10, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (74, 'Ste Camille', 7, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (75, 'Ste Carine', 11, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (76, 'Ste Caroline', 7, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (77, 'St Casimir', 3, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (78, 'Ste Catherine', 3, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (79, 'Ste Catherine Labouré', 11, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (80, 'Ste Cathy', 4, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (81, 'Ste Cécile', 11, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (82, 'Ste Céline', 10, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (83, 'Ste Chantal', 12, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (84, 'St Charles', 11, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (85, 'St Charles le Bon', 3, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (86, 'Christ-Roi', 11, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (87, 'St Christian', 11, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (88, 'Ste Christine', 7, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (89, 'St Christophe', 8, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (90, 'Ste Claire', 8, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (91, 'Ste Clarisse', 8, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (92, 'St Claude', 2, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (93, 'Ste Claudine', 6, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (94, 'Ste Clémence', 3, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (95, 'St Clément', 11, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (96, 'Ste Clementine', 11, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (97, 'Ste Clotilde', 6, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (98, 'Ste Colette', 3, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (99, 'St Côme et Damien', 9, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (100, 'St Conrad', 11, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (101, 'St Constant', 9, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (102, 'St Constantin', 5, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (103, 'Conversion de St Paul', 1, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (104, 'Ste Corinne', 5, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (105, 'St Crépin', 10, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (106, 'St Cyrille', 3, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (107, 'St Daniel', 12, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (108, 'St David', 12, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (109, 'St Davy', 9, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (110, 'Défunts', 11, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (111, 'St Denis', 10, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (112, 'Ste Denise', 5, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (113, 'Ste Désiré', 5, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (114, 'Ste Diane', 6, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (115, 'St Didier', 5, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (116, 'St Dimitri', 10, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (117, 'St Dominique', 8, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (118, 'St Donald', 7, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (119, 'St Donatien', 5, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (120, 'St Edgar', 7, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (121, 'Ste Edith', 9, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (122, 'St Edmond', 11, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (123, 'St Edouard', 1, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (124, 'Ste Edwige', 10, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (125, 'St Elie', 7, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (126, 'Ste Elisabeth', 11, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (127, 'Ste Elise', 11, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (128, 'Ste Elisée', 6, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (129, 'Ste Ella', 2, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (130, 'Ste Elodie', 10, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (131, 'Ste Emeline', 10, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (132, 'St Emile', 5, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (133, 'Ste Emilie', 9, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (134, 'Ste Emma', 4, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (135, 'St Emmanuel', 12, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (136, 'Epiphanie', 1, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (137, 'St Eric', 5, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (138, 'St Ernest', 11, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (139, 'St Etienne', 12, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (140, 'St Evrard', 8, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (141, 'Ste Eugénie', 2, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (142, 'Ste Euloge', 3, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (143, 'Ste Eusèbe', 8, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (144, 'Ste Fabienne', 1, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (145, 'Ste Fanny', 12, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (146, 'St Félix', 2, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (147, 'Ste Félicité', 3, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (148, 'St Ferdinand', 5, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (149, 'St Fernand', 6, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (150, 'Fête-Dieu', 6, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (151, 'St Fiacre', 8, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (152, 'St Fidèle', 4, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (153, 'St Firmin', 10, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (154, 'Ste Fleur', 10, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (155, 'Ste Florence', 12, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (156, 'St Florent', 7, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (157, 'St Florentin', 10, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (158, 'St François', 10, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (159, 'Ste Françoise', 3, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (160, 'Ste Françoise-Xavière', 12, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (161, 'St François de Sales', 1, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (162, 'St Frédéric', 7, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (163, 'St Fulbert', 4, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (164, 'St Gabin', 2, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (165, 'St Gabriel', 9, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (166, 'St Gaétan', 8, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (167, 'St Gaston', 2, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (168, 'St Gatien', 12, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (169, 'Ste Geneviève', 1, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (170, 'St Geoffroy', 11, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (171, 'St Georges', 4, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (172, 'Ste Georgette', 4, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (173, 'St Gérald', 12, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (174, 'St Gérard', 10, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (175, 'St Géraud', 10, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (176, 'St Germain', 5, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (177, 'Ste Germaine', 6, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (178, 'St Ghislain', 10, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (179, 'St Gilbert', 2, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (180, 'Ste Gilberte', 8, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (181, 'St Gildas', 1, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (182, 'St Gilles', 9, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (183, 'Ste Gisèle', 5, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (184, 'St Gontran', 3, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (185, 'St Grégoire', 9, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (186, 'St Guennolé', 3, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (187, 'St Guillaume', 1, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (188, 'St Guy', 6, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (189, 'St Habib', 3, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (190, 'St Hébert', 9, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (191, 'Ste Hélène', 8, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (192, 'St Henri', 7, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (193, 'St Herbert', 3, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (194, 'St Hermann', 9, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (195, 'St Hervé', 6, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (196, 'St Hippolyte', 8, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (197, 'St Honoré', 5, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (198, 'Ste Honorine', 2, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (199, 'St Hubert', 11, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (200, 'St Hugues', 4, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (201, 'Ste Hyacinthe', 8, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (202, 'Ste Ida', 4, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (203, 'Ste Ignace', 7, 31)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (204, 'St Igor', 6, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (205, 'Immaculée conception', 12, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (206, 'Ste Inès', 9, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (207, 'Ste Irène', 4, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (208, 'Ste Irénée', 6, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (209, 'Ste Isabelle', 2, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (210, 'St Isidore', 4, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (211, 'Ste Jacqueline', 2, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (212, 'St Jacques', 7, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (213, 'St Jean Eudes', 8, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (214, 'St Jean-Baptiste', 6, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (215, 'St J.-B. de la Salle', 4, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (216, 'St Jean de Dieu', 3, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (217, 'St Jean de Capistran', 10, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (218, 'St Jean-François Régis', 6, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (219, 'St Jean-Marie Vianney', 8, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (220, 'Ste Jeanne', 5, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (221, 'St Jérôme', 9, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (222, 'St Joachim', 7, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (223, 'St Joël', 7, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (224, 'St Jonas', 3, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (225, 'St Joseph', 3, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (226, 'St Judicaël', 12, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (227, 'Ste Judith', 5, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (228, 'St Jules', 4, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (229, 'Ste Julie', 4, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (230, 'St Julien', 8, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (231, 'Ste Julienne', 2, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (232, 'Ste Juliette', 7, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (233, 'St Juste', 10, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (234, 'St Justin', 6, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (235, 'Ste Justine', 3, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (236, 'Ste Karine', 11, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (237, 'Ste Katia', 11, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (238, 'St Kevin', 6, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (239, 'St Killian', 7, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (240, '".$dbConn->analyseSql("L'Annonciation")."', 3, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (241, 'LA Sainte Croix', 9, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (242, 'St Landry', 6, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (243, 'Ste Larissa', 3, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (244, 'Ste Laure', 8, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (245, 'St Laurent', 8, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (246, 'St Lazare', 2, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (247, 'Ste Léa', 3, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (248, 'St Léger', 10, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (249, 'St Léon', 11, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (250, 'Ste Léonce', 6, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (251, 'Ste Lidwine', 4, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (252, 'St Louis', 8, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (253, 'Ste Louise', 3, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (254, 'St Luc', 10, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (255, 'Ste Lucie', 12, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (256, 'St Lucien', 1, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (257, 'Ste Lydie', 8, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (258, 'St Marc', 4, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (259, 'St Marcel', 1, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (260, 'Ste Marcelle', 1, 31)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (261, 'St Marcellin', 4, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (262, 'Ste Marguerite', 11, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (263, 'Ste Marianne', 7, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (264, 'Ste Marie', 1, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (265, 'Ste Marie-Madeleine', 7, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (266, 'Ste Marie-Thérèse', 6, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (267, 'Ste Mariette', 7, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (268, 'Ste Marilyne', 8, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (269, 'Ste Marina', 7, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (270, 'St Marius', 1, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (271, 'Ste Marthe', 7, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (272, 'St Martial', 6, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (273, 'St Martin', 11, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (274, 'Ste Martine', 1, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (275, 'St Martinien', 7, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (276, 'Ste Mathilde', 3, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (277, 'St Mathurin', 11, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (278, 'St Matthias', 5, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (279, 'St Matthieu', 9, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (280, 'St Maurice', 9, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (281, 'St Mayeul', 5, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (282, 'St Médard', 6, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (283, 'Ste Mélaine', 1, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (284, 'St Michel', 9, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (285, 'St Modeste', 2, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (286, 'Ste Monique', 8, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (287, 'Ste Muguette', 5, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (288, 'Ste Nadège', 9, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (289, 'St Narcisse', 10, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (290, 'Ste Natacha', 8, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (291, 'Nativité Vierge Marie', 9, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (292, 'Ste Nathalie', 7, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (293, 'N.-D. de Lourdes', 2, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (294, 'N.-D. du Mont-Carmel', 7, 16)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (295, 'St Nestor', 2, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (296, 'St Nicolas', 12, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (297, 'Ste Nina', 1, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (298, 'Ste Ninon', 12, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (299, 'St Noël', 12, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (300, 'St Norbert', 6, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (301, 'Ste Odette', 4, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (302, 'Ste Odile', 12, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (303, 'Ste Olga', 7, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (304, 'St Olive', 3, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (305, 'St Olivier', 7, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (306, 'St Oswald', 8, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (307, 'Ste Pacôme', 5, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (308, 'StParfait', 4, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (309, 'St Pascal', 5, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (310, 'St Paterne', 4, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (311, 'St Patrice', 3, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (312, 'St Patrick', 3, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (313, 'St Paul', 6, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (314, 'Ste Paule', 1, 26)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (315, 'St Paulin', 1, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (316, 'Ste Pélagie', 10, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (317, 'St Philippe', 5, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (318, 'St Pierre', 6, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (319, 'St Pierre Canisius', 12, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (320, 'St Pierre Damien', 2, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (321, 'St Pierre Fourier', 12, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (322, 'St Placide', 6, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (323, '1er de Carême', 2, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (324, 'Prés. du seigneur', 2, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (325, 'Ste Prisca', 1, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (326, 'St Prosper', 6, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (327, 'Ste Prudence', 5, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (328, 'St Quentin', 10, 31)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (329, 'Ste Rachel', 1, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (330, 'Ste Raïssa', 9, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (331, 'St Raoul', 7, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (332, 'St Raymond', 1, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (333, 'Ste Reine', 9, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (334, 'St Rémi', 1, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (335, 'St Renaud', 9, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (336, 'St René', 10, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (337, 'St Richard', 4, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (338, 'St Robert', 4, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (339, 'St Rodolphe', 6, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (340, 'St Rodrigue', 3, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (341, 'St Roger', 12, 30)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (342, 'St Roland', 9, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (343, 'St Romain', 2, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (344, 'St Romaric', 12, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (345, 'St Roméo', 2, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (346, 'St Romuald', 6, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (347, 'Ste Rosalie', 9, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (348, 'Ste Rose', 8, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (349, 'Ste Roselyne', 1, 17)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (350, 'Ste Sabine', 8, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (351, 'Saints Innocents', 12, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (352, 'St Samson', 7, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (353, 'Ste Sandrine', 4, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (354, 'St Saturnin', 11, 29)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (355, 'St Sébastien', 1, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (356, 'St Serge', 10, 7)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (357, 'St Séverin', 11, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (358, 'St Silvère', 6, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (359, ' Sidoine', 11, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (360, 'St Simon', 10, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (361, 'Ste Solange', 5, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (362, 'Ste Sonia', 9, 18)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (363, 'Ste Sophie', 5, 25)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (364, 'St Stanislas', 4, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (365, 'Ste Suzanne', 8, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (366, 'St Sylvain', 5, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (367, 'St Sylvestre', 12, 31)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (368, 'Ste Sylvie', 11, 5)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (369, 'St Symphorien', 8, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (370, 'St Tanguy', 11, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (371, 'Ste Tatiana', 1, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (372, 'St Thècle', 9, 24)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (373, 'St Théodore', 11, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (374, 'St Théophile', 12, 20)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (375, 'Ste Thérèse', 10, 15)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (376, '".$dbConn->analyseSql("Ste Thérèse de l'E.-J.")."', 10, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (377, 'St Thibaud', 7, 8)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (378, 'St Thierry', 7, 1)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (379, 'St Thomas', 7, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (380, '".$dbConn->analyseSql("St Thomas d'Aquin")."', 1, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (381, 'Transfiguration', 8, 6)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (382, 'St Ulrich', 7, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (383, 'St Urbain', 12, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (384, 'Ste Ursula', 10, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (385, 'St Valentin', 2, 14)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (386, 'Ste Valérie', 4, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (387, 'Ste Véronique', 2, 4)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (388, 'St Victor', 7, 21)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (389, 'St Victorien', 3, 23)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (390, 'St Vincent', 1, 22)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (391, 'St Vincent de Paul', 9, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (392, 'Visitation', 5, 31)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (393, 'Ste Viviane', 12, 2)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (394, 'St Vivien', 3, 10)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (395, 'St Walter', 4, 9)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (396, 'St Wenceslas', 9, 28)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (397, 'St Wilfried', 10, 12)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (398, 'St Xavier', 12, 3)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (399, 'St Yann', 12, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (400, 'Ste Yolande', 6, 11)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (401, 'St Yves', 5, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (402, 'Ste Yvette', 1, 13)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (403, 'Ste Yvonne', 5, 19)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (404, 'Ste Zita', 4, 27)";
$tabIns[] = "INSERT INTO SIT_EPHEMERIDE (EPH_ID, EPH_SAINT, EPH_MOIS, EPH_JOUR) VALUES (405, 'Ste Zoe', 5, 2)";

// mailing
$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_ADD_SPACE', 'Envoyé lors de la création d un espace', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_DEMANDE_INVITATION', 'Envoyé pour être invité à un espace', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_CONTACT', 'Envoyé aux admins pour répondre à un problème', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_CONFIRME_DEJA_INVITE', 'Confirme que la personne est déjà invitée sur l espace', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_CONFIRME_INVITATION', 'Envoyé pour confirmer invitation à un espace', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_CONFIRME_UTIL_CPT', 'Envoyé pour confirmer la création du compte utilisateur', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";
  
$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_UTIL_MDP_OUBLIE', 'Envoyé pour fournir les paramètres de connexion', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_UTIL_A_VALIDER_RELANCE', 'Envoyé aux admins pour relancer la validation d un compte', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_UTIL_A_ACTIVER', 'Envoyé aux admins pour activer un compte', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_AR_UTIL_CREATION', 'Accusé réception de la demande de création de compte', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";

$tabIns[] = "INSERT INTO SIT_MAILING (MAIL_CLE, MAIL_DESC, MAIL_SUJET, MAIL_MSG, MAIL_PJ)" .
  " VALUES ('ESPACE_UTIL_A_VALIDER', 'Envoyé aux admins suite création fiche pour valider la fiche', '{\$apptitle} : {\$msgTitle}', " .
  "'<html><p>{\$dest},<br/><br/>" .
  "{\$msg}<br/><br/>".
  "{\$msgUrlSite}<br/>".
  "{\$msgSign}<br/>".
  "{\$msgPS}</p></html>', NULL)";
  
$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)" .
  " values ( -1, -1,'ALK_B_SPACE_SHEET_LINKS', 'false', 3, 'Possiblité de vérifier les liens présents dans les différents modules', 1)";

$tabIns[] = "insert into SIT_CONSTANTE (ATYPE_ID,APPLI_ID,CONST_INTITULE,CONST_VALEUR,CONST_TYPE,CONST_LABEL,CONST_ADMIN)" .
  " values ( -1, -1,'ALK_B_INSCRIPTION_SERVICE', 'false', 3, 'Inscription intermédiaire', 1)";

$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
            "VALUES( -1, -1, 'ALK_B_GRP_TRAV_OBJET', 'true', '".$dbConn->analyseSql("Possibilité d'afficher le champ objet dans la gestion des espaces")."', 3, 0)";

$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
		"VALUES( -1, -1, 'ALK_ITEM_PER_STATS', '10', '".$dbConn->analyseSql("Nombre de valeur maximale accepté pour afficher les graphiques des statistiques")."', 1, 0)";

$tabIns[] = "INSERT INTO SIT_CONSTANTE (ATYPE_ID,APPLI_ID, CONST_INTITULE,CONST_VALEUR, CONST_LABEL, CONST_TYPE, CONST_ADMIN) " .
		"VALUES( -1, -1, 'ALK_B_MEDIA_SHARED', 'false', '".$dbConn->analyseSql("Permet pour un même espace de gérer tous les fichiers envoyer sur le serveur dans un même répertoire")."', 3, 0)";
    

$tabIns[] = "INSERT INTO ALK_RESSOURCETYPE (RESSTYPE_ID, RESSTYPE_NAME_FR, RESSTYPE_NAME_EN, TAPPLI_ID, RESSTYPE_ALIAS) VALUES (2, 'Option d''application', 'Application option', 0, 'RESSTYPE_ESPACE_OPTIONAPPLI');";
$tabIns[] = "insert into ACL_ROLE (ROLE_ID, ROLE_NAME_FR, ROLE_NAME_EN, ROLE_MASK, ROLE_ALIAS) VALUES(4, 'Option activée', 'Activated Option', 127, 'ROLE_ESPACE_OPTIONAPPLI')";
$tabIns[] = "insert into ACL_ROLE_RESSTYPE values (4, 2); ";  

 ?>