 <?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormAppliList
 * Classe d'affichage de la page gestion des domainess blocs de controle d'un formulaire
 */
class AlkHtmlFormAppliList extends AlkHtmlForm
{

  /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formAppliList"); 
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $strAction = "";
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }

  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    
    $iMode = AlkRequest::getToken("iMode");
    $page  = AlkRequest::getToken("page");

    switch( $iMode ) {
    case ALK_FORM_MODE_DEL: // suppression d'une application
      $appli_id = AlkRequest::getToken("idAppli");
      $atype_id = AlkRequest::getToken("atype_id");

      $this->oAppli->delAppli($appli_id, $atype_id);
      break;
    }

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_APPLICATION, ALK_SHEET_LIST, "&page=".$page);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $cont_id = $this->oAppli->cont_id;
    $this->strParam = "cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_APPLICATION."&iSSheet=";

    $this->setLabel(_t("Liste des applications associ&eacute;es &agrave; cet espace"));
    $strTokenImport = AlkRequest::getEncodeParam($this->strParam.ALK_SHEET_FORM."&iMode=4");
    $strDesc = _t("Cliquez sur l'intitul&eacute; de l'application pour modifier ses propri&eacute;t&eacute;s.")."<br/>".
      ( ALK_B_UPLOAD_FTP == true 
        ? _t("Il est possible d'ajouter des applications par").' <a href="'.ALK_ALKANET.'?token='.$strTokenImport.'">'._t("import").'</a>.'
        : "" );
    $this->setLabelDesc($strDesc);

    $strToken = AlkRequest::getEncodeParam($this->strParam.ALK_SHEET_FORM."&iMode=".ALK_FORM_MODE_ADD);
    $oBtAdd = AlkHtmlFactory::getHtmlButtonPage(ALK_ALKANET."?token=".$strToken, _t("Ajouter"), _t("Ajouter une application"));
    
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    AlkFactory::setSQLParamsName();

    $this->dsAppli = $this->oAppli->oQuery->getDs_listeAppliByEspace($cont_id);
    $nbElt = $this->dsAppli->getCountTotDr();
    $iNbEltParPage = $nbElt; //ALKRequest::_GETint("nbItemsPerPage", ALK_ITEMS_PER_PAGE);
    $page = 1; //ALKRequest::_GETint("page", 1);
    
    $output = array();
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
      $output = array(
            "sEcho" => AlkFactory::getSQLParamsName("sEcho", ""),
            "iTotalRecords" => $this->dsAppli->getCountTotDr(),
            "iTotalDisplayRecords" => $this->dsAppli->getCountTotDr(),
            "aaData" => array()
          );
          
    AlkFactory::emptySQLParamsName();
    
    $strUrlPagine = $_SERVER["PHP_SELF"]."?token=".AlkRequest::getEncodeParam($this->strParam.ALK_SHEET_LIST."&iMode=4");
    
    $oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, $strUrlPagine);
    
    /*$oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, $page, $iNbEltParPage, false, 
                                            $strUrlPagine, _t("Aucune application sur cet espace."));*/
                                            
                                            
                                            
    $oTabPage->SetColumns(array("left",   "220", "APPLI_INTITULE"),
                          array("center", "150", "ATYPE_INTITULE"),
                          array("center", "50",  "APPLI_RANG"),
                          array("center", "70", "", false, false));

    $oTabPage->AddTitleRow(_t("Intitulé de l'application"), _t("Type"), _t("Ordre"), $oBtAdd->getHtml());
    $oTabPage->setFilter(true);
    $oTabPage->setModeAjax(true);
    
     // Lecture des données
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    $iMode = AlkRequest::getToken("iMode");
    if ($iMode==4)
      $this->readData(true, $page, $iNbEltParPage, $oTabPage, $output);
 
    $oTabPage->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformapplilist.js");

    $this->addPanel($oTabPage);
  }
  
  private function readData($bModeAjax=false, $page, $iNbEltParPage, &$oList, &$output){
    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    $nbElt = $this->dsAppli->getCountTotDr();
    $appli_id_defaut = $this->oAppli->getAppliProperty("CONT_APPLI_DEFAUT", "0");
    $cont_id = $this->oAppli->cont_id;
    
    while( $drAppli = $this->dsAppli->getRowIter() ) {
      $idAppli          = $drAppli->getValueName("APPLI_ID");
      $appli_intitule   = $drAppli->getValueName("APPLI_INTITULE");
      $appli_rang       = $drAppli->getValueName("APPLI_RANG");
      $atype_id         = $drAppli->getValueName("ATYPE_ID");
      $atype_intitule   = $drAppli->getValueName("ATYPE_INTITULE");
      $atype_compatible = $drAppli->getValueName("ATYPE_COMPATIBLE");
      $iNbRef           = $drAppli->getValueName("NB_APPLI");
      $appli_liee       = $drAppli->getValueName("APPLI_LIEE");
      
      $bDroit = false;
      if( $appli_liee=="" && ($atype_compatible == "1" || ($atype_compatible == "0" && ($user_priv & ALK_PRIV_SPACE_ADMIN)==ALK_PRIV_SPACE_ADMIN )) ) 
        $bDroit = true;
    
      $strDef = ($appli_id_defaut == $idAppli ? " ("._t("d&eacute;faut").")" : "" );
    
      $oLinkIntitule = AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".AlkRequest::getEncodeParam($this->strParam.ALK_SHEET_FORM.
                                                                                                     "&iMode=".ALK_FORM_MODE_UPDATE."&idAppli=".$idAppli), 
                                                     $appli_intitule.$strDef, _f("Modifier les propriétés de l'application %s", $appli_intitule));
    
      $oSuppr = "&nbsp;";
      if( $bDroit == true ) {
        $iPage = ( $nbElt-1 <= ($page-1)*$iNbEltParPage ? ($page-1>0 ? $page-1 : 1) : $page);

        $oSuppr = AlkHtmlFactory::getHtmlButtonForm("javascript:supprAppli('".AlkRequest::getEncodeParam($this->strParam.ALK_SHEET_LIST."&iMode=".ALK_FORM_MODE_DEL.
                                                                                                         "&idAppli=".$idAppli."&atype_id=".$atype_id."&page=".$iPage)."')", 
                                                    _t("Supprimer"), _f("Supprimer l'application %s", $appli_intitule));
        if ( (defined("ALK_B_ATYPE_ACL") && ALK_B_ATYPE_ACL==true)){
          // bouton gérer les options
          $oOptions = AlkHtmlFactory::getHtmlButtonForm("javascript:OpenWindow('".ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".
                                                      ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_OPTIONS."&idAppli=".$idAppli."&atype_id=".$atype_id."&page=".$iPage)."', 550, 1000)", 
                                                      _t("Options"), _f("Gérer les options de l'application %s", $appli_intitule));

          $oSuppr = $oOptions->getHtml()." ".$oSuppr->getHtml();
        }else{
          $oSuppr = $oSuppr->getHtml();
        }
      }
      
       if ($bModeAjax)
        $output["aaData"][] = array($oLinkIntitule->getHtml(), $atype_intitule, $appli_rang, $oSuppr);
      else
        $oList->addRowByArray(array($oLinkIntitule->getHtml(), $atype_intitule, $appli_rang, $oSuppr));
    }
    
    if ( $bModeAjax) {
      echo json_encode( $output );
      exit();
    }
  }
 
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_07_appli_list.htm"); 
  }

}
?>