<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormAppliForm
 * Classe d'affichage de la page gestion des domainess blocs de controle d'un formulaire
 */
class AlkHtmlFormCategorieForm extends AlkHtmlForm
{
  protected $type_intitule;
  protected $type_id;
  
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formCategorie");

    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strAction = "";

    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit)
  {
    $type_id = AlkRequest::getToken("type_id", -1);

    $this->type_intitule      = new AlkFormData($this, "type_intitule", "", ALK_SQL_TEXT);
    $this->type_id            = new AlkFormData($this, "type_id", $type_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
   
    
    $oDrData = null;
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
    	$oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $oDsData = $oQuery->GetDs_ficheCategorieById($type_id);
      if( !($oDrData = $oDsData->GetRowIter()) )
        $oDrData = null;
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
    
    $this->initData($iTypeInit, $oDrData, $reqMethod);
    
  }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
  	$this->setData(ALK_INIT_MODE_REQUEST);
  
    $iMode = AlkRequest::getToken("iMode", -1);
    $page = AlkRequest::getToken("page", 1);
    $type_id = AlkRequest::getToken("type_id", -1);
        
    switch( $iMode ) {
    case ALK_FORM_MODE_ADD:
      $tabQuery = $this->getTabQuery(array("TYPE_ID"), array());
      $this->oAppli->oQueryAction->addWithTabQuery($this, $tabQuery, "SIT_CONT_TYPE");
      break;

    case ALK_FORM_MODE_UPDATE:
      $tabQuery = $this->getTabQuery(array("TYPE_ID"), array());
      $this->oAppli->oQueryAction->updateWithTabQuery($this, $tabQuery, "SIT_CONT_TYPE");
      break;
    }
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_PROPRIETE, ALK_SHEET_RUBRIQUE, ALK_SHEET_LIST, "&page=".$page);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
       
  	$this->setData(ALK_INIT_MODE_DATAROW);


    $page = AlkRequest::getToken("page", 1);
    $type_id = AlkRequest::getToken("type_id", -1);

    $iWidthTxt = 30;
    $iWidthLabelLeft = 130;
    $iWidthCtrlLeft  = 250;
    $iWidthLabelRight = 100;
    $iWidthCtrlRight = 280;

    $this->setLabel( $this->iMode == ALK_FORM_MODE_ADD
                     ? _t("Ajout d'une cat&eacute;gorie &agrave; cet espace")
                     : _t("Modification des propri&eacute;t&eacute;s de la cat&eacute;gorie") );

    $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->type_intitule, _t("Intitulé"), 1, $iWidthTxt, 32);
    $oCtrlTxt->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT); 
 
    
    /** ajout de blocs et association des controles */
    $oBlockProp = $this->addBlock("block_1", _t("Propriétés de la catégorie"), "", $iWidthLabelLeft, $iWidthCtrlLeft, true);
    $oBlockProp->addCtrl($oCtrlTxt);

    /** Ajout des boutons */
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_PROPRIETE, ALK_SHEET_RUBRIQUE, ALK_SHEET_FORM, 
                                        "&type_id=".$type_id."&iMode=".$this->iMode."&page=".$page);
    $oButton = $this->addButtonPage("bt_1", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider les modifications"));
    $this->addSubmitButton($oButton);

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_PROPRIETE, ALK_SHEET_RUBRIQUE, ALK_SHEET_LIST, "&page=".$page);
    $this->addButtonPage("bt_2", ALK_ALKANET."?token=".$strToken, _t("Annuler"), _t("Annuler les modifications"));
        
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformcategorielist.js");
    //$this->setTemplate("espace", "alkhtmlformappliform.tpl");  
  }

  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_07_appli_form.htm"); 
  }
}
?>