<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormCategorieList
 * Classe d'affichage de la page gestion des categorie blocs de controle d'un formulaire
 */
class AlkHtmlFormCategorieList extends AlkHtmlForm
{

  /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formCategorieList"); 
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $strAction = "";
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }

  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }

  /**
   * Traitement du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    $type_id = AlkRequest::getToken("type_id");
    $iMode = AlkRequest::getToken("iMode");
    $page  = AlkRequest::getToken("page");

    switch( $iMode ) {
    case ALK_FORM_MODE_DEL: // suppression d'une application
     
      $this->oAppli->oQueryAction->delDataCategorie($type_id);
     
      break;
    }

    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_PROPRIETE, ALK_SHEET_RUBRIQUE, ALK_SHEET_LIST, "&page=".$page);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $cont_id = $this->oAppli->cont_id;
    $strParam = "cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_PROPRIETE."&iSheet=".ALK_SHEET_RUBRIQUE."&iSSheet=";

    $this->setLabel(_t("Liste des cat&eacute;gories potentielles associ&eacute;es aux espaces"));
    $strDesc = _t("Cliquez sur l'intitul&eacute; de la cat&eacute;gorie pour modifier ses propri&eacute;t&eacute;s.");

    $this->setLabelDesc($strDesc);

    $strToken = AlkRequest::getEncodeParam($strParam.ALK_SHEET_FORM."&iMode=".ALK_FORM_MODE_ADD);
    $oBtAdd = AlkHtmlFactory::getHtmlButtonPage(ALK_ALKANET."?token=".$strToken, _t("Ajouter"), _t("Ajouter une cat&eacute;gorie pour cet espace"));


    $dsCategorie = $this->oAppli->oQuery->getDsListTypeByGrpTravailForCombo($cont_id);
    $nbElt = $dsCategorie->getCountTotDr();
    $iNbEltParPage = $nbElt; //ALKRequest::_GETint("nbItemsPerPage", ALK_ITEMS_PER_PAGE);
    $page = 1; //ALKRequest::_GETint("page", 1);
    
    $strUrlPagine = $_SERVER["PHP_SELF"]."?token=".AlkRequest::getEncodeParam($strParam.ALK_SHEET_LIST);
    $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, $page, $iNbEltParPage, false, 
                                            $strUrlPagine, _t("Aucune cat&eacute;gorie sur cet espace."));
    $oTabPage->SetColumns(array("left",   "220"),
                          array("center", "120"));
    $oTabPage->AddTitleRow(_t("Intitulé de la cat&eacute;gorie"), $oBtAdd->getHtml());
    while( $drAppli = $dsCategorie->getRowIter() ) {
      $type_id          = $drAppli->getValueName("TYPE_ID");
      $cat_intitule   = $drAppli->getValueName("TYPE_INTITULE");
      $oLinkIntitule = AlkHtmlFactory::getHtmlButton(ALK_ALKANET."?token=".AlkRequest::getEncodeParam($strParam.ALK_SHEET_FORM.
                                                                                                     "&iMode=".ALK_FORM_MODE_UPDATE."&type_id=".$type_id), 
                                                     $cat_intitule, _f("Modifier les propriétés de la cat&eacute;gorie %s", $cat_intitule));
      $oSuppr = "&nbsp;";
      $iPage = ( $nbElt-1 <= ($page-1)*$iNbEltParPage ? ($page-1>0 ? $page-1 : 1) : $page);
      $oSuppr = AlkHtmlFactory::getHtmlButtonForm("javascript:supprCategorie('".AlkRequest::getEncodeParam($strParam.ALK_SHEET_LIST."&iMode=".ALK_FORM_MODE_DEL.
                                                                                                         "&type_id=".$type_id."&page=".$iPage)."')", 
                                                    _t("Supprimer"), _f("Supprimer la cat&eacute;gorie %s", $cat_intitule));
      $oSuppr = $oSuppr->getHtml();   
      $oTabPage->AddRow($oLinkIntitule->getHtml(), $oSuppr);
    }
 
    $oTabPage->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformcategorielist.js");

    $this->addPanel($oTabPage);
  }
 
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/help/espace_07_categorie_list.htm"); 
  }

}
?>