<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

include_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/classes/alkhtmlformlsdifform.class.php";
/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormInvitationForm
 * Classe de gestion des invitation à un espace
 */
class AlkHtmlFormInvitationForm extends AlkHtmlFormLsDifForm
{
    /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
   
  protected $atype_id;
  protected $oAppliEspace;
  protected $appli_id;
   
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli); 

  }
  
  protected function setData($iTypeInit) {
    parent::setData($iTypeInit);
    
    $oEspace = AlkFactory::getAppli(ALK_ATYPE_ID_ESPACE);
    $nomEspace = "";
    $dsEspace = $oEspace->oQuery->getDs_ficheEspaceById($this->oAppli->cont_id);
    if($drEspace = $dsEspace->getRowIter()){
    	$nomEspace = $drEspace->getValueName("CONT_INTITULE");
    }
    $cont_id = ($this->oAppli->cont_id==-1 ? AlkRequest::getToken("cont_id",-1) : $this->oAppli->cont_id);
    // on impose le appli_id à -1 pour pointer sur l'espace
    //$appli_id = ($this->oAppli->appli_id==-1 ? AlkRequest::getToken("appli_id",-1): $this->oAppli->appli_id);
    $appli_id = -1;
    $strParam = "cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER."&iSSheet=".ALK_SHEET_NONE."&key=";
    
    //$strParam = "cont_id=-1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER."&iSSheet=".ALK_SHEET_NONE."&key=";
    
    $strParam .= md5($strParam); 
    $strToken = AlkRequest::getEncodeParam($strParam) ;
    $strUrlToken = ALK_ALKANET."?token=".$strToken;
      
    $bIsCollabSpace = $oEspace->oQuery->Is_CollabSpace($this->oAppli->cont_id);
    
    $this->msg_message->value = "<p> Bonjour, <br/><br/> Vous avez &eacute;t&eacute; invit&eacute;s ".($bIsCollabSpace ? "&agrave; vous inscrire au groupe de travail" : "&agrave; vous inscrire sur l'outil d'administration de l'espace ")." '".$nomEspace."'. <br/>Pour confirmer cette invitation vous devez cliquer sur le lien suivant : <br/>".
     "<a href=".$strUrlToken." target='_blank'>Lien pour confirmer votre inscription.</a><br/><br/>".
        " Cordialement,<br/><br/>" .
        "Administrateur ".ALK_APP_TITLE.".</p>";
    $this->msg_sujet->value = ($bIsCollabSpace ? "Invitation au groupe de travail" : "Invitation à l'administration de l'espace")." '".$nomEspace."'"; 
  }
  
  /**
   * Traitements Sql
   */
  public function doSql(){
    parent::doSql();
  }
  
  /*
   * Contenu du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    $this->appli_id = $appli_id = AlkRequest::getToken("appli_id", "-1");

    // Initialisation des longueurs de champs de formulaire
    $this->iWidthTxt = $iWidthTxt = 38;
    $iWidthMemo = 36;
    $this->iHeightMemo = $iHeightMemo = 20;
    $this->iHeightSelect = $iHeightSelect = 7;
    $this->iWidthSelect = $iWidthSelect = 247;
    $cont_id = $this->oAppli->cont_id;
    $this->user_right = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    $this->user_id = $user_id    = AlkFactory::getSProperty("user_id", "-1");
    
    AlkFactory::loadConstants(array($this->oAppli->cont_id, -1), array($this->oAppli->appli_id, -1), array(ALK_ATYPE_ID_LSDIF));
    
    $this->addJs("var ALK_B_LSDIF_EDITOR_LONGDESC = ".( defined("ALK_B_LSDIF_EDITOR_LONGDESC") && ALK_B_LSDIF_EDITOR_LONGDESC ? 1 : 0 ).";");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");  
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_form.js");  
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."lsdif/lib/alkhtmlformlsdifform.js");  

    $this->setLabel(( $this->msg_id->value=="-1" ? _t("Nouveau message") : _("Modifier votre message") ));

    $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->msg_idfrom);
    $oCtrlH->addDataHidden($this->msg_idreply);
    $oCtrlH->addDataHidden($this->msg_id);
    $oCtrlH->addDataHidden($this->liste_id);
    
    $this->getBlockDestinataire(false);
    $this->getBlockExpediteur($oCtrlH );
    $this->getBlockMessage($oCtrlH, false);
    $this->getButtons(false);
    
    $this->setTemplate("lsdif", "alkhtmlformlsdifform.tpl");    
   
  }
}