<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."acl/classes/alkaclmanager.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlFormParametreForm
 * Classe de gestion des paramètres pour une application
 */
class AlkHtmlFormOptionsForm extends AlkHtmlForm
{
  /**
   * constructeur par défaut
   * @param oAppli Référence sur l'appli en cours
   */
   
   protected $idAppli;
   protected $dsOptions;
   protected $strParam;
   
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formOptionsAppliForm"); 
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $strAction = "";
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
    $this->idAppli = AlkRequest::getToken("idAppli", -1);
    $cont_id = $this->oAppli->cont_id;
    $this->strParam = "cont_id=".$cont_id."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_OPTIONS.
                      "&idAppli=".$this->idAppli;
  }
  
  protected function setData($iTypeInit) {}
  
    /**
   * Traitements Sql
   */
  public function doSql(){
    $this->setData(ALK_INIT_MODE_REQUEST);
    $strUrl = "";
    switch($this->iMode){
      case ALK_FORM_MODE_ADD: // Enregistrement des options
       $options = AlkRequest::_REQUEST("option", array());
       $this->oAppli->oQueryAction->updateOptionsToAppli($this->idAppli, $options);
       $strUrl = ALK_ALKANET."?token=".AlkRequest::getEncodeParam($this->strParam);
       break;
    }
    return $strUrl;
  }
  
    /*
   * Contenu du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_REQUEST+ALK_INIT_MODE_DATAROW);
    $user_id = AlkFactory::getSProperty("user_id", -1);
    $this->setLabel(_t("Gestion des options"));
    
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    AlkFactory::setSQLParamsName();

    $this->dsOptions = $this->oAppli->oQuery->getDsOptions($this->idAppli);
    $nbElt = $this->dsOptions->getCountTotDr();
    $iNbEltParPage = $nbElt; 
    $page = ALKRequest::_GETint("page", 1);
    
    $output = array();
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
      $output = array(
            "sEcho" => AlkFactory::getSQLParamsName("sEcho", ""),
            "iTotalRecords" => $this->dsOptions->getCountTotDr(),
            "iTotalDisplayRecords" => $this->dsOptions->getCountTotDr(),
            "aaData" => array()
          );
          
    AlkFactory::emptySQLParamsName();
    
    $strUrlPagine = ALK_ALKANET."?token=".AlkRequest::getEncodeParam($this->strParam."&iMode=4");
    
    $oTabPage = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, $strUrlPagine);
    
    $oTabPage->SetColumns(array("left",   "150", "OPTION_INTITULE"),
                          array("center", "100", "OPTION_ALIAS"),
                          array("center", "150",  "OPTION_DESC"),
                          array("left", "120", "", false, false));

    $oTabPage->AddTitleRow(_t("Intitulé de l'option"), _t("Alias"), _t("Description"), _t("Actions"));
    $oTabPage->setFilter(true);
    $oTabPage->setModeAjax(true);
    
     // Lecture des données
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    $iMode = AlkRequest::getToken("iMode");
    if ($iMode==4)
      $this->readData(true, $page, $iNbEltParPage, $oTabPage, $output);
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlformoptionsform.js");
    $this->addPanel($oTabPage);
    
    // boutons de page
    $strUrl = ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($this->strParam."&iMode=".ALK_FORM_MODE_ADD);
    $this->addValidButton(array(), $strUrl);
      
    // bouton annuler
    $this->addButtonPage("bt_cancel", "javascript:closeWindow()", "Fermer", "Fermer la fenêtre");
  }
  
  private function readData($bModeAjax=false, $page, $iNbEltParPage, &$oList, &$output){
   
    $oAppiAcl = AlkFactory::getAppli(ALK_ATYPE_ID_ACL);
    while( $drOption = $this->dsOptions->getRowIter() ) {
      $option_id             = $drOption->getValueName("OPTION_ID");
      $option_alias          = $drOption->getValueName("OPTION_ALIAS");
      $option_intitule       = $drOption->getValueName("OPTION_INTITULE");
      $option_desc           = $drOption->getValueName("OPTION_DESC");
      $option_activee        = $drOption->getValueName("OPTION_ACTIVEE");
      $option_droits_avances = $drOption->getValueName("OPTION_DROITS_AVANCES");
      $option_activee        = ($option_activee=="" && $option_droits_avances==1 ? -1 : $option_activee);
      
      // bouton de gestion de droits avancés
      $strUrl = AlkAclManager::getUrlAclFormRessource($option_id, "RESSTYPE_ESPACE_OPTIONAPPLI");
      $oBtDroit = AlkHtmlFactory::getHtmlButtonForm("javascript:OpenWindow('".$strUrl."', 550, 1000)", 
                                                    _t("Gérer"), _f("Gérer les droits avancés de l'option %s", $option_intitule));
                                                    
      $oRadio = AlkHtmlFactory::getNewHtmlRadio(null, 0, "option[".$option_id."]", $option_activee, "");
      $oRadio->addRadio(0, "Désactivé globalement");
      $oRadio->addRadio(1, "Activé globalement");
      $oRadio->addRadio(-1, "Droits avancés"."&nbsp;<span style='display:".($option_activee == -1 ? "inline-block" : "none").
      "' id='div_".$option_id."'>".$oBtDroit->getHtml()."</span>");
      $oRadio->setSeparator("<br/>");
      $oRadio->addEventToRadio(-1, "onclick", "displayOptions(".$option_id.",'inline-block')");
      $oRadio->addEventToRadio(0,  "onclick", "displayOptions(".$option_id.",'none')");
      $oRadio->addEventToRadio(1,  "onclick", "displayOptions(".$option_id.",'none')");

      
      if ($bModeAjax)
        $output["aaData"][] = array($option_intitule, $option_alias, $option_desc, $oRadio->getHtml());
      else
        $oList->addRowByArray(array($option_intitule, $option_alias, $option_desc, $oRadio));
    }
    
     if ( $bModeAjax) {
      echo json_encode( $output );
      exit();
    }
  }
  
  public function getTitle() {
    return "Gestion des options de l'application";
  }
   
}