<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
/**
 * classe qui permet à l'utilisateur internet de demander son adhésion à un espace
 * @author ematcha
 *
 */
class AlkHtmlPopupAskGuestUser extends AlkHtmlForm {
  
  protected $motivation;
  protected $securecode;
  protected $cont_id;
  protected $agent_id;
  
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formGuestUser");
    
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $this->toAnim = AlkRequest::getToken("toAnim",AlkRequest::_REQUESTint("toAnim", 0)); // si mail destiné aux animateurs de l'espace    
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&iMode=".$iMode."&toAnim=".$this->toAnim);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;    
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, $strAction);
  }
  
  protected function setData($iTypeInit) 
  { 
    $this->securecode = new AlkFormData($this, "securecode", "", ALK_SQL_NONE);
    $this->motivation = new AlkFormData($this, "motivation", AlkRequest::_POST("motivation", ""), ALK_SQL_TEXT);
    $this->cont_id = new AlkFormData($this, "cont_id", AlkRequest::getToken("cont_id", -1), ALK_SQL_NUMBER);
    $this->agent_id = new AlkFormData($this, "agent_id", AlkRequest::getToken("agent_id",AlkRequest::_POSTint("agent_id", -1)), ALK_SQL_NUMBER);
  }
  
  /**
   * Retourne le titre de la fenêtre popup
   */
  public function getTitle()
  {
    return "Demande de participation à un groupe de travail";
  }
  
  /**
   * traitement
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    
    $cont_intitule = "";
    $oDsEspace = $this->oAppli->oQuery->getDs_ficheEspaceById($this->cont_id->value);
    if ( $oDrEspace = $oDsEspace->getRowIter() ) {
      $cont_intitule = $oDrEspace->getValueName("CONT_INTITULE");
      
      setMailAlkLocale(ALK_MAIL_ADMIN_LG);
      $oAlkMail = AlkFactory::getMail();
      
      // envoi de mail aux animateurs pour l'inscription avec le lien token
      // infos de l'agent à inviter dans l'espace
      $dsAgent = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU)->getDs_ficheAgent($this->agent_id->value);
  
      if($drAgent = $dsAgent->getRowIter()){
        $agent_nom = $drAgent->getValueName("AGENT_NOM");
        $agent_prenom = $drAgent->getValueName("AGENT_PRENOM");
        $agent_mail = $drAgent->getValueName("AGENT_MAIL");
        $agent_service = $drAgent->getValueName("SERVICE_INTITULE");
        $agent_desc = $drAgent->getValueName("AGENT_DESC");
      
        // lien invitation     
        $strParam = "cont_id=".$this->cont_id->value."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER.
          "&iSSheet=".ALK_SHEET_NONE."&mailGuest=".$agent_mail."&ask=1&key=";
        $token = AlkRequest::getEncodeParam($strParam.md5($strParam)) ;
        $urlToken = ALK_ALKANET_SQL."?token=".$token;
        
        // mail à envoyer aux animateurs de l'espace
        if($this->toAnim == 1){
          $dsAnimByEspace = $this->oAppli->oQuery->getDs_listeAnimateurByEspaceForCombo($this->cont_id->value);
          while($drAnimByEspace = $dsAnimByEspace->getRowIter()){
            $oAlkMail->AddTo($drAnimByEspace->getValueName("prenom_nom"), $drAnimByEspace->getValueName("mail"));
          }
        }
        
        $strType = "ESPACE_DEMANDE_INVITATION";
        $oAlkMail->SetFrom($agent_prenom." ".$agent_nom, $agent_mail);
        $oAlkMail->AddTo(ALK_APP_TITLE, ALK_MAIL_ADMIN_MAIL);
        
        $bIsCollabSpace = $this->oAppli->oQuery->Is_CollabSpace($this->cont_id->value);
  
        $tabAssoc["msgTitle"] = ($bIsCollabSpace ? _f("Invitation au groupe de travail %s", html_entity_decode($cont_intitule)) : _f("Invitation à l'outil d'administration de l'espace '%s'", html_entity_decode($cont_intitule)) );
        $tabAssoc["dest"] = ($bIsCollabSpace ? "Animateur du groupe de travail" : "Animateur de l'espace");
        $tabAssoc["msg"] = ($bIsCollabSpace ? _f("J'ai effectué une demande de participation au groupe de travail - %s - le %s à %s.", 
                              $cont_intitule, date("d/m/Y"), date("H:i")) : _f("J'ai effectué une demande de participation à l'outil d'administration de l'espace - %s - le %s à %s.", 
                              $cont_intitule, date("d/m/Y"), date("H:i"))).'<br/>'.
          _t("Il est maintenant nécessaire de la valider.").'<br/>'.
          _t("Mes paramètres sont les suivants :").
          '<ul>'.
          '<li>'._f("Nom : %s", $agent_nom).'</li>'.
          '<li>'._f("Prénom : %s", $agent_prenom).'</li>'.
          '<li>'._f("Courriel : %s", $agent_mail).'</li>'.
          '<li>'._f("Service : %s", $agent_service).'</li>'.
          '<li>'._f("Commentaire : %s", $agent_desc).'</li>'.
          '<li>'._f("Motivation : %s", $this->motivation->value).'</li>'.
          '</ul>'.
          ($bIsCollabSpace ? _f("Pour valider la participation au groupe de travail, merci de cliquer sur %sce lien%s.", 
             '<a href="'.$urlToken .'">', '</a>') : _f("Pour valider la participation à l'outil d'administration de l'espace, merci de cliquer sur %sce lien%s.", 
             '<a href="'.$urlToken .'">', '</a>')).'<br/>';
        
        // informations annexe pour la personnalisation
        $tabAssoc["cont_intitule"]    = $cont_intitule;
        $tabAssoc["lien"]             = $urlToken;
        $tabAssoc["agent_nom"]        = $agent_nom;
        $tabAssoc["agent_nom"]        = $agent_prenom;
        $tabAssoc["agent_mail"]       = $agent_mail;
        $tabAssoc["agent_desc"]       = $agent_desc;
        $tabAssoc["service_intitule"] = $agent_service;
        $tabAssoc["agent_motivation"] = $this->motivation->value;
  
        AlkMailing::SendMailType($oAlkMail, $strType, $tabAssoc);
        $ok = 1;
      } else {    
        $ok = -1;
      }
    } else {
      $ok = -2;
    }
    setCurrentAlkLocale();
    
    $strToken = $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, $this->iSSheet, "&ok=".$ok);
    return ALK_ALKANET."?token=".$strToken;
  }
   
  public function setContents()
  {    
    $this->setData(ALK_INIT_MODE_DATAROW);
    $oBlock = $this->addBlock("block_1", "", "", 75, 300, true);
    
    $ok = AlkRequest::getToken("ok", 0);
    
    if ($ok==1){
      $html = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>".
        "Votre demande a bien été envoyée. Vous recevrez prochainement un mail vous informant de votre adhésion.</div>";
      $oHtml = AlkHtmlFactory::getHtml($html);
      $oBlock->addCtrl($oHtml);
      $this->addButtonPage("cancel", "javascript:closeWindow()", "Fermer", "Fermer la fenêtre");
    } else if ($ok==-1){
      $html = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>".
        "Vous n'êtes pas encore inscrits dans l'annuaire. Merci de procéder tout d'abord à une inscription.</div>";
      $oHtml = AlkHtmlFactory::getHtml($html);
      $oBlock->addCtrl($oHtml);
      $this->addButtonPage("cancel", "javascript:closeWindow()", "Fermer", "Fermer la fenêtre");
    } else if ($ok==-2){
      $html = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>".
        "Votre demande a échoué car le groupe de travail n'existe pas ou a été supprimé.</div>";
      $oHtml = AlkHtmlFactory::getHtml($html);
      $oBlock->addCtrl($oHtml);
      $this->addButtonPage("cancel", "javascript:closeWindow()", "Fermer", "Fermer la fenêtre");
    } else {
      $oHidden = AlkHtmlFactory::getHtmlHidden($this->agent_id);
      
      $html = "<div style='margin-right:auto; margin-left:auto; text-align:center;'>".
        "Vous souhaitez participer à ce groupe de travail. Vous pouvez ajouter un commentaire précisant vos motivations.</div>";
      $oHtml = AlkHtmlFactory::getHtml($html);
      $oBlock->addCtrl($oHtml);
      
      $oMotovationGuest = AlkHtmlFactory::getHtmlText($this->motivation,"Ajouter un commentaire",5,60,255);
      $oMotovationGuest->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
      $oBlock->addCtrl($oMotovationGuest);
      
      $oCtrlSecure = null;
      if ( !(defined("ALK_B_SECURE_MODE") && ALK_B_SECURE_MODE==false) ){
        $oCtrlSecure = AlkHtmlFactory::getHtmlText($this->securecode, "Code de sécurité", 1, 6, 6);
        $oCtrlSecure->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
        $oCtrlSecureImg = AlkHtmlFactory::getHtml("<a title='Un autre code' href=\"javascript:loadSecureImg('sImg".$oCtrlSecure->getGUID()."')\"><image id='sImg".$oCtrlSecure->getGUID()."' src='".ALK_ALKANET_CAPTCHA."' height='25' border='0'></a>");
        $oCtrlSecure->addCtrl($oCtrlSecureImg);
      }
      $oBlock->addCtrl($oCtrlSecure);
          
      $this->addValidButton("", "", "Valider", "Valider");
      $this->addButtonPage("cancel", "javascript:closeWindow()", "Annuler", "Fermer la fenêtre");
    }    
      
  }
}
