<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlPopupCreateUser
 * Classe de creation d'une connexion'
 */
class AlkHtmlPopupCreateUser extends AlkHtmlForm
{
  protected $err; 
  protected $bEnvoi; 
  protected $strNom; 
  protected $strPrenom;
  protected $strMail;
  protected $strLocale;
  protected $strTel;
  protected $idServ;
  protected $idServNiv2;
  protected $strServ;
  protected $strDesc;
  protected $securecode;   
  protected $bInscriptionInt;  
  
  /**
   * Constructeur par défaut
   * @param oAppli Référence sur l'application courante
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formLog");
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $strToken = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                           "&iSheet=".ALK_SHEET_CREATEUSER."&iSSheet=".ALK_SHEET_NONE);
    $strAction = ALK_ALKANET."?token=".$strToken;
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }

  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  public function setData($iTypeInit)
  {
    
    $err = AlkRequest::getToken("err", AlkRequest::_REQUESTint("err", ""));
    $mailGuest = AlkRequest::getToken("mailGuest","");
    $service_interne = AlkRequest::_REQUEST("service_interne", "-1"); // cas où on passe par l'inscription intermédaire
    $this->bInscriptionInt = AlkRequest::_REQUESTint("bInscriptionInt", 0);
    
    $this->bEnvoi     = new AlkFormData($this, "bEnvoi", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->strNom     = new AlkFormData($this, "strNom", "", ALK_SQL_TEXT);
    $this->strPrenom  = new AlkFormData($this, "strPrenom", "", ALK_SQL_TEXT);
    $this->strMail    = new AlkFormData($this, "strMail", $mailGuest, ALK_SQL_TEXT);
    $this->strLocale  = new AlkFormData($this, "strLocale", $GLOBALS["tabLocales"]["backoffice"][0], ALK_SQL_TEXT);
    $this->strTel     = new AlkFormData($this, "strTel", "", ALK_SQL_TEXT);
    $this->idServ     = new AlkFormData($this, "idServ", $service_interne, ALK_SQL_NUMBER);
    $this->idServNiv2 = new AlkFormData($this, "idServNiv2", "", ALK_SQL_NUMBER);
    $this->strServ    = new AlkFormData($this, "strServ", "", ALK_SQL_TEXT);
    $this->strDesc    = new AlkFormData($this, "strDesc", "", ALK_SQL_TEXT);     
    $this->err        = new AlkFormData($this, "err", $err); // si err=" mot de passe oublié si err=1 demande inscription    
    $this->securecode = new AlkFormData($this, "securecode", "", ALK_SQL_NONE);
       
    $reqMethod = REQ_POST_GET;
    $this->initData(ALK_INIT_MODE_REQUEST, null, $reqMethod);  	
  }
  
  /**
   * Traitement du formulaire
   */
  public function doSql() { 

  
    $this->setData(ALK_INIT_MODE_DEFAULT);  	
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");

    switch( $this->iMode ) {
    
      case 10: // modification filiation par ajax

      $idServ = AlkRequest::_GETint("idServ", "-1");
      $strJsHtml = " var tabOptionsServ = new Array();";
      $strJsHtml .= " tabOptionsServ[1] = '';";
      $this->oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
     
      $dsServ = $this->oAppliAnnu->oQuery->getDsListeServiceForCombo(2, $idServ, true, 55, "");           
      $nbElt = $dsServ->getCountTotDr();
      $strJsHtml .= " tabOptionsServ[1] = new Array();";

      if($nbElt == 0){
        $strJsHtml .= " tabOptionsServ[1][0] = new Array('-1', '"._t("Auncune structure")."');";      
      }elseif( $nbElt > 0 ) {
        $strJsHtml .= " tabOptionsServ[1][0] = new Array('-1', '"._t("Sélectionnez une structure")."');";
        while( $drServ = $dsServ->getRowIter() ) {
          $idServ  = $drServ->getValueNum(1);
          $strServ = $drServ->getValueNum(0);
          $strServ = addslashes(mb_ereg_replace('"', '', $strServ));
          $strJsHtml .= " tabOptionsServ[1][tabOptionsServ[1].length] = new Array('".$idServ."', '".$strServ."');";
        }
      } 
      $strJsHtml .= " var strUrl = '';";

      // retour : code js du tableau pour le niveau de service
      echo $strJsHtml;
      break;  

    }  
  }
  
  /**
   * retourne le titre / surcharge car pour les popup le gethtml est appelé après
   * @return string 
   */
  public function getTitle()
  {
    $err = AlkRequest::getToken("err", AlkRequest::_REQUESTint("err", "0"));

    $bNewCpt = ( $err != 0 ? true : false );
    $strTitle = ( $bNewCpt ? _t("Demande d'accès") : _t("Paramètres de connexion oubliés") );	
    $this->setTitle($strTitle);
    return $strTitle;
  }  
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_DEFAULT);

    $bNewCpt = ( $this->err->value != 0 ? true : false );
    $bEnvoi = $this->bEnvoi->value;
    $iLarg = 500;
    $strHtml = "";

    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $oQueryAnnuAction = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);

    if( $bEnvoi == 1 ) {
      // $bEnvoi = 1 après validation du formulaire de demande inscription ou mot de passe oublié 
         
      if( $this->err->value==0 ) {
      	// cas de demande mot de passe oublié (err=0)   
        // interrogation de la base SIT 
        $dsAgent = $oQueryAnnu->GetDsAgentByNomPrenomMail($this->strNom->value, $this->strPrenom->value, $this->strMail->value);  
        if( $drAgent = $dsAgent->getRowIter() ) {
          // si trouvé dans SIT
          $agent_id        = $drAgent->getValueName("AGENT_ID");
          $agent_login     = $drAgent->getValueName("AGENT_LOGIN");
          $agent_mail      = $drAgent->getValueName("AGENT_MAIL");
          $agent_civilite  = $drAgent->getValueName("AGENT_CIVILITE");
          $agent_nom       = $drAgent->getValueName("AGENT_NOM");
          $agent_prenom    = $drAgent->getValueName("AGENT_PRENOM");
          $agent_login     = $drAgent->getValueName("AGENT_LOGIN");
          $agent_valide    = $drAgent->getValueName("AGENT_VALIDE");
          $agent_lg        = $drAgent->getValueName("AGENT_LG");
          $agent_pwd_clair = $oQueryAnnuAction->getStrGeneratedPwd();
          $agent_pwd       = AlkFactory::encrypt($agent_pwd_clair);
          if( $agent_valide == "1" ) {          
            $oQueryAnnuAction->updateUserPwd($agent_id, $agent_pwd);

            
            $strHtml ="<div class='txtNormal' align='center'>".
               _f("Votre demande a été traitée.%nlVous recevrez dans quelques instants par courriel%nlvos paramètres de connexion pour %s.",
                  "<br/>", "<br/>", "<b>".ALK_APP_TITLE."</b>").
               "</div>";         

            // envoi nouveau pwd à l'agent
            $this->SendMailDemandeAccesToAgent(1, $agent_nom, $agent_prenom, $agent_mail, $agent_login, 
                                               $agent_pwd_clair, "", "", "", $agent_lg);

          } elseif( $agent_valide == "-2" ) {
            $strHtml ="<div class='txtNormal' align='center'>".
               _f("Votre demande est en cours de traitement.%nlVous recevrez prochainement par courriel vos paramètres de connexion pour %s.",
                  "<br/>", "<b>".ALK_APP_TITLE.".</b>").
               "</div>";
            
            // envoi d'un mail aux admins généraux pour valider la fiche
            $this->SendMailDemandeAccesToAgent(2, $this->strNom->value, $this->strPrenom->value, $this->strMail->value, 
                                               "", "", "", "", "", $agent_lg);
          } else {
            $strHtml ="<div class='txtNormal' align='center'>".
               _f("Votre compte avait été désactivé. Une demande de réactivation a été envoyée aux administrateurs.%nlVous recevrez prochainement par courriel vos paramètres de connexion pour %s.",
                  "<br/>", "<b>".ALK_APP_TITLE.".</b>").
               "</div>";
               
            // envoi d'un mail aux admins généraux pour réactiver la fiche 
            $this->SendMailDemandeAccesToAgent(3, $this->strNom->value, $this->strPrenom->value, $this->strMail->value, 
                                               "", "", "", "", "", $agent_lg);
          }
        } 
        else { 
          // mot de passe oublié non trouvé
          $strTokenSaisie = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                       "&iSheet=".ALK_SHEET_CREATEUSER."&iSSheet=".ALK_SHEET_NONE."&err=0");
          $strTokenInscritpion = AlkRequest::getEncodeParam("cont_id=1&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                            "&iSheet=".ALK_SHEET_CREATEUSER."&iSSheet=".ALK_SHEET_NONE."&err=1");
          $strHtml ="<div class='txtWarning' align='center'>".
            _f("Vos paramètres n'ont pas permis%nlde vous identifier sur %s.",
               "<br/>", "<b>".ALK_APP_TITLE."</b>").
            "</div>".
            "<br/>".
            "<div class='txtNormal' align='center'>"._t("Que souhaitez-vous faire ?")."<br/><br/>".
            "<a title='"._t("Recommencer la saisie")."'href='".ALK_ALKANET."?token=".$strTokenSaisie."'>"._t("Recommencer la saisie")."</a> ou ".
            "<a title='"._t("effectuer une demande de compte.")."' href='".ALK_ALKANET."?token=".$strTokenInscritpion."'>"._t("effectuer une demande de compte.")."</a></div>";
        }
      }          
      else { //$this->err->value==1 
    
        // cas demande ouverture de compte
        // on vérifie que le compte n'existe pas
        $dsAgent = $oQueryAnnu->GetDsAgentByNomPrenomMail($this->strNom->value, $this->strPrenom->value, $this->strMail->value);  
        
        if ($drAgent = $dsAgent->getRowIter()){
          // si trouvé dans SIT
          $agent_id        = $drAgent->getValueName("AGENT_ID");
          $agent_login     = $drAgent->getValueName("AGENT_LOGIN");
          $agent_mail      = $drAgent->getValueName("AGENT_MAIL");
          $agent_civilite  = $drAgent->getValueName("AGENT_CIVILITE");
          $agent_nom       = $drAgent->getValueName("AGENT_NOM");
          $agent_prenom    = $drAgent->getValueName("AGENT_PRENOM");
          $agent_login     = $drAgent->getValueName("AGENT_LOGIN");
          $agent_lg        = $drAgent->getValueName("AGENT_LG");
          $agent_valide    = $drAgent->getValueName("AGENT_VALIDE");
          $agent_pwd_clair = $oQueryAnnuAction->getStrGeneratedPwd();
          $agent_pwd       = AlkFactory::encrypt($agent_pwd_clair);
          if( $agent_valide == "1" ) {
            $oQueryAnnuAction->updateUserPwd($agent_id, $agent_pwd);
            
            $strHtml ="<div class='txtNormal' align='center'>".
              _f("Vous recevrez dans quelques instants par courriel%nlvos paramètres de connexion pour %s.",
                 "<br/>", "<b>".ALK_APP_TITLE."</b>").
              "</div>";         

            // envoi pwd à l'agent par mail 
            $this->SendMailDemandeAccesToAgent(6, $agent_nom, $agent_prenom, $agent_mail, $agent_login, 
                                               $agent_pwd_clair, "", "", "", $agent_lg);
          } elseif( $agent_valide == "-2" ) {
            $strHtml ="<div class='txtNormal' align='center'>".
              _f("Votre demande est en cours de traitement.%nlVous recevrez prochainement par courriel vos paramètres de connexion pour %s.",
                 "<br/>", "<b>".ALK_APP_TITLE."</b>").
              "</div>";

            // envoi d'un mail aux admins généraux pour valider la fiche           
            $this->SendMailDemandeAccesToAgent(2, $this->strNom->value, $this->strPrenom->value, $this->strMail->value, 
                                               "", "", "", "", "", $this->strLocale->value);
          } else {
            $strHtml ="<div class='txtNormal' align='center'>".
              _f("Votre compte est désactivé.%nlUne demande de réactivation a été envoyée aux administrateurs.%nlVous recevrez prochainement par courriel vos paramètres de connexion pour %s.",
                 "<br/>", "<br/>", "<b>".ALK_APP_TITLE."</b>").
              "</div>";

            // envoi d'un mail aux admins généraux pour réactiver la fiche 
            $this->SendMailDemandeAccesToAgent(3, $this->strNom->value, $this->strPrenom->value, $this->strMail->value, 
                                               "", "", "", "", "", $this->strLocale->value);
          }
        }        
        else if( ALK_LDAP == true ) {
          // on recherche le compte dans la base ldap avec l'adresse mail
        	$bCptLdap = false;
          $dsCptLdap = $oQueryAnnu->getDsLdapUserInfo($this->strMail->value);
          if( $drCptLdap = $dsCptLdap->getRowIter() ) {
            $bCptLdap = true;
            
            // création du compte avec agent_valide=-2 à partir des données ldap 
            $agent_id = $this->addUser($drCptLdap);

            $strHtml ="<div class='txtNormal' align='center'>".
              _f("Votre demande de création de compte a été transmise aux administrateurs.%nlVous recevrez prochainement par courriel vos paramètres de connexion pour %s.",
                 "<br/>", "<b>".ALK_APP_TITLE."</b>").
              "</div>";
            
            // envoi d'un mail à la personne 
            $this->SendMailDemandeAccesToAgent(4, $this->strNom->value, $this->strPrenom->value, $this->strMail->value, 
                                               "", "", $this->strTel->value, $this->strDesc->value, $this->strServ->value,
                                               $this->strLocale->value);

            // envoi d'un mail aux admins généraux pour valider la fiche
            $this->strDesc->value .= _t(" Note automatique :")." ". 
              ( $agent_id == "-1" 
                ? _t("Le compte n'a pas pu être créé dans l'annuaire. Vous devez la créer.")
                : _t("Le compte a été créé dans l'annuaire en attente de validation.") );
            
            // envoi d'un mail aux admins généraux pour valider la fiche 
            $this->SendMailDemandeAccesToAgent(5, $this->strNom->value, $this->strPrenom->value, $this->strMail->value, 
                                               "", "", $this->strTel->value, $this->strDesc->value, $this->strServ->value,
                                               $this->strLocale->value);
          }
          else {        	
            $this->err->value = 2;
          }
        } else {
          $this->err->value = 2;
        }
      }
      
      if( $this->err->value == 2 ) {
        $this->err->value = 1;
        $strFileCharte = ""; 
        //création de la structure
        $bCompteServiceCree = false;
        if($this->idServ->value==-1){
        	$strFileCharte = DoUpload("service_charte", $this->strServ->value."_", AlkFactory::getUploadPath(ALK_ATYPE_ID_ESPACE,true)."/", 0, "");
          $dsServices = $oQueryAnnu->GetDs_listeAllServiceForCombo();
          $bExistService = false;
          //vérifie la non existence de la structure à partir de l'intitule, si oui affectation à celle-ci
          while($drServices = $dsServices->getRowIter()){  
            $service_intitule = $drServices->getValueName("SERVICE_INTITULE");
          	if($this->strServ->value==$service_intitule){
          		$bExistService = true;
          		$this->idServ->value = $drServices->getValueName("SERVICE_ID");
          		break;
          	}
          }
          //création du service utilisateur avec serv_valid=-2 en niveau 1
          if(!$bExistService){
            $this->idServ->value = $this->addServ();
            $bCompteServiceCree = true;
          }
        }
        // création du compte avec agent_valide=-2 à partir des données saisies 
        $agent_id = $this->addUser(null);
        
        $strHtml ="<div class='txtNormal' align='center'>".
           _f("Votre demande de création de compte a été transmise aux administrateurs.%nlVous recevrez prochainement par courriel vos paramètres de connexion pour %s.",
              "<br/>", "<b>".ALK_APP_TITLE."</b>").
           "</div>";
  
        // envoi d'un mail à la personne 
        $this->SendMailDemandeAccesToAgent(4, $this->strNom->value, $this->strPrenom->value, $this->strMail->value,
                                           "", "", $this->strTel->value, $this->strDesc->value, $this->strServ->value,
                                           $this->strLocale->value);
              
        // envoi d'un mail aux admins généraux pour valider la fiche
        $this->strDesc->value .= "<p> "._t("Note automatique :")." ". 
          ( $agent_id == "-1" 
            ? _t("Le compte n'a pas pu être créé dans l'annuaire. Vous devez la créer.")
            : _t("Le compte a été créé dans l'annuaire en attente de validation.") ).
          "</p>";
        if ($bCompteServiceCree)
          $this->strDesc->value .= "<p> "._t("Note automatique :"). _t("Le service a été créé dans l'annuaire en attente d'activation.")."</p>" ;
 
        $this->SendMailDemandeAccesToAgent(5, $this->strNom->value, $this->strPrenom->value, $this->strMail->value,
                                           "", "", $this->strTel->value, $this->strDesc->value, $this->strServ->value,
                                           $this->strLocale->value, AlkFactory::getUploadPath(ALK_ATYPE_ID_ESPACE), $strFileCharte);
 
        // le compte maia n'existe pas
        $strHtml ="<div class='txtNormal' align='center'>".
          _f("Votre demande de création de compte a été transmise aux administrateurs.%nlVous recevrez prochainement par courriel vos paramètres de connexion pour %s.",
             "<br/>", "<b>".ALK_APP_TITLE."</b>").
          "</div>";
      }
            
      if( $bEnvoi == 1 ) {
        $oBtFermer = $this->addButtonPage("Bt_fermer", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));  
        $oCtrlText = AlkHtmlFactory::getHtml($strHtml);
        $oBlockText = $this->addBlock("block_txt", "", "", "10", "420");
        $oBlockText->addCtrl($oCtrlText, ALK_HTMLFORM_1L1C);
      }
   
    } 
    else { //bEnvoi == 0
    
      // on vérifie qu'on vient du lien InviteEspace
      $inviteEspace = AlkRequest::getToken("invit",-1);
      
      $oBlockProp = $this->addBlock("block_1", "", "", "100", "300");
      
      if( $inviteEspace==0 ) {
        $texte = _t("Après création et validation de votre compte, vous pouvez à nouveau vous inviter dans l'espace.");
        $oTexte = AlkHtmlFactory::getHtml($texte); 
      }
      
      /** affichage du formulaire */
      if( $strHtml != "" ) {
        $this->setLabelDesc($strHtml);
      } else {
        $strMess = ( $this->err->value==0 
                     ? _t("Vous avez oublié votre mot de passe, merci d'indiquer ci-dessous votre identité.")
                     : _t("Vous souhaitez obtenir un accès, merci d'indiquer ci-dessous votre identité." ) );
        
        if( $this->err->value == 1 &&
            defined("ALK_B_INSCRIPTION_SERVICE") && ALK_B_INSCRIPTION_SERVICE==true && $this->bInscriptionInt==0 ) {
          $strMess = _t("Vous souhaitez obtenir un accès, merci de sélectionner ci-dessous votre organisme.");
          $strMessFile = @file_get_contents(ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."mode_emploi_intro.txt");
          if( $strMessFile != "" ) {
            $strMess = $strMessFile; 
          }
        }
        
        $this->setLabelDesc("<div class='txtNormal' align='center'>".$strMess."<br/>");
      }
      
      if( isset($oTexte) ) {
        $oBlockProp->addCtrl($oTexte);
      }

      $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->bEnvoi);
      $oCtrlH->addDataHidden($this->err);
      $oCtrlH->addDataHidden($this->strServ);
      
      if( $this->err->value == 1 &&
          defined("ALK_B_INSCRIPTION_SERVICE") && ALK_B_INSCRIPTION_SERVICE==true && $this->bInscriptionInt==0 ) {
       
       // 1ere étape        
        $oCtrlServiceInscript = AlkHtmlFactory::getNewHtmlSelect($this, "0", "service_interne", "-1", _t("Organisme"), "1", "295");
        $dsServNivInt = $oQueryAnnu->getDsListeServiceForCombo("1", "-1", true, 55, 1);
        $oCtrlServiceInscript->setProperty("tabValTxtDefault", array("-1", _t("Sélectionner un organisme")));
        $oCtrlServiceInscript->setProperty("oValTxt", $dsServNivInt);
        $oCtrlServiceInscript->setProperty("tabValTxtLast", array("-2", _t("Autre")));
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_CREATEUSER, ALK_SHEET_NONE);
        $oCtrlServiceInscript->addEvent("onchange", "DisplayCharte('".$strToken."',this)");
        $oCtrlServiceInscript->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, "-1");
        $oBlockProp->addCtrl($oCtrlServiceInscript);
        // div
        // message charte ...   
        
        // test sur la charte
        $strPath = ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."charte_adhesion.";
        $fileext ="";
        $strHtml = "";
        
        /*$tabExt = array("pdf", "doc", "odt");
        
        foreach($tabExt as $ext){
          if(@file_get_contents($strPath.$ext) != "")
            $fileext = $ext;
        } 
        
        if (in_array($fileext, $tabExt)){
          $strHtml = "<p style='text-align:justify;'></p>";
        }*/
        
        
        // un champ caché pour signifier le relaod
        $oHide = AlkHtmlFactory::getNewHtmlHidden($this, "bInscriptionInt", "1");
        $oBlockProp->addCtrl($oHide);
        
      } else {
        // on fait comme d'habitude
        $oCtrlNom = AlkHtmlFactory::getHtmlText($this->strNom, _t("Nom"), 1, 40, 100);
        $oCtrlNom->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);

        $oCtrlPrenom =  AlkHtmlFactory::getHtmlText($this->strPrenom, _t("Prénom"), 1, 40, 40);
        $oCtrlPrenom->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);

        $oCtrlMail =  AlkHtmlFactory::getHtmlText($this->strMail, _t("Courriel"), 1, 40, 255);
        $oCtrlMail->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_MAIL);

        if( count($GLOBALS["tabStrLocales"]) > 1 ) {
          $oCtrlLg = AlkHtmlFactory::getHtmlSelect($this->strLocale, _t("Langue - Pays"),  1, 295);
          $oCtrlLg->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, "-1");    
          //$oCtrlLg->setProperty("tabValTxtDefault", array("", ""));                                  
          $oCtrlLg->setProperty("tabValTxt", $GLOBALS["tabStrLocales"]);
        } else {
          $tabLocales = array_keys($GLOBALS["tabStrLocales"]);
          $this->strLocale->value = $tabLocales[0]; 
          $oCtrlLg = AlkHtmlFactory::getHtmlHidden($this->strLocale);
        }
              
        if( $this->err->value == 1 ) { 
          //cas du formulaire complet
          $oCtrlTel =  AlkHtmlFactory::getHtmlText($this->strTel, _t("Téléphone"), 1, 40, 30);
          $oCtrlTel->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXTNUM);
            
          //cas structure autre
          if($this->idServ->value==-2){
          	
          	
		        $mode_emploi = @file_get_contents(ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."mode_emploi.txt");
		        if ($mode_emploi != ""){
		          $strHtml.= "<p style='text-align:justify;'>".$mode_emploi."</p>";
		          $oHtml = AlkHtmlFactory::getHtml("<div style='margin-left:20px;margin-right:10px;text-align:justify' id='div_charte'>".
		          $strHtml.
		          "</div>");
		          $oBlockProp->addCtrl($oHtml, ALK_HTMLFORM_1L1C);
		        }
		       
          	$oCtrlServ = AlkHtmlFactory::getHtmlText($this->strServ,( defined("ALK_B_INSCRIPTION_SERV_NIV2") && ALK_B_INSCRIPTION_SERV_NIV2  ?  "Organisme" : "Structure"), 1, 40, 30);
          	$oCtrlServ->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
          	$oCtrlCharte = AlkHtmlFactory::getNewHtmlFile($this, "0", "service_charte","",  _t("Charte d'adhésion signée"), 20, 255);
          	$oCtrlCharte->setProperty("urlFile", ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."espace/");
            $oCtrlCharte->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
          }else{
	          $oCtrlServ =  AlkHtmlFactory::getHtmlSelect($this->idServ, ( defined("ALK_B_INSCRIPTION_SERV_NIV2") && ALK_B_INSCRIPTION_SERV_NIV2  ?  "Organisme" : "Structure"), 1, 295);
	          if( defined("ALK_B_INSCRIPTION_SERVICE") && ALK_B_INSCRIPTION_SERVICE==true ) {
	            $dsServ = $oQueryAnnu->getDsListeServiceForCombo("1", "-1", true, 55, 1);
	          } else {
	            $dsServ = $oQueryAnnu->getDsListeServiceForCombo("1");
	          }
	          $oCtrlServ->setProperty("tabValTxtDefault", array("-1", ( defined("ALK_B_INSCRIPTION_SERV_NIV2") && ALK_B_INSCRIPTION_SERV_NIV2  ? _t("Sélectionnez un organisme") : _t("Sélectionnez une structure"))));
	          $oCtrlServ->setProperty("oValTxt", $dsServ);
	          $oCtrlServ->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_SELECT, "-1");
	   
	          if( defined("ALK_B_INSCRIPTION_SERV_NIV2") && ALK_B_INSCRIPTION_SERV_NIV2 ){ // modif pour le SI17
	            $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_CREATEUSER, ALK_SHEET_NONE, "&err=".$this->err->value."&iMode=10");
	            $oCtrlServ->AddEvent("onChange", "ChangeService('".$strToken."', 0)");
	            ($this->idServ->value == "" ? $this->idServ->value=-1 : $this->idServ->value);
	            $oCtrlServNiv2 =  AlkHtmlFactory::getHtmlSelect($this->idServNiv2, _t("Structure"), 1, 295);
	            $dsServNiv2 = $oQueryAnnu->getDsListeServiceForCombo("2", $this->idServ->value);
	            $oCtrlServNiv2->setProperty("tabValTxtDefault", array("-1", _t("Sélectionner une structure")));
	            $oCtrlServNiv2->setProperty("oValTxt", $dsServNiv2);
	            if($this->idServ->value != -1){
	              $oCtrlServNiv2->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_SELECT, "-1");
	            }
	          }
          }	        
          $oCtrlDesc =  AlkHtmlFactory::getHtmlText($this->strDesc, _t("Commentaires"), 2, 38, 4000);
          $oCtrlDesc->AddValidator(ALK_IS_REQUIRED+ALK_VERIF_MEMO);
        }
      
        $oCtrlSecure = null;
        if ( !(defined("ALK_B_SECURE_MODE") && ALK_B_SECURE_MODE==false) ){
          $oCtrlSecure = AlkHtmlFactory::getHtmlText($this->securecode, _t("Code de sécurité"), 1, 6, 6);
          $oCtrlSecure->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
          $oCtrlSecureImg = AlkHtmlFactory::getHtml("<a title=\""._t("Un autre code")."\" href=\"javascript:loadSecureImg('sImg".$oCtrlSecure->getGUID()."')\"><image id='sImg".$oCtrlSecure->getGUID()."' src='".ALK_ALKANET_CAPTCHA."' height='25' border='0'></a>");
          $oCtrlSecure->addCtrl($oCtrlSecureImg);
        }
      
        $oBlockProp->addCtrl($oCtrlNom);
        $oBlockProp->addCtrl($oCtrlPrenom);
        $oBlockProp->addCtrl($oCtrlMail);
        $oBlockProp->addCtrl($oCtrlLg);

        if( $this->err->value == 1 ) { 
          $oBlockProp->addCtrl($oCtrlTel); 
          $oBlockProp->addCtrl($oCtrlServ); 
          if( defined("ALK_B_INSCRIPTION_SERV_NIV2") && ALK_B_INSCRIPTION_SERV_NIV2 ){
            $oBlockProp->addCtrl($oCtrlServNiv2); 
          }
          $oBlockProp->addCtrl($oCtrlDesc);                      
        }
        $oBlockProp->addCtrl($oCtrlSecure);
      }
        
      // ajout acceptation des conditions d'utilisations
      if( defined("ALK_B_INSCRIPTION_SERVICE") && ALK_B_INSCRIPTION_SERVICE==true && $this->bInscriptionInt==1 ) {
        
        $regles = @file_get_contents(ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."regles.txt");
        if(isset($oCtrlCharte))
          $oBlockProp->addCtrl($oCtrlCharte);          
        if ($regles != ""){
          $strHtml= "<p text-align='justify'>".$regles."</p>";
        
          $oHtml = AlkHtmlFactory::getHtml("<div style='overflow:auto; height:100px;border:1px solid;margin-left:10px; padding:2px;'>".$strHtml."</div>");
          $oBlockProp->addCtrl($oHtml, ALK_HTMLFORM_1L1C);
        }
        $oCheckLu = AlkHtmlFactory::getNewHtmlCheckbox($this, "0", "chk_condLu", 0, "");
        $oCheckAc = AlkHtmlFactory::getNewHtmlCheckbox($this, "0", "chk_condAc", 0, "");
        $oCheckLu->setLabelAfter(_t("J'ai lu les règles de fonctionnement du portail"));
        $oCheckAc->setLabelAfter(_t("j'accepte les règles de fonctionnement du portail"));
        $oBlockProp->addCtrl($oCheckLu);
        $oBlockProp->addCtrl($oCheckAc);
      }

      $this->addOnload("onLoadWindAuth()");
        
      if( $this->err->value == 0 || !(defined("ALK_B_INSCRIPTION_SERVICE") && ALK_B_INSCRIPTION_SERVICE==true ) || $this->bInscriptionInt==1 ) {
        $oBtVal = $this->addButtonPage("BtVal", "javascript:Valider();", _t("Valider"), _t("Valider"));
        $this->addSubmitButton($oBtVal); 
      }  
      
      $strBut = _t("Annuler");
      if( $this->err->value == 1 && defined("ALK_B_INSCRIPTION_SERVICE") && ALK_B_INSCRIPTION_SERVICE==true && $this->bInscriptionInt==0 ) {
        $strBut = _t("Fermer");
      }
      
      $oBtAnnuler = $this->addButtonPage("BtAnnuler", "javascript:closeWindow()", $strBut, _t("Annuler votre demande"));
    }

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupcreateuser.js");
  }
  
  /**
   * Ajout d'un utilisateur dans l'annuaire
   * Retourne l'id de l'agent ajouté, -1 sinon
   * @param drLdap         datarow de la fiche ldap éventuellement trouvée, null sinon
   * @param agent_valide   type de validité de compte, =2 par défaut
   * @return int
   */
  private function addUser($drLdap, $agent_valide="-2")
  {
    $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $tabAssoc = unserialize(ALK_LDAP_ASSOC_ANNU);
    
    $tabQuery = array();
    $tabQuery["AGENT_CIVILITE"] = array(ALK_SQL_TEXT,   "");
    $tabQuery["AGENT_PRIV"]     = array(ALK_SQL_NUMBER, "0");
    $tabQuery["AGENT_VALIDE"]   = array(ALK_SQL_NUMBER, $agent_valide);
    $tabQuery["PROFIL_ID"]      = array(ALK_SQL_NUMBER, "1");
    $tabQuery["AGENT_DESC"]      = array(ALK_SQL_TEXT, $this->strDesc->value);
    
    if( !is_null($drLdap) ) {
      foreach($tabAssoc as $strLdapKey => $tabAnnu) {
        if( $tabAnnu["table"] == "SIT_AGENT" || $tabAnnu["table"] == "SIT_ADRESSE" ) {
          $strValue = trim($drLdap->getValueName($tabAnnu["field"]));
          if( $tabAnnu["field"] == "ADR_POST" && mb_strlen($strValue)>5 ) {
            $strValue = mb_substr(trim($strValue), 0, 5);
          }
          $tabQuery[$tabAnnu["field"]] = array(ALK_SQL_TEXT, $strValue);
        } 
      }
      // recherche du service :
      $serv_ldpauid = $drLdap->getValueName("SERVICE_LDAPUID");
      
      $tabServTree = $oQueryAnnu->getTabServiceTree("-1", $serv_ldpauid, "");
      $serv_niv1 = ( count($tabServTree)>1 ? $tabServTree[1] : $this->idServ->value ); 
      $serv_niv2 = ( count($tabServTree)>2 ? $tabServTree[2] : "-1" ); 
      $serv_niv3 = ( count($tabServTree)>3 ? $tabServTree[3] : "-1" ); 
      $serv_niv4 = ( count($tabServTree)>4 ? $tabServTree[4] : "-1" ); 
      
      $this->idServ->value = $serv_niv1; 
      
      $tabQuery["SERVICE_ID"]     = array(ALK_SQL_NUMBER, $serv_niv1);
      $tabQuery["SERV_NIV2"]      = array(ALK_SQL_NUMBER, $serv_niv2);
      $tabQuery["SERV_NIV3"]      = array(ALK_SQL_NUMBER, $serv_niv3);
      $tabQuery["SERV_NIV4"]      = array(ALK_SQL_NUMBER, $serv_niv4);
      $tabQuery["AGENT_LDAP"]     = array(ALK_SQL_NUMBER, "1");
    } else {
      $tabQuery["AGENT_NOM"]    = array(ALK_SQL_TEXT, $this->strNom->value);
      $tabQuery["AGENT_PRENOM"] = array(ALK_SQL_TEXT, $this->strPrenom->value);
      $tabQuery["AGENT_MAIL"]   = array(ALK_SQL_TEXT, $this->strMail->value);
      
      $tabQuery["SERVICE_ID"]     = array(ALK_SQL_NUMBER, $this->idServ->value);
      if(ALK_B_INSCRIPTION_SERV_NIV2){ // modif pour le SI17 : possibilité d'enregsitrer un service de niv 2
        $tabQuery["SERV_NIV2"]      = array(ALK_SQL_NUMBER, $this->idServNiv2->value);
      }
    }
    
    if( !isset($tabQuery["AGENT_TEL"]) ) {
      $tabQuery["AGENT_TEL"]   = array(ALK_SQL_TEXT, $this->strTel->value);
    }

    $agent_id = "-1"; 
    if( $this->idServ->value != "-1" ) {
      $this->strServ->value = $oQueryAnnu->getStr_ServiceSigle($this->idServ->value, false);
          
      $tabFields = array("field" => $tabQuery, "pk" => array());
      
      $agent_id = $oAppliAnnu->addUser($tabFields);
    }
  
    return $agent_id;
  }
  
  
 /**
  * Ajout d'un service
  * @return int
  */
  private function addServ()
  {
    $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    
    $tabQuery = array();
    $tabQuery["SERVICE_ETAT"] = array(ALK_SQL_NUMBER,   "1");
    $tabQuery["SERVICE_PERE"] = array(ALK_SQL_NUMBER,   "1");
    $tabQuery["CONT_ID_START"] = array(ALK_SQL_NUMBER,   "1");
    $tabQuery["SERVICE_INTITULE"] = array(ALK_SQL_TEXT, $this->strServ->value);
    $tabQuery["SERVICE_INTITULE_COURT"] = array(ALK_SQL_TEXT, substr($this->strServ->value, 0, 40));
    $tabQuery["SERVICE_TEL"]   = array(ALK_SQL_TEXT, $this->strTel->value);
    $tabQuery["SERVICE_EMAIL"]   = array(ALK_SQL_TEXT, $this->strMail->value);
    $tabQuery["SERVICE_VALIDE"]   = array(ALK_SQL_NUMBER, -2);
    
    $tabFields = array("field" => $tabQuery, "pk" => array());
      
    $serv_id = $oAppliAnnu->addService($tabFields);
  
    return $serv_id;
  }
  
    /**
   * obtention des infos pour savoir si le service existe ou pas
   *
   * @param data_id   Identifiant de l'information
   *
   * @return Retourne un dataset
   */
  private function getDsDataByServiceIntitule($service_intitule)
  {
    $oDbConn = AlkFactory::getDbConn();
    $strSql = "select SERVICE_ID from SIT_SERVICE where SERVICE_INTITULE like '".$service_intitule."'";
    return $this->oAppli->oQuery->getDs($strSql);
  }
  
  
  /**
   * Envoi de mail pour une demande d'accès au SIT : identifiants oubliès
   * @param typeSend      type d'envoi
   * @param agent_nom     nom de l'utilisateur destinataire
   * @param agent_prenom  prenom de l'utilisateur destinataire
   * @param agent_mail    mail de l'utilisateur destinataire
   * @param agent_login   login de l'utilisateur destinataire
   * @param agent_pwd     mot de passe de l'utilisateur destinataire
   */
  function SendMailDemandeAccesToAgent($typeSend, $agent_nom, $agent_prenom, $agent_mail, 
                                       $agent_login, $agent_pwd, $agent_tel="", $agent_desc="", 
                                       $agent_serv="", $agent_lg="", $service_charte_path="",$service_charte="") 
  {
    $oAlkMail = AlkFactory::getMail();
    
    $tabAssoc = array();
    $strType = "";
    switch( $typeSend ) {
      case 6:
        $strType = "ESPACE_CONFIRME_UTIL_CPT";
        $oAlkMail->SetFrom(ALK_APP_TITLE, ALK_MAIL_ADMIN_MAIL);
        setMailAlkLocale($agent_lg);
        $oAlkMail->AddTo($agent_prenom." ".$agent_nom, $agent_mail);

        $strTokenPwd = AlkRequest::getEncodeParam("l=".$agent_login."&p=".md5($agent_pwd));

        $tabAssoc["msgTitle"] = _t("Paramètres de connexion");
        $tabAssoc["msg"] = _f("Vous avez sollicité une demande de création de compte le %s à %s.", date("d/m/Y"), date("H:i")).'<br/>'.
          _t("Un compte à votre nom existe déjà.").' '.
          _t("Un nouveau mot de passe a été généré.").'<br/>'.
          _t("Vos nouveaux paramètres de connexion sont les suivants :").
          '<ul>'.
          '<li>'._f("Identifiant : %s", $agent_login).'</li>'.
          '<li>'.( ALK_B_ANNU_PWD_SENDMAIL
                   ? _f("Mot de passe : [%s] (le mot de passe se situe entre les 2 crochets)", $agent_pwd)
                   : '<a href="'.ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE.'alkanet/index_chgpwd.php?token='.$strTokenPwd.'">'.
                     _f("Cliquez sur ce lien pour modifier votre mot de passe").'</a>.' ).   
          '</li>'.
          '</ul>';
          
        // informations complémentaires
        $tabAssoc["agent_login"] = $agent_login;
        if( ALK_B_ANNU_PWD_SENDMAIL ) {
          $tabAssoc["agent_pwd"] = $agent_pwd;
        }
        break;
      case 1 :
        $strType = "ESPACE_UTIL_MDP_OUBLIE";
        $oAlkMail->SetFrom(ALK_APP_TITLE, ALK_MAIL_ADMIN_MAIL);
        setMailAlkLocale($agent_lg);
        $oAlkMail->AddTo($agent_prenom." ".$agent_nom, $agent_mail);
        
        $strTokenPwd = AlkRequest::getEncodeParam("l=".$agent_login."&p=".md5($agent_pwd));

        $tabAssoc["msgTitle"] = _t("Paramètres de connexion");
        $tabAssoc["msg"] = _f("Vous avez sollicité une demande de mot de passe oublié le %s à %s.", date("d/m/Y"), date("H:i")).'<br/>'.
          _t("Un nouveau mot de passe a été généré.").'<br/>'.
          _t("Vos nouveaux paramètres de connexion sont les suivants :").
          '<ul>'.
          '<li>'._f("Identifiant : %s", $agent_login).'</li>'.
          '<li>'.( ALK_B_ANNU_PWD_SENDMAIL
                   ? _f("Mot de passe : [%s] (le mot de passe se situe entre les 2 crochets)", $agent_pwd)
                   : '<a href="'.ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE.'alkanet/index_chgpwd.php?token='.$strTokenPwd.'">'.
                     _f("Cliquez sur ce lien pour modifier votre mot de passe").'</a>.' ).   
          '</li>'.
          '</ul>';

        // informations complémentaires
        $tabAssoc["agent_login"] = $agent_login;
        if( ALK_B_ANNU_PWD_SENDMAIL ) {
          $tabAssoc["agent_pwd"] = $agent_pwd;
        }
        break;
  
      case 2:
        $strType = "ESPACE_UTIL_A_VALIDER_RELANCE";
        $oAlkMail->SetFrom($agent_prenom." ".$agent_nom, $agent_mail);
        setMailAlkLocale(ALK_MAIL_ADMIN_LG);
        $oAlkMail->AddTo(ALK_APP_TITLE, ALK_MAIL_ADMIN_MAIL);
        
        $tabAssoc["msgTitle"] = _t("Compte utilisateur à valider");
        $tabAssoc["msg"] = _f("J'ai souhaité accéder au %s le %s à %s.", ALK_S_SIT, date("d/m/Y"), date("H:i")).'<br/>'.
          _t("Il semble que ma fiche annuaire ne soit pas validée.").'<br/>'.
          _t("Mes paramètres sont les suivants :").
          '<ul>'.
          '<li>'._f("Nom : %s", $agent_nom).'</li>'.
          '<li>'._f("Prenom : %s", $agent_prenom).'</li>'.
          '<li>'._f("Courriel : %s", $agent_mail).'</li>'.
          '</ul>';

        // informations complémentaires
        $tabAssoc["agent_nom"]    = $agent_nom;
        $tabAssoc["agent_prenom"] = $agent_prenom;
        $tabAssoc["agent_mail"]   = $agent_mail;
        break;
        
      case 3:
        $strType = "ESPACE_UTIL_A_ACTIVER";
        $oAlkMail->SetFrom($agent_prenom." ".$agent_nom, $agent_mail);
        setMailAlkLocale(ALK_MAIL_ADMIN_LG);
        $oAlkMail->AddTo(ALK_APP_TITLE, ALK_MAIL_ADMIN_MAIL);
  
        $tabAssoc["msgTitle"] = _t("Demande de réactivation de compte annuaire");
        $tabAssoc["msg"] = _f("J'ai souhaité accéder au %s le %s à %s.", ALK_S_SIT, date("d/m/Y"), date("H:i")).'<br/>'.
          _t("Il semble que ma fiche annuaire ne soit plus activée.").'<br/>'.
          _t("Mes paramètres sont les suivants :").
          '<ul>'.
          '<li>'._f("Nom : %s", $agent_nom).'</li>'.
          '<li>'._f("Prenom : %s", $agent_prenom).'</li>'.
          '<li>'._f("Courriel : %s", $agent_mail).'</li>'.
          '</ul>';

        // informations complémentaires
        $tabAssoc["agent_nom"]    = $agent_nom;
        $tabAssoc["agent_prenom"] = $agent_prenom;
        $tabAssoc["agent_mail"]   = $agent_mail;
        break;
  
      case 4 :
        $strType = "ESPACE_AR_UTIL_CREATION";
        $oAlkMail->SetFrom(ALK_APP_TITLE, ALK_MAIL_ADMIN_MAIL);
        setMailAlkLocale($agent_lg);
        $oAlkMail->AddTo($agent_prenom." ".$agent_nom, $agent_mail);
        
        $tabAssoc["msgTitle"] = _t("Création d'un compte utilisateur");
        $tabAssoc["msg"] = _f("Votre demande de création de compte a été transmise aux administrateurs le %s à %s.", date("d/m/Y"), date("H:i")).'<br/>'.
          _f("Vous recevrez prochainement par courriel vos paramètres de connexion pour %s.", ALK_APP_TITLE).'<br/>';
        break;
  
      case 5:
        $strType = "ESPACE_UTIL_A_VALIDER";
        $oAlkMail->SetFrom($agent_prenom." ".$agent_nom, $agent_mail);
        setMailAlkLocale(ALK_MAIL_ADMIN_LG);
        $oAlkMail->AddTo(ALK_APP_TITLE, ALK_MAIL_ADMIN_MAIL);
        
        if($service_charte_path!="" && $service_charte!="")
          $oAlkMail->addFile($service_charte_path.$service_charte, $service_charte);
        $tabAssoc["msgTitle"] = _t("Nouveau compte utilisateur à valider");
        $tabAssoc["msg"] = _f("J'ai effectué une demande de création de compte au %s le %s à %s.", ALK_S_SIT, date("d/m/Y"), date("H:i")).'<br/>'.
          _t("Il est maintenant nécessaire de la valider.").'<br/>'.
          _t("Mes paramètres sont les suivants :").
          '<ul>'.
          '<li>'._f("Nom : %s", $agent_nom).'</li>'.
          '<li>'._f("Prenom : %s", $agent_prenom).'</li>'.
          '<li>'._f("Courriel : %s", $agent_mail).'</li>'.
          '<li>'._f("Téléphone : %s", $agent_tel).'</li>'.
          '<li>'._f("Service : %s", $agent_serv).'</li>'.
          '<li>'._f("Commentaire : %s", $agent_desc).'</li>'.
          '</ul>';

        // informations complémentaires
        $tabAssoc["agent_nom"]    = $agent_nom;
        $tabAssoc["agent_prenom"] = $agent_prenom;
        $tabAssoc["agent_mail"]   = $agent_mail;
        $tabAssoc["agent_tel"]    = $agent_tel;
        $tabAssoc["agent_serv"]   = $agent_serv;
        $tabAssoc["agent_desc"]   = $agent_desc;
        break;
    }
    
    if( $strType != "" ) {
      AlkMailing::SendMailType($oAlkMail, $strType, $tabAssoc);
      setCurrentAlkLocale();
    }
  }
  
}

?>