<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlPopupEspaceArbo
 * Classe de gestion de l'arborescence des espaces
 */
class AlkHtmlPopupEspaceArbo extends AlkHtmlForm 
{
  /**
   * Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formArbo");

    $this->title = _t("Gestion de l'arborescence des espaces administrables");
    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

   /**
   * Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql() 
  {
    $cont_id      = AlkRequest::_GETint("folderSrc_id",  "-1");
    $cont_id_dest = AlkRequest::_GETint("folderDest_id", "-1");

    // appel ajax
    // opération à effectuer
    $strOp = AlkRequest::_GET("op", "cut");

    if( $strOp == "cut" ) {
      $this->oAppli->moveSpace($cont_id, $cont_id_dest);
      //trace ajax pour décider du rafraichissement
      echo "cut";
    } elseif( $strOp == "copy" ) {
      $this->oAppli->dupSpace($cont_id, $cont_id_dest);
      // trace ajax pour décider du rafraichissement
      echo "copy";
    }

    return "";
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $user_id = AlkFactory::getSProperty("user_id", "-1");

    $this->setLabelDesc(_t("Affichage de tous les espaces de travail dont vous êtes animateur").".<br/>".
                        _t("Cliquez sur l'intitulé de l'espace pour atteindre ses propriétés").".<br/>".
                        _t("Pour activer l'espace à déplacer, cliquer sur le picto")." <img class=\"alkimgicon alkimgiconpast\" src='".ALK_MEDIA_URL."images/transp.gif'/>".
                        _f("%spour afficher le picto", "&nbsp;")." <img class=\"alkimgicon alkimgiconcut\" src='".ALK_MEDIA_URL."images/transp.gif'/>.<br/>".
                        _t("Pour activer l'espace à copier, cliquer sur le picto")." <img class=\"alkimgicon alkimgiconcut\" src='".ALK_MEDIA_URL."images/tranp.gif'/>".
                        _f("%spour afficher le picto", "&nbsp;")." <img class=\"alkimgicon alkimgiconcopy\" src='".ALK_MEDIA_URL."images/transp.gif'/>.<br/>".
                        _t("Pour sélectionner l'espace cible, cliquer sur le picto")." <img class=\"alkimgicon alkimgiconpast\" src='".ALK_MEDIA_URL."images/transp.gif'/> associé.");

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_layer.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_arbre.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_treeview.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/jquery.treeview.js");
    $this->addScriptCss("../../".ALK_ROOT_CLASSE."form/treeview.css");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupespacearbo.js");

    $strHtml = "<div id='layerArbre' style='width:520;'>&nbsp;</div>";
    $oCtrlTxt = AlkHtmlFactory::getHtml($strHtml); 
    $oBlock = $this->addBlock("blockplan", "", "", "10", "550", true);
    $oBlock->addCtrl($oCtrlTxt);

    $strHtmlJs =  "var objTreeview = null; ".
      " function AffTreeview() { ".
      "   objTreeview = new Treeview(document, 'layerArbre', 0); ";
      
    // liste des conteneurs accessibles a l'utilisateur
    $dsNoeud = $this->oAppli->oQuery->getDs_listeEspaceByAgentForArbo($user_id, true);
    while( $drNoeud = $dsNoeud->getRowIter() )	{
      $idFils = $drNoeud->getValueName("ID");
      $idPere = $drNoeud->getValueName("ID_PERE");
      $iNiv = $drNoeud->getValueName("NIV");
      $strNom = $drNoeud->getValueName("NOM");

      $strNom = preg_replace( "/\"/", "'", $strNom);
      $strNom = preg_replace( "/'/", "\'", $strNom);

      $strToken = AlkRequest::getEncodeParam("cont_id=".$idFils."&appli_id=-1&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_FICHE);
      $strUrl = "javascript:closeWindow('".$strToken."')";
      $iDroitLink = 2;
      $iDroitAction = 2;
		
      $strHtmlJs .=  " objTreeview.AddFolder(\"_".$idFils."\", \"_".$idPere."\", \"".
        $strNom."\", ".$iNiv.", ".$iDroitLink.", ".$iDroitAction.", \"".$strUrl."\", \"\");";
    }

    // paramétrage
    $strHtmlJs .=  " objTreeview.classLinkFolder = 'bold';".
      " objTreeview.classTextFolder = 'bold';".
      " objTreeview.classLinkDoc = '';".
      " objTreeview.classTextDoc = '';".
      
      " objTreeview.imgNodeOpen  = '';".
      " objTreeview.imgNodeClose = '';".
      " objTreeview.imgNode      = '';".
      
      " objTreeview.imgNodeFolder    = '".ALK_MEDIA_URL."images/icon_paste.gif';".
      " objTreeview.imgNodeFolderCut = '".ALK_MEDIA_URL."images/icon_cut.gif';".
      " objTreeview.imgNodeFolderCopy = '".ALK_MEDIA_URL."images/icon_copy.gif';".
      " objTreeview.iTabLg = 540;".
      
      " objTreeview.urlConfirm = 'javascript:CutCopySpace';".
      " objTreeview.tokenCutCopy = '".$this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_ARBORESCENCE, ALK_SHEET_NONE)."';".
      
      " objTreeview.bShowNode = false;".
      " objTreeview.bCanShowHideNode = false;".
      " objTreeview.strNodeName = '';".
      
      " /* affichage: objTreeview.Draw(); */".
      "	objTreeview.OpenAll(); ".
      "} ";
    
    $this->addJs($strHtmlJs);
    //$this->addOnLoad("AffTreeview()");
    $this->addOnLoad("AffTreeview();dragAndDropPages('layerArbre');");
  }

}

?>