<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Espace
Module gestionnaire d'espaces.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Espace
 * @class AlkHtmlPopupUserRight
 * Classe de gestion de droit par utilisateur sur les applis d'un espace
 */
class AlkHtmlPopupUserRight extends AlkHtmlForm 
{
  /** nom de l'utilisateur sélectionné */
  protected $strUserName;
  /** identifiant de l'utilisateur sélectionné */
  protected $userId;
  
  /**
   * Constructeur par défaut
   * @param oAppli  Référence sur l'appli annuaire
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formUserRight");

    $this->userId  = AlkRequest::getToken("agent_id", "-1");
    $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $this->strUserName = $oQuery->GetStr_agentNomPrenom($this->userId);

    $this->setProperties(ALK_FORM_MODE_UPDATE, ALK_FORM_METHOD_POST, "");
  }

   /**
   * Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit) { }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql() 
  {
    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    $user_id  = AlkRequest::getToken("agent_id", "-1");
    $cont_id = AlkRequest::getToken("cont_id", "-1");

    $this->oAppli->setUserRightsOnSpace($cont_id, $user_id);
    
    echo  getBodyOnLoadExec("", "closeWindow()");
    exit();
  }
  
  /**
   * Retourne le titre de la page
   */
  public function getTitle()
  {
    if( $this->iSSheet == ALK_SHEET_NONE) {
      return _f("Gestion des droits de %s", $this->strUserName);
    }

    return _f("Ensemble des droits de %s", $this->strUserName);
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $iWidthTxt = 30;
    $iWidthLabel = 130;
    $iWidthCtrl  = 300;

    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    $user_id  = AlkRequest::getToken("agent_id", "-1");
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    
    $appli_id = ($this->oAppli->appli_id==-1 ? $appli_id : $this->oAppli->appli_id);
    
    if( $this->iSSheet == ALK_SHEET_NONE ) {
      $this->setLabelDesc(_t("Fixez les droits d'accès à cet utilisateur sur les applications de cet espace."));
  
      $oBlockRight = $this->getRightPanel();
      //$oBlockRight->enableBlock("", "", $iWidthLabel, $iWidthCtrl, false);
      $this->addPanel($oBlockRight);
  
      $strToken  = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&iTypeSheet=".$this->iTypeSheet."&iSheet=".ALK_SHEET_USERRIGHT."&iSSheet=". ALK_SHEET_NONE."&agent_id=".$user_id);

      $oButton = $this->addButtonPage("bt_Valider", "javascript:Valider('".$strToken."')", _t("Valider"), _t("Valider les droits"));
      $this->addSubmitButton($oButton);
  
      $this->addButtonPage("bt_Annuler", "javascript:closeWindow()", _t("Annuler"), _t("Annuler les modifications"));
          
      $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."espace/lib/alkhtmlpopupuserright.js");
      
      $this->setTemplate("espace", "alkhtmlpopupuserright.tpl");
    } else {
      $this->setLabelDesc(_f("Cette fenêtre fournit l'ensemble des droits de %s.", $this->strUserName).
                          "<a href='#legende'>"._t("Cliquer ici pour atteindre la légende")."</a>");

      $this->addBlockUserAllRights($user_id);
    }  
  }

  /**
   * Retourne le block liste des applications avec la gestion de droits
   * @return AlkHtmlList
   */
  private function getRightPanel()
  {
    // liste des groupe de cet espace
    $user_id  = AlkRequest::getToken("agent_id", "-1");
    $cont_id = AlkRequest::getToken("cont_id", "-1");

    $nbProfilPerUser = 0;
    $dsAppli = $this->oAppli->oQuery->getDsUserRightOnSpace($nbProfilPerUser, $cont_id, $user_id);
    $nbProfilPerUser += 1;

    // nombre de groupe
    $nbElt = $dsAppli->getCountTotDr();

    $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, 1, $nbElt, false, "",
                                            _t("Aucune application n'a été créée sur cet espace."));
    $oTabPage->SetColumns(array("left",  "160"),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false),
                          array("center", "50", "", false, false));

    $oTabPage->AddTitleRow(_t("Application"), _t("Aucun"), _t("Consult."), _t("Admin."), _t("Publi."));
    $oTabPage->setProperty("strTableAlign", "center");

    $strToken = "";

    // selectionne la liste des applis
    $i   = 0;
    $memDroit_id = -1;
    while( $drAppli = $dsAppli->getRowIter() ) {
      $appli_id = $drAppli->getValueName("APPLI_ID");
      $strAppli = $drAppli->getValueName("APPLI_INTITULE");
      $droit_id  = $drAppli->GetValueName("DROIT_ID");
      if( $droit_id == "" ) {
        $droit_id = ALK_APPLI_RIGHT_NONE;
      }
        
      $check0 = "-0'";
      $check1 = "-1'";
      $check2 = "-2'";
      $check4 = "-4'";
      switch( $droit_id )	{
      case ALK_APPLI_RIGHT_NONE:	$check0 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_READ:	$check1 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_ADMIN:	$check2 .= " checked='checked'"; break;
      case ALK_APPLI_RIGHT_PUBLI:	$check4 .= " checked='checked'"; break;
      }
      
      $strBR0 = "<input type='radio' name='listRight[".$i."]' value='".$appli_id.$check0."/>";
      $strBR1 = "<input type='radio' name='listRight[".$i."]' value='".$appli_id.$check1."/>";
      $strBR2 = "<input type='radio' name='listRight[".$i."]' value='".$appli_id.$check2."/>";
      $strBR4 = "<input type='radio' name='listRight[".$i."]' value='".$appli_id.$check4."/>".
        "<input type='hidden' name='memRight[".$i."]' value='".$droit_id."'>";
      
      $oTabPage->AddRow($strAppli, $strBR0, $strBR1, $strBR2, $strBR4);
      $i++;
    }
    return $oTabPage;
  }  
  
  /**
   * Retourne le block affichant tous les droits de l'utilisateur sur l'extranet
   * @param user_id  identifiant de l'utilisateur connecté
   * @return  
   */
  private function addBlockUserAllRights($user_id)
  {
    $dsAppli = $this->oAppli->oQuery->GetDs_listeAppliByAgentEspace($user_id);

    // nombre de groupe
    $nbElt = 0;
    $strUser = _t("Utilisateur :").' <a title="'.$this->strUserName.' "href="javascript:OpenPopupFiche(\'agent\', '.$this->userId.')">'.$this->strUserName."</a>";
  
    $oTabPage = AlkHtmlFactory::getHtmlList($this, $nbElt, 1, $nbElt, false, "", _t("Aucun droit"));
    $oTabPage->SetColumns(array("center", "50"),
                          array("left",  "550"));

    $oTabPage->AddTitleRow(_t("Droits"), $strUser);
    $oTabPage->setProperty("strTableAlign", "center");
    
    $tabLogoCont = array(0 => "picto04_prive.gif", 
                         1 => "picto03_reseaux.gif", 
                         2 => "picto04_privevisible.gif");
    $tabCssCont = array(0 => "userspace", 1 => "adminspace");
    $tabDroitCont = array(0 => "&nbsp;", 1 => "A");
    $tabCssAppli = array(0 => "appli0", 1 => "appli1", 2=> "appli2", 3 => "", 4=> "appli4");
    $tabDroitAppli = array(0 => "&nbsp;",  1 => "C", 2=> "A", 3=> "", 4=> "AP");

    $idContOld = -1;
    $dsAppli->setTree("CONT_ID", "CONT_PERE");
    $iCpt = 0;
    while( $drAppli = $dsAppli->getRowIter() ) {
      $appli_id       = $drAppli->getValueName("APPLI_ID");
      $atype_id       = $drAppli->getValueName("ATYPE_ID");
      $appli_intitule = $drAppli->getValueName("APPLI_INTITULE");
      $appli_logo     = $drAppli->getValueName("ATYPE_LOGO");
      $idCont         = $drAppli->getValueName("CONT_ID");
      $cont_intitule  = $drAppli->getValueName("CONT_INTITULE");
      $cont_public    = $drAppli->getValueName("CONT_PUBLIC");
      $cont_admin     = $drAppli->getValueName("CONT_ADMIN");
      $cont_niveau    = $drAppli->getValueName("CONT_NIVEAU");
      $droit_id       = $drAppli->getValueName("DROIT_ID");
      if( $droit_id == "" ) $droit_id = 0;
    
      if( $idCont != $idContOld ) {
        // ligne espace (pair)
        $strLogo  = ALK_MEDIA_URL."pictos/".$tabLogoCont[$cont_public];
        $iPadding = ($cont_niveau-1)*32+4;
        $idContOld = $idCont;
        $strIntitule = "<img src='".$strLogo."' align='middle'/>&nbsp;".$cont_intitule;
    
        $oTabPage->AddRow(array($tabDroitCont[$cont_admin], 1, 1, $tabCssCont[$cont_admin]),
                          array($strIntitule, 1, 1, "style='font-weight:bold; padding-left:".$iPadding."px;' class='pair'"));
        $iCpt++;
      }
    
      // ligne application (impair)
      $strLogo  = ALK_MEDIA_URL."pictos/".$appli_logo;
      $strIntitule = "<img src='".$strLogo."' align='middle'/>&nbsp;".$appli_intitule;
      $iPadding = ($cont_niveau-1)*32+16+4;

      $oTabPage->AddRow(array($tabDroitAppli[$droit_id], 1, 1, $tabCssAppli[$droit_id]),
                        array($strIntitule, 1, 1, "style='font-weight:normal; border-top:none; padding-left:".$iPadding."px;'"));
      $iCpt++;
    }
    
    $oTabPage->setProperty("strTableAlign", "center");
    $oTabPage->setProperty("iNbElt", $iCpt);
    //$oTabPage->enableBlock("", "", "1", "610", false);
    $this->addPanel($oTabPage);

    $strHtml = "<a name='legende'>".
      "<div class='txtNormal bold' style='margin-left:20px; margin-bottom:8px;".
      " border-bottom:1px solid #000000; width:500'>"._t("Légende :")."</div></a>".
      "<table summary='legende' border='0' cellpadding='0' cellspacing='0' style='margin-left:20px'><tr>".
      "<td width='70' rowspan='2' valign='top' class='txtNormal bold'>"._t("Espace")."</td>".
      "<td width='32' class='".$tabCssCont[0]."' align='center'>".$tabDroitCont[0]."</td>".
      "<td width='400' class='txtNormal' style='padding-left:4px'>"._t("Utilisateur de l'espace")."</td>".
      "</tr><tr>".
      "<td class='".$tabCssCont[1]."' align='center'>".$tabDroitCont[1]."</td>".
      "<td class='txtNormal' style='padding-left:4px'>"._t("Animateur de l'espace")."</td>".
      "</tr><tr>".
      "<td colspan='3' height='4'></td></tr><tr>".
      "<td rowspan='4' valign='top' class='txtNormal bold'>"._t("Application")."</td>".
      "<td class='".$tabCssAppli[0]."' align='center'>".$tabDroitAppli[0]."</td>".
      "<td class='txtNormal' style='padding-left:4px'>Aucun droit sur l'application</td>".
      "</tr><tr>".
      "<td class='".$tabCssAppli[1]."' align='center'>".$tabDroitAppli[1]."</td>".
      "<td class='txtNormal' style='padding-left:4px'>"._t("Droit d'accès à la partie consultation de l'application")."</td>".
      "</tr><tr>".
      "<td class='".$tabCssAppli[2]."' align='center'>".$tabDroitAppli[2]."</td>".
      "<td class='txtNormal' style='padding-left:4px'>"._t("Droit d'accès à la partie administration de l'application")."</td>".
      "</tr><tr>".
      "<td class='".$tabCssAppli[4]."' align='center'>".$tabDroitAppli[4]."</td>".
      "<td class='txtNormal' style='padding-left:4px'>"._t("Droit d'accès à la partie propriétés de l'application + droit de publication")."</td>".
      "</tr>".
      "</table><br>";
      
    $oCtrl = AlkHtmlFactory::getHtml($strHtml);  
    $oBlock = $this->addBlock("blockLegend", "", "", "1", "600", false);
    $oBlock->addCtrl($oCtrl, ALK_HTMLFORM_1L1C);
  }
 
}

?>