{*licence 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::CEdit
Module consultation éditoriale..
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

licence
*}
{*strip*}

{php}  

$oAppliEspace = AlkFactory::getAppli(ALK_ATYPE_ID_ESPACE);

/**
* descriptif du tabParam :
* "b_atype" : correspont au booleen du module; verifie si module implementé
* "atype_id" : correspond au atype_id, c'est cet identifiant qui permet de sélectionner les images du bloc
* "atypeIdBloc" : pour le iedit correspond au bloc possible : actu, agenda..; -1 par defaut
* "typeAssoc" : voir le parametrage du getDataContents pour chaque appli (dans alkappli..).
* "color", : la couleur des bandeau des bloc à choisir parmi "orange", "vert", "rose", "bleu"
* "cont_id" : permet de récupérer les information d'appli sur d'autre espace que l'espace courant ($GLOBALS["cont_id"] par defaut : espace courant)
* "intituleActuOuAgenda" : si appli de type actu ou agenda : préciser "Agenda" ou "Actualité"
* "nbItem" : nb d'item souhaité dans le bloc
**/

$tabParam= array(
	array(	"b_atype"    => ALK_B_ATYPE_ACTU,
			"atype_id"   => ALK_ATYPE_ID_IEDIT,
			"atypeIdBloc"=> ALK_ATYPE_ID_ACTU,
			"typeAssoc"  => 1,
			"color"      => "bleu",
			"cont_id"    => $GLOBALS["cont_id"],
			"typeActu"   => "Actualité",
			"nbItem"     => 5,
			"title_bloc" => "Actualités"),
				
	array(	"b_atype"    => ALK_B_ATYPE_ACTU,
			"atype_id"   => ALK_ATYPE_ID_IEDIT,
			"atypeIdBloc"=> ALK_ATYPE_ID_ACTU,
			"typeAssoc"  => 1,
			"color"      => "orange",
			"cont_id"    => $GLOBALS["cont_id"],
			"typeActu"   => "Agenda",
			"nbItem"     => 5,
			"title_bloc" => "Agenda"),
				
	array(	"b_atype"    => ALK_B_ATYPE_FDOC,
			"atype_id"   => ALK_ATYPE_ID_FDOC,
			"atypeIdBloc"=> -1,
			"typeAssoc"  => 1,
			"color"      => "vert",
			"cont_id"    => $GLOBALS["cont_id"],
			"typeActu"   => "",
			"nbItem"     => 5,
			"title_bloc" => "Fond documentaire"),				
	);


$user_id = AlkFactory::getSProperty("user_id", "-1");

foreach($tabParam as $tabParamNiv2) { 

  $oAppli = AlkFactory::getAppli($tabParamNiv2["atype_id"]);
	  
  if( !is_null($oAppli) ) { 	
    $tabAppli_id = $oAppliEspace->oQuery->getApplisId($tabParamNiv2["atype_id"], $tabParamNiv2["cont_id"]); 
    foreach($tabAppli_id as $key => $value) { 
      // dans le cas où l'on a plusieurs blocs pour une meme appli (ex. actu - agenda dans iedit)	

      // si iedit de type actu on cherche à savoir si agenda ou actu sinon on n'affiche rien
      $bvisible = true;
      if( $tabParamNiv2["atypeIdBloc"] == ALK_ATYPE_ID_ACTU ) {
        $intitule = $oAppli->oQuery->getstrTypeData($tabParamNiv2["atypeIdBloc"], $tabAppli_id[$key]); 
        $bvisible = ( $intitule == $tabParamNiv2["typeActu"] ? true : false );
      }
			
      if( $bvisible == true ) {
        $tabContent = $oAppli->getDataContents($tabAppli_id[$key], $tabParamNiv2["typeAssoc"], $user_id, ALK_LG_BDD, $tabParamNiv2["atypeIdBloc"]);
			    
        $this->assign("tabContent", $tabContent );
        $this->assign("atype_id", $tabParamNiv2["atype_id"] );
        $this->assign("cont_id", $tabParamNiv2["cont_id"] );
        $this->assign("color", $tabParamNiv2["color"]);
        $this->assign("nbItem", $tabParamNiv2["nbItem"]);
        $this->assign("title_bloc", $tabParamNiv2["title_bloc"]);
	
		{/php}
		{include file="$strPathTpl/templates/alkhtmlbloctableaubord.tpl" strPathTpl=$strPathTpl tabContent=$tabContent}
		{php}	
      }	
    }
  }
}

{/php}
{*/strip*}
