<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Form
 * 
 * @class AlkHtmlPopupFormulaireForm
 * Classe permettant d'afficher une popup permettant de gérer les formulaires depuis la syndication
 */
class AlkHtmlPopupFormulaireForm extends AlkHtmlForm
{
  protected $synd_id;
  protected $form_id;
  
  protected $syndic_datereponse;
  protected $syndic_formfichier;
  
  protected $strParam;
  protected $strTokeClose;
  
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "popupFormulaireForm"); 
    
    $this->synd_id = AlkRequest::getToken("synd_id", -1);
    $this->form_id = AlkRequest::getToken("form_id", -1); 
  
    $dataTableName = AlkRequest::getToken("tablename", "");
    $dataFieldName = AlkRequest::getToken("fieldname", "");
    $data_id       = AlkRequest::getToken("data_id", -1);    
    $atypedata_id  = AlkRequest::getToken("atypedata_id", 26);   //Atype de provenance de la donnée
    $applidata_id  = AlkRequest::getToken("applidata_id", -1);

    $this->strParam = "&tablename=".$dataTableName.
                      "&fieldname=".$dataFieldName.
                      "&data_id=".$data_id.
                      "&atypedata_id=".$atypedata_id.
                      "&synd_id=".$this->synd_id;

    $this->strTokeClose = AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=".$applidata_id."&iTypeSheet=".
                                                     ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_FICHE.$this->strParam.
                                                     "&applitype_id=".ALK_ATYPE_ID_SYND);
    $iMode = AlkRequest::getToken("iMode", "-1");
    if( $iMode == "-1" ) {
      $iMode = ( $this->form_id == "-1" ? ALK_FORM_MODE_ADD : ALK_FORM_MODE_UPDATE );
    }
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  } 
   
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) 
  { 
  	$datereponse = "";
    
    $this->syndic_datereponse = new AlkformData($this, "datereponse", "", ALK_SQL_DATE);
    $this->syndic_formfichier = new AlkformData($this, "syndic_formfichier", "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT);
    $this->form_id_select     = new AlkformData($this, "form_id_select"    , "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->form_titre         = new AlkformData($this, "form_titre"        , "", ALK_SQL_TEXT, ALK_VERIF_DEFAULT, true);
    
    $oDrData = null;
    $reqMethod = -1; 
    if( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {        
      $oQuerySynd = AlkFactory::getQuery(ALK_ATYPE_ID_SYND);    
      $oDsData = $oQuerySynd->GetDs_ficheSyndById($this->synd_id);
      $oDrData = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
    }
    if( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;

    $this->initData($iTypeInit, $oDrData, $reqMethod);
  }
  
  /**
   * Traitement du formulaire
   */
  public function doSql() 
  { 
    $this->setData(ALK_INIT_MODE_REQUEST);
    $form_id = "-1";
    $iMode = ALK_FORM_MODE_UPDATE;
    
    $oQuerySyndAction = AlkFactory::getQueryAction(ALK_ATYPE_ID_SYND);
    switch( $this->iMode ) {
    case ALK_FORM_MODE_UPDATE: // modif de la fiche syndication
      $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_SYND, true);
      $oQuerySyndAction->addAssocSyndForm($this->synd_id, $this->form_id, 
                                          $this->syndic_datereponse->value, "syndic_formfichier", $strPathUpload);
      
      echo getBodyOnLoadExec("closeWindow('".ALK_ALKANET."?token=".$this->strTokeClose."');");
      return "";                                          
      break;

    case ALK_FORM_MODE_DEL: // suppression d'un formulaire
      $oQuerySyndAction->delAssocSyndForm($this->synd_id);
      $this->oAppli->oQueryAction->delFormulaire($this->form_id);
      $iMode = ALK_FORM_MODE_ADD;
      $form_id = "-1";
      break;
      
    case 4: // association d'un formulaire existant à la circulaire
      $oQuerySyndAction->addAssocSyndForm($this->synd_id, $this->form_id_select->value);
      $form_id = $this->form_id_select->value;
      break;
      
    case 5: // création d'un formulaire puis association à la circulaire
      $tabTitre = array();
      foreach($this->tabLangue as $key => $tabLg) {
        $tabTitre[$key] = AlkRequest::_POST("form_titre".$tabLg["bdd"], "");
      }
      $path_Form = AlkFactory::getModulePath(ALK_ATYPE_ID_FORM);   
      $strPathFileGabarit = $path_Form."gabarit.html";
      $strContenu = "";
      if( file_exists($strPathFileGabarit) && is_file($strPathFileGabarit) ) {
        $handle = fopen($strPathFileGabarit, "r");
        $strContenu = trim(fread($handle, filesize($strPathFileGabarit)));
        fclose($handle);
      } 
      $form_id = $this->oAppli->oQueryAction->addFormulaire($tabTitre, "", $strContenu, $this->oAppli->appli_id, "", "", "1", "0", "", "0", "");       
      $oQuerySyndAction->addAssocSyndForm($this->synd_id, $form_id);
      break;
    }
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                        $this->strParam."&form_id=".$form_id."&iMode=".$iMode);
    return ALK_ALKANET."?token=".$strToken;
  }
   
  /**
   * Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  { 
    return _t("Gestion des formulaires de réponse");
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    $cont_id = AlkRequest::getToken("cont_id", "-1");

    $iSelectWidth = 305;
    $iTxtWidth = 41;
      
    $strHtml = "";
      
    $strDesc = _t("Cliquez sur le bouton Ajouter pour créer un nouveau formulaire".
      " ou choisissez le parmi la liste des formulaires existants puis cliquez sur Associer.")."<br>".
      ( $this->iMode==ALK_FORM_MODE_UPDATE 
        ? _t("Lorsque le formulaire est sélectionné, cliquez sur le drapeau pour modifier le contenu du formulaire.")."<br>".
          _t("Vous pouvez également proposer un formulaire de réponse en téléchargeant un document.")
        : "" );
    $oBlock = $this->addBlock("blocProp", _t("Sélectionnez un formulaire"), $strDesc, "150", "420", true);

    $oCtrlSelect = AlkHtmlFactory::getHtmlSelect($this->form_id_select, _t("Sélectionnez un formulaire"), 1, $iSelectWidth);
    $oCtrlSelect->setProperty("tabValTxtDefault", array("-1", ""));
    $oCtrlSelect->setProperty("strFieldValue", "FORM_ID");
    $oCtrlSelect->setProperty("strFieldText", AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
    $oCtrlSelect->setProperty("oValTxt", $this->oAppli->oQuery->GetDs_ListeFormulairesByAppli(-3));
    $strTokenSelect = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, $this->strParam."&iMode=4");
    $btSelect = AlkHtmlFactory::getHtmlButtonForm("javascript:selectForm('".$strTokenSelect."')", _t("Associer"), 
                                                 _t("Associer ce formulaire à la circulaire"), true);
    $oCtrlSelect->setLabelAfter("&nbsp;".$btSelect->getHtml());
    $oBlock->addCtrl($oCtrlSelect);

    $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->form_titre, _t("Nouveau formulaire"), 1, $iTxtWidth, 255);
    $strTokenAdd = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, $this->strParam."&iMode=5");
    $btAdd = AlkHtmlFactory::getHtmlButtonForm("javascript:AddForm('".$strTokenAdd."')", "Ajouter", 
                                               _t("Créer puis associer ce formulaire à la circulaire"), true);
    $oCtrlTxt->setLabelAfter("&nbsp;".$btAdd->getHtml());
    $oBlock->addCtrl($oCtrlTxt);

    if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
      $oBlockIdent = $this->addBlock("blocIdent", _t("Propriétés du formulaire sélectionné"), "", "150", "420", false);
      
      $form_titre = "";
      $dsForm = $this->oAppli->oQuery->GetDs_formulaire($this->form_id);
      if( $drForm = $dsForm->getRowIter() ) {
        $form_titre = $drForm->getValueName(AlkFactory::getDBCurrentLanguageField("FORM_TITRE"))."<br/>";
      }
      
      $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true).$cont_id."/";
      if( !(@file_exists(ALK_ALKANET_ROOT_PATH.$strPathUpload) && @is_dir(ALK_ALKANET_ROOT_PATH.$strPathUpload)) ) {
        $bRes = @mkdir(ALK_ALKANET_ROOT_PATH.$strPathUpload, 0770);
        if( !$bRes ) {
          $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_FORM, true);
        } 
      }
      
      foreach($this->tabLangue as $key => $tabLg) {
        $strTokenEdit = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE,
                                                "&applitype_id=".ALK_ATYPE_ID_FORM.
                                                "&form_id=".$this->form_id."&table=FORM_01_FORM".
                                                "&lang=".$tabLg["bdd"]."&repUpload=".$strPathUpload);
        
        $oBtEdit = AlkHtmlFactory::getHtmlButtonIcon("javascript:OpenPopupEditeur('".$strTokenEdit."')",
                                                     "drapeau_".$tabLg["rep"], _f("Contenu %s de ce formulaire", $tabLg["rep"]));
        $form_titre .= ( $form_titre=="" ? "" : "&nbsp;").$oBtEdit->getHtml();
      }

      $strTokenExp = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_LIST, ALK_SHEET_NONE, 
                                             $this->strParam."&form_id=".$this->form_id."&iMode=6");
      $oBtExport = AlkHtmlFactory::getHtmlButtonIcon("javascript:void(OpenFooterExec('".ALK_ALKANET_SQL."?token=".$strTokenExp."'))", 
                                                     "Envoyer", _t("Exporter les réponses"));

      $strTokenPurge = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_LIST, ALK_SHEET_NONE, 
                                               $this->strParam."&form_id=".$this->form_id."&iMode=7");
      $oBtPurge = AlkHtmlFactory::getHtmlButtonIcon("javascript:ExecPurge('".$strTokenPurge."')",
                                                    "Purge",  _t("Purger les réponses"));

      $strTokenDel = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                             $this->strParam."&form_id=".$this->form_id."&iMode=".ALK_FORM_MODE_DEL);
      $strHtmlBtModifForm = AlkHtmlFactory::getHtmlButtonIcon("javascript:Confirmation('".ALK_ALKANET_SQL."?token=".$strTokenDel."',".
                                                              _t(" 'Veuillez confirmer la suppression de ce formulaire ?'").")", 
                                                              "Supprimer",  _t("Supprimer ce formulaire"), true);  
      $form_titre .= "&nbsp;".$oBtExport->getHtml()."&nbsp;".$oBtPurge->getHtml()."&nbsp;".$strHtmlBtModifForm->getHtml();
      $oCtrlF = AlkHtmlFactory::getHtml($form_titre, _t("Formulaire sélectionné :"));
      $oBlockIdent->addCtrl($oCtrlF);

      if( ALK_B_SYND_DATEREPONSE == true ) {
        $oCtrlDate = AlkHtmlFactory::getHtmlDate($this->syndic_datereponse, _t("Date limite de réponse")); 
        $oCtrlDate->addValidator(ALK_VERIF_DATE10);      
        $oBlockIdent->addCtrl($oCtrlDate);
      }
                    
      $oCtrlPj = AlkHtmlFactory::getHtmlFile($this->syndic_formfichier, _t("Fichier joint au formulaire"), $iTxtWidth);
      $oCtrlPj->setDualMode(true);
      $oCtrlPj->setFileUrl(AlkFactory::getUploadUrl(ALK_ATYPE_ID_SYND), $this->syndic_formfichier->value);
      $oBlockIdent->addCtrl($oCtrlPj);
          
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                                          $this->strParam."&form_id=".$this->form_id."&iMode=".ALK_FORM_MODE_UPDATE);
      $this->addValidButton("", "javascript:ValidForm('".$strToken."')", _t("Valider"), _t("Valider la fiche"));
      $this->addButtonPage("btCancel", "javascript:closeWindow('".ALK_ALKANET."?token=".$this->strTokeClose."')", _t("Annuler"), _t("Annuler la modification"));
    }
          
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/alkhtmlpopupformulaireform.js");
    $this->AddScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."form/lib/alkhtmlformlist.js");
  }

}
?>