<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Form
Module formulaire.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkxml.class.php");
/**
 * @package Alkanet_Class_Module_Form
 * 
 * @class AlkHtmlPopupFormulaireReponse
 * Classe d'affichage du formulaire de répon
 */
class AlkHtmlPopupFormulaireReponse extends AlkHtmlForm
{  
 
  /**
   *  constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formFormReponse");

    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }
  
  /**
   *  Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) 
  {
  }

  /**
   *  Retourne le titre de la popup
   * @return string
   */
  public function getTitle()
  { 
    return _t("Fiche");
  }
     
  /**
   * Initialise les lignes de DR à lire
   */
  protected function initDrData(){
  	
  }

  /**
   *  Traitement 
   */
  public function doSql() 
  {
  }

  /**
   *  Construction du contenu du formulaire
   */
  public function setContents()
  { 
    $this->form_id = AlkRequest::getToken("form_id", "-1");    
    
    $strTitre = "";
    $strContenu = "";
    if ( $this->form_id != "-1" ) {
      $dsForm = $this->oAppli->oQuery->GetDs_formulaire($this->form_id);
      if( $drForm = $dsForm->GetRowIter() ) {
        $strTitre      = $drForm->GetValueName(AlkFactory::getDBCurrentLanguageField("FORM_TITRE"));
        $dDateCrea     = $drForm->GetValueName("FORM_DATE_CREA");
        $dDateMaj      = $drForm->GetValueName("FORM_DATE_MAJ");
        $strMail       = $drForm->GetValueName("FORM_MAIL");
        $strContenu    = $drForm->GetValueName(AlkFactory::getDBCurrentLanguageField("FORM_CONTENU"));
      }
    }

    $oBlockApercu = $this->addBlock("blockAp", "", "", "5", "565");
    $oCtrlContenuText = AlkHtmlFactory::getHtml($strContenu);
    $oBlockApercu->addCtrl($oCtrlContenuText);
    
  }

}
?>