/*On déclare ici toutes les variables globales et les fonctions javascript qui seront réutilisées à plusieurs endroits*/
var _ctrl_index = 1001;
      
var _tabNameUsed = new Array();
var _currentNameLoaded = new Array();

var _form_id = -1;

Array.prototype.inArray = function(p_val) {
    return (this.indexOf(p_val) != -1);
}
Array.prototype.removeElement = function(p_val) {
    if (this.indexOf(p_val) != -1){
      this.splice(this.indexOf(p_val), 1);
    }
}

      
var validName= function(s){
  var strTmp = s.toLowerCase();
  non_asciis = {
    'a': '[àáâãäå]', 
    'ae': 'æ', 
    'c': 'ç', 
    'e': '[èéêë]', 
    'i': '[ìíîï]', 
    'n': 'ñ', 
    'o': '[òóôõö]', 
    'oe': 'œ', 
    'u': '[ùúûűü]', 
    'y': '[ýÿ]'
  };
  for (i in non_asciis) { 
    strTmp = strTmp.replace(new RegExp(non_asciis[i], 'g'), i);
  }
  //On enlève tous les caractères non alphanumérique, _ ou -
  strTmp = strTmp.replace(new RegExp('[^\\w-_]','ig'), '_');
  strTmp = strTmp.replace(new RegExp('_+','ig'), '_');
  strTmp = strTmp.replace(new RegExp('^_*','ig'), '');
  strTmp = strTmp.replace(new RegExp('_*$','ig'), '');
  strTmp = $('<div/>').text(strTmp).html();
  return strTmp;
};
var validVal = function(s){
  var strTmp = s.replace('"', '');
  strTmp = strTmp.replace("'", "");
  strTmp = strTmp.replace(new RegExp('_+','ig'), '_');
  strTmp = strTmp.replace(new RegExp('^_*','ig'), '');
  strTmp = strTmp.replace(new RegExp('_*$','ig'), '');
  strTmp = strTmp.replace(new RegExp('^ *','ig'), '');
  strTmp = strTmp.replace(new RegExp(' *$','ig'), '');
  strTmp = strTmp.replace(new RegExp(' +','ig'), ' ');
  return strTmp;
};
var validText = function(s){
  var strTmp = s.replace(new RegExp('_+','ig'), '_');
  strTmp = strTmp.replace(new RegExp('^_','ig'), '');
  strTmp = strTmp.replace(new RegExp('_$','ig'), '');
  strTmp = strTmp.replace(new RegExp('^ *','ig'), '');
  strTmp = strTmp.replace(new RegExp(' *$','ig'), '');
  strTmp = strTmp.replace(new RegExp(' +','ig'), ' ');
  return strTmp;
};
      
var addSpanTools = function (_this) {
  $(_this).prepend(
    $('<span class="toolsForm handle" ></span>').append(
      $('<button type="button"><span class="ui-icon ui-icon-pencil"></span></button>').click( function(){
        var me = $(this).parent().parent();
        var ctrl_type = $.trim(me.find("[class*=ctrl]").attr('class').match("ctrl-.*")[0].split(" ")[0].split("-")[1]);
        customize_ctrl(ctrl_type, me.attr('id'));
      })
      ).append(
      $('<button type="button"><span class="ui-icon ui-icon-trash"></span></button>').click( function(){
        var currentElem = $(this);
        $('<div id="removeConfirmationDialog"><p>'+_gt('Êtes-vous sûr de vouloir supprimer cet élément ?')+'</p></div>').dialog({
          autoOpen: true,
          modal: true,
          resizable: false,
          draggable: false,
          position: { my: "center top", at: "center top+10", of: window },
          title: ""+_gt("Supprimer l'élément ?")+"",
          buttons : [
            {
              text: _gt("Supprimer"),
              click: function() {
                $('*').blur();
                var me = currentElem.parent().parent();
                me.remove();
                checkAllName();
                $(this).dialog("close");
              }
            },{
              text: _gt("Annuler"),
              click : function() {
                $('*').blur();
                $(this).dialog("close");
              }
            }
          ],
          open: function() {
            var _this = $(this);
            $('.ui-widget-overlay').bind('click', function() {
              _this.dialog('close');
            })
          },
          close: function(){
            $('*').blur();
          }
        });
      })
      ).append('<button type="button" class="handle"><span class="ui-icon ui-icon-arrow-4"></span></button>')
    );
    $(_this).prepend($('<span class="form-icon" ></span>'));
}
      
var recusiveFieldset = function(_clonable){
  var clickable = $(_clonable).clone();
  clickable.find('.removeAtCopy, .removeAtCopyOnly').remove();
  clickable[0].id = "CTRL-DIV-"+(_ctrl_index++);

  addSpanTools(clickable);

  var tabInsideClickable = new Array();
  clickable.children('.fieldsetInside').children().each(function(i, _insiseClonable){
    var insideClickable = $(_insiseClonable).clone();
    if(insideClickable.hasClass( 'form_element' )){ 
      insideClickable.find('label.obligatoire, span.label.obligatoire').each(function(i, o){
        $(o).children('span.obligatoire').remove();
        $(o).append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
      });
      if(insideClickable.children('table').html() != undefined){
        insideClickable.children('table').find('tr').each(function(i, o){
          if(i > 0){
            var tmpLabelName = $(o).children('th').first().get(0).textContent;
            if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerHTML;
            if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerText;
            _tabNameUsed.push(validName(tmpLabelName));
          }
        });
      }
      if(insideClickable.children('input, textarea, select').attr('name') != undefined){
        if(_tabNameUsed.inArray(insideClickable.children('input, textarea, select').attr('name'))) {
          insideClickable.children('input, textarea, select').attr('name', '') ;
        }else{
          _tabNameUsed.push(insideClickable.children('input, textarea, select').attr('name'));
        }
      }
      insideClickable.find('.removeAtCopy, .removeAtCopyOnly ').remove();
      insideClickable[0].id = "CTRL-DIV-"+(_ctrl_index++);
      addSpanTools(insideClickable);
      tabInsideClickable.push(insideClickable);
    }else if(insideClickable.children('.fieldsetInside')) { 
      tabInsideClickable.push( recusiveFieldset(insideClickable));
    }
  });
  clickable.find('.form_element , fieldset').remove();
  clickable.appendTo("#futur_form");
  for(var insI=0; insI < tabInsideClickable.length; insI++){
    tabInsideClickable[insI].appendTo(clickable.children('.fieldsetInside'));
  }

  clickable.find('.fieldsetInside').sortable({
    cancel: null, // Cancel the default events on the controls
    handle: '.handle',
    connectWith: "#futur_form, .fieldsetInside",
    placeholder: "ui-state-highlight",
    items: "div:not(.ui-state-disabled)",
    start: function(e, ui){
      ui.placeholder.height(ui.item.height()+30);
    }
  }).disableSelection();

  return clickable;
};


var testFormIsValid = function(){
  var bValid =true;
  $('#futur_form').find('.form_element').find('.ctrl-paragraphe').each(function(i, o){
    if($(o).get(0) != undefined){
      if($(o).get(0).innerText == ""){
        bValid = false;
        var me = $(o).parents('.form_element');
        try{
          me.find('.notValid').remove();
          me.children('span.toolsForm').prepend(
            $('<button type="button" class="notValid"><span class="ui-icon ui-icon-alert"></span></button>').tooltip({ 
              content: _gt("Vous devez remplir ce paragraphe"),
              items: "span",
              position: {
                my: "right+50 bottom-20",
                at: "center top"
              },
              tooltipClass: "form_tooltip_notValid"
            }).click(function(){return false;})
          );
          me.addClass('notValid');
        }catch(err){
          me.find('.notValid').remove();
          me.children('span.toolsForm').prepend(
            $('<button type="button" class="notValid"><span class="ui-icon ui-icon-alert"></span></button>').click(function(){return false;})
          );
        }
        $('button#previewButton').attr('disabled', true);
      }else{
        $(o).parents('.form_element').find('.toolsForm .notValid').remove();
        $(o).parents('.form_element').removeClass('notValid');
      }
    }
  });
  
  $('#futur_form').find('.form_element').find('input, textarea.ctrl-textarea, select').each(function(i, o){
    if($(o).get(0) != undefined){
      if($(o).get(0).name == ""){
        bValid = false;
        var me = $(o).parents('.form_element');
        try{
          me.find('.notValid').remove();
          me.children('span.toolsForm').prepend(
            $('<button type="button" class="notValid"><span class="ui-icon ui-icon-alert"></span></button>').tooltip({ 
              content: _gt("Un ou plusieurs champs obligatoire de cet élément ne sont pas renseigné."),
              items: "span",
              position: {
                my: "right+50 bottom-20",
                at: "center top"
              },
              tooltipClass: "form_tooltip_notValid"
            }).click(function(){return false;})
          );
          me.addClass('notValid');
        }catch(err){
          me.find('.notValid').remove();
          me.children('span.toolsForm').prepend(
            $('<button type="button" class="notValid"><span class="ui-icon ui-icon-alert"></span></button>').click(function(){return false;})
          );
          me.addClass('notValid');
        }
        $('button#previewButton').attr('disabled', true);
      }else{
        $(o).parents('.form_element').find('.notValid').remove();
        $(o).parents('.form_element').removeClass('notValid');
      }
    }
  });
  if(bValid){ $('button#previewButton').removeAttr('disabled'); }
  return bValid;
};
    
var checkAllName = function(){
  _tabNameUsed = new Array();
  $('#futur_form .form_element , #futur_form fieldset').each(function(){
    if($(this).children('table').html() != undefined){
      $(this).children('table').find('tr').each(function(i, o){
        if(i > 0){
          var tmpLabelName = $(o).children('th').first().get(0).textContent;
          if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerHTML;
          if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerText;
          if(tmpLabelName!= undefined){
            if(_tabNameUsed.inArray(validName(tmpLabelName))) {
              var ind=2;
              _tmpLabelName= tmpLabelName
              /*while(_tabNameUsed.inArray(validName(tmpLabelName))) {
                tmpLabelName = _tmpLabelName+'('+ind+')';
                ind++;
              }*/
              if(_tabNameUsed.inArray(validName(tmpLabelName))) {
                tmpLabelName = '';
              }
              $(this).children('input, textarea, select').attr('name', '') ;
              if($(o).children('th').first().get(0).textContent != undefined){
                $(o).children('th').first().get(0).textContent = tmpLabelName;
              }else if( $(o).children('th').first().get(0).innerHTML != undefined){
                $(o).children('th').first().get(0).innerHTML = tmpLabelName;
              }else if( $(o).children('th').first().get(0).innerText != undefined){
                $(o).children('th').first().get(0).innerText = tmpLabelName;
              }
              $(o).find('input:radio, input:checkbox').attr('name', validName(tmpLabelName));
              //_tabNameUsed.push(validName(tmpLabelName));
              $(o).find('input:text').attr('name', validName(tmpLabelName+'_autre'));
            }else{
              _tabNameUsed.push(validName(tmpLabelName));
            }
          }
        }
      });
    }
    
    if($(this).children('input, textarea, select').attr('name') != undefined){
      if(_tabNameUsed.inArray($(this).children('input, textarea, select').attr('name'))) {
        $(this).children('input, textarea, select').attr('name', '') ;
      }else{
        _tabNameUsed.push($(this).children('input, textarea, select').attr('name'));
      }
    }
  });
  testFormIsValid();
};
    
    
$(document).ready(function(){
  
  var bIsHoverFuturForm = false;
  $('#futur_form').hover(function(){ bIsHoverFuturForm = true;} , function(){ bIsHoverFuturForm = false;} );
  
  _form_id = $('#futur_form').parent().attr('id');
  //On lance la compilation des template du plugin HandleBars
  compileTemplates();
  
  //Supprime les controleurs qui n'auraient pas été enlevé lors de l'enregistrement du formulaire
  $('span.toolsForm').remove();
        
  $( "#listOfFields" ).accordion({ 
    header: "span.accordion",
    heightStyle: "content",
    collapsible: false,
    icons: { header: "ui-icon-plus", activeHeader: "ui-icon-minus"}
  });
  
  try{
  $('#listOfFields').find('.form_element, .form_fieldset, .custom_element').find('button.removeAtCopy').tooltip({
      content: function(){ 
        var element = $(this).parent().clone();
        element.find('.removeAtCopy').remove();
        var text = element.text();
        return element;
      },
      items: "button",
      //track: true,
      position: {
        my: "left+10 center", 
        at: "right center"
      },
      tooltipClass: "form_tooltip"
    });
  }catch(err){
    //console.log(err);
  }
        
  //On parcours tous les elements rechargés pour les récupérer l'incrementation de l'ID et pour réactiver la possibilité de trier ses éléments
  $('#futur_form .form_element , #futur_form fieldset').each(function(){
    addSpanTools($(this));
    $(this).attr('id', "CTRL-DIV-"+_ctrl_index++);
    
  });
  checkAllName();
  $('#futur_form .form_fieldset').each(function(){
    $(this).children('legend').dblclick(function() {
      var me = $(this).parent();
      var ctrl_type = $.trim(me.find("[class*=ctrl]").attr('class').match("ctrl-.*")[0].split(" ")[0].split("-")[1]);
      customize_ctrl(ctrl_type, me.attr('id'));
    });
  });
  
  $('#futur_form .form_element').each(function(){
    $(this).find('label.obligatoire, span.label.obligatoire').each(function(i, o){
      $(o).children('span.obligatoire').remove();
      $(o).append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
    });
    $(this).dblclick(function() {
      var me = $(this);
      var ctrl_type = $.trim(me.find("[class*=ctrl]").attr('class').match("ctrl-.*")[0].split(" ")[0].split("-")[1]);
      customize_ctrl(ctrl_type, me.attr('id'));
    })
  });
   
  $('textarea.ctrl-paragraphe, textarea.ctrl-textarea, #futur_form input').attr('readonly','readonly');
  $('select.ctrl-combobox, #futur_form input:radio, #futur_form input:checkbox').attr('disabled', true);

  $( "#listOfFields fieldset" ).not('.notElement').click( function(){
    if(bIsHoverFuturForm) return false;
    var clickable = $(this).clone();
    clickable.find('.removeAtCopy, .removeAtCopyOnly').remove();
    clickable[0].id = "CTRL-DIV-"+(_ctrl_index++); // Attach an ID to the rendered control
    clickable.appendTo("#futur_form");
    addSpanTools(clickable);
    
    clickable.find('.fieldsetInside').sortable({
      cancel: null, // Cancel the default events on the controls
      handle: '.handle',
      connectWith: "#futur_form, .fieldsetInside",
      placeholder: "ui-state-highlight",
      items: "div:not(.ui-state-disabled)",
      start: function(e, ui){
        ui.placeholder.height(ui.item.height()+30);
      }
    }).disableSelection();
    
    clickable.children('legend').dblclick(function() {
      var me = $(this).parent();
      var ctrl_type = $.trim(me.find("[class*=ctrl]").attr('class').match("ctrl-.*")[0].split(" ")[0].split("-")[1]);
      customize_ctrl(ctrl_type, me.attr('id'));
    });
    
    $('textarea.ctrl-paragraphe, textarea.ctrl-textarea, #futur_form input').attr('readonly','readonly');
    $('select.ctrl-combobox, #futur_form input:radio, #futur_form input:checkbox').attr('disabled', true);
    testFormIsValid();
    checkAllName();
  });
        
  //Definie la création d'un élément
  $( "#listOfFields .form_element" ).click( function(){
    if(bIsHoverFuturForm) return false;
    var clickable = $(this).clone();
    clickable.find('.removeAtCopy, .removeAtCopyOnly').remove();
    clickable[0].id = "CTRL-DIV-"+(_ctrl_index++);
    clickable.appendTo("#futur_form");
          
    addSpanTools(clickable);
    
    clickable.dblclick(function() {
      var me = $(this);
      var ctrl_type = $.trim(me.find("[class*=ctrl]").attr('class').match("ctrl-.*")[0].split(" ")[0].split("-")[1]);
      customize_ctrl(ctrl_type, me.attr('id'));
    });
    
    $('textarea.ctrl-paragraphe, textarea.ctrl-textarea, #futur_form input').attr('readonly','readonly');
    $('select.ctrl-combobox, #futur_form input:radio, #futur_form input:checkbox').attr('disabled', true);
    testFormIsValid();
    checkAllName();
  });
        
  //Definie la création d'un élément
  $( "#listOfFields .custom_element" ).click( function(){
    if(bIsHoverFuturForm) return false;
    var _thisCustom = this;
    
    $('<div id="custom_element_insert" name="custom_element_insert" class="modal hide fade" />').append(
    '<dl><dt>'+_gt('Insérer')+' : </dt><dd>'+_gt('Insère la sélection à la fin de votre formulaire.')+'</dd><dt>'+_gt('Remplacer')+' : </dt><dd>'+_gt('Remplace votre formulaire courant par la sélection.')+'</dd></dl>').dialog({ 
    title: _gt('Comment souhaitez-vous insérer la sélection ?'),
    autoOpen: true,
    height: top.height,
    position: { my: "center top", at: "center top+10", of: window },
    maxHeight: 300,
    width: 600,
    closeText: _gt("Fermer"),
    modal: true,
    draggable: true,
    resizable: false,
    open: function() {
      var _this = $(this);
      $('.ui-widget-overlay').bind('click', function() {
        _this.dialog('close');
      })
    },
    close: function(){
      $('*').blur();
    },
    dialogClass: "dialogParam",
    hide: ({
      effect : 'drop', 
      direction : 'up', 
      duration: 300
    }),
    show: ({
      effect : 'drop', 
      direction : 'up', 
      duration: 300
    }),
    buttons: [
      {
        text: _gt("Insérer"),
        click : function() {
          $(_thisCustom).children('fieldset').each( function(i, _clonable){
            var clickable = $(_clonable).clone();
            clickable.find('.removeAtCopy, .removeAtCopyOnly').remove();
            clickable[0].id = "CTRL-DIV-"+(_ctrl_index++);

            addSpanTools(clickable);
            tabInsideClickable = new Array();

            clickable.children('.fieldsetInside').children().each(function(i, _insiseClonable){
              var insideClickable = $(_insiseClonable).clone();
              if(insideClickable.hasClass( 'form_element' )){ 
                insideClickable.find('label.obligatoire, span.label.obligatoire').each(function(i, o){
                  $(o).children('span.obligatoire').remove();
                  $(o).append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
                });
                if(insideClickable.children('table').html() != undefined){
                  insideClickable.children('table').find('tr').each(function(i, o){
                    if(i > 0){
                      var tmpLabelName = $(o).children('th').first().get(0).textContent;
                      if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerHTML;
                      if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerText;
                      _tabNameUsed.push(validName(tmpLabelName));
                    }
                  });
                }
                if(insideClickable.children('input, textarea, select').attr('name') != undefined){
                  if(_tabNameUsed.inArray(insideClickable.children('input, textarea, select').attr('name'))) {
                    insideClickable.children('input, textarea, select').attr('name', '') ;
                  }else{
                    _tabNameUsed.push(insideClickable.children('input, textarea, select').attr('name'));
                  }
                }
                insideClickable.find('.removeAtCopy, .removeAtCopyOnly').remove();
                insideClickable[0].id = "CTRL-DIV-"+(_ctrl_index++);
                addSpanTools(insideClickable);
                tabInsideClickable.push(insideClickable);
              }else if(insideClickable.children('.fieldsetInside')) { 
                tabInsideClickable.push(recusiveFieldset(insideClickable));
              }
            });
            clickable.find('.form_element , fieldset').remove();
            clickable.appendTo("#futur_form");
            for(var insI=0; insI < tabInsideClickable.length; insI++){
              tabInsideClickable[insI].appendTo(clickable.children('.fieldsetInside'));
            }

            clickable.find('.fieldsetInside').sortable({
              cancel: null, // Cancel the default events on the controls
              handle: '.handle',
              connectWith: "#futur_form, .fieldsetInside",
              placeholder: "ui-state-highlight",
              items: "div:not(.ui-state-disabled)",
              start: function(e, ui){
                ui.placeholder.height(ui.item.height()+30);
              }
            }).disableSelection();
          });


          $(_thisCustom).find('.form_element').each(function(i, _clonable){
            if($(_clonable).parent('.fieldsetInside').length > 0) return;
            var clickable = $(_clonable).clone();
            clickable.find('.removeAtCopy, .removeAtCopyOnly').remove();

            clickable[0].id = "CTRL-DIV-"+(_ctrl_index++);
            clickable.appendTo("#futur_form");
            
            clickable.find('label.obligatoire, span.label.obligatoire').each(function(i, o){
              $(o).children('span.obligatoire').remove();
              $(o).append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
            });
            addSpanTools(clickable);
          });
          $('textarea.ctrl-paragraphe, textarea.ctrl-textarea, #futur_form input').attr('readonly','readonly');
          $('select.ctrl-combobox, #futur_form input:radio, #futur_form input:checkbox').attr('disabled', true);
          testFormIsValid();
          checkAllName();
          
          $(this).dialog('close');
        }
      },
      {
        text: _gt("Remplacer"),
        click : function() {
          $("#futur_form").empty();
          
          $(_thisCustom).children('fieldset').each( function(i, _clonable){
            var clickable = $(_clonable).clone();
            clickable.find('.removeAtCopy, .removeAtCopyOnly').remove();
            clickable[0].id = "CTRL-DIV-"+(_ctrl_index++);

            addSpanTools(clickable);
            tabInsideClickable = new Array();

            clickable.children('.fieldsetInside').children().each(function(i, _insiseClonable){
              var insideClickable = $(_insiseClonable).clone();
              if(insideClickable.hasClass( 'form_element' )){ 
                insideClickable.find('label.obligatoire, span.label.obligatoire').each(function(i, o){
                  $(o).children('span.obligatoire').remove();
                  $(o).append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
                });
                if(insideClickable.children('table').html() != undefined){
                  insideClickable.children('table').find('tr').each(function(i, o){
                    if(i > 0){
                      var tmpLabelName = $(o).children('th').first().get(0).textContent;
                      if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerHTML;
                      if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerText;
                      _tabNameUsed.push(validName(tmpLabelName));
                    }
                  });
                }
                if(insideClickable.children('input, textarea, select').attr('name') != undefined){
                  if(_tabNameUsed.inArray(insideClickable.children('input, textarea, select').attr('name'))) {
                    insideClickable.children('input, textarea, select').attr('name', '') ;
                  }else{
                    _tabNameUsed.push(insideClickable.children('input, textarea, select').attr('name'));
                  }
                }
                insideClickable.find('.removeAtCopy, .removeAtCopyOnly').remove();
                insideClickable[0].id = "CTRL-DIV-"+(_ctrl_index++);
                addSpanTools(insideClickable);
                tabInsideClickable.push(insideClickable);
              }else if(insideClickable.children('.fieldsetInside')) { 
                tabInsideClickable.push(recusiveFieldset(insideClickable));
              }
            });
            clickable.find('.form_element , fieldset').remove();
            clickable.appendTo("#futur_form");
            for(var insI=0; insI < tabInsideClickable.length; insI++){
              tabInsideClickable[insI].appendTo(clickable.children('.fieldsetInside'));
            }

            clickable.find('.fieldsetInside').sortable({
              cancel: null, // Cancel the default events on the controls
              handle: '.handle',
              connectWith: "#futur_form, .fieldsetInside",
              placeholder: "ui-state-highlight",
              items: "div:not(.ui-state-disabled)",
              start: function(e, ui){
                ui.placeholder.height(ui.item.height()+30);
              }
            }).disableSelection();
          });


          $(_thisCustom).find('.form_element').each(function(i, _clonable){
            if($(_clonable).parent('.fieldsetInside').length > 0) return;
            var clickable = $(_clonable).clone();
            clickable.find('.removeAtCopy, .removeAtCopyOnly').remove();

            clickable[0].id = "CTRL-DIV-"+(_ctrl_index++);
            clickable.appendTo("#futur_form");
            
            clickable.find('label.obligatoire, span.label.obligatoire').each(function(i, o){
              $(o).children('span.obligatoire').remove();
              $(o).append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
            });

            addSpanTools(clickable);
          });
          $('textarea.ctrl-paragraphe, textarea.ctrl-textarea, #futur_form input').attr('readonly','readonly');
          $('select.ctrl-combobox, #futur_form input:radio, #futur_form input:checkbox').attr('disabled', true);
          testFormIsValid();
          checkAllName();
          
          $(this).dialog('close');
        }
      },
      {
        text: _gt("Annuler"),
        click : function() {
          $(this).dialog('close');
        }
      }
    ]
    });
    return false;
    
  });

  //Rend tous les élements dans la div du formulaire a créer sortable
  $( "#futur_form" ).sortable({
    cancel: null,
    handle: '.handle',
    connectWith: "#futur_form, .fieldsetInside",
    placeholder: "ui-state-highlight",
    start: function(e, ui){
      ui.placeholder.height(ui.item.height()+30);
    }
  }).disableSelection();
        
  //Rend l'interrieur de chaque fieldset rechargé sortable'
  $('#futur_form fieldset').each(function(){
    $(this).find('.fieldsetInside').sortable({
      cancel: null,
      handle: '.handle',
      connectWith: "#futur_form, .fieldsetInside",
      placeholder: "ui-state-highlight",
      items: "div:not(.ui-state-disabled)",
      start: function(e, ui){
        ui.placeholder.height(ui.item.height()+30);
      }
    }).disableSelection();
  });
  
  testFormIsValid();
});
      

/*
        Preview the customized form 
          -- Opens a new window and renders html content there.
* /
function preview() {
  // Sample preview - opens in a new window by copying content -- use something better in production code
		
  var selected_content = $("#futur_form").clone();
  selected_content.find("div").each(function(i,o) {
    var obj = $(o)
    obj.removeClass("draggableField ui-draggable well ui-droppable ui-sortable");
  });
  
  selected_content.find('.toolsForm').remove();
  selected_content.find('textarea.ctrl-paragraphe, textarea.ctrl-textarea, input').removeAttr('readonly');
  selected_content.find('select.ctrl-combobox, input:radio, input:checkbox').removeAttr('disabled');
  
  
  selected_content.find('textarea.ctrl-paragraphe').each(function(i,textarea){
    $(textarea).replaceWith(textarea.textContent);
  });
        
  selected_content.find("#form-title-div").remove();
		
  var selected_content_html = selected_content.html();
		
  var dialogContent  ='<!DOCTYPE HTML>\n<html lang="fr-FR">\n<head>\n<meta charset="UTF-8">\n<title></title>\n';
  dialogContent+='<style>\n'+$("#content-styles").html()+'\n</style>\n';
  dialogContent+= '</head>\n<body>';
  dialogContent+= selected_content_html;

  dialogContent+='<br/><br/><b>Code Source : </b><pre>'+$('<div/>').text(dialogContent).html();
  +'</pre>\n\n';

  dialogContent = dialogContent.replace('\n</body></html>','');
  dialogContent+= '\n</body></html>';
        
  var win = window.open("about:blank");
  win.document.write(dialogContent);
}
// */

if(typeof(console)=='undefined' || console==null) {
  console={};    
  console.log=function(){}
}

var addInputField = function(element, strName) {
  var parentElem = element.parent();
  strName = (strName == undefined || strName == '' ? 'option' : strName);
  element.after($('<input type="text" name="none" value="" placeholder="'+_gt("Cliquer pour ajouter une option")+'" />').focus(function(){
    var subCloned = $(this);
    addInputField(subCloned, strName);
  }));
  element.replaceWith(
    $('<span class="input">'+
      '<input type="text" name="'+strName+'[]" value="" placeholder="'+_gt("Saisisser ici votre option")+'" />'+
      '<button type="button" onclick=" $(this).parent().next(\'br\').remove();$(this).parent().remove();" class="deleteInput">X</button>'+
      '</span><br/>')
    );
  parentElem.find('span.input').last().find('input').focus();
        
}
      
/* Compile the templates for use */
function compileTemplates() {
  window.templates = {};
  window.templates.common = Handlebars.compile($("#control-customize-template").html());

  /* HTML Templates required for specific implementations mentioned below */
  window.templates.fieldset = Handlebars.compile($("#fieldset-template").html());
  window.templates.paragraphe = Handlebars.compile($("#paragraphe-template").html());

  window.templates.textbox = Handlebars.compile($("#textbox-template").html());
  window.templates.passwordbox = Handlebars.compile($("#passwordbox-template").html());
  window.templates.textarea = Handlebars.compile($("#textarea-template").html());

  window.templates.combobox = Handlebars.compile($("#combobox-template").html());
  window.templates.selectmultiplelist = Handlebars.compile($("#combobox-template").html());
  window.templates.radiogroup = Handlebars.compile($("#checkbox-template").html());
  window.templates.checkboxgroup = Handlebars.compile($("#checkbox-template").html());
  window.templates.gridradiogroup = Handlebars.compile($("#grid-template").html());
  window.templates.gridcheckboxgroup = Handlebars.compile($("#grid-template").html());
}

// Object containing specific "Save Changes" method
save_changes = {};

// Object comaining specific "Load Values" method. 
load_values = {};


/* Common method for all controls with Label and Name */
load_values.common = function(ctrl_type, ctrl_id) {
  var form = $("#theForm");
  var div_ctrl = $("#"+ctrl_id);
  if(div_ctrl.hasClass('form_element')){
    _currentNameLoaded = new Array();
    if(div_ctrl.children('table').html() != undefined){
      div_ctrl.children('table').find('tr').each(function(i,o){
        if(i > 0){
          var tmpLabelName = $(o).children('th').first().get(0).textContent;
          if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerHTML;
          if(tmpLabelName == undefined) tmpLabelName = $(o).children('th').first().get(0).innerText;
          _currentNameLoaded.push(validName(tmpLabelName));
        }
      });
    }else{
      if(div_ctrl.find('input:not(.autre), textarea, select').attr('name') != undefined){
        _currentNameLoaded = [validName(div_ctrl.find('input:not(.autre), textarea, select').attr('name'))];
      }
    }
  }
  //_tabNameUsed.removeElement(div_ctrl)
  div_ctrl.find('span.obligatoire:not(.label)').remove();
  form.find("[name=label]").val(div_ctrl.find('label').text())
  var specific_load_method = load_values[ctrl_type];
  if(typeof(specific_load_method)!='undefined') {
    specific_load_method(ctrl_type, ctrl_id);		
  }
}
	
/* Specific method to load values from a fieldset control to the customization dialog */
load_values.fieldset = function(ctrl_type, ctrl_id) {
  var form = $("#theForm");
  var div_ctrl = $("#"+ctrl_id);
  form.find("[name=legende]").val(div_ctrl.children('legend').text());
  //Recuperer Aide
  if(div_ctrl.children('span.aide').get(0) != undefined){
    form.find("[name=aide]").val(div_ctrl.children('span.aide').get(0).textContent);
  }
  if(div_ctrl.hasClass('colonne')){
    form.find("[name=colonne]").attr('checked',true);
  }
}
	
/* Specific method to load values from a paragraphe control to the customization dialog */
load_values.paragraphe = function(ctrl_type, ctrl_id) {
  var form = $("#theForm");
  var div_ctrl = $("#"+ctrl_id);
  //form.find("[name=paragraphe]").text(div_ctrl.find('textarea').text());
  form.find("[name=paragraphe]").text(div_ctrl.find('.ctrl-paragraphe').html());
  /* //Decommenté pour utiliser CKEditor
  if (CKEDITOR.instances.paragraphe) CKEDITOR.instances.paragraphe.destroy(true);
  form.find( 'textarea.paragraphe' ).ckeditor({
    toolbar: 'Basic',
    uiColor: '#ffffff',
    language: 'fr',
    customConfig: '/styles/ckconfig.js',
    stylesSet: 'styleperso:/styles/ckstyle.js',
    contentsCss: '/styles/editeur.css',
    //filebrowserBrowseUrl: '/scripts/editeur/editor/pdw_file_browser/index.php?editor=ckeditor&ServerPath=".ALK_VIRTUAL_DIR.$this->strRepUpload."&UrlRoot=".ALK_ROOT_URL',
    filebrowserBrowseUrl: '/scripts/editeur/editor/pdw_file_browser/index.php?editor=ckeditor&ServerPath=/upload/form/1/&UrlRoot=/upload/form/1/',
    resizable: false,
    draggable: false
  }).val( div_ctrl.find('.ctrl-paragraphe').html() );
  // */
}

/* Specific method to load values from a textbox control to the customization dialog */
load_values.textbox = function(ctrl_type, ctrl_id) {
  var form = $("#theForm");
  var div_ctrl = $("#"+ctrl_id);
  var ctrl = div_ctrl.find("input")[0];
  form.find("[name=name]").val(ctrl.name);
  form.find("[name=placeholder]").val(ctrl.placeholder);
  form.find("[name=type]").val(ctrl.type);
		
  ctrl.jstype = div_ctrl.find("input").attr('jstype');
  form.find("[name=jstype]").val(ctrl.jstype);
		
  if(ctrl.required){
    form.find("[name=required]").attr('checked',true);
  }
  //Recuperer Aide
  if(div_ctrl.find('span.aide').get(0) != undefined){
    form.find("[name=aide]").val(div_ctrl.find('span.aide').get(0).textContent);
  }
}
	
// Passwordbox uses the same functionality as textbox - so just point to that
load_values.text = load_values.textbox;
load_values.passwordbox = load_values.textbox;
load_values.email= load_values.textbox;
load_values.tel= load_values.textbox;
load_values.number= load_values.textbox;
load_values.date= load_values.textbox;
load_values.hidden= load_values.textbox;
load_values.file= load_values.textbox;

/* Specific method to load values from a textbox control to the customization dialog */
load_values.textarea = function(ctrl_type, ctrl_id) {
  var form = $("#theForm");
  var div_ctrl = $("#"+ctrl_id);
  var ctrl = div_ctrl.find("textarea")[0];
  form.find("[name=name]").val(ctrl.name);
  form.find("[name=placeholder]").val(ctrl.placeholder);
				
  if(ctrl.required){
    form.find("[name=required]").attr('checked',true);
  }
  form.find("[name=textarea]").val(ctrl.textarea);
  //Recuperer Aide
  if(div_ctrl.find('span.aide').get(0) != undefined){
    form.find("[name=aide]").val(div_ctrl.find('span.aide').get(0).textContent);
  }
}
	
/* Specific method to load values from a combobox control to the customization dialog  */
load_values.combobox = function(ctrl_type, ctrl_id) {
  var form = $("#theForm");
  var div_ctrl = $("#"+ctrl_id);
  var ctrl = div_ctrl.find("select")[0];
  form.find("[name=name]").val(ctrl.name.replace("[]", ""));
  form.find("[name=placeholder]").val(ctrl.placeholder);
        
  if($(ctrl).find('option.placeholder').length >0){
    form.find("[name=placeholder]").val($(ctrl).find('option.placeholder').get(0).text);
  }
        
  $(ctrl).find('option').each(function(i,o) { 
    if(o.className != 'placeholder'){
      $('.optionsComboBox').append('<span class="input">'+
        '<input type="text" name="option[]" value="'+o.text+'" placeholder="'+_gt("Ajouter un choix ici")+''+(i == 0 ? _gt(' (champ obligatoire)') : '' )+'" '+(i == 0 ? 'required' : '' )+' />'+
        (i > 0 ? '<button type="button" onclick=" $(this).parent().next(\'br\').remove();$(this).parent().remove();" class="deleteInput">X</button>' : '')+
        '</span><br/>');
    }
  });
  $('.optionsComboBox').append($('<input type="text" name="none" value="" placeholder="'+_gt("Cliquer pour ajouter une option")+'" />').focus(function(){
    var cloned = $(this);
    addInputField(cloned);
  }));
  if(ctrl.required){
    form.find("[name=required]").attr('checked',true);
  }
  if(ctrl.multiple){
    form.find("[name=multiple]").attr('checked',true);
  }
  form.find("[name=size]").val(ctrl.size);
  form.find("[name=required]").val(ctrl.required);
  //Recuperer Aide
  if(div_ctrl.find('span.aide').get(0) != undefined){
    form.find("[name=aide]").val(div_ctrl.find('span.aide').get(0).textContent);
  }
}
// Multi-select combobox has same customization features
load_values.selectmultiplelist = load_values.combobox;
	
/* Specific method to load values from a radio group */
load_values.radiogroup = function(ctrl_type, ctrl_id) {
  var form = $("#theForm");
  var div_ctrl = $("#"+ctrl_id);
  var ctrl = div_ctrl.find("input")[0];
  var radios = div_ctrl.find("input");
        
  $(radios).each(function(i,o) {
    if(o.className != 'autre' && (o.type == 'radio' || o.type == 'checkbox' )){
      if(o.required){
        form.find("[name=required]").attr('checked',true);
      }
      
      var label = $(o).next('label').get(0).textContent;
      if(label == undefined) label = $(o).next('label').get(0).innerText;
      if(label == undefined) label = $(o).next('label').get(0).innerHTML;
      $('.optionsCheckBox').append('<span class="input">'+
        '<input type="text" name="option[]" value="'+label+'" placeholder="'+_gt("Ajouter un choix ici")+''+(i == 0 ?_gt(' ( champ obligatoire )') : '' )+'" '+(i == 0 ? 'required' : '' )+' />'+
        (i > 0 ? '<button type="button" onclick=" $(this).parent().next(\'br\').remove();$(this).parent().remove();" class="deleteInput">X</button>' : '')+
        '</span><br/>');
    }else{
      form.find("[name=autre]").attr('checked',true);
      form.find("[name=autre]").val(ctrl.required);
    }
  });
  $('.optionsCheckBox').append($('<input type="text" name="none" value="" placeholder="'+_gt("Cliquer pour ajouter une option")+'" />').focus(function(){
    var cloned = $(this);
    addInputField(cloned);
  }));
  //Recuperer Aide
  if(div_ctrl.find('span.aide').get(0) != undefined){
    form.find("[name=aide]").val(div_ctrl.find('span.aide').get(0).textContent);
  }
  if(div_ctrl.find('span.label').get(0) != undefined){
    form.find("[name=titre]").val(div_ctrl.find('span.label').get(0).textContent);
  }
  form.find("[name=name]").val(radios[0].name);
}
	
// Checkbox group  customization behaves same as radio group
load_values.checkboxgroup = load_values.radiogroup;
      
      
      
load_values.gridradiogroup = function(ctrl_type, ctrl_id) {
  var form = $("#theForm");
  var div_ctrl = $("#"+ctrl_id);
  var table = div_ctrl.find('table');
        
  table.find('tr').each(function(tr,o){
    if(tr>0){
      var textTmp = $(o).find('th').first().get(0).textContent;
      if(textTmp == undefined) textTmp = $(o).find('th').first().get(0).innerText;
      if(textTmp == undefined) textTmp = $(o).find('th').first().get(0).innerHTML;
      $('.optionsGridRows').append('<span class="input">'+
        '<input type="text" name="rows[]" value="'+textTmp+'" placeholder="'+_gt("Ajouter un choix ici")+''+(tr > 1 ? '' : _gt(' ( champ obligatoire )') )+'" '+(tr >1 ? '' : 'required' )+' />'+
        (tr > 1 ? '<button type="button" onclick=" $(this).parent().next(\'br\').remove();$(this).parent().remove();" class="deleteInput">X</button>' : '')+
        '</span><br/>');
    }
  });
  $('.optionsGridRows').append($('<input type="text" name="none" value="" placeholder="'+_gt("Cliquer pour ajouter une option")+'" />').focus(function(){
    var cloned = $(this);
    addInputField(cloned, 'rows');
  }));
        
  table.find('tr').first().find('th').each(function(i,o){
    if(o.className != 'autre'){
      var textTmp = $(o).get(0).textContent;
      if(textTmp == undefined) textTmp = $(o).get(0).innerText;
      if(textTmp == undefined) textTmp = $(o).get(0).innerHTML;
        $('.optionsGridCols').append('<span class="input">'+
          '<input type="text" name="cols[]" value="'+textTmp+'" placeholder="'+_gt("Ajouter un choix ici")+''+(i > 1 ? '' : _gt(' ( champ obligatoire )') )+'" '+(i > 0 ? '' : 'required' )+' />'+
          (i > 0 ? '<button type="button" onclick=" $(this).parent().next(\'br\').remove();$(this).parent().remove();" class="deleteInput">X</button>' : '')+
          '</span><br/>');
    }else{
      form.find("[name=autre]").attr('checked',true);
    }
  });
  $('.optionsGridCols').append($('<input type="text" name="none" value="" placeholder="'+_gt("Cliquer pour ajouter une option")+'" />').focus(function(){
    var cloned = $(this);
    addInputField(cloned, 'cols');
  }));
        
  //Recupérer Titre
  if(div_ctrl.find('span.label').get(0) != undefined){
    form.find("[name=titre]").val(div_ctrl.find('span.label').get(0).textContent);
  }
  //Recuperer Aide
  if(div_ctrl.find('span.aide').get(0) != undefined){
    form.find("[name=aide]").val(div_ctrl.find('span.aide').get(0).textContent);
  }
  //Recupérer Required
  var radio = table.find(' input:radio , input:checkbox').first();
  if(radio.get(0).required){
    form.find("[name=required]").attr('checked',true);
  }
}
// Grid Checkbox group customization behaves same as Grid Radio group
load_values.gridcheckboxgroup = load_values.gridradiogroup;
      
      
/* Common method to save changes to a control  - This also calls the specific methods */
save_changes.common = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  if(values.label != undefined){
    div_ctrl.find('label').text(validText(values.label));
  }
  var specific_save_method = save_changes[values.type];
  if(typeof(specific_save_method)!='undefined') {
    specific_save_method(values);
  }
  testFormIsValid();
  $('textarea.ctrl-paragraphe, textarea.ctrl-textarea, #futur_form input').attr('readonly','readonly');
  $('select.ctrl-combobox, #futur_form input:radio, #futur_form input:checkbox').attr('disabled', true);
}
      
/* Specific method to save changes to a fieldset */
save_changes.fieldset = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  div_ctrl.children('legend').text(validText(values.legende));
        
  div_ctrl.children('span.aide').remove();
  if(values.aide != undefined && values.aide != ''){
    div_ctrl.children('legend').after('<span class="aide">'+validText(values.aide)+'</span>');
  }
  if(values.colonne){
    if(!div_ctrl.hasClass('colonne')){
      div_ctrl.addClass('colonne');
    }
  }else{
    div_ctrl.removeClass('colonne');
  }
}

/* Specific method to save changes to a paragraphe */
save_changes.paragraphe = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  //div_ctrl.find('textarea').text(validText(values.paragraphe));
  div_ctrl.find('.ctrl-paragraphe').text(validText(values.paragraphe));
  /* //Décommenter pour utiliser CKEditor
  try{
    var editor = CKEDITOR.instances.paragraphe;
    div_ctrl.find('.ctrl-paragraphe').html(editor.getData());
  }catch(err){console.log(err)}
  div_ctrl.find('.ctrl-paragraphe *').click(function(){event.preventDefault();});
  // */
}

/* Specific method to save changes to a text box */
save_changes.textbox = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  var ctrl = div_ctrl.find("input")[0];

  ctrl.name = validName(values.name);
  ctrl.type = values.type;
  div_ctrl.find("label").remove();
  div_ctrl.find('span.aide').remove();
  
  if(values.jstype != 'hidden'){  
    ctrl.placeholder = validVal(values.placeholder);
    
    ctrl.required = values.required;
    
    div_ctrl.find("input").attr('jstype', values.jstype);
    
    div_ctrl.find("input").before('<label/>');
    if(values.label != undefined){
      div_ctrl.find('label').text(validText(values.label));
    }
    div_ctrl.find("label").attr('for', 'form_'+_form_id+'_'+validName(values.name));
    if(values.required){
      div_ctrl.find("label").append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
      div_ctrl.find("label").addClass('obligatoire');
    }else{
      div_ctrl.find("label").children('.obligatoire').remove();
      div_ctrl.find("label").removeClass('obligatoire');
    }

    div_ctrl.find("input").attr('id', 'form_'+_form_id+'_'+validName(values.name));

    if(values.aide != undefined && values.aide != ''){
      div_ctrl.children('label').after('<span class="aide">'+validText(values.aide)+'</span>');
    }
  }else{
    ctrl.required = false;
    div_ctrl.find("label").children('.obligatoire').remove();
    div_ctrl.find("label").removeClass('obligatoire');
    div_ctrl.find("input").removeAttr('placeholder');
    div_ctrl.find("input").attr('jstype', values.jstype);
  }
}

// Password box customization behaves same as textbox
save_changes.text= save_changes.textbox;
save_changes.password= save_changes.textbox;
save_changes.email= save_changes.textbox;
save_changes.tel= save_changes.textbox;
save_changes.number= save_changes.textbox;
save_changes.date= save_changes.textbox;
save_changes.hidden= save_changes.textbox;
save_changes.file= save_changes.textbox;

/* Specific method to save changes to a text box */
save_changes.textarea = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  var ctrl = div_ctrl.find("textarea")[0];
        
  div_ctrl.find('span.aide').remove();
  if(values.aide != undefined && values.aide != ''){
    div_ctrl.children('label').after('<span class="aide">'+validText(values.aide)+'</span>');
  }
    
  div_ctrl.find("label").attr('for', 'form_'+_form_id+'_'+validName(values.name));
  if(values.required){
    div_ctrl.find("label").append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
    div_ctrl.find("label").addClass('obligatoire');
  }else{
    div_ctrl.find("label").children('.obligatoire').remove();
    div_ctrl.find("label").removeClass('obligatoire');
  }
  
  div_ctrl.find("textarea").attr('id', 'form_'+_form_id+'_'+validName(values.name));
  ctrl.name = validName(values.name);
  ctrl.required = values.required;
  ctrl.placeholder = $("#theForm").find("[name=placeholder]").val();
}

/* Specific method to save changes to a combobox */
save_changes.combobox = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  var ctrl = div_ctrl.find("select")[0];
  ctrl.name = validName(values.name.replace('[]', ''));
  ctrl.multiple = values.multiple;
  div_ctrl.find("label").attr('for', 'form_'+_form_id+'_'+validName(values.name.replace('[]', '')));
  if(values.required){
    div_ctrl.find("label").append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
    div_ctrl.find("label").addClass('obligatoire');
  }else{
    div_ctrl.find("label").children('.obligatoire').remove();
    div_ctrl.find("label").removeClass('obligatoire');
  }
  
  div_ctrl.find("select").attr('id', 'form_'+_form_id+'_'+validName(values.name.replace('[]', '')));
  div_ctrl.find("select").attr('name', validName(values.name.replace('[]', ''))+(values.multiple ? '[]' : ''));
        
  div_ctrl.find('span.aide').remove();
  if(values.aide != undefined && values.aide != ''){
    div_ctrl.children('label').after('<span class="aide">'+validText(values.aide)+'</span>');
  }
        
  $(ctrl).empty();
        
  ctrl.placeholder = values.placeholder;
  if(!values.multiple){
    if(values.placeholder != '') {
      $(ctrl).prepend('<option class="placeholder" value="" selected="selected" disabled>'+validText(values.placeholder)+'</option>');
    }
  }
        
  for(var opt=0; opt < values.option.length ;opt++){
    if(values.option[opt] == '') continue;
    $(ctrl).append('<option value="'+validVal(values.option[opt])+'">'+validText(values.option[opt])+'</option>');
  }
  ctrl.size = values.size;
  ctrl.required = values.required;
}
	
/* Specific method to save a radiogroup */
save_changes.radiogroup = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  $(div_ctrl).find('.checkable').remove();
  $(div_ctrl).find('.ctrl-radiogroup').next('label').remove();
  $(div_ctrl).find('.ctrl-radiogroup').remove();
  $(div_ctrl).find('.autre').remove();
  $(div_ctrl).find('br').remove();
  div_ctrl.find('span.label').remove();
  div_ctrl.find('span.aide').remove();
  
  if(values.aide != undefined && values.aide != ''){
    $(div_ctrl).prepend('<span class="aide">'+validText(values.aide)+'</span>');
  }
  if(values.titre != undefined && values.titre != ''){
    $(div_ctrl).prepend('<span class="label">'+validText(values.titre)+'</span>');
    if(values.required){
      div_ctrl.find(".label").append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
      div_ctrl.find(".label").addClass('obligatoire');
    }else{
      div_ctrl.find(".label").children('.obligatoire').remove();
      div_ctrl.find(".label").removeClass('obligatoire');
    }
  }
  $(div_ctrl).append('<span class="checkable"></span>');
  
  for(var opt=0; opt < values.option.length ;opt++){
    if(values.option[opt] == '') continue;
    $(div_ctrl).find('.checkable').append('<input id="form_'+_form_id+'_'+validName(values.name)+'_'+opt+'" class="ctrl-radiogroup" type="radio" name="'+validName(values.name)+'" value="'+validVal(values.option[opt])+'" '+(values.required ? "required" : "")+' /><label for="form_'+_form_id+'_'+validName(values.name)+'_'+opt+'">'+validText(values.option[opt])+'</label>'+(opt <= values.option.length-1 ? '<br/>' : ''));
  }
  if(values.autre){
    $(div_ctrl).find('.checkable').append('<input id="form_'+_form_id+'_'+validName(values.name)+'" type="radio" class="autre" name="'+validName(values.name)+'" value="autre" '+(values.required ? "required" : "")+' /><label for="form_'+_form_id+'_'+validName(values.name)+'_autre"class="autre">'+_gt("Autre : ")+'</label><input id="form_'+_form_id+'_'+validName(values.name)+'_autre" class="autre" type="text" name="'+validName(values.name)+'_autre" placeholder="'+_gt("Votre valeur")+'" />');
  }
}
	
/* Same as radio group, but separated for simplicity */
save_changes.checkboxgroup = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  $(div_ctrl).find('.checkable').remove();
  $(div_ctrl).find('.ctrl-checkboxgroup').next('label').remove();
  $(div_ctrl).find('.ctrl-checkboxgroup').remove();
  $(div_ctrl).find('.autre').remove();
  $(div_ctrl).find('br').remove();
  div_ctrl.find('span.label').remove();
  div_ctrl.find('span.aide').remove();
  
  if(values.aide != undefined && values.aide != ''){
    $(div_ctrl).prepend('<span class="aide">'+validText(values.aide)+'</span>');
  }
  if(values.titre != undefined && values.titre != ''){
    $(div_ctrl).prepend('<span class="label">'+validText(values.titre)+'</span>');
    if(values.required){
      div_ctrl.find(".label").append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
      div_ctrl.find(".label").addClass('obligatoire');
    }else{
      div_ctrl.find(".label").children('.obligatoire').remove();
      div_ctrl.find(".label").removeClass('obligatoire');
    }
  }
  
  $(div_ctrl).append('<span class="checkable"></span>');
  for(var opt=0; opt < values.option.length ;opt++){
    if(values.option[opt] == '') continue;
    $(div_ctrl).find('.checkable').append('<input id="form_'+_form_id+'_'+validName(values.name)+'_'+opt+'" class="ctrl-checkboxgroup" type="checkbox" name="'+validName(values.name)+'" value="'+validVal(values.option[opt])+'" '+(values.required ? "required" : "")+' /><label for="form_'+_form_id+'_'+validName(values.name)+'_'+opt+'">'+validText(values.option[opt])+'</label>'+(opt <= values.option.length-1 ? '<br/>' : ''));
  }
  if(values.autre){
    $(div_ctrl).find('checkable').append('<input id="form_'+_form_id+'_'+validName(values.name)+'" type="checkbox" class="autre" name="'+validName(values.name)+'" value="autre" '+(values.required ? "required" : "")+' /><label for="form_'+_form_id+'_'+validName(values.name)+'_autre" class="autre">'+_gt("Autre : ")+'</label><input id="form_'+_form_id+'_'+validName(values.name)+'_autre" class="autre" type="text" name="'+validName(values.name)+'_autre" placeholder="'+_gt("Votre valeur")+'" />');
  }
}
	
/* Same as radio group, but separated for simplicity */
save_changes.gridradiogroup = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  var table = div_ctrl.find('table');
  div_ctrl.find('p').remove();
  div_ctrl.find('span.label').remove();
  div_ctrl.find('span.aide').remove();
        
  if( ( values.aide != undefined && values.aide != '' ) || ( values.titre != undefined && values.titre != '' ) ){
    table.before('<p></p>');
  }
  
  if(values.titre != undefined && values.titre != ''){
    table.prev('p').append('<span class="label">'+validText(values.titre)+'</span>');
    if(values.required){
      div_ctrl.find(".label").append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
      div_ctrl.find(".label").addClass('obligatoire');
    }else{
      div_ctrl.find(".label").children('.obligatoire').remove();
      div_ctrl.find(".label").removeClass('obligatoire');
    }
  }
  if(values.aide != undefined && values.aide != ''){
    table.prev('p').append('<span class="aide">'+validText(values.aide)+'</span>');
  }
        
  table.empty();
  var indiceSupplIfAutre = (values.autre ? 1 : 0);
  for( var rowI = -1; rowI < values.rows.length; rowI++){
    table.append('<tr>');
    var tr = table.find('tbody').children('tr').last();
    for( var colI = -1; colI < values.cols.length+indiceSupplIfAutre; colI++){
      if(rowI == -1 && colI == -1){
        tr.append('<td>');
      }else if(rowI == -1 && colI >= 0 && colI < values.cols.length){
        tr.append($('<th>'+validText(values.cols[colI])+'</th>'));
      }else if(rowI >= 0 && colI == -1){
        tr.append($('<th>'+validText(values.rows[rowI])+'</th>'));
      }else if(rowI == -1 && colI == values.cols.length){
        tr.append('<th class="autre">'+_gt("Autre")+'</th>');
      }else if(rowI >= 0 && colI == values.cols.length){
        tr.append($('<td class="autre">').append('<input type="radio" class="autre" name="'+validName(values.rows[rowI])+'" value="autre" '+(values.required ? "required" : "" )+' /><input type="text" class="autre" value="" name="'+validName(values.rows[rowI])+'_autre" placeholder="'+_gt("Votre valeur")+'" />'));
      }else {
        tr.append($('<td>').append('<input type="radio" name="'+validName(values.rows[rowI])+'" value="'+validVal(values.cols[colI])+'" '+(values.required ? "required" : "" )+' />'));
      }
    }
  }
}
  
/* Same as radio group, but separated for simplicity */
save_changes.gridcheckboxgroup = function(values) {
  var div_ctrl = $("#"+values.forCtrl);
  var table = div_ctrl.find('table');
  div_ctrl.find('p').remove();
  div_ctrl.find('span.label').remove();
  div_ctrl.find('span.aide').remove();
  
  if( ( values.aide != undefined && values.aide != '' ) || ( values.titre != undefined && values.titre != '' ) ){
    table.before('<p></p>');
  }
        
  if(values.titre != undefined && values.titre != ''){
    table.prev('p').append('<span class="label">'+values.titre+'</span>');
    if(values.required){
      div_ctrl.find(".label").append('<span class="obligatoire">&nbsp;*&nbsp;</span>');
      div_ctrl.find(".label").addClass('obligatoire');
    }else{
      div_ctrl.find(".label").children('.obligatoire').remove();
      div_ctrl.find(".label").removeClass('obligatoire');
    }
  }
  if(values.aide != undefined && values.aide != ''){
    table.prev('p').append('<span class="aide">'+values.aide+'</span>');
  }
        
  table.empty();
  var indiceSupplIfAutre = (values.autre ? 1 : 0);
  for( var rowI = -1; rowI < values.rows.length; rowI++){
    table.append('<tr>');
    var tr = table.find('tbody').children('tr').last();
    for( var colI = -1; colI < values.cols.length+indiceSupplIfAutre; colI++){
      if(rowI == -1 && colI == -1){
        tr.append('<td>');
      }else if(rowI == -1 && colI >= 0 && colI < values.cols.length){
        tr.append($('<th>'+values.cols[colI]+'</th>'));
      }else if(rowI >= 0 && colI == -1){
        tr.append($('<th>'+values.rows[rowI]+'</th>'));
      }else if(rowI == -1 && colI == values.cols.length){
        tr.append('<th class="autre">'+_gt("Autre")+'</th>');
      }else if(rowI >= 0 && colI == values.cols.length){
        tr.append($('<td class="autre">').append('<input type="checkbox" class="autre" name="'+validName(values.rows[rowI])+'" value="autre" '+(values.required ? "required" : "" )+' /><input type="text" class="autre" value="" name="'+validName(values.rows[rowI])+'_autre" placeholder="'+_gt("Votre valeur")+'" />'));
      }else {
        tr.append($('<td>').append('<input type="checkbox" name="'+validName(values.rows[rowI])+'" value="'+validVal(values.cols[colI])+'" '+(values.required ? "required" : "" )+' />'));
      }
    }
  }
}
  
// Multi-select customization behaves same as combobox
save_changes.selectmultiplelist = save_changes.combobox;
	
/* Specific method for Button */
/*
      save_changes.btn = function(values) {
        var div_ctrl = $("#"+values.forCtrl);
        var ctrl = div_ctrl.find("button")[0];
        $(ctrl).html($(ctrl).html().replace($(ctrl).text()," "+$.trim(values.label)));
        ctrl.name = values.name;
      }*/
  
/* Save the changes due to customization 
        - This method collects the values and passes it to the save_changes.methods
       */
function save_customize_changes(e, obj) {
  var formValues = {};
  var val=null;
  $("#theForm").find("input, textarea, select").each(function(i,o) {
    if(o.type=="checkbox"){
      val = o.checked;
    } else {
      val = o.value;
    }
    if(o.name.indexOf("[]") != -1){
      var tmpName = o.name.replace('[]', '');
      if(formValues[tmpName] == undefined){
        formValues[tmpName] = new Array();
      }
      formValues[tmpName].push(val);
            
    }else{
      formValues[o.name] = val;
    }
  });
  save_changes.common(formValues);
  checkAllName();
}
	
/*
        Opens the customization window for this
       */
function customize_ctrl(ctrl_type, ctrl_id) {
  var ctrl_params = {};
  /* Load the specific templates */
  var specific_template = templates[ctrl_type];
  if(typeof(specific_template)=='undefined') {
    specific_template = function(){
      return '';
    };
  }
  var template_params = {
    content: specific_template(ctrl_params), 
    type: ctrl_type,
    forCtrl: ctrl_id
  }
  // Pass the parameters - along with the specific template content to the Base template
  var s = templates.common(template_params)+"";
        
  $("[name=form_element_editor]").remove(); // Making sure that we just have one instance of the modal opened and not leaking
  $('<div id="form_element_editor" name="form_element_editor" class="modal hide fade" />').append(s).dialog({
    title: _gt('Éditer l\'élément'),//$("#"+ctrl_id).find('.toolsForm + label:first-of-type, span.label').text(),
    autoOpen: true,
    height: top.height,
    position: { my: "center top", at: "center top+10", of: window },
    maxHeight: 500,
    width: 600,
    closeText: _gt("Fermer"),
    modal: true,
    draggable: true,
    resizable: false,
    dialogClass: "dialogParam",
    hide: ({
      effect : 'drop', 
      direction : 'up', 
      duration: 300
    }),
    show: ({
      effect : 'drop', 
      direction : 'up', 
      duration: 300
    }),
    buttons: [
      {
        text: _gt("Sauver"),
        click : function() {
          //TODO : Tester si le formulaire est valide avant de sauvegarder et fermer la popup (surtout tester les required)
          var bOk = true;
          
          $('#form_element_editor form').find('input:text').each(function(i,o){
            if( (o.required && o.value =='' && o.name != 'label' ) || ( o.name == 'label' && o.value =='' && $('#form_element_editor form').find('select[name=jstype]').val() != "hidden" ) ){
              $(o).focus(); 
              $( '<div id="dialog_warning">'+( $(o).prev('label').html() != undefined ? $(o).prev('label').get(0).textContent+_gt(' ne peut être vide pour cet élément.') : _gt('Un des champs obligatoire est vide') )+'</div>').dialog({
                title: _gt('Attention'),
                height: 100,
                width: 360,
                modal: true,
                draggable: false,
                resizable: false,
                open: function() {
                  var _this = $(this);
                  $('.ui-widget-overlay').bind('click', function() {
                    _this.dialog('close');
                  })
                }
              });
              bOk=false;
              return false;
            }
          });
          if(bOk){
            if( $('#form_element_editor form').find('.optionsGridRows').html() != undefined){
              var tabTmpName = new Array();
              $('#form_element_editor form').find('.optionsGridRows').find('input:text').each(function(i, o){
                if($(o).val() != '' &&  $(o).val() != undefined){
                  if(!_currentNameLoaded.inArray(validName( $(o).val() ) )){
                    if(_tabNameUsed.inArray( validName( $(o).val() ) ) ){
                      $( '<div id="dialog_warning">'+_gt("Le nom")+' : "'+ validName( $(o).val() ) +'" '+_gt("est déjà utilisé.")+'</div>').dialog({
                        title: _gt('Attention'),
                        height: 100,
                        width: 360,
                        modal: true,
                        draggable: false,
                        resizable: false,
                        open: function() {
                          var _this = $(this);
                          $('.ui-widget-overlay').bind('click', function() {
                            _this.dialog('close');
                          })
                        },
                        close: function(){
                          $(o).focus(); 
                        }
                      });
                      bOk=false;
                      return false;
                    }else{
                      tabTmpName.push(validName( $(o).val() ));
                    }
                  }
                }
              });
              if(bOk) {
                _tabNameUsed = _tabNameUsed.concat(tabTmpName)
              }
            }
            if( $('#form_element_editor form').find('input:text[name=name]').val() != undefined){
              if(! _currentNameLoaded.inArray(validName( $('#form_element_editor form').find('input:text[name=name]').val() ) )){
                if(_tabNameUsed.inArray( validName( $('#form_element_editor form').find('input:text[name=name]').val() ) ) ){
                  $( '<div id="dialog_warning">'+_gt('Le nom')+' : "'+validName( $('#form_element_editor form').find('input:text[name=name]').val() ) +'" '+_gt("est déjà utilisé.")+'</div>').dialog({
                    title: 'Attention',
                    height: 100,
                    width: 360,
                    modal: true,
                    draggable: false,
                    resizable: false,
                    open: function() {
                      var _this = $(this);
                      $('.ui-widget-overlay').bind('click', function() {
                        _this.dialog('close');
                      })
                    },
                    close: function(){
                      $('#form_element_editor form').find('input:text[name=name]').focus(); 
                    }
                  });
                  bOk=false;
                  return;
                }else{
                  _tabNameUsed.push(validName($('#form_element_editor form').find('input:text[name=name]').val()));
                }
              }
            }
          }

          if(bOk){
            $('*').blur();
            save_customize_changes();
            $( this ).dialog( "close" );
          }
        }
      }, {
        text: _gt("Fermer"),
        click : function() {
          $('*').blur();
          $( this ).dialog( "close" );
        }
      }
    ],
    open: function() {
      var _this = $(this);
      $('.ui-widget-overlay').bind('click', function() {
        _this.dialog('close');
      })
    },
    close: function(){$('*').blur();}
  });
  //save_customize_changes()
		
  setTimeout(function() {
    // For some error in the code  modal show event is not firing - applying a manual delay before load
    load_values.common(ctrl_type, ctrl_id);
  },300);
}

//var bIsPageAliasUnique = false;
var AlkNbClickValid = 0;
function Validation(strToken, strTokenUnicite)
{
  if(testFormIsValid()==false){ 
    $( '<div id="dialog_warning">'+_gt("Au moins l'un de vos champs est invalide.")+'</div>').dialog({
      title: _gt('Attention'),
      height: 120,
      width: 360,
      modal: true,
      draggable: false,
      resizable: false,
      buttons: [ { text: "Ok", click: function() { $( this ).dialog( "close" ); } } ],
      open: function() {
        var _this = $(this);
        $('.ui-widget-overlay').bind('click', function() {
          $('*').blur();
          _this.dialog('close');
        })
      },
      close: function(){
        $('*').blur();
      }
    });
    return false;
  }else{
    if( AlkNbClickValid == 0 ) {
      var alkForm = $('#futur_form').clone();
      alkForm.find('span.toolsForm').remove();
      alkForm.find('span.form-icon').remove();
      alkForm.find('label span.obligatoire, span.label .obligatoire').remove();

      alkForm.find('textarea.ctrl-paragraphe, textarea.ctrl-textarea, input').removeAttr('readonly');
      alkForm.find('select.ctrl-combobox, input:radio, input:checkbox').removeAttr('disabled');

      alkForm.find('textarea.ctrl-paragraphe').each(function(i,textarea){
        $(textarea).parents('.form_element').replaceWith($('<p class="form_paragraphe">'+$(textarea).html()+'</p>'));
      });
      /* //Decommenter pour utiliser CKEditor
      alkForm.find('.ctrl-paragraphe').each(function(i,textarea){
        $(textarea).parents('.form_element').replaceWith($('<div class="ctrl-paragraphe">'+$(textarea).html()+'</div>'));
      });
      // */
      alkForm.find('.form_element, .form_fieldset').removeAttr('id');
      alkForm.find('.form_element, .form_fieldset').removeAttr('style');
      alkForm.find('.form_fieldset').find('.fieldsetInside').removeClass('ui-sortable');
      alkForm.find('.form_element').find('input[type=file], input[type=date], input[type=hidden]').removeAttr('value');
      alkForm.find('.form_element').find('input[jstype=file], input[jstype=date], input[jstype=hidden]').removeAttr('value');
      alkForm.find('.form_element').find('input[type=file], input[type=date], input[type=hidden]').removeAttr('placeholder');
      alkForm.find('.form_element').find('input[jstype=file], input[jstype=date], input[jstype=hidden]').removeAttr('placeholder');
      
      alkForm.find('.form_inputText, .form_inputPassword, .form_textarea, .form_combobox, .form_radio, .form_checkbox').each(function(i, o){
        if($(o).hasClass('form_inputText') || $(o).hasClass('form_inputPassword') ){
          $(o).children('label').attr('for', 'form_'+_form_id+'_'+$(o).children('input').attr('name'));
          $(o).children('input').attr('id', 'form_'+_form_id+'_'+$(o).children('input').attr('name'));
          //form_'+_form_id+'_'+validName(values.name)+'_'+opt+'
        }else if( $(o).hasClass('form_textarea') ){
          $(o).children('label').attr('for', 'form_'+_form_id+'_'+$(o).children('textarea').attr('name'));
          $(o).children('textarea').attr('id', 'form_'+_form_id+'_'+$(o).children('textarea').attr('name'));
        }else if( $(o).hasClass('form_combobox') ){
          $(o).children('label').attr('for', 'form_'+_form_id+'_'+$(o).children('select').attr('name'));
          $(o).children('select').attr('id', 'form_'+_form_id+'_'+$(o).children('select').attr('name'));
        }else if( $(o).hasClass('form_radio') ){
          var indAutre = 0;
          $(o).children('input:radio').each(function(ir, r){
            if($(r).hasClass('autre')){
              indAutre = ir;
            }else{
              $(r).next('label').attr('for', 'form_'+_form_id+'_'+$(r).attr('name')+'_'+ir);
              $(r).attr('id', 'form_'+_form_id+'_'+$(r).attr('name')+'_'+ir);
            }
          });
          $(o).children('input:text.autre').attr('id', 'form_'+_form_id+'_'+$(o).children('input:text.autre').attr('name')+'_'+indAutre);
          $(o).children('input:text.autre').prev('label').attr('for', 'form_'+_form_id+'_'+$(o).children('input:text.autre').attr('name')+'_'+indAutre);
        }else if( $(o).hasClass('form_checkbox') ){
          var indAutre = 0;
          $(o).children('input:checkbox').each(function(ic, c){
            if($(c).hasClass('autre')){
              indAutre = ic;
            }else{
              $(c).next('label').attr('for', 'form_'+_form_id+'_'+$(c).attr('name')+'_'+ic);
              $(c).attr('id', 'form_'+_form_id+'_'+$(c).attr('name')+'_'+ic);
            }
          });
          $(o).children('input:text.autre').attr('id', 'form_'+_form_id+'_'+$(o).children('input:text.autre').attr('name')+'_'+indAutre);
          $(o).children('input:text.autre').prev('label').attr('for', 'form_'+_form_id+'_'+$(o).children('input:text.autre').attr('name')+'_'+indAutre);
        }
      });
      alkFormDisplay = alkForm.clone();
      alkForm.prepend($('<span class="alkFormBuilder"/>'));
      
      var form = document.createElement('form');
      form.setAttribute('action', strTokenUnicite);
      form.setAttribute('method', 'post');
      var inputvar = document.createElement('input');
      inputvar.setAttribute('type', 'hidden');
      inputvar.setAttribute('name', 'formulaire');
      inputvar.setAttribute('value', TextEncode(alkForm.html()));
      form.appendChild(inputvar);
      
      var inputvar2 = document.createElement('input');
      inputvar2.setAttribute('type', 'hidden');
      inputvar2.setAttribute('name', 'formulaire_display');
      inputvar2.setAttribute('value', TextEncode(alkFormDisplay.html()));
      form.appendChild(inputvar2);
      
      document.body.appendChild(form);
      AlkNbClickValid++;
      form.submit();
    }else{alert(_gt("Votre clique a déjà été pri en compte."));}
  }
  return false;
}
