<?php
require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkfactory.class.php";
require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkappli.class.php";
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_GEdit
 * @class AlkHtmlFormGEditForm
 * Classe d'affichage de la page de gestion éditoriale 
 */

class AlkHtmlFileManager extends AlkHtmlForm{

  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application associée
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formPage");

    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_UPDATE);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { /** rien à faire **/ }

  /**
   * Traitement du formulaire
   */
  public function doSql() { /** rien à faire **/ }
  
  /**
   * Construction du formulaire
   */
  public function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);  
      
    $oPanelSheet = AlkHtmlFactory::getHtmlPanel("_formPage", "");
    $oPanelSheet->setIsStyleTitle(false);
    $this->addPanel($oPanelSheet);
    
    $oBlockFileManager = $this->getBlockFileManager();
    $oPanelSheet->addPanel($oBlockFileManager);
    

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."gedit/lib/alkhtmlformgeditform.js");
  }
  
  public function getTitle(){
    return "Gestionnaire de fichiers";
  }
  
  public function getBlockFileManager()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE,
          "&ServerPath=".ALK_VIRTUAL_DIR.ALK_ROOT_UPLOAD."gedit/".$cont_id."/".
          "&UrlRoot=".ALK_ROOT_URL.
          "&CKEditor=TextHtml" .
          "&CKEditorFuncNum=1" .
          "&langCode=fr");
    $oBlockFileManager  = $this->addBlock("BlockFileManager",  "Gestionnaire de Fichiers", "", "10", "750", true);
    $strHtml = "<br /><a href=\"javascript:OpenFileManager('".$strToken."', '".$cont_id."')\" >Gestionnaire de fichiers dans une fenetre</a>";
    $oCtrlHtml = AlkHtmlFactory::getHtml($strHtml);
    $oBlockFileManager->addCtrl($oCtrlHtml);
    return $oBlockFileManager; 
  }

}
?>