<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::GEdit
Module gestion éditoriale.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkquery.class.php");

/**
 * @package Alkanet_Module_GEdit
 * @class AlkQueryGEditAction
 * Ensemble des requetes actions liées à l'application GEdit
 */
class AlkQueryGEditAction extends AlkQuery
{
  protected $tabLastPageIdAdded;

  /**
   * Constructeur par défaut
   */ 
  public function __construct(&$oDb)
  {
    parent::__construct($oDb);
    $this->tabLastPageIdAdded = array(-1, -1);
  }

  /**
   * Destructeur par défaut
   */
  public function __destruct() { }    

  /**
   * Ajout d'une page et de sa page brouillon. Retourne l'identifiant de la page brouillon créée
   * 
   * @return int
   */
  public function addPage($tab_page_titre, $tab_page_titre_court, $tab_page_alias, $tab_page_titrenav, $tab_page_motcle, $tab_page_desc, 
                          $page_datepdeb, $page_datepfin, $page_rang, $page_validepub, $page_parent,
                          $page_niveau, $page_arbre_parent, $page_racine_droit, $agent_id, $appli_id, $page_repertoire="", 
                          $page_visible_menu="0", $page_redirection="", $page_target="0", $page_public=0,
                          $page_template="", $page_validesynd=0, $page_aptypeid="23_0", $page_appliid=-1, $page_catid=-1, $bSetRight=true)
  {
    $this->tabLastPageIdAdded[0] = $page_id[0] = $this->dbConn->getNextId("GEDIT_01_PAGE","PAGE_ID","SEQ_GEDIT_01_PAGE") ; // page brouillon
    $this->tabLastPageIdAdded[1] = $page_id[1] = $this->dbConn->getNextId("GEDIT_01_PAGE","PAGE_ID","SEQ_GEDIT_01_PAGE") ; // page publiée
    
    $page_brouillon[0] = $page_id[1];
    $page_brouillon[1] = "null";
    
    $page_parents[0] = $page_parent; 
    $page_parents[1] = -1;
    
    $page_arbres[0] = $page_arbre_parent; 
    $page_arbres[1] = "";
     
    $page_racine_droits[0] = ( $page_public == 0 ? $page_id[0] : ( $page_racine_droit == "0" ? $page_parents[0] : $page_racine_droit ));
    $page_racine_droits[1] = ( $page_public == 0 ? $page_id[1] : -1 );
    
    if( $page_datepdeb=="" ) {
      $page_datepdeb = "NULL";
    } else {
      $page_datepdeb = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$page_datepdeb."'");
    }
        
    if( $page_datepfin=="" ) {
      $page_datepfin = "NULL";
    } else {
      $page_datepfin = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$page_datepfin."'");
    }

    $strIntituleChamp = "";
    $strIntituleValues = "";
    foreach($this->tabLangue as $key => $tabLg) {
      $strIntituleChamp  .=
        ", PAGE_TITRE".$tabLg["bdd"].
        ", PAGE_TITRE_COURT".$tabLg["bdd"].
        ", PAGE_ALIAS".$tabLg["bdd"].
        ", PAGE_TITRENAV".$tabLg["bdd"].
        ", PAGE_MOTCLE".$tabLg["bdd"].
        ", PAGE_DESC".$tabLg["bdd"];
      $strIntituleValues .=
        ", '".$this->dbConn->analyseSql($tab_page_titre[$key])."'".
        ", '".$this->dbConn->analyseSql($tab_page_titre_court[$key])."'".
        ", ".$this->dbConn->getLowerCase("'".$this->dbConn->analyseSql($tab_page_alias[$key]). ( $key == 0 ? "" : $tabLg["bdd"] )."'").
        ", '".$this->dbConn->analyseSql($tab_page_titrenav[$key])."'".
        ", '".$this->dbConn->analyseSql($tab_page_motcle[$key])."'".
        ", '".$this->dbConn->analyseSql($tab_page_desc[$key])."'";
    }
    
    if( $page_niveau == "1" || $page_niveau == "0" ) {
      $page_arbres[0] = "-0-";
      $page_arbres[1] = "-0-";
      $page_niveau    = "1";
      $page_parents[0] = "0";
      $page_parents[1] = "0";
      if( $page_racine_droits[0] == -1 ) {
        $page_racine_droits[0] = $page_id[0];
      }
      if( $page_racine_droits[1] == -1 ) {
        $page_racine_droits[1] = $page_id[1];
      }
    } else {
      // recherche de l'arbre et du parent de la page publiée
      $strSql = "select pp.PAGE_ID, pp.PAGE_ARBRE, pp.PAGE_RACINE_DROIT".
        " from GEDIT_01_PAGE pp".
        "   inner join GEDIT_01_PAGE p on p.PAGE_BROUILLON=pp.PAGE_ID".
        " where p.PAGE_ID=".$page_parents[0];
      $dsPage = $this->dbConn->initDataSet($strSql);
      if( $drPage = $dsPage->getRowIter() ) {
        $page_arbres[1]        = $drPage->getValueName("PAGE_ARBRE");        
        $page_parents[1]       = $drPage->getValueName("PAGE_ID");
        if( $page_racine_droits[1] == -1 ) {
          $page_racine_droits[1] = $drPage->getValueName("PAGE_ID");
        }
      }  
    }
    
    $atype_id = "23";
    $ptype_id = "0";
    $tabAPTYPEID = explode("_", $page_aptypeid);
    if( count($tabAPTYPEID) == 2 && is_numeric($tabAPTYPEID[0]) && is_numeric($tabAPTYPEID[1]) ) {
      $atype_id = $tabAPTYPEID[0];
      $ptype_id = $tabAPTYPEID[1];
    }  
  
    for($i=0; $i<=1; $i++) {
      $strSql = "insert into GEDIT_01_PAGE (".
        "PAGE_ID".$strIntituleChamp.", PAGE_DATEPDEB, PAGE_DATEPFIN, PAGE_DATECREA, PAGE_DATEMAJ, PAGE_RANG,".
        "PAGE_PARENT, PAGE_NIVEAU, PAGE_ARBRE, PAGE_RACINE_DROIT, AGENT_ID_CREA, AGENT_ID_MAJ, PAGE_REPERTOIRE,".
        "APPLI_ID, PAGE_VALIDEPUB, PAGE_VISIBLE_MENU, PAGE_URL_REDIRECTION, PAGE_TARGET_REDIRECTION, PAGE_PUBLIC,".
        "PAGE_TEMPLATE, PAGE_VALIDESYND, PAGE_BROUILLON, ATYPE_ID, PTYPE_ID, PAGE_APPLIID, PAGE_CATID".
        ") values (".$page_id[$i].
        "  ".$strIntituleValues.
        ", ".$page_datepdeb.
        ", ".$page_datepfin.
        ", ".$this->dbConn->getDateCur().
        ", ".$this->dbConn->getDateCur().
        ", ".$page_rang.
        ", ".$page_parents[$i].
        ", ".$page_niveau.
        ", '".$page_arbres[$i].$page_id[$i]."-'".
        ", ".$page_racine_droits[$i].
        ", ".$agent_id.
        ", ".$agent_id.
        ", '".$this->dbConn->analyseSql($page_repertoire)."'".
        ", ".$appli_id.
        ", ".$page_validepub.
        ", ".$page_visible_menu.
        ", '".$this->dbConn->analyseSql($page_redirection)."'".
        ", ".$page_target.
        ", ".$page_public.
        ", '".$this->dbConn->analyseSql($page_template)."'".
        ", ".$page_validesynd.
        ", ".$page_brouillon[$i].
        ", ".$atype_id.
        ", ".$ptype_id.
        ", ".$page_appliid.
        ", ".$page_catid.
        ")";
      
      //$this->dbConn->updateRank("GEDIT_01_PAGE", "PAGE_RANG", $page_rang, true, "PAGE_PARENT=".$page_parent." and PAGE_BROUILLON is not null");    
      
      $res = $this->dbConn->executeSql($strSql) ;
        
      // gestion des droits
      if( $bSetRight ) {
        if( $page_public == 1 ) {
          // recopie les droits des profils de l'appli sur le dossier
          $this->setRightsOnAppli($appli_id, $page_id[$i]);
        } else {
          // fixe les droits des profils sur le dossier
          $tabRight = AlkRequest::_POST("listRight", array(), "is_array");
          $this->setRightsOnAppli($appli_id, $page_id[$i], $tabRight);
        }
      }
    }
    
    // fixe la date de création et modif identique pour les 2 versions
    $strSql = "update GEDIT_01_PAGE set ".
      "  PAGE_DATECREA=".$this->dbConn->getDateCur().
      ", PAGE_DATEMAJ=".$this->dbConn->getDateCur().
      " where PAGE_ID in (".$page_id[0].", ".$page_id[1].")"; 
    $this->dbConn->executeSql($strSql) ;
    
    AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);   
     
    return $page_id[0];
  }
  
  /**
   * Modifie une page brouillon
   * Maintient les droits sur la version publiée (page_public et page_racine_droit)
   * 
   * @param appli_id  identifiant de l'application
   * @param page_id   identifiant de la page brouillon
   */
  public function updatePage($appli_id, $page_id, $tab_page_titre, $tab_page_titre_court, $tab_page_alias, $tab_page_titrenav, $tab_page_motcle, $tab_page_desc,
                             $page_datepdeb, $page_datepfin, /*$page_rang,*/ $page_validepub, $page_parent, $page_racine_droit, $user_id,
                             $page_repertoire="", $page_visible_menu="", $page_redirection="", $page_target="0", $page_public=0, 
                             $page_template="", $page_validesynd=0, $page_aptypeid="23_0", $page_appliid=-1, $page_catid=-1, 
                             $page_brouillon="", $page_typeassoc=0, $page_ordre="", $page_datedeb="", $page_datefin="", $page_nb_elements=-1)
  {
    $strIntituleValues = "";
    
    // dates de début et de fin de publication de la page
    if( $page_datepdeb=="" ) {
      $page_datepdeb = "NULL";
    } else {
      $page_datepdeb = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$page_datepdeb."'");
    }
    
    if( $page_datepfin == "" ) {
      $page_datepfin = "NULL";
    } else {
      $page_datepfin = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$page_datepfin."'");
    }
    
    // dates de début et de fin des données à sélectionner
    if( $page_datedeb=="" ) {
      $page_datedeb = "NULL";
    } else {
      $page_datedeb = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$page_datedeb."'");
    }
    
    if( $page_datefin == "" ) {
      $page_datefin = "NULL";
    } else {
      $page_datefin = $this->dbConn->getDateFormat("DD/MM/YYYY", "'".$page_datefin."'");
    }
    
    foreach($this->tabLangue as $key => $tabLg) {
      $strIntituleValues .= 
        ", PAGE_TITRE".$tabLg["bdd"]."='".$this->dbConn->analyseSql($tab_page_titre[$key])."'".
        ", PAGE_TITRE_COURT".$tabLg["bdd"]."='".$this->dbConn->analyseSql($tab_page_titre_court[$key])."'".
        ", PAGE_ALIAS".$tabLg["bdd"]."=".$this->dbConn->getLowerCase("'".$this->dbConn->analyseSql($tab_page_alias[$key])."'").
        ", PAGE_TITRENAV".$tabLg["bdd"]."='".$this->dbConn->analyseSql($tab_page_titrenav[$key])."'".
        ", PAGE_MOTCLE".$tabLg["bdd"]."='".$this->dbConn->analyseSql($tab_page_motcle[$key])."'".
        ", PAGE_DESC".$tabLg["bdd"]."='".$this->dbConn->analyseSql($tab_page_desc[$key])."'";
    }
    
    $atype_id = "23";
    $ptype_id = "0";
    $tabAPTYPEID = explode("_", $page_aptypeid);
    if( count($tabAPTYPEID) == 2 && is_numeric($tabAPTYPEID[0]) && is_numeric($tabAPTYPEID[1]) ) {
      $atype_id = $tabAPTYPEID[0];
      $ptype_id = $tabAPTYPEID[1];
    }  
    
    // détection modif des droits
    $bSetRight = false;
    $page_racine_droit_old = $page_racine_droit;
    if( $page_public == "0" /*&& $page_racine_droit != $page_id*/ ) { 
      
    /* La condition commentée plus haut n'est plus vérifiée  si on modifie les droits à partir de 2 
     * fois sur une page non publique */
      // la page n'hérite plus de $page_racine_droit
      $page_racine_droit = $page_id;
      $bSetRight = true;
    } elseif( $page_public == "1" && $page_racine_droit==$page_id ) {
      $strSql = "select PAGE_RACINE_DROIT from GEDIT_01_PAGE where PAGE_ID=".$page_parent;
      $page_racine_droit = $this->dbConn->getScalarSql($strSql, $page_parent);
      if( $page_racine_droit == "" || $page_racine_droit == "0" ) {
        $page_racine_droit = $page_id;
      } 
      $bSetRight = true;
    }
    
    $strSql = "update GEDIT_01_PAGE set ".
      " PAGE_DATEPDEB=".$page_datepdeb.
      $strIntituleValues.
      ", PAGE_DATEPFIN=".$page_datepfin.
      //", PAGE_RANG=".$page_rang.
      ", PAGE_VALIDEPUB=".$page_validepub.
      ", AGENT_ID_MAJ=".$user_id.
      ", PAGE_DATEMAJ=".$this->dbConn->getDateCur().
      ", PAGE_REPERTOIRE='".$this->dbConn->analyseSql($page_repertoire)."'".
      ", PAGE_VISIBLE_MENU = ".$page_visible_menu.
      ", PAGE_URL_REDIRECTION = '".$this->dbConn->analyseSql($page_redirection)."'".
      ", PAGE_TARGET_REDIRECTION = ".$page_target.
      ", PAGE_TEMPLATE = '".$this->dbConn->analyseSql($page_template)."'".
      ", PAGE_VALIDESYND = ".$page_validesynd.
      ", ATYPE_ID=".$atype_id.
      ", PTYPE_ID=".$ptype_id.
      ", PAGE_APPLIID=".$page_appliid.
      ", PAGE_CATID=".$page_catid.
      ( $bSetRight
        ? ", PAGE_PUBLIC=".$page_public.
          ", PAGE_RACINE_DROIT=".$page_racine_droit
        : "" ).
      // propriétés des données à sélectionner sur la page
      ", PAGE_TYPEASSOC=".$page_typeassoc.
      ", PAGE_ORDRE='".$this->dbConn->analyseSql($page_ordre)."'".
      ", PAGE_DATEDEB=".$page_datedeb.
      ", PAGE_DATEFIN=".$page_datefin.
      ", PAGE_NB_ELEMENTS=".$page_nb_elements.
      " where PAGE_ID=".$page_id;
  
    /*$this->dbConn->updateRank("GEDIT_01_PAGE", "PAGE_RANG", $page_rang, true,  
                              "PAGE_PARENT=".$page_parent." and PAGE_BROUILLON is not null");*/

    $this->dbConn->executeSql($strSql);
    
    if( $bSetRight ) {
      // répercute l'information d'héritage pour les enfants de cette page brouillon
      $strSql = "update GEDIT_01_PAGE set" .
        " PAGE_RACINE_DROIT=".$page_racine_droit.
        " where PAGE_RACINE_DROIT=".$page_racine_droit_old." and PAGE_PUBLIC=1 and PAGE_ARBRE like '%-".$page_id."-%'";
      $this->dbConn->executeSql($strSql);
    }
    
    if( $bSetRight && $page_brouillon!="" ) {
      // on maintient les mêmes droits entre page brouillon et publiée
      $ppage_racine_droit = $page_brouillon; // par défaut si page_public=0
      if( $page_public == "1" ) {
        // sélection de PAGE_RACINE_DROIT de la page parente publiée
        $strSql = "select pppub.PAGE_RACINE_DROIT" .
          " from GEDIT_01_PAGE ppub" .
          "   inner join GEDIT_01_PAGE pppub on ppub.PARENT_ID=pppub.PAGE_ID". 
          " where ppub.PAGE_ID=".$page_brouillon;
        $ppage_racine_droit = $this->dbConn->getScalarSql($strSql, $page_brouillon);
      }

      // récupère la racine des droits de la page publiée avant mise à jour
      $strSql = "select PAGE_RACINE_DROIT from GEDIT_01_PAGE where PAGE_ID=".$page_brouillon;
      $ppage_racine_droit_old = $this->dbConn->getScalarSql($strSql, $page_brouillon);

      $strSql = "update GEDIT_01_PAGE set ".
        " PAGE_PUBLIC=".$page_public.
        ", PAGE_RACINE_DROIT=".$ppage_racine_droit.
        " where PAGE_ID=".$page_brouillon;
      $this->dbConn->executeSql($strSql);

      // répercute l'information d'héritage pour les enfants de cette page publiée
      $strSql = "update GEDIT_01_PAGE set" .
        " PAGE_RACINE_DROIT=".$ppage_racine_droit.
        " where PAGE_RACINE_DROIT=".$ppage_racine_droit_old." and PAGE_PUBLIC=1 and PAGE_ARBRE like '%-".$page_brouillon."-%'";
      $this->dbConn->executeSql($strSql);
    }

    if( $bSetRight ) {
      $tabPageId = ( $page_brouillon != "" ? array($page_id, $page_brouillon) : array($page_id) );
      foreach($tabPageId as $pid) {
        // gestion des droits
        if( $page_public == 1 ) {
          // recopie les droits des profils de l'appli sur le dossier
          $this->setRightsOnAppli($appli_id, $pid);
        } else {
          // fixe les droits des profils sur le dossier
          $tabRight = AlkRequest::_POST("listRight", array(), "is_array");
          $this->setRightsOnAppli($appli_id, $pid, $tabRight);
        }
      }
    }
    
    AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
  }

  /**
   * Suppression d'une ou plusieurs liste
   * @param liste_id  identifiant ou liste d'identifiants séparés par une virgule
   */
  public function delListe($liste_id)
  {
    $strSql = "delete from GEDIT_01_PAGE_LISTE where liste_id in (".$liste_id.")";
    $this->dbConn->executeSql($strSql);
  }

  /**
   * Invalide une information. Positionne son état de publication à 0
   * @param page_id  identifiant de la page à invalider
   */
  public function invalideData($page_id)
  {
    $strSql = "update GEDIT_01_PAGE set PAGE_VALIDEPUB=1 where PAGE_ID=".$page_id." and PAGE_BROUILLON is not null";
    $this->dbConn->executeSql($strSql);
  }
  
    /**
   * Supprime un mot clé
   * @param tagCloud_id identifiant du mot clé à supprimer
   */
   public function DelMotCle($tagCloud_id)
   {
     $strSql = "DELETE FROM GEDIT_01_TAGCLOUD where TAGCLOUD_ID =".$tagCloud_id;
     $this->dbConn->executeSql($strSql);
   }
   
   /**
   * insère un mot clé et son poids
   * @param tagCloud_id identifiant du mot clé 
   * @param mot mot clé
   * @param appli_id du mot clé
   * @poids poids du mot clé
   */
   public function AddMotCle($tagCloud_id, $appli_id, $mot, $poids)
   {
     $strSql = "INSERT INTO GEDIT_01_TAGCLOUD VALUES (".$tagCloud_id.",".$appli_id.",'".$mot."',".$poids.")";
     $this->dbConn->executeSql($strSql);
   }
   
   /**
   * insère un mot clé search
   * @param $motCleSearch mot clé
   * @param appli_id du mot clé search
   * @poids poids du mot clé
   */
   public function AddMotCleSearch($appli_id, $motCleSearch)
   {
     $oAppli= AlkFactory::getAppli(ALK_ATYPE_ID_GEDIT);
     $dsSearch = $oAppli->oQuery->GetMotCleSearchByMocleSearch($motCleSearch);
    
     if ($dsSearch->getCountTotDr() == 0){
       // le mot n'esxite pas encore, on le rajoute
       $motCleSearchId = AlkFactory::getDbConn()->getNextId("FORM_01_FORM", "SSTAT_ID", "SEQ_GEDIT_01_SEARCH_STAT");
       $strSql = "INSERT INTO GEDIT_01_SEARCH_STAT VALUES (".$motCleSearchId.",".$appli_id.",'".$this->dbConn->analyseSql(strtolower($motCleSearch))."',1)";
       $this->dbConn->executeSql($strSql);
     } else {
       // on fait un update
       if ( $drSearch = $dsSearch->GetRowIter()) {
         $this->UpdateMotCleSearch($drSearch->GetValueName("SSTAT_ID"));
       }
     }
   }
   
   /**
   * modifie un mot clé et son poids
   * @param $motCleSearch_id identifiant du mot clé 
   */
   public function UpdateMotCleSearch($motCleSearch_id)
   {
     $strSql = "UPDATE GEDIT_01_SEARCH_STAT SET ". 
       "SSTAT_NB = SSTAT_NB +1".
       " where SSTAT_ID=".$motCleSearch_id;
     $this->dbConn->executeSql($strSql);
   }
      /**
   * modifie un mot clé et son poids
   * @param tagCloud_id identifiant du mot clé 
   * @param mot mot clé
   * @poids poids du mot clé
   */
   public function UpdateMotCle($tagCloud_id, $mot, $poids)
   {
     $strSql = "UPDATE GEDIT_01_TAGCLOUD SET ". 
       "TAGCLOUD_MOT = "."'".$mot. "'".
       ",TAGCLOUD_POIDS =".$poids.
       " where TAGCLOUD_ID=".$tagCloud_id;
     $this->dbConn->executeSql($strSql);
   }
   
  /**
   * Suppression d'une page
   *
   * @param page_id  identifiant de la page brouillon à supprimer
   */
  public function delPage($page_id, $appli_id)
  {
    if( $page_id == "0" ) {
      // on interdit la suppression de la racine
      return; 
    }
    
    // recherche la page publiée
    $page_id_pub = "";
    $liste_id = "";
    $strSql = "select PAGE_BROUILLON from GEDIT_01_PAGE where PAGE_ID=".$page_id;
    $dsPage = $this->dbConn->initDataSet($strSql);
    if( $drPage = $dsPage->getRowIter() ) {
      $page_id_pub = $drPage->getValueName("PAGE_BROUILLON");
    }
    $tabPageId[] = $page_id;
    if( $page_id_pub != "" && is_numeric($page_id_pub) ) {
      $tabPageId[] = $page_id_pub;
    }
    
    $tabSql = array();
    foreach($tabPageId as $page_id) {
      // sélection des pages filles également
      $strSetPageID = "select PAGE_ID from GEDIT_01_PAGE where APPLI_ID=".$appli_id." and PAGE_ARBRE like '%-".$page_id."-%'";
  
      $strSetBlocID = "select b.BLOC_ID".
        " from GEDIT_01_PAGE p".
        "   inner join GEDIT_01_BLOC b on p.PAGE_ID=b.PAGE_ID".
        " where p.APPLI_ID=".$appli_id." and p.PAGE_ARBRE like '%-".$page_id."-%'";
  
      $tabSql[] = "delete from GEDIT_01_CONTENU where BLOC_ID in (".$strSetBlocID.")";
     
      $strListBlocId = "-1";
      $dsBloc = $this->dbConn->initDataSet($strSetBlocID);
      while( $drBloc = $dsBloc->getRowIter() ) {
        $bloc_id = $drBloc->getValueName("BLOC_ID");
        $strListBlocId .= ",".$bloc_id;
      }
  
      $tabSql[] = "delete from FORM_01_FORM_BLOC where BLOC_ID in (".$strListBlocId.")";
      $tabSql[] = "delete from GEDIT_01_APPLI_BLOC where BLOC_ID in (".$strListBlocId.")";
      $tabSql[] = "delete from GEDIT_01_BLOC_RSS where BLOC_ID in (".$strListBlocId.")";
      $tabSql[] = "delete from GEDIT_01_BLOC where PAGE_ID in (".$strSetPageID.")";
      $tabSql[] = "delete from GEDIT_01_PROFIL where PAGE_ID in (".$strSetPageID.")";
      $tabSql[] = "delete from GEDIT_01_DROIT where PAGE_ID in (".$strSetPageID.")";
      $tabSql[] = "delete from GEDIT_PJ where DATA_ID in (".$strSetPageID.")";
      if( defined("ALK_B_ATYPE_CEDIT") && ALK_B_ATYPE_CEDIT==true ) { 
        $tabSql[] = "delete from GEDIT_LINKS where GEDIT_PAGE_ID in (".$strSetPageID.")";
      }
      $tabSql[] = "delete from GEDIT_01_PAGE where PAGE_ARBRE like '%-".$page_id."-%'";
    }
    foreach($tabSql as $strSql) {
      $bSucceed = $this->dbConn->executeSql($strSql);
      /*if($bSucceed === false)
        echo "Error SQL : ".$strSql."<br/>";*/
    }
    
    AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
  }
  
  /**
   * Supprime les données associées à la page ou à l'application si page_id=-1
   * @param appli_id  identifiant de l'application
   * @param page_id   identifiant de la page brouillon, =-1 par défaut
   */
  public function delDataAssoc($appli_id, $page_id=-1)
  {
    $page_id_pub = -1;
    if ( $page_id != -1 ) {
      // recherche la page publiée
      $liste_id = "";
      $strSql = "select PAGE_BROUILLON from GEDIT_01_PAGE where PAGE_ID=".$page_id;
      $dsPage = $this->dbConn->initDataSet($strSql);
      if( $drPage = $dsPage->getRowIter() ) {
        $page_id_pub = $drPage->getValueName("PAGE_BROUILLON");
      }
      if( $page_id_pub == "" || !is_numeric($page_id_pub) ) {
        return;
      }
    }
    
    // cas suppression d'une application
    if ( $page_id_pub == -1 ) {
      $strIn = "select PAGE_ID from GEDIT_01_PAGE where APPLI_ID=".$appli_id;
    }
    // cas suppression d'une page (supprime également les pages filles)
    else {
      $strIn = "select PAGE_ID from GEDIT_01_PAGE where PAGE_ARBRE like '%-".$page_id_pub."-%'";
    }
    
    $strSqlDelAssoc = "delete from GEDIT_01_PAGE_LISTE where PAGE_ID in (".$strIn.")";
    $strSqlDelAssocPJ = "delete from GEDIT_PJ where DATA_ID in (".$strIn.")";
    $strSqlSelect   = "select LISTE_ID, MSG_ID from GEDIT_01_PAGE_LISTE where PAGE_ID in (".$strIn.")";
    
    // récupère les identifiants des listes et messages associés
    $tabListeId = array();
    $tabMsgId = array();
    $oDsSelect = $this->dbConn->initDataset($strSqlSelect);
    while ( $oDrSelect = $oDsSelect->getRowIter() ) {
      $tabListeId[] = $oDrSelect->getValueName("LISTE_ID");
      $tabMsgId[]   = $oDrSelect->getValueName("MSG_ID");
    }
    
    // ordre de suppression à respecter
    $tabSql = array();
    $tabSql[] = $strSqlDelAssoc;  // 1
    $tabSql[] = $strSqlDelAssocPJ;  // 1
    $tabSql[] = ( empty($tabListeId)  ? "" : "delete from SIT_ABONNE_LISTE where LISTE_ID in (".implode(", ", $tabListeId).")" ); // 1
    $tabSql[] = ( empty($tabListeId)  ? "" : "delete from LSDIF_MSG_LISTE where LISTE_ID in (".implode(", ", $tabListeId).")" );  // 1
    $tabSql[] = ( empty($tabMsgId)    ? "" : "delete from LSDIF_DEST where MSG_ID in (".implode(", ", $tabMsgId).")" ); // 1
    $tabSql[] = ( empty($tabMsgId)    ? "" : "delete from LSDIF_MSG where MSG_ID in (".implode(", ", $tabMsgId).")" );  // 2
    $tabSql[] = ( empty($tabListeId)  ? "" : "delete from SIT_LISTE where LISTE_ID in (".implode(", ", $tabListeId).")" );  // 2
    
    foreach ( $tabSql as $sql ) {
      if ( $sql != "" ) {
        $this->dbConn->executeSql($sql, false);
      }
    }
  }
  
  /**
   * Duplique une page identifiée par page_id et la place sous page_id_new
   * Ne duplique ni l'arbo, ni les droits
   * @param page_id       Identifiant de la page à dupliquer
   * @param page_id_new   Identifiant de la page qui deviendra parente de celle créée si bDraft=false
   *                      Identifiant de la page créée si bDraft=true
   * @param bDraft        =false par défaut, true pour générer une page de brouillon.
   */
  protected function dupPage($page_id, $page_id_new, $bDraft=false)
  {
    if( $bDraft == true ) die("Non implémenté");
    
    $strIntituleChamp = "";
    $strIntituleChampBloc = "";
    $strIntituleChampContenu = "";
    $tabIntituleChampUpdate = array();
    $strIntituleChampRss = "";
    foreach($this->tabLangue as $key => $tabLg) {
      $strIntituleChamp  .=
        ", PAGE_TITRE".$tabLg["bdd"].
        ", PAGE_TITRE_COURT".$tabLg["bdd"].
        ", PAGE_ALIAS".$tabLg["bdd"].
        ", PAGE_TITRENAV".$tabLg["bdd"].
        ", PAGE_MOTCLE".$tabLg["bdd"].
        ", PAGE_DESC".$tabLg["bdd"];
      $tabIntituleChampUpdate = array_merge($tabIntituleChampUpdate,
                                            array("PAGE_TITRE".$tabLg["bdd"]          => "",
                                                  "PAGE_TITRE_COURT".$tabLg["bdd"]    => "",
                                                  "PAGE_ALIAS".$tabLg["bdd"]          => "",
                                                  "PAGE_TITRENAV".$tabLg["bdd"]       => "",
                                                  "PAGE_MOTCLE".$tabLg["bdd"]         => "",
                                                  "PAGE_DESC".$tabLg["bdd"]           => ""));
      $strIntituleChampBloc    .= ", BLOC_NOM".$tabLg["bdd"];
      $strIntituleChampContenu .= ", CONTENU".$tabLg["bdd"];
      $strIntituleChampRss .= ", RSS_TITRE".$tabLg["bdd"];
    }
    $strIntituleChampBloc .= ", BLOC_DESC, BLOC_LIMIT";
    $tabSql = array();
    
    // recopie de la page et des droits
    if( $bDraft ) {
      /* création de la page brouillon
      $tabSql[] = "insert into GEDIT_01_PAGE (".
        "   PAGE_ID, APPLI_ID, PAGE_LOCK, PAGE_VISIBLE_MENU, PAGE_VALIDEPUB, PAGE_VALIDESYND, PAGE_DATEPDEB,".
        "   PAGE_DATEPFIN, PAGE_DATECREA, AGENT_ID_CREA, PAGE_DATEMAJ, AGENT_ID_MAJ, PAGE_PARENT, PAGE_NIVEAU, PAGE_RACINE_DROIT,".
        "   PAGE_ARBRE, PAGE_PUBLIC, PAGE_RANG, AGENT_ID, PAGE_REPERTOIRE, PAGE_URL_REDIRECTION, PAGE_TARGET_REDIRECTION, ".
        "   DOC_ID, PAGE_TEMPLATE, ATYPE_ID, PTYPE_ID, PAGE_APPLIID, PAGE_CATID, PAGE_TYPEASSOC, PAGE_ORDRE, PAGE_DATEDEB, PAGE_DATEFIN, PAGE_BROUILLON".$strIntituleChamp.")".
        " select ".$page_id_new.", APPLI_ID, PAGE_LOCK, PAGE_VISIBLE_MENU, PAGE_VALIDEPUB, PAGE_VALIDESYND, PAGE_DATEPDEB,".
        "   PAGE_DATEPFIN, PAGE_DATECREA, AGENT_ID_CREA, PAGE_DATEMAJ, AGENT_ID_MAJ, PAGE_PARENT, PAGE_NIVEAU," .
        $this->dbConn->compareSql("PAGE_PUBLIC", "=", "1", "PAGE_RACINE_DROIT", $page_id_new).
        "   PAGE_ARBRE, PAGE_PUBLIC, PAGE_RANG, AGENT_ID, PAGE_REPERTOIRE, PAGE_URL_REDIRECTION, PAGE_TARGET_REDIRECTION, ".
        "   DOC_ID, PAGE_TEMPLATE, ATYPE_ID, PTYPE_ID, PAGE_APPLIID, PAGE_CATID, PAGE_TYPEASSOC, PAGE_ORDRE, PAGE_DATEDEB, PAGE_DATEFIN, ".$page_id.$strIntituleChamp.
        " from GEDIT_01_PAGE".
        " where PAGE_ID=".$page_id;*/
    } else {
      // recopie d'une page sur une autre
      // page_public et page_racine_droit sont déjà à jour (updatePage) 
      // page_parent, page_niveau et page_arbre sont déjà à jour (movePage)
      $tabFieldsName = array_merge($tabIntituleChampUpdate,
                                   array("PAGE_LOCK"         => "",
                                         "PAGE_VISIBLE_MENU" => "",
                                         "PAGE_VALIDEPUB"    => "",
                                         "PAGE_VALIDESYND"   => "",
                                         "PAGE_DATEPDEB"     => "",
                                         "PAGE_DATEPFIN"     => "",
                                         "PAGE_DATEMAJ"      => "",
                                         "AGENT_ID_MAJ"      => "",
                                         "PAGE_RANG"         => "",
                                         "AGENT_ID"          => "",
                                         "PAGE_REPERTOIRE"   => "",
                                         "PAGE_URL_REDIRECTION"    => "",
                                         "PAGE_TARGET_REDIRECTION" => "",
                                         "DOC_ID"                  => "",
                                         "PAGE_TEMPLATE"           => "",
                                         "ATYPE_ID"          => "",
                                         "PTYPE_ID"          => "",
                                         "PAGE_APPLIID"      => "",
                                         "PAGE_CATID"        => "",
                                         "PAGE_TYPEASSOC"    => "",
                                         "PAGE_ORDRE"        => "",
                                         "PAGE_DATEDEB"      => "",
                                         "PAGE_DATEFIN"      => "",
                                         "PAGE_NB_ELEMENTS"  => ""
                                         ));      
      
      $tabSql[] = $this->dbConn->getSqlCopyRowFromTableToTable("GEDIT_01_PAGE", "GEDIT_01_PAGE",
                                                               array("PAGE_ID" => $page_id),
                                                               array("PAGE_ID" => $page_id_new),
                                                               $tabFieldsName);
    }      

    // il n'est plus nécessaire de recopier les droits, fait avec updatePage() et dupAppli()
    
    foreach($tabSql as $strSql) {
      $this->dbConn->executeSql($strSql);
    }
    
    // recopie des blocs
    $tabBlocid = array();
    
   $strSql = "select b.BLOC_ID, b.TB_ID, tb.ATYPE_ID, p.APPLI_ID".
      " from GEDIT_01_BLOC b".
      "   inner join GEDIT_01_TYPEBLOC tb on b.TB_ID=tb.TB_ID".
      "   inner join GEDIT_01_PAGE p on b.PAGE_ID=p.PAGE_ID".
      " where p.PAGE_ID=".$page_id.
      "   and b.BLOC_LOCK=0"; // on ne touche pas aux blocs lockés
    $dsBloc = $this->dbConn->initDataSet($strSql); 
    while( $drBloc = $dsBloc->getRowIter() ) {
      $bloc_id  = $drBloc->getValueName("BLOC_ID");
      $tb_id    = $drBloc->getValueName("TB_ID");
      $atype_id = $drBloc->getValueName("ATYPE_ID");
      $appli_id = $drBloc->getValueName("APPLI_ID");
      $bloc_id_new = $this->dbConn->getNextId("GEDIT_01_BLOC","BLOC_ID", "SEQ_GEDIT_01_BLOC");
      
      // recopie de l'info bloc
      $strSql = "insert into GEDIT_01_BLOC (BLOC_ID, PAGE_ID, TB_ID, BLOC_NOM, BLOC_RANG, BLOC_UNE,".
        "   BLOC_COLONNE, BLOC_LOCK, BLOC_DATECREA, AGENT_ID_CREA, BLOC_DATEMAJ, AGENT_ID_MAJ, AGENT_ID, BLOC_PERE,".
        "   BLOC_ARBRE, BLOC_NIVEAU ".$strIntituleChampBloc.", BLOC_TYPEASSOC, BLOC_ORDRE, BLOC_DATEDEB, BLOC_DATEFIN)".
        " select ".$bloc_id_new.", ".$page_id_new.", TB_ID, ".$this->dbConn->getConcat("'block'", "'".$bloc_id_new."'").", BLOC_RANG, BLOC_UNE,".
        "   BLOC_COLONNE, BLOC_LOCK, BLOC_DATECREA, AGENT_ID_CREA, BLOC_DATEMAJ, AGENT_ID_MAJ, AGENT_ID, BLOC_PERE,".
        "   BLOC_ARBRE, BLOC_NIVEAU ".$strIntituleChampBloc.", BLOC_TYPEASSOC, BLOC_ORDRE, BLOC_DATEDEB, BLOC_DATEFIN".
        " from GEDIT_01_BLOC".
        " where BLOC_ID=".$bloc_id;
      $this->dbConn->executeSql($strSql);
      
      if( $tb_id == "1" ) {
        // recopie le contenu editorial
        $contenu_id_new = $this->dbConn->getNextId("GEDIT_01_CONTENU","CONTENU_ID", "SEQ_GEDIT_01_CONTENU") ;
        $strSql = "insert into GEDIT_01_CONTENU (CONTENU_ID, BLOC_ID".$strIntituleChampContenu.")".
          " select ".$contenu_id_new.", ".$bloc_id_new.$strIntituleChampContenu.
          " from GEDIT_01_CONTENU".
          " where BLOC_ID=".$bloc_id;
        $this->dbConn->executeSql($strSql);
      } elseif( $tb_id == "16" ) {
        // recopie les blocs rss
        $rss_id_new = $this->dbConn->getNextId("GEDIT_01_BLOC_RSS","RSS_ID", "SEQ_GEDIT_01_BLOC_RSS") ;
        $strSql = "insert into GEDIT_01_BLOC_RSS (RSS_ID, BLOC_ID, RSS_URL, RSS_NB_ELT_AFF, RSS_AFF_DETAIL, AGENT_ID, RSS_AFF_DATE".$strIntituleChampRss.")".
          " select ".$rss_id_new.", ".$bloc_id_new.", RSS_URL, RSS_NB_ELT_AFF, RSS_AFF_DETAIL, AGENT_ID, RSS_AFF_DATE".$strIntituleChampRss.
          " from GEDIT_01_BLOC_RSS".
          " where BLOC_ID=".$bloc_id;
        $this->dbConn->executeSql($strSql);
      } else {
        // recopie association (appli_id, bloc_id)
        $strSql = "insert into GEDIT_01_APPLI_BLOC (APPLI_ID, BLOC_ID)".
          " select APPLI_ID, ".$bloc_id_new.
          " from GEDIT_01_APPLI_BLOC".
          " where BLOC_ID=".$bloc_id;
        $this->dbConn->executeSql($strSql);
        
      }
      // recopie les associations de bloc avec les données et catégories appartenant à d'autres applications
      $oAppli = AlkFactory::getAppli($atype_id);
      if( !is_null($oAppli) && is_object($oAppli) && method_exists($oAppli, "dupGEditBloc") )
        $oAppli->dupGEditBloc($bloc_id, $bloc_id_new);
    }
  }
  
  /**
   * Fonction non utilisée
   * Duplique toutes les pages publiées pour créer les pages brouillons associées
   * Retourne l'identifiant de cette nouvelle page brouillon
   * 
   * @param page_id_src  identifiant de la page publiée
   * @return int
   *
  public function createDraftPage($page_id_src, $appli_id="-1")
  {
    $page_id_res = $page_id_src;
    
    $strSql = "select PAGE_ID from GEDIT_01_PAGE where PAGE_BROUILLON is null and PAGE_ID>0".
    					( $appli_id!="-1" ? " and APPLI_ID=".$appli_id : "");
    $dsPage = $this->dbConn->initDataset($strSql);
    while( $drPage = $dsPage->getRowIter() ) {
      $idPage = $drPage->getValueName("PAGE_ID");
    
      $page_id_new = $this->dbConn->getNextId("GEDIT_01_PAGE","PAGE_ID","SEQ_GEDIT_01_PAGE") ;
      if( $idPage == $page_id_src ) {
        $page_id_res = $page_id_new; 
      }
      $this->dupPage($idPage, $page_id_new, true);
    }
  
    // met à jour page_arbre
    $this->updatePageArbre("-1", false);
  
    return $page_id_res;
  } */ 

  /**
   * Regénère la valeur de PAGE_PARENT et PAGE_ARBRE pour :
   *   - toutes les pages publiées de l'application si bPublish=true
   *   - toutes les pages brouillon de l'application si bPublish=false
   * L'information niveau doit être mise à jour au préalable
   * 
   * @param appli_id  identifiant de l'application gedit, =-1 pour toutes
   * @param bPublish  =true par défaut pour copier le contenu du brouillon sur le contenu publié, false pour l'inverse
   *
  private function updatePageArbre($appli_id="-1", $bPublish=true)
  {
    $strSql = "select p.PAGE_ID, p.PAGE_ARBRE, p.PAGE_BROUILLON as PAGE_ID_PUB,".
      ( $bPublish
        ? " '' as PAGE_ARBRE_PUB"
        : " pp.PAGE_ARBRE as PAGE_ARBRE_PUB" ).
      " from GEDIT_01_PAGE p".
      ( $bPublish
        ? ""
        : " inner join GEDIT_01_PAGE pp on p.PAGE_BROUILLON=pp.PAGE_ID" ).
      " where p.PAGE_BROUILLON is not null and p.PAGE_ID>0".
      ( $appli_id != "-1"
        ? " and p.APPLI_ID=".$appli_id
        : "" ).
      " order by ".( $bPublish ? "p.PAGE_NIVEAU" : "pp.PAGE_NIVEAU" );
 
    $tabAssoc = array("_0" => "0");
    $tabArbre = array();
    $dsPage = $this->dbConn->initDataset($strSql);
    while( $drPage = $dsPage->getRowIter() ) {
      $page_id_brouillon    = $drPage->getValueName("PAGE_ID");
      $page_arbre_brouillon = $drPage->getValueName("PAGE_ARBRE");
      $page_id_pub          = $drPage->getValueName("PAGE_ID_PUB");
      $page_arbre_Pub       = $drPage->getValueName("PAGE_ARBRE_PUB");
      if( $bPublish ) {
        // recopie le brouillon vers publication
        $tabArbre["_".$page_id_pub] = mb_substr($page_arbre_brouillon, 1, mb_strlen($page_arbre_brouillon)-2);
        $tabAssoc["_".$page_id_brouillon] = $page_id_pub;
      } else {
        // recopie la publication vers brouillon
        $tabArbre["_".$page_id_brouillon] = mb_substr($page_arbre_Pub, 1, mb_strlen($page_arbre_Pub)-2);
        $tabAssoc["_".$page_id_pub] = $page_id_brouillon;  
      }
    }
    
    foreach($tabArbre as $strKey => $page_arbre_src) {
      $page_id_dest = substr($strKey, 1);
      $tabArbreSrc = explode("-", $page_arbre_src);
      $page_parent_src = "_".$tabArbreSrc[count($tabArbreSrc)-2];
      $page_parent_dest = ( array_key_exists($page_parent_src, $tabAssoc)
                            ? $tabAssoc[$page_parent_src]
                            : "0" );
      $page_arbre_dest = "-";
      foreach($tabArbreSrc as $page_parent_src) {
        $page_arbre_dest .= ( array_key_exists("_".$page_parent_src, $tabAssoc)
                              ? $tabAssoc["_".$page_parent_src]
                              : "0" )."-";
      }
      
      $strSql = "update GEDIT_01_PAGE set PAGE_PARENT=".$page_parent_dest.", PAGE_ARBRE='".$page_arbre_dest."' where PAGE_ID=".$page_id_dest;
      $this->dbConn->executeSql($strSql);
    }
  }*/

  /**
   * Publie ou restaure la page de brouillon en fonction de la valeur de bCopy
   * 
   * @param uploadDir chemin d'acces au répertoire d'upload
   * @param page_id  identifiant de la page brouillon
   * @param bPublish =true par défaut pour copier le contenu du brouillon sur le contenu publié, false pour l'inverse
   */
  public function publishRestoreDraftPage($uploadDir, $page_id, $bPublish=true)
  {
    $user_id = AlkFactory::GetSProperty("user_id", "-1");
    
    // sélection des blocs de la page : publiée si bPublish=true, brouillon si bPublish=false
    // le but étant de supprimer les blocs trouvés afin de les redupliquer par la suite
    $strSql = "select b.BLOC_ID, b.TB_ID, tb.ATYPE_ID, p.APPLI_ID".
      ( !$bPublish 
        ? ", p.PAGE_BROUILLON as PAGE_ID_PUB, p.PAGE_ID as PAGE_ID_DRAFT"
        : ", pp.PAGE_BROUILLON as PAGE_ID_PUB, pp.PAGE_ID as PAGE_ID_DRAFT" ).
      " from GEDIT_01_BLOC b".
      "   inner join GEDIT_01_TYPEBLOC tb on b.TB_ID=tb.TB_ID".
      "   inner join GEDIT_01_PAGE p on b.PAGE_ID=p.PAGE_ID".
      ( !$bPublish
        ? ""
        : " inner join GEDIT_01_PAGE pp on p.PAGE_ID=pp.PAGE_BROUILLON" ).
      " where b.BLOC_LOCK=0". // on ne touche pas aux blocs lockés
      ( !$bPublish 
        ? " and p.PAGE_ID=".$page_id 
        : " and pp.PAGE_ID=".$page_id );
     
    $appli_id = "-1";
    $page_id_dest = "-1";
    $page_id_src  = "-1";
        
    $dsBloc = $this->dbConn->initDataSet($strSql);
    if( $dsBloc->getCountTotDr() > 0 ) { 
      while( $drBloc = $dsBloc->getRowIter() ) {
        $bloc_id       = $drBloc->getValueName("BLOC_ID");
        $tb_id         = $drBloc->getValueName("TB_ID");
        $atype_id      = $drBloc->getValueName("ATYPE_ID");
        $appli_id      = $drBloc->getValueName("APPLI_ID");
        $page_id_pub   = $drBloc->getValueName("PAGE_ID_PUB");
        $page_id_draft = $drBloc->getValueName("PAGE_ID_DRAFT");
      
        $page_id_dest = ( $bPublish ? $page_id_pub : $page_id_draft );
        $page_id_src  = ( !$bPublish ? $page_id_pub : $page_id_draft );
       
        // supprime tous les bloc de page_id_dest
        $oAppli = AlkFactory::getAppli($atype_id, $appli_id);
        if( !is_null($oAppli) && is_object($oAppli) && method_exists($oAppli, "delGEditBloc") ) {
          $oAppli->delGEditBloc($page_id_dest, $bloc_id, $tb_id, $atype_id);
        }
        $this->delGEditBloc($page_id_dest, $bloc_id, $user_id, true);
      }
    } else {
      $strSql = "select p.PAGE_ID, p.PAGE_BROUILLON, p.APPLI_ID".
        " from GEDIT_01_PAGE p".
        " where p.PAGE_ID=".$page_id;
      $dsBloc = $this->dbConn->initDataSet($strSql); 
      if( $drBloc = $dsBloc->getRowIter() ) {
        $page_id_draft = $drBloc->getValueName("PAGE_ID");
        $page_id_pub   = $drBloc->getValueName("PAGE_BROUILLON");
      
        $page_id_dest = ( $bPublish ? $page_id_pub : $page_id_draft );
        $page_id_src  = ( !$bPublish ? $page_id_pub : $page_id_draft );
        $appli_id      = $drBloc->getValueName("APPLI_ID");
      }
    }

    if( $page_id_dest != "-1" && $page_id_src!="-1" && $appli_id != "-1" ) {
      if ( $bPublish ){
        // en publication, fixe la valeur de validepub avant la recopie
        $strSql = "update GEDIT_01_PAGE set".
          "  PAGE_VALIDEPUB=".($bPublish ? "1" : "0").
          ", AGENT_ID_MAJ=".$user_id.
          ", PAGE_DATEMAJ=".$this->dbConn->getDateCur().
          " where PAGE_ID=".$page_id_src." or PAGE_ID=".$page_id_dest;
        $this->dbConn->ExecuteSql($strSql);
      }
  
      // duplique tous les blocs de page_id_src vers page_id_dest
      $this->dupPage($page_id_src, $page_id_dest);
      
      // pas de traitement nécessaire pour gérer l'arbo, gérer avec movePage
    }
    
    //GESTION DES VISUELS ASSOCIES A LA PAGE
    if($uploadDir != ""){
      $arrayFileSrc = $arrayFileDest = array();
      $strDir           = dirname($uploadDir."visuel/".$page_id_src."_*");
      if( substr($strDir, -1) != "/" ) $strDir .= "/";
      if( is_dir($strDir) ) {
        $hDir = opendir($strDir);
        while( $strFileName = readdir($hDir) ) {
          if( is_file($strDir.$strFileName) && preg_match("/^".$page_id_dest."_(\d+?)_/", $strFileName,$matches) ) {
            $arrayFileDest[md5_file( $strDir.$strFileName)]["path"] = $strDir.$strFileName;
            $arrayFileDest[md5_file( $strDir.$strFileName)]["dataid_pjid"] = $matches[0];
            $arrayFileDest[md5_file( $strDir.$strFileName)]["pjid"] = $matches[1];
          }
          if( is_file($strDir.$strFileName) && preg_match("/^".$page_id_src."_(\d+?)_/", $strFileName,$matches) ) {
            $arrayFileSrc[md5_file( $strDir.$strFileName)]["path"] = $strDir.$strFileName;
            $arrayFileSrc[md5_file( $strDir.$strFileName)]["dataid_pjid"] = $matches[0];
            $arrayFileSrc[md5_file( $strDir.$strFileName)]["pjid"] = $matches[1];
          }
        }
        closedir($hDir);
      }
      foreach($arrayFileSrc as $md5_src=>$tabFile_src){
        foreach($arrayFileDest as $md5_dest=>$tabFile_dest){
          if( $md5_src == $md5_dest){
            if(ALK_BDD_TYPE == ALK_SGBD_MYSQL){
              $strSql = "UPDATE GEDIT_PJ pjDest, GEDIT_PJ pjSrc ".
                      " SET ".
                        " pjDest.PJ_DATECREAFILE = pjSrc.PJ_DATECREAFILE , ".
                        " pjDest.PJ_TITLE = pjSrc.PJ_TITLE , ".
                        " pjDest.PJ_COPYRIGHT = pjSrc.PJ_COPYRIGHT , ".
                        " pjDest.PJ_AUTEUR = pjSrc.PJ_AUTEUR , ".
                        " pjDest.PJ_DESC = pjSrc.PJ_DESC , ".
                        " pjDest.PJ_KEYWORDS = pjSrc.PJ_KEYWORDS ".
                      " WHERE pjDest.PJ_ID = ".$arrayFileDest[$md5_dest]["pjid"]." AND pjSrc.PJ_ID = ".$arrayFileSrc[$md5_src]["pjid"]." ";
              $this->dbConn->executeSql($strSql);

              unset($arrayFileSrc[$md5_src]);
              unset($arrayFileDest[$md5_dest]);
            }
          }
        }
      }

      foreach ($arrayFileDest as $md5_dest => $tabFile_dest){
        //Suppression en base
        $strSql = "delete from GEDIT_PJ where PJ_ID= ".$tabFile_dest["pjid"];
        $this->dbConn->executeSql($strSql);
        //Suppression physique
        delFile($uploadDir."visuel/".$page_id_dest."_".$tabFile_dest["pjid"]."_*");
        delFile($uploadDir."visuel/declinaisons/".$page_id_dest."_".$tabFile_dest["pjid"]."_*");
      }

      foreach ($arrayFileSrc as $md5_src => $tabFile_src){
        //On ajoute en base et sur le disque tous les fichiers qui existent sur src mais qui ne sont pas présent dans dest
        //Ajout en base
        $dsSrc = $this->dbConn->initDataset("select * from GEDIT_PJ where PJ_ID= ".$tabFile_src["pjid"]);
        while ( $drSrc = $dsSrc->getRowIter() ){
          $pj_id_dest   = $this->dbConn->getNextId("GEDIT_PJ", "PJ_ID", "SEQ_DATA_PJ");
          $pj_id_src    = $drSrc->getValueName("PJ_ID");
          $pj_name      = $drSrc->getValueName("PJ_NAME");
          //$fields       = ", PJ_CHAMP, PJ_NAME, PJ_TYPE, PJ_TAILLE, PJ_LANG, PJ_DATECREA, PJ_AGENTCREA";
          $tabFields    = array("PJ_CHAMP", "PJ_NAME", "PJ_TYPE", "PJ_TAILLE", "PJ_LANG", "PJ_DATECREA", "PJ_AGENTCREA");

          // tableau de définition des champs détaillés des pièces jointes
          if ( isset($GLOBALS["tabPJDetails"]) && is_array($GLOBALS["tabPJDetails"]) && !empty($GLOBALS["tabPJDetails"]) ) {
            foreach($GLOBALS["tabPJDetails"] as $tabFieldInfo ) {
               if( $tabFieldInfo["field"] != "" ) {
                //$fields .= ", ".$tabFieldInfo["field"];
                $tabFields[] = strtoupper($tabFieldInfo["field"]);
              }
            }
          }
          $fields = implode(", ", array_unique($tabFields));
          $pj_file_dest = $page_id_dest."_".$pj_id_dest."_".$pj_name;
          $pj_file_src  = $page_id_src."_".$pj_id_src."_".$pj_name;
          $strSql = "insert into GEDIT_PJ (DATA_ID, PJ_ID, PJ_FILE, ". $fields.")" .
              " select ".$page_id_dest.", ".$pj_id_dest.", '".$this->dbConn->analyseSql($pj_file_dest)."', ". $fields."" .
              " from GEDIT_PJ where DATA_ID=".$page_id_src." and PJ_ID=".$pj_id_src;
          $this->dbConn->executeSql($strSql);      

          //Ajout sur le disque
          $pj_file_dest = getFileRadical($pj_file_dest);
          $pj_file_src  = getFileRadical($pj_file_src);
          // cherche tous les fichiers commencant par $pj_file_src sans extension
          $tabFiles = glob($uploadDir."visuel/".$pj_file_src."*");
          foreach ($tabFiles as $file){
            if ( !is_file($file) ) continue;
            $fileDest = preg_replace("!".$pj_file_src."!", $pj_file_dest, $file);
            copy($file, $fileDest);
            chmod($fileDest, 0777);
          }
          $tabFiles = glob($uploadDir."visuel/declinaisons/".$pj_file_src."*");
          foreach ($tabFiles as $file){
            if ( !is_file($file) ) continue;
            $fileDest = preg_replace("!".$pj_file_src."!", $pj_file_dest, $file);
            copy($file, $fileDest);
            chmod($fileDest, 0777);
          }
        }
      }
    }
    
    if( $bPublish ) {
      AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
    }
    
    // gestion des liens
    $oAppliLink = AlkFactory::getAppli(ALK_ATYPE_ID_LINK);
    if ( $oAppliLink ) {
      $oAppliLink->delLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $page_id_dest, -1, -1);
      $oDsLink = $oAppliLink->getDsLinks(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $page_id_src, -1, -1);
      while ( $oDrLink = $oDsLink->getRowIter() ) {
        $data_to_id = $oDrLink->getValueName("DATA_TO_ID");
        $value      = $oDrLink->getValueName("VALUE");
        $oAppliLink->setLink(ALK_ATYPE_ID_GEDIT, ALK_LTYPE_ID_PAGE, $page_id_dest, $data_to_id, $value);
      }
    }
  }  

  /**
   * Retire de la publication, la page publiée
   * 
   * @param page_id_pub   identifiant de la page publiée
   * @param appli_id      identifiant de l'application gedit
   */
  public function unpublishPage($page_id_pub, $appli_id)
  {
    $strSql = "update GEDIT_01_PAGE set PAGE_VALIDEPUB=0".
      " where PAGE_ID=".$page_id_pub." or PAGE_BROUILLON=".$page_id_pub;
    $this->dbConn->ExecuteSql($strSql);
  
    AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
  }

  /**
   * Déplace la page page_id vers la page page_id_dest qui devient son parent
   * Cette méthode est à appeler avec les identifiants brouillon. 
   * Elle itère ensuite automatiquement avec les identifiants publiés.
   * Gère les déplacements vers une application GEDIT d'un espace différent.
   * Retourne 1 si ok, 0 si ko
   * 
   * @param page_id_move  Identifiant de la page à déplacer
   * @param page_id_dest  Identifiant de la page qui deviendra parente de page_id_move
   * @param appli_id      Identifiant de l'application de destination (utile dans le cas de déplacement d'une page en tant que racine)
   * @return 0 si ko, 1 si ok
   */
  public function movePage($page_id_move, $page_id_dest, $appli_id=-1)
  {
    if( $page_id_move == $page_id_dest ) return 0;
    
    // deplace page_id_move vers page_id_dest
    $strSql = "select * from GEDIT_01_PAGE where PAGE_ID=".$page_id_move;
    $dsMPage = $this->dbConn->initDataset($strSql);
    if( $drMPage = $dsMPage->getRowIter() ) {
      // info de l'espace a deplacer avant déplacement
      $mpage_pere         = $drMPage->getValueName("PAGE_PARENT");
      $mpage_rang         = $drMPage->getValueName("PAGE_RANG");
      $mpage_niv          = $drMPage->getValueName("PAGE_NIVEAU");
      $mpage_arbre        = $drMPage->getValueName("PAGE_ARBRE");
      $mpage_racine_droit = $drMPage->getValueName("PAGE_RACINE_DROIT");
      $mpage_public       = $drMPage->getValueName("PAGE_PUBLIC");
      $mpage_brouillon    = $drMPage->getValueName("PAGE_BROUILLON");

      $lgMPage_arbre = strlen($mpage_arbre);
 
      // sélection de la page destination à condition qu'elle n'appartient pas à la sous-arbo de celle à déplacer
      $strSql = "select * from GEDIT_01_PAGE where PAGE_ID=".$page_id_dest." and not(PAGE_ARBRE like '%-".$page_id_move."-%')";
      $dsPPage = $this->dbConn->initDataset($strSql);
      if( $drPPage = $dsPPage->getRowIter() ) {
        // info sur la nouvelle page parente
        $pappli_id          = $appli_id && $appli_id != -1 ? $appli_id : $drPPage->getValueName("APPLI_ID");
        $ppage_arbre        = $drPPage->getValueName("PAGE_ARBRE");
        $ppage_niv          = $drPPage->getValueName("PAGE_NIVEAU");
        $ppage_racine_droit = $drPPage->getValueName("PAGE_RACINE_DROIT");
        $ppage_public       = $drPPage->getValueName("PAGE_PUBLIC");
        $ppage_brouillon    = $page_id_dest == 0 ? $page_id_dest : $drPPage->getValueName("PAGE_BROUILLON");
        
        // info de la page déplacée après déplacement
        $page_niv          = $ppage_niv+1;
        $page_arbre        = $ppage_arbre.$page_id_move."-";
        $nivDiff           = $page_niv-$mpage_niv;
        
        // met à jour l'appli des pages déplacées
        $strSql = "update GEDIT_01_PAGE set".
          " APPLI_ID=".$pappli_id.
          " where PAGE_ARBRE like '%-".$page_id_move."-%'";
        $this->dbConn->ExecuteSql($strSql);
        
        // met à jour le parent de la page déplacée et préserve les droits
        $strSql = "update GEDIT_01_PAGE set" .
          " PAGE_PARENT=".$page_id_dest.
          ", PAGE_PUBLIC=0" .
          ", PAGE_RACINE_DROIT=".$page_id_move.
          " where PAGE_ID=".$page_id_move;
        $this->dbConn->ExecuteSql($strSql);

        // recalcul l'arbre de la page déplacée et de sa sous arborescence
        $strArbreSql = $this->dbConn->getConcat("'".$page_arbre."'",
                                                $this->dbConn->getSubstring("PAGE_ARBRE", $lgMPage_arbre));

        $strSql = "update GEDIT_01_PAGE set".
          "  PAGE_NIVEAU=PAGE_NIVEAU+(".$nivDiff.")".
          ", PAGE_ARBRE=".$strArbreSql.
          " where PAGE_ARBRE like '".$mpage_arbre."%'";
        $this->dbConn->ExecuteSql($strSql);

        // met à jour la racine des droits hérités
        $strSql = "update GEDIT_01_PAGE set".
          " PAGE_RACINE_DROIT=".$page_id_move.
          " where PAGE_PUBLIC=1 and PAGE_ID<>".$page_id_move." and PAGE_ARBRE like '%-".$page_id_move."-%'";
        $this->dbConn->ExecuteSql($strSql);
        
        // met à jour les droits sur la page déplacée
        $this->setRightsOnAppli($pappli_id, $page_id_move);

        // Pas de mise a jour du rang
        
        if( $mpage_brouillon!=="" && $ppage_brouillon!=="" ) {
          // itère sur la version publiée
          return $this->movePage($mpage_brouillon, $ppage_brouillon, $appli_id);
        } else {
          // efface le cache
          AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$pappli_id);
          return 1;
        }
      }
    }
    return 0;
  }

  /** 
   * Ajout des droits liés au profil
   * @param profil_id  identifiant du profil
   */
  public function addProfil($profil_id, $cont_id=0)
  {
    // ménage avant insertion
    $this->delProfil($profil_id);
    
    // ajout du droit 0 avec le profil sur toutes les pages
    $strSql = "insert into GEDIT_01_PROFIL (PAGE_ID, PROFIL_ID, DROIT_ID)".
      " select PAGE_ID, ".$profil_id.", 0".
      " from GEDIT_01_PAGE".
      " where PAGE_ID>0".
      ( $cont_id > 0 
        ? " and APPLI_ID in (select APPLI_ID from SIT_APPLI_CONT where CONT_ID=".$cont_id.")"
        : "" );
    $this->dbConn->ExecuteSql($strSql);
  }  

  /**
   * Supprime le profil sur la gestion des droits du type application
   * @param profil_id  Identifiant du profil
   */
  public function delProfil($profil_id)
  {
    $strSql = "delete from GEDIT_01_PROFIL where PROFIL_ID=".$profil_id;
    $this->dbConn->executeSql($strSql);
  }

  /**
   * Supprime toutes les données gedit associées à appli_id
   *        Les éléments associés aux blocs ne sont pas supprimés
   * @param appli_id  identifiant de l'appli à supprimer
   */
  public function delAppli($appli_id, $strPathUpload)
  {
    $strSetPageID = "select PAGE_ID from GEDIT_01_PAGE where APPLI_ID=".$appli_id;

    $strSetBocID = "select b.BLOC_ID".
      " from GEDIT_01_PAGE p".
      "   inner join GEDIT_01_BLOC b on p.PAGE_ID=b.PAGE_ID".
      " where p.APPLI_ID=".$appli_id;

    $tabSql[] = "delete from GEDIT_01_CONTENU where BLOC_ID in (".$strSetBocID.")";
    $tabSql[] = "delete from GEDIT_01_APPLI_BLOC where BLOC_ID in (".$strSetBocID.")";
    $tabSql[] = "delete from GEDIT_01_BLOC_RSS where BLOC_ID in (".$strSetBocID.")";
    $tabSql[] = "delete from GEDIT_01_BLOC where PAGE_ID in (".$strSetPageID.")";
    $tabSql[] = "delete from GEDIT_01_DROIT where PAGE_ID in (".$strSetPageID.")";
    $tabSql[] = "delete from GEDIT_01_PROFIL where PAGE_ID in (".$strSetPageID.")";
    if( defined("ALK_B_ATYPE_CEDIT") && ALK_B_ATYPE_CEDIT==true ) { 
      $tabSql[] = "delete from GEDIT_LINKS where GEDIT_PAGE_ID in (".$strSetPageID.")";
    }
    $tabSql[] = "delete from GEDIT_01_PAGE where APPLI_ID=".$appli_id;

    foreach($tabSql as $strSql) {
      $this->dbConn->executeSql($strSql);
    }
    AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
  }

  /**
   * Duplication de la structure et du paramètrage de l'application src à la courante
   * @param appli_id_src  identifiant de l'application source
   * @param appli_id_dest identifiant de l'application destination
   * @param iTypeDup      type de duplication : 0 = application vierge (ne fait rien) 
   *                                            1 = structure et paramétrage
   *                                            2 = structure, paramétrage et données  
   */
  public function dupAppli($appli_id_src, $appli_id_dest, $iTypeDup)
  {
    if( $iTypeDup == 0 ) return;
    
    $user_id = AlkFactory::getSProperty("user_id", "-1");

    $tabValue = array();
    foreach($this->tabLangue as $key => $tabLg) {
      $tabValue[$key] = "";
    }
    
    // table de correspondance entre les pages sources et destination
    $tabConvPageId = array();

    //Dupliquer toutes les pages publiées de l'appli source vers l'application courrante
    $strSql = "select pp.*, pb.PAGE_ID as PAGE_ID_BROUILLON" .
      " from GEDIT_01_PAGE pp" .
      "   inner join GEDIT_01_PAGE pb on pp.PAGE_ID=pb.PAGE_BROUILLON".
      " where pp.PAGE_BROUILLON is null and pp.PAGE_ID>0 and pp.APPLI_ID=".$appli_id_src.
      " order by pp.PAGE_NIVEAU, pp.PAGE_RANG";
    $dsPageSrc = $this->dbConn->initDataset($strSql);
    while( $drPageSrc = $dsPageSrc->getRowIter() ) { 
      $spage_id           = $drPageSrc->getValueName("PAGE_ID");
      $spage_id_brouillon = $drPageSrc->getValueName("PAGE_ID_BROUILLON");
      $spage_parent       = $drPageSrc->getValueName("PAGE_PARENT");
      $spage_arbre        = $drPageSrc->getValueName("PAGE_ARBRE");
      $spage_niveau       = $drPageSrc->getValueName("PAGE_NIVEAU");
      $spage_public       = $drPageSrc->getValueName("PAGE_PUBLIC");
      $spage_racine_droit = $drPageSrc->getValueName("PAGE_RACINE_DROIT");
      $spage_rang         = $drPageSrc->getValueName("PAGE_RANG");
      $spage_validepub    = $drPageSrc->getValueName("PAGE_VALIDEPUB");

      $page_parent    = ( isset($tabConvPageId["_".$spage_parent]) 
                          ? $tabConvPageId["_".$spage_parent] 
                          : 0 );

      $page_racine_droit = ( isset($tabConvPageId["_".$spage_racine_droit]) 
                          ? $tabConvPageId["_".$spage_racine_droit] 
                          : 0 );
      
      // construit l'arbre du parent avec les nouveaux id
      $tabArbre = explode("-", substr($spage_arbre, 1, -1));
      // retire le dernier, correspondant à spage_id
      array_shift($tabArbre);
      
      $page_arbre_parent = "";
      foreach($tabArbre as $pid) {
        $page_arbre_parent .= "-".( isset($tabConvPageId["_".$pid]) ? $tabConvPageId["_".$pid] : 0 );
      }
      $page_arbre_parent .= "-";
      
      //Ajout de la nouvelle page dans l'appli_dest + son brouillon, sans gérer les droits
      $page_id_brouillon_new = $this->addPage($tabValue, $tabValue, $tabValue, $tabValue, $tabValue, 
                                              "", "", $spage_rang, $spage_validepub, $page_parent,
                                              $spage_niveau, $page_arbre_parent, $page_racine_droit, 
                                              $user_id, $appli_id_dest,
                                              "", "0", "", "0", $spage_public, "", 0, "23_0", -1, -1, false);
      
      $page_id_new = $this->tabLastPageIdAdded[1];
      
      $tabConvPageId["_".$spage_id_brouillon] = $page_id_brouillon_new;
      $tabConvPageId["_".$spage_id]           = $page_id_new;
      
      //Duplication des données de la page appli d'origine vers la page de l'appli destinatrice                           
      $this->dupPage($spage_id, $page_id_new);
      
      //Duplication des données de la page d'origine vers la nouvelle page de brouillon  
      $this->dupPage($spage_id, $page_id_brouillon_new);
      
      // copy les droits / profils (uniquement les profils communs entre les 2 applis)
      $strSql = "insert into GEDIT_01_PROFIL (PAGE_ID, PROFIL_ID, DROIT_ID) ".
        " select ".$page_id_brouillon_new.", gp.PROFIL_ID, gp.DROIT_ID".
        " from GEDIT_01_PROFIL gp".
        "  inner join SIT_PROFIL_APPLI pa on (ap.PROFIL_ID=gp.PROFIL_ID and pa.APPLI_ID=".$appli_id_dest.")".
        " where gp.PAGE_ID=".$spage_id_brouillon;
      $this->dbConn->executeSql($strSql);

      $strSql = "insert into GEDIT_01_PROFIL (PAGE_ID, PROFIL_ID, DROIT_ID) ".
        " select ".$page_id_new.", gp.PROFIL_ID, gp.DROIT_ID".
        " from GEDIT_01_PROFIL gp".
        "  inner join SIT_PROFIL_APPLI pa on (ap.PROFIL_ID=gp.PROFIL_ID and pa.APPLI_ID=".$appli_id_dest.")".
        " where gp.PAGE_ID=".$spage_id;
      $this->dbConn->executeSql($strSql);
    }
    $tabConvPageId = null;
    
    // applique les droits des profils aux agents sur l'appli destination
    $this->setRightProfilToAgentByAppli($appli_id_dest);
    
    AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id_dest);
  }

  /**
   * Transfère de propriété d'un utilisateur à un autre
   *        Méthode à appeler avant suppression définitive d'un utilisateur
   * @param idUserFrom  identifiant de l'utilisateur perdant la propriété des ses données
   * @param idUserTo    identifiant de l'utilisateur récupérant la propriété des données
   */
  public function replaceUser($idUserFrom, $idUserTo)
  {
    $strSql = "update GEDIT_01_BLOC_RSS set AGENT_ID=".$idUserTo." where AGENT_ID=".$idUserFrom;
    $this->dbConn->executeSql($strSql);

    $strSql = "update GEDIT_01_BLOC set AGENT_ID_CREA=".$idUserTo." where AGENT_ID_CREA=".$idUserFrom;
    $this->dbConn->executeSql($strSql);

    $strSql = "update GEDIT_01_BLOC set AGENT_ID_MAJ=".$idUserTo." where AGENT_ID_MAJ=".$idUserFrom;
    $this->dbConn->executeSql($strSql);

    $strSql = "update GEDIT_01_PAGE set AGENT_ID_CREA=".$idUserTo." where AGENT_ID_CREA=".$idUserFrom;
    $this->dbConn->executeSql($strSql);

    $strSql = "update GEDIT_01_PAGE set AGENT_ID_MAJ=".$idUserTo." where AGENT_ID_MAJ=".$idUserFrom;
    $this->dbConn->executeSql($strSql);
  }

  /**
   * Invitation d'un utilisateur à un espace (tous si cont_id=-1, tous les espaces publics si cont_id=-2)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces. -2 tous les espaces publics
   * @param appli_id identifiant de l'appli, =-1 si non connue, >0 si cont_id>0
   */
  public function addUserToSpace($user_id, $cont_id, $appli_id) 
  {
    // toutes les pages
    $strField = "";
    $strIn = "";
    if( $cont_id > 0 && $appli_id>0 ) {
      // page de appli_id
      $strField = " and PAGE_ID";
      $strIn = " in (select PAGE_ID from GEDIT_01_PAGE where APPLI_ID=".$appli_id.")";
    } elseif( $cont_id == -2 ) {
      // page des espaces publics
      $strField = " and PAGE_ID";
      $strIn = " in (" .
        " select p.PAGE_ID" .
        " from GEDIT_01_PAGE p" .
        "  inner join SIT_APPLI_CONT ac on ac.APPLI_ID=p.APPLI_ID" .
        "  inner join SIT_CONTENEUR c on c.CONT_ID=ac.CONT_ID".
        " where c.CONT_PUBLIC=1)";
    }
    
    // ménage
    $strSql = "delete from GEDIT_01_DROIT where AGENT_ID in (".$user_id.")".$strField.$strIn;
    $this->dbConn->executeSql($strSql);
 
     if( $strField != "" ) {
      $strField = " and pd.PAGE_ID";
    }
       
    $strSql = "insert into GEDIT_01_DROIT (AGENT_ID, PAGE_ID, DROIT_ID)". 
      " select agc.AGENT_ID, pd.PAGE_ID, ".$this->dbConn->compareSql("agc.CONT_ADMIN", "=", "1", "4", "max(pd.DROIT_ID)")." as RIGHT_ID".
      " from GEDIT_01_PAGE p". 
      "   inner join GEDIT_01_PROFIL pd  on p.PAGE_ID=pd.PAGE_ID".
      "   inner join SIT_APPLI_CONT ac   on p.APPLI_ID=ac.APPLI_ID".
      "   inner join SIT_AGENT_CONT agc  on agc.CONT_ID=ac.CONT_ID".
      "   inner join SIT_AGENT_PROFIL ap on (pd.PROFIL_ID=ap.PROFIL_ID and ap.AGENT_ID=agc.AGENT_ID)".
      " where agc.AGENT_ID in (".$user_id.")".$strField.$strIn.  
      " group by agc.AGENT_ID, pd.PAGE_ID, agc.CONT_ADMIN".
      " having ".$this->dbConn->compareSql("agc.CONT_ADMIN", "=", "1", "4", "max(pd.DROIT_ID)").">0";
    $this->dbConn->executeSql($strSql);
    
    if( $appli_id>0 ) {
      AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
    } else {
      $this->memCacheFushFromSpace($cont_id);
    }
  }

  /**
   * Supprime le cache de toutes les applis gedit :
   *  - d'un espace si cont_id>0
   *  - de tous les espace si cont_id=-1
   *  - des espaces publics si cont_id=-2
   */
  private function memCacheFushFromSpace($cont_id)
  {
    $strSql = "select a.APPLI_ID".
      " from SIT_APPLI a" .
      "  inner join SIT_APPLI_CONT ac on ac.APPLI_ID=a.APPLI_ID" .
      "  inner join SIT_CONTENEUR c on c.CONT_ID=ac.CONT_ID".
      " where a.ATYPE_ID=".ALK_ATYPE_ID_GEDIT.
      ( $cont_id==-2
        ? " and c.CONT_ID>0 and c.CONT_PUBLIC=1"
        : ( $cont_id == -1 
            ? " and c.CONT_ID>0"
            : " and c.CONT_ID=".$cont_id ));
    
    $dsAppli = $this->dbConn->initDataSet($strSql);
    while( $drAppli = $dsAppli->getRowIter() ) {
      $appli_id = $drAppli->getValueName("APPLI_ID"); 
      AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
    }
  }

  /**
   * Suppression de l'accès à un espace (ou tous si cont_id=-1) pour un utilisateur
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   */
  public function removeUserFromSpace($user_id, $cont_id)
  {
    $strSql = "delete from GEDIT_01_DROIT where AGENT_ID in (".$user_id.")".
      ( $cont_id != "-1"
        ? " and PAGE_ID in " .
          "(select p.PAGE_ID " .
          " from GEDIT_01_PAGE p".
          "   inner join SIT_APPLI_CONT ac on ac.APPLI_ID=p.APPLI_ID".
          " where ac.CONT_ID=".$cont_id.")"
        : "" );
    $this->dbConn->executeSql($strSql);
    
    $this->memCacheFushFromSpace($cont_id);
  }

  /**
   * Recopie les droits fixés sur les profils de l'appli
   * vers les droits des profils sur toutes les pages
   * Si page_id!=-1, uniquement sur page_id et sur les pages qui en héritent
   *
   * @param appli_id  identifiant de l'application
   * @param page_id   identifiant de la page (publiée ou brouillon), =-1 par défaut pour toutes les pages de l'appli
   * @param tabRight  tableau contenant les couples (profil_id, droit_id) séparés par un tiret, 
   *                  =tableau vide par défaut, utilisé uniquement avec page_id !=-1
   */
  public function setRightsOnAppli($appli_id, $page_id=-1, $tabRight=array())
  {
    $page_racine_droit = "-1";
    if( $page_id == -1 ) {
      // recherche info sur la racine
      // si celle-ci n'hérite pas des droits de l'appli, on ne fait rien
      $strSql = "select PAGE_ID, PAGE_PUBLIC from GEDIT_01_PAGE where PAGE_NIVEAU=1 and APPLI_ID=".$appli_id." and PAGE_BROUILLON is null";
      $dsPage = $this->dbConn->initDataSet($strSql);
      if( $drPage = $dsPage->getRowIter() ) {
        $page_public  = $drPage->getValueName("PAGE_PUBLIC");
        $root_page_id = $drPage->getValueName("PAGE_ID");
      } else {
        return;
      }

      if( $page_public == "1" ) {
        // menage sur page racine (brouillon et publiée)
        $strSql = "delete from GEDIT_01_PROFIL where PAGE_ID in ".
          "(select PAGE_ID from GEDIT_01_PAGE where PAGE_NIVEAU=1 and APPLI_ID=".$appli_id.")";
        $this->dbConn->executeSql($strSql);
        
        // recopie les droits sur profil de l'appli pour la page racine (brouillon et publiée)
        $strSql = "insert into GEDIT_01_PROFIL (PAGE_ID, PROFIL_ID, DROIT_ID) ".
          " select g.PAGE_ID, p.PROFIL_ID, p.APPLI_DROIT_ID".
          " from  SIT_PROFIL_APPLI p, GEDIT_01_PAGE g".
          " where g.PAGE_NIVEAU=1 and g.APPLI_ID=".$appli_id." and p.APPLI_ID=".$appli_id;
        $this->dbConn->executeSql($strSql);

        // menage sur les droits/profils sur les pages qui héritent de la racine
        $strSql = "delete from GEDIT_01_PROFIL where PAGE_ID in ".
          "(select PAGE_ID from GEDIT_01_PAGE where PAGE_PUBLIC=1 and PAGE_NIVEAU>1 and APPLI_ID=".$appli_id.
          " and PAGE_RACINE_DROIT in (select PAGE_ID from GEDIT_01_PAGE where PAGE_NIVEAU=1 and APPLI_ID=".$appli_id."))";
        $this->dbConn->executeSql($strSql);

        // recopie les droits/profils sur les pages qui héritent de la racine
        $strSql = "insert into GEDIT_01_PROFIL (PAGE_ID, PROFIL_ID, DROIT_ID) ".
          " select g.PAGE_ID, p.PROFIL_ID, p.DROIT_ID".
          " from GEDIT_01_PROFIL p, GEDIT_01_PAGE g".
          " where g.PAGE_PUBLIC=1 and g.PAGE_NIVEAU>1 and g.APPLI_ID=".$appli_id.
          " and g.PAGE_RACINE_DROIT in (select PAGE_ID from GEDIT_01_PAGE where PAGE_NIVEAU=1 and APPLI_ID=".$appli_id.")".
          " and p.PAGE_ID=".$root_page_id;
        $this->dbConn->executeSql($strSql);
      } else {
        // on ne fait rien, la page racine n'hérite pas des droits de l'appli
      }
    } else {
      // recherche info sur la page
      $strSql = "select PAGE_PUBLIC, PAGE_NIVEAU, PAGE_RACINE_DROIT," .
        $this->dbConn->compareSql("PAGE_DATECREA", "=", "PAGE_DATEMAJ", "1", "0")." as mode_form".
        " from GEDIT_01_PAGE" .
        " where PAGE_ID=".$page_id;
      $dsPage = $this->dbConn->initDataSet($strSql);
      if( $drPage = $dsPage->getRowIter() ) {
        $page_public       = $drPage->getValueName("PAGE_PUBLIC");
        $page_niveau       = $drPage->getValueName("PAGE_NIVEAU");
        $page_racine_droit = $drPage->getValueName("PAGE_RACINE_DROIT");
        $iModeForm         = $drPage->getValueName("MODE_FORM");
      } else {
        return;
      } 
      
      $bRoot = ( $page_niveau == "1" ? true : false );
      $bAdd  = ( $iModeForm == "1" ? true : false );
      $strWithoutPageID = " and g.PAGE_ID<>".$page_id;
      $bEnd  = false;
      
      if( $page_public == "0" ) {
        // ici : $page_racine_droit = $page_id

        if( !empty($tabRight) ) {
          // fixe les droits spécifiques pour cette page qui devient racine des droits
          if( !$bAdd ) {
            $strSql = "delete from GEDIT_01_PROFIL where PAGE_ID=".$page_id;
            $this->dbConn->executeSql($strSql);
          }
           
          $strSqlBase = "insert into GEDIT_01_PROFIL (PAGE_ID, PROFIL_ID, DROIT_ID) values (".$page_id.", ";
          foreach($tabRight as $strRight) {
            $tabTmp = explode("-", $strRight);
            $strSql = $strSqlBase.$tabTmp[0].", ".$tabTmp[1].")";
            $this->dbConn->ExecuteSql($strSql);
          }
          
          // en mode ajout, il n'y a pas d'autres actions à faire
          $bEnd = $bAdd;           
        }
      }
      elseif( $bRoot ) {
        // recopie les droits de l'application pour cette page racine publique
        
        // ménage
        //if( !$bAdd ) {
        $strSql = "delete from GEDIT_01_PROFIL where PAGE_ID=".$page_id;
        $this->dbConn->executeSql($strSql);
        //}
        
        // recopie les droits sur profil de l'appli pour la page racine publique
        $strSql = "insert into GEDIT_01_PROFIL (PAGE_ID, PROFIL_ID, DROIT_ID) ".
          " select g.PAGE_ID, p.PROFIL_ID, p.APPLI_DROIT_ID".
          " from  SIT_PROFIL_APPLI p, GEDIT_01_PAGE g".
          " where g.PAGE_ID=".$page_id." and p.APPLI_ID=".$appli_id;
        $this->dbConn->executeSql($strSql); 
        
        // en mode ajout, il n'y a pas d'autres actions à faire
        $bEnd = $bAdd;           
      }
      else {
        // en mode ajout, on intègre page_id dans la recopie des droits pour le cas page_public=1
        $strWithoutPageID = ( $bAdd
                              ? " and g.PAGE_ID=".$page_id
                              : " and g.PAGE_ID<>".$page_racine_droit );
      }
      
      // ménage sur les pages qui héritent des droits de $page_racine_droit
      if( !$bAdd ) {
        $strSql = "delete from GEDIT_01_PROFIL where PAGE_ID in" .
          " (select g.PAGE_ID from GEDIT_01_PAGE g where g.PAGE_PUBLIC=1 ".$strWithoutPageID." and g.PAGE_RACINE_DROIT=".$page_racine_droit.")";
        $this->dbConn->executeSql($strSql);
      }
      
      if( !$bEnd ) {
        // recopie les droits de la page racine
        $strSql = "insert into GEDIT_01_PROFIL (PAGE_ID, PROFIL_ID, DROIT_ID) ".
          " select g.PAGE_ID, p.PROFIL_ID, p.DROIT_ID".
          " from GEDIT_01_PROFIL p, GEDIT_01_PAGE g". 
          " where g.PAGE_PUBLIC=1 ".$strWithoutPageID." and g.PAGE_RACINE_DROIT=".$page_racine_droit.
          "  and p.PAGE_ID=".$page_racine_droit ;
          $this->dbConn->executeSql($strSql);
      }
    }
    
    // précalcul les droits par agent pour toutes les pages qui héritent de $page_racine_droit
    $this->setRightProfilToAgentByAppli($appli_id, $page_racine_droit);
    
    AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);
  }
  
  /**
   * Enregistre les droits des profils sur les pages publiques de l'application qui héritent de la racine 
   * si celle-ci hérite des droits de l'appli
   * @param appli_id      identifiant de l'application
   * @param tabRight      tableau de type "_".idProfil => droid_id pour les autres applis
   */
  public function setProfilRightsOnSpace($appli_id, $tabRight=array())
  {
    $this->setRightsOnAppli($appli_id);
  }
  
  /**
   * fixe les droits aux agents de l'espace / aux droits sur profil sur une application
   *
   * @param appli_id           Identifiant de l'application (peut valoir -1 pour tous les espaces)
   * @param page_racine_droit  Identifiant de la page racine pour l'héritage des droits (=-1 par défaut pour ttes les pages de appli_id ou de l'espace)
   */
  protected function setRightProfilToAgentByAppli($appli_id, $page_racine_droit="-1")
  {
    $strWhere = ( $page_racine_droit != "-1"
                  ? "PAGE_RACINE_DROIT=".$page_racine_droit 
                  : ( $appli_id == "-1"  
                      ? "PAGE_ID>0" 
                      : "APPLI_ID=".$appli_id ));
    
    // ménage
    $strSql = "delete from GEDIT_01_DROIT where PAGE_ID" .
      ( $appli_id == "-1"
        ? ">0" 
        : " in (select PAGE_ID from GEDIT_01_PAGE where ".$strWhere.")" );
    $this->dbConn->executeSql($strSql);
    
    $strSql = "insert into GEDIT_01_DROIT (AGENT_ID, PAGE_ID, DROIT_ID)". 
      " select agc.AGENT_ID, pd.PAGE_ID,  ".$this->dbConn->compareSql("agc.CONT_ADMIN", "=", "1", "4", "max(pd.DROIT_ID)")." ".
      " from GEDIT_01_PAGE p". 
      "   inner join GEDIT_01_PROFIL pd  on p.PAGE_ID=pd.PAGE_ID".
      "   inner join SIT_APPLI_CONT ac   on p.APPLI_ID=ac.APPLI_ID".
      "   inner join SIT_AGENT_CONT agc  on agc.CONT_ID=ac.CONT_ID".
      "   inner join SIT_AGENT_PROFIL ap on (pd.PROFIL_ID=ap.PROFIL_ID and ap.AGENT_ID=agc.AGENT_ID)".
      " where p.".$strWhere.  
      " group by agc.AGENT_ID, pd.PAGE_ID, agc.CONT_ADMIN".
      " having ".$this->dbConn->compareSql("agc.CONT_ADMIN", "=", "1", "4", "max(pd.DROIT_ID)").">0";
    $this->dbConn->executeSql($strSql);    
  }

  /**
   * fixe le droit spécifique de l'utilisateur Personnalisation des droits d'un utilisateur
   * @note Appelé en admin. annuaire avec gestion des droits sur un profil sur l'espace courant
   * @param appli_id      identifiant de l'appli gedit
   * @param user_id       identifiant de l'utilisateur sélectionné
   * @param iRight        droit fixé sur l'appli gedit
   * @param iDefaultRight non utilisé
   */
  public function setUserRightsOnSpace($appli_id, $user_id, $iRight=-1, $iDefaultRight=-1)
  {
    // on ne répercute pas le droit des utilisateurs aux éléments de l'appli car aucune possiblité de personnalisation par la suite.
    
    /*$strSetRubID = "(select p.PAGE_ID from GEDIT_01_PAGE p where p.PAGE_PUBLIC=1 and p.APPLI_ID=".$appli_id.")";
    
    // menage
    $strSql = "delete from GEDIT_01_DROIT where AGENT_ID=".$user_id." and PAGE_ID in ".$strSetRubID;
    $this->dbConn->executeSql($strSql);

    // insertion du droit
    if( $iRight>0 ) {
      $strSql = "insert into GEDIT_01_DROIT (AGENT_ID, PAGE_ID, DROIT_ID) ".
        " select ".$user_id.", p.PAGE_ID, ".$iRight.
        " from GEDIT_01_PAGE p".
        " where p.PAGE_PUBLIC=1 and p.APPLI_ID=".$appli_id;
      $this->dbConn->executeSql($strSql);
    }
    
    AlkFactory::memCacheFlush(constant("ALK_ATYPE_ABREV_".ALK_ATYPE_ID_GEDIT)."_".$appli_id);*/
  }
  
  /**
   * Applique les droits d'un utilisateur par rapport à ses profils
   * @param user_id  identifiant de l'utilisateur 
   */
  public function setProfilRightToUser($user_id)
  {
    // ménage
    $strSql = "delete from GEDIT_01_DROIT where AGENT_ID in (".$user_id.")";
    $this->dbConn->executeSql($strSql);
    
    $strSql = "insert into GEDIT_01_DROIT (AGENT_ID, PAGE_ID, DROIT_ID)". 
      " select agc.AGENT_ID, pd.PAGE_ID,  ".$this->dbConn->compareSql("agc.CONT_ADMIN", "=", "1", "4", "max(pd.DROIT_ID)")." ".
      " from GEDIT_01_PAGE p". 
      "   inner join GEDIT_01_PROFIL pd  on p.PAGE_ID=pd.PAGE_ID".
      "   inner join SIT_APPLI_CONT ac   on p.APPLI_ID=ac.APPLI_ID".
      "   inner join SIT_AGENT_CONT agc  on agc.CONT_ID=ac.CONT_ID".
      "   inner join SIT_AGENT_PROFIL ap on (pd.PROFIL_ID=ap.PROFIL_ID and ap.AGENT_ID=agc.AGENT_ID)".
      " where pd.PAGE_ID>0 and agc.AGENT_ID in (".$user_id.")".
      " group by agc.AGENT_ID, pd.PAGE_ID, agc.CONT_ADMIN".
      " having ".$this->dbConn->compareSql("agc.CONT_ADMIN", "=", "1", "4", "max(pd.DROIT_ID)").">0";
    $this->dbConn->executeSql($strSql);  
    
    AlkFactory::memCacheFlush();
  }

  /**
   * Ajoute un bloc, l'associe à la page puis retourne son identifiant
   *        Si le bloc est de type éditorial, le contenu est créé puis associé au bloc.
   * @param page_id    identifiant de la page
   * @param user_id    identifiant de l'utilisateur connecté
   * @param typeIdBloc type de bloc
   * @param iColonne   type de représentation : normal=0, colonne=1
   * @param bRssUser   permet de savoir si on enregistre le bloc rss avec le user_id
   * @return int
   */
  public function addGEditBloc($page_id, $user_id, $typeIdBloc, $iColonne, $bRssUser=false)
  {
    $bloc_id = $this->dbConn->getNextId("GEDIT_01_BLOC","BLOC_ID", "SEQ_GEDIT_01_BLOC");
    $iRang = $this->dbConn->getNextRank("GEDIT_01_BLOC", "BLOC_RANG", "PAGE_ID=".$page_id);
        
    // ajoute le bloc
    $strSql = "insert into GEDIT_01_BLOC (BLOC_ID, BLOC_NOM, TB_ID, BLOC_RANG, PAGE_ID,".
      "BLOC_DATECREA, BLOC_DATEMAJ, AGENT_ID_CREA, AGENT_ID_MAJ, BLOC_COLONNE, BLOC_LOCK) values (".$bloc_id.
      ", 'BlocId".$bloc_id."'".
      ", ".$typeIdBloc.
      ", ".$iRang.
      ", ".$page_id.
      ", ".$this->dbConn->getDateCur().
      ", ".$this->dbConn->getDateCur().
      ", ".$user_id.
      ", ".$user_id.
      ", ".$iColonne.
      ", ".( $typeIdBloc == "16" && $bRssUser ? "1" : "0" ).  // lock de page pour éviter la suppression lors d'une publication ou restauration
      ")";
    $this->dbConn->executeSql($strSql) ;

    if( $typeIdBloc == "1" ) {
      // ajoute un contenu vide
      $contenu_id = $this->dbConn->getNextId("GEDIT_01_CONTENU","CONTENU_ID", "SEQ_GEDIT_01_CONTENU") ;
      $strSql = "insert into GEDIT_01_CONTENU (CONTENU_ID, BLOC_ID) values (".$contenu_id.", ".$bloc_id.")";
      $this->dbConn->executeSql($strSql);
    }
    
    if( $typeIdBloc == "16" ) { // bloc de type RSS
      // ajoute un bloc RSS vide
      $rss_id = $this->dbConn->getNextId("GEDIT_01_BLOC_RSS","RSS_ID", "SEQ_GEDIT_01_BLOC_RSS") ;
      
      if ($bRssUser)
        $strSql = "insert into GEDIT_01_BLOC_RSS (RSS_ID, BLOC_ID, AGENT_ID) values (".$rss_id.", ".$bloc_id.",".$user_id.")";
      else
         $strSql = "insert into GEDIT_01_BLOC_RSS (RSS_ID, BLOC_ID) values (".$rss_id.", ".$bloc_id.")";
      $this->dbConn->executeSql($strSql);
    }

    $strSql = "update  GEDIT_01_PAGE set".
      "  PAGE_DATEMAJ=".$this->dbConn->getDateCur().
      ", AGENT_ID_MAJ=".$user_id.
      " where PAGE_ID=".$page_id;
    $this->dbConn->executeSql($strSql);
    
    AlkFactory::memCacheFlush("gedit");
    return $bloc_id;
  }

  /**
   * Supprime un bloc et éventuellement le contenu editorial associé
   * @param bloc_id   identifiant du bloc
   */
  public function delGEditBloc($page_id, $bloc_id, $user_id, $bDelForDup=false)
  {
    $tabSql[] = "delete from GEDIT_01_CONTENU where BLOC_ID in (".$bloc_id.")";
    $tabSql[] = "delete from GEDIT_01_APPLI_BLOC where BLOC_ID in (".$bloc_id.")";

    $tabSql[] = "delete from GEDIT_01_BLOC_RSS where BLOC_ID in (".$bloc_id.")".
      ( $bDelForDup
        ? " and AGENT_ID is null"
        : "" );
    $tabSql[] = "delete from GEDIT_01_BLOC where BLOC_ID in (".$bloc_id.")";
    $tabSql[] = "update  GEDIT_01_PAGE set".
      "  PAGE_DATEMAJ=".$this->dbConn->getDateCur().
      ", AGENT_ID_MAJ=".$user_id.
      " where PAGE_ID=".$page_id;

    foreach($tabSql as $strSql) {
      $this->dbConn->executeSql($strSql);
    }
    AlkFactory::memCacheFlush("gedit");
  }

  /**
   * Met à jour l'information de mise en colonne de l'information
   * @param $bloc_atypeid  identifie le type de bloc (graphe, carto ...)
   * @param bloc_id        Identifiant du bloc
   * @param icolumn        entier : =1 pour mise en colonne, =0 sinon
   * @param bloc_typeassoc type de données associée : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on : présente les news uniquement
   *                       si bit 3 on : présente les docs publiés passés
   *                       si bit 4 on : présente les docs publiés présents
   *                       si <=3, présente tous les docs publiés : passés, présent, à venir
   * @param user_id        Identifiant de l'utilisateur connecté
   * @param bloc_order     chaine contenant l'odre de tri des données séparé par des virgules
   * @param bloc_datedeb   date de début du filtre calendaire
   * @param bloc_datefin   date de fin du filtre calendaire
   * @param tab_bloc_nom   tableau contenant le nom du bloc
   */
  public function updateBlocColumn($bloc_id, $iColumn, $bloc_typeassoc, $user_id, $bloc_order="", $bloc_datedeb="", 
                                   $bloc_datefin="", $tab_bloc_nom=array(), $bloc_desc="", $bloc_limit="-1")
  {
   $strIntituleValues = "";
   foreach($this->tabLangue as $key => $tabLg) {
      $strIntituleValues .= 
        ", BLOC_NOM".$tabLg["bdd"]."='".$this->dbConn->analyseSql($tab_bloc_nom[$key])."'";
    }
    $strIntituleValues .= ", BLOC_DESC='".$this->dbConn->analyseSql($bloc_desc)."', BLOC_LIMIT=".$bloc_limit;
    
    $tabSql[] = "update GEDIT_01_BLOC set".
      "  BLOC_DATEMAJ=".$this->dbConn->getDateCur().
      ", AGENT_ID_MAJ=".$user_id.
      ", BLOC_COLONNE=".$iColumn.
      ", BLOC_TYPEASSOC=".$bloc_typeassoc.
      ($bloc_datedeb!="" ? ", BLOC_DATEDEB=".$this->dbConn->getDateFormat("DD/MM/YYYY", "'".$bloc_datedeb."'") : "").
      ($bloc_datefin!="" ? ", BLOC_DATEFIN=".$this->dbConn->getDateFormat("DD/MM/YYYY", "'".$bloc_datefin."'") : "").
      ", BLOC_ORDRE='".$this->dbConn->analyseSql($bloc_order)."'".
      $strIntituleValues.
      " where BLOC_ID=".$bloc_id;
    $tabSql[] = "update GEDIT_01_PAGE set".
      "  PAGE_DATEMAJ=".$this->dbConn->getDateCur().
      ", AGENT_ID_MAJ=".$user_id.
      " where PAGE_ID in (select PAGE_ID from GEDIT_01_BLOC where BLOC_ID=".$bloc_id.")";
    foreach($tabSql as $strSql) {
      $this->dbConn->executeSql($strSql);
    }
    
    AlkFactory::memCacheFlush("gedit");

  }

  /**
   * Met à jour le rang d'un bloc dans une page
   * @param page_id  Identifiant de la page
   * @param bloc_id  Identifiant du bloc
   * @param iDelta   Sens de déplacement d'un bloc : -1 = précédent, +1 = suivant
   */
  public function updateBlocRank($page_id, $bloc_id, $iDelta, $user_id)
  {
    $strSql = "select BLOC_RANG from GEDIT_01_BLOC where BLOC_ID=".$bloc_id." and PAGE_ID=".$page_id;
    $dsBloc = $this->dbConn->initDataset($strSql);
    if( $drBloc = $dsBloc->getRowIter() ) {
      $iRang = $drBloc->getValueName("BLOC_RANG");
      $this->dbConn->switchRank("GEDIT_01_BLOC", "BLOC_RANG", $iRang, $iDelta, "PAGE_ID=".$page_id, "BLOC_ID=".$bloc_id);
    }

    $strSql = "update  GEDIT_01_PAGE set".
      "  PAGE_DATEMAJ=".$this->dbConn->getDateCur().
      ", AGENT_ID_MAJ=".$user_id.
      " where PAGE_ID=".$page_id;
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * Création d'une association entre bloc et appli 
   * @param bloc_id  Identifiant du bloc
   * @param appli_id Identifiant de l'application
   */
  public function assocAppliToBloc($bloc_id, $appli_id)
  {
    $this->removeAppliFromBloc($bloc_id, -1);
    
    $strSql = "insert into GEDIT_01_APPLI_BLOC (BLOC_ID, APPLI_ID) values (".$bloc_id.", ".$appli_id.")";
    $this->dbConn->executeSql($strSql);
  }

  /**
   * Supprime une association bloc et appli 
   * @param bloc_id  Identifiant du bloc
   * @param appli_id Identifiant de l'application
   */
  public function removeAppliFromBloc($bloc_id, $appli_id)
  {
    $strSql = "delete from GEDIT_01_APPLI_BLOC where BLOC_ID=".$bloc_id.( $appli_id != "-1" ? " and APPLI_ID=".$appli_id : "" );
    $this->dbConn->executeSql($strSql);
  }
  
  /**
   * Modifie un bloc de type RSS
   * @param tabQueryRss les infos rss 
   * @param tabQueryBloc les infos de bloc conteneur
   */
  public function updateRss($tabQueryRss, $tabQueryBloc)
  {
    $rss_id = $tabQueryRss["pk"]["RSS_ID"][1];
    
    $strSql = "update GEDIT_01_BLOC_RSS set ".$this->getPartUpdateSql($tabQueryRss["field"])." where RSS_ID=".$rss_id;
    $this->dbConn->executeSql($strSql);
    
    $bloc_id = $tabQueryBloc["pk"]["BLOC_ID"][1];
    $iColumn = $tabQueryBloc["field"]["BLOC_COLONNE"][1];
    $user_id = AlkFactory::GetSProperty("user_id", "-1");
    $this->updateBlocColumn($bloc_id, $iColumn, 0, $user_id);
  }
  
  /**
   * Autorise l'abonnement à une page
   */
  public function enablePageAbonnement($page_id)
  {
    $strSql = "update GEDIT_01_PAGE_LISTE set ABONNEMENT=1 where PAGE_ID=".$page_id;
    $this->dbConn->executeSql($strSql);
    $this->updatePageAbonnement($page_id);
  }
  
  /**
   * Interdit l'abonnement à une page
   */
  public function disablePageAbonnement($page_id)
  {
    $strSql = "update GEDIT_01_PAGE_LISTE set ABONNEMENT=0 where PAGE_ID=".$page_id;
    $this->dbConn->executeSql($strSql);
    
    // récupère la liste de la page
    $liste_id = -1;
    $oQueryLsDif = AlkFactory::getQuery(ALK_ATYPE_ID_LSDIF);
    $oDsAbonnement = $oQueryLsDif->getInfoAbonnement("GEDIT_01_PAGE_LISTE", "PAGE_ID", $page_id);
    if ( $oDrAbonnement = $oDsAbonnement->getRowIter() ) {
      $liste_id = $oDrAbonnement->getValueName("LISTE_ID");
    }
    
    // récupère tous les abonnés de la page
    $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
    $oDsAbonne = $oQueryAnnu->getDsAbonnesByListe($liste_id, true);
    
    // supprime tous les abonnés de la page et des sous-pages
    while ( $oDrAbonne = $oDsAbonne->getRowIter() ) {
      $abonne_id = $oDrAbonne->getValueName("ABONNE_ID");
      $this->delPageAbonnement($abonne_id, $page_id);
    }
  }
  
  /**
   * Ajoute un ou plusieurs abonnés à la liste des abonnés d'une page
   * Répercute les abonnés en profondeur de façon récursive sur les sous-pages
   */
  public function addPageAbonnement($page_id, $abonne_id, $strDateCur="", $bAuto=false)
  {
    $oQuerLsDif = AlkFactory::getQuery(ALK_ATYPE_ID_LSDIF);
    $oQueryActionAnnu = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
    
    // récupère les informations d'abonnement de la page
    $liste_id = -1;
    $iAbonnement = 0;
    $oDsInfo = $oQuerLsDif->getInfoAbonnement("GEDIT_01_PAGE_LISTE", "PAGE_ID", $page_id);
    if ( $oDrInfo = $oDsInfo->getRowIter() ) {
      $liste_id = $oDrInfo->getValueName("LISTE_ID");
      $iAbonnement = $oDrInfo->getValueName("ABONNEMENT");
    }
    
    // ajoute le ou les abonnés à la liste des abonnés de la page
    if ( $liste_id != -1 && $iAbonnement != 0 ) {
      $oQueryActionAnnu->addAbonnement($abonne_id, $liste_id, $strDateCur, $bAuto);
    }
 
    // met à jour les abonnés pour chaque sous-page (appel récursif)
    $strSql = "select PAGE_ID from GEDIT_01_PAGE" .
      " where PAGE_PARENT =".$page_id;
    $oDsPage = $this->dbConn->initDataset($strSql);
    while ( $oDrPage = $oDsPage->getRowIter() ) {
      $page_id = $oDrPage->getValueName("PAGE_ID");
      $oQueryActionAnnu->addPageAbonnement($page_id, $abonne_id, $strDateCur, true);
    }
  }
  
  /**
   * Met à jour les abonnés d'une page en fonction de sa page parente
   * Répercute les abonnés en profondeur de façon récursive sur les sous-pages
   */
  public function updatePageAbonnement($page_id)
  {
    $oQuerLsDif = AlkFactory::getQuery(ALK_ATYPE_ID_LSDIF);
    $oQueryActionAnnu = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
    
    // récupère la page parente
    $strSql = "select PAGE_PARENT from GEDIT_01_PAGE where PAGE_ID=".$page_id;
    $oDsPage = $this->dbConn->initDataSet($strSql);
    if ( $oDrPage = $oDsPage->getRowIter() ) {
      $page_id_parent = $oDrPage->getValueName("PAGE_PARENT");
    } else {
      return;
    }
    
    // récupère les informations d'abonnement de la page parente
    $liste_id_parent = -1;
    $iAbonnementParent = 0;
    $oDsInfoParent = $oQuerLsDif->getInfoAbonnement("GEDIT_01_PAGE_LISTE", "PAGE_ID", $page_id_parent);
    if ( $oDrInfoParent = $oDsInfoParent->getRowIter() ) {
      $liste_id_parent = $oDrInfoParent->getValueName("LISTE_ID");
      $iAbonnementParent = $oDrInfoParent->getValueName("ABONNEMENT");
    }
    
    // récupère les informations d'abonnement de la page
    $liste_id = -1;
    $iAbonnement = 0;
    $oDsInfo = $oQuerLsDif->getInfoAbonnement("GEDIT_01_PAGE_LISTE", "PAGE_ID", $page_id);
    if ( $oDrInfo = $oDsInfo->getRowIter() ) {
      $liste_id = $oDrInfo->getValueName("LISTE_ID");
      $iAbonnement = $oDrInfo->getValueName("ABONNEMENT");
    }
    
    // met à jour les abonnés de la page
    if ( $liste_id != -1 && $iAbonnement != 0 ) {
      $oQueryActionAnnu->delAllAbonnement($liste_id, true);
      if ( $liste_id_parent != -1 && $iAbonnementParent != 0 ) {
        $oQueryActionAnnu->addAbonnesFromListeToListe($liste_id_parent, $liste_id, true, 1);
      }
    }
    
    // met à jour les abonnés pour chaque sous-page (appel récursif)
    $strSql = "select PAGE_ID from GEDIT_01_PAGE" .
      " where PAGE_PARENT =".$page_id;
    $oDsPage = $this->dbConn->initDataset($strSql);
    while ( $oDrPage = $oDsPage->getRowIter() ) {
      $page_id = $oDrPage->getValueName("PAGE_ID");
      $this->updatePageAbonnement($page_id);
    }
  }
  
  /**
   * Supprime un abonné de la liste des abonnés d'une page
   * Répercute les abonnés en profondeur de façon récursive sur les sous-pages
   */
  public function delPageAbonnement($abonne_id, $page_id, $strDate="")
  {
    $oQuerLsDif = AlkFactory::getQuery(ALK_ATYPE_ID_LSDIF);
    $oQueryActionAnnu = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
    
    // récupère les informations d'abonnement de la page
    $liste_id = -1;
    $oDsInfo = $oQuerLsDif->getInfoAbonnement("GEDIT_01_PAGE_LISTE", "PAGE_ID", $page_id);
    if ( $oDrInfo = $oDsInfo->getRowIter() ) {
      $liste_id = $oDrInfo->getValueName("LISTE_ID");
    }
    
    // supprime l'abonné de la liste des abonnés de la page
    $oQueryActionAnnu->delAbonnement($abonne_id, $liste_id, -1, $strDate);
    
    // met à jour les abonnés pour chaque sous-page (appel récursif)
    $strSql = "select PAGE_ID from GEDIT_01_PAGE" .
      " where PAGE_PARENT=".$page_id;
    $oDsPage = $this->dbConn->initDataset($strSql);
    while ( $oDrPage = $oDsPage->getRowIter() ) {
      $page_id = $oDrPage->getValueName("PAGE_ID");
      $this->delPageAbonnement($abonne_id, $page_id, $strDate);
    }
  }
  
  /**
   * Change le rang des pages soeurs de la page id (avant et apres son déplacement)
   * @param type $page_id Identifiant de la page qui a été déplacé
   * @param type $page_id_parent_start Identifiant de la page parent avant déplacement
   * @param type $page_id_parent_end Identifiant de la page parent après déplacement
   * @param type $page_rang_start Indice du rang de la page avant déplacement
   * @param type $page_rang_end Indice du rang de la page après déplacement
   */
  public function updatePageRang($page_id, $page_id_parent_start, $page_id_parent_end, $page_rang_start, $page_rang_end){
    
    $strSql = "select PAGE_BROUILLON from GEDIT_01_PAGE where PAGE_ID=".$page_id."";
    $page_id_brouillon = $this->dbConn->getScalarSql($strSql,-1);
    $strSql = "select PAGE_BROUILLON from GEDIT_01_PAGE where PAGE_ID=".$page_id_parent_start."";
    $page_id_parent_start_brouillon = $this->dbConn->getScalarSql($strSql,-1);
    $strSql = "select PAGE_BROUILLON from GEDIT_01_PAGE where PAGE_ID=".$page_id_parent_end."";
    $page_id_parent_end_brouillon = $this->dbConn->getScalarSql($strSql,-1);
    
    $strSql = "";
    
    $bOK = $this->dbConn->initTransaction();
    $tabSql = array();
    
    if($page_id_parent_start == $page_id_parent_end){
      if($page_rang_start < $page_rang_end){
        //on diminue le rang de toutes les pages dont la page parent est $page_id_parent_start et page_rang <= $page_rang_end et page_rang > $page_rang_start
        $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = PAGE_RANG - 1 WHERE PAGE_PARENT = ".$page_id_parent_start." AND PAGE_ID <> ".$page_id." AND PAGE_RANG <= ".$page_rang_end." AND PAGE_RANG > ".$page_rang_start." ; ";
        
        $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = PAGE_RANG - 1 WHERE PAGE_PARENT = ".$page_id_parent_start_brouillon." AND PAGE_ID <> ".$page_id_brouillon." AND PAGE_RANG <= ".$page_rang_end." AND PAGE_RANG > ".$page_rang_start." ; ";
      }else {
        //on augmente le rang de toutes les pages dont la page parent est $page_id_parent_start et page_rang >= $page_rang_end et page_rang < $page_rang_start
        $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = PAGE_RANG + 1 WHERE PAGE_PARENT = ".$page_id_parent_start." AND PAGE_ID <> ".$page_id." AND PAGE_RANG > ".$page_rang_end." AND PAGE_RANG <= ".$page_rang_start." ; ";
        $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = PAGE_RANG + 1 WHERE PAGE_PARENT = ".$page_id_parent_start_brouillon." AND PAGE_ID <> ".$page_id_brouillon." AND PAGE_RANG > ".$page_rang_end." AND PAGE_RANG <= ".$page_rang_start." ; ";
      }
    }else{
      //on diminue le rang de toutes les pages dont la page parent est $page_id_parent_start et page_rang > $page_rang_start
      $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = PAGE_RANG - 1 WHERE PAGE_PARENT = ".$page_id_parent_start." AND PAGE_ID <> ".$page_id." AND PAGE_RANG > ".$page_rang_start." ; ";
      $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = PAGE_RANG - 1 WHERE PAGE_PARENT = ".$page_id_parent_start_brouillon." AND PAGE_ID <> ".$page_id_brouillon." AND PAGE_RANG > ".$page_rang_start." ; ";
      //on augmente le rang de toutes les pages dont la page parent est $page_id_parent_end et page_rang >= $page_rang_end
      $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = PAGE_RANG + 1 WHERE PAGE_PARENT = ".$page_id_parent_end." AND PAGE_ID <> ".$page_id." AND PAGE_RANG > ".$page_rang_end." ; ";
      $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = PAGE_RANG + 1 WHERE PAGE_PARENT = ".$page_id_parent_end_brouillon." AND PAGE_ID <> ".$page_id_brouillon." AND PAGE_RANG > ".$page_rang_end." ; ";
    }
    if($page_rang_start < $page_rang_end){
      $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = ".$page_rang_end." WHERE PAGE_ID = ".$page_id." ; ";
      $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = ".$page_rang_end." WHERE PAGE_ID = ".$page_id_brouillon." ; ";
    }else{
      $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = ".$page_rang_end."+1 WHERE PAGE_ID = ".$page_id." ; ";
      $tabSql[] = " UPDATE GEDIT_01_PAGE  SET PAGE_RANG = ".$page_rang_end."+1 WHERE PAGE_ID = ".$page_id_brouillon." ; ";
    }
    foreach($tabSql as $strSql){
      $bOK = $bOK && $this->dbConn->executeSql($strSql);
    }
    ($bOK ? $this->dbConn->commitTransaction() : $this->dbConn->rollBackTransaction() );
  }

}
?>