<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

include_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkappli.class.php";

/**
 * @package Alkanet_Module_LsDif
 * Module liste de diffusion
 * @class AlkAppliLsDif
 * Classe de l'application liste de diffusion 
 */
final class AlkAppliLsDif extends AlkAppli implements AlkIntAppli, AlkIntRights, AlkIntGedit, AlkIntAbonne
{

  /**
   * Constructeur par défaut
   * @param appli_id  Identifiant de l'application
   */
  public function __construct($appli_id)
  {
    parent::__construct(ALK_ATYPE_ID_LSDIF, $appli_id);
  }

  /**
   * Destructeur par défaut
   */
  public function __destruct() { }

  /**
   * Vérifie les droits spécifiques à l'application
   *        Retourne vrai si l'utilisateur connecté possède les droits, faux sinon
   * @return booleen
   */
  public function verifSecuAppli()
  { 
    return true;
  }

  /**
   * Ajout d'une application à un espace. Retourne l'identifiant de l'appli créée
   * @param tabFields tableau associatif des champs nécessaires à la création d'une appli
   * @return int
   */
  public function addAppli($tabFields) { 
    
    // création du répertoire upload
    $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF, true).$this->cont_id."/"; 
    if( !(@file_exists(ALK_ALKANET_ROOT_PATH.$strPathUpload) && @is_dir(ALK_ALKANET_ROOT_PATH.$strPathUpload)) ) {
      $bRes = @mkdir(ALK_ALKANET_ROOT_PATH.$strPathUpload, 0770);
      if( !$bRes ) {
        $strPathUpload = AlkFactory::getUploadPath(ALK_ATYPE_ID_LSDIF, true);
      } 
    }
  
  }
   
  /**
   * Modification d'une application
   * @param tabFields tableau associatif des champs nécessaires à la création d'une appli
   */
  public function updateAppli($tabFields) { /** rien à faire */ }

  /**
   * Suppression de l'application d'un espace
   *        Suppression des boites de messages
   */
  public function delAppli()
  {
    $this->oQueryAction->delAppli($this->appli_id);
  }

  /**
   * Déplacement d'une application d'un espace vers un autre
   *        Cette méthode se charge d'appelé la recopie des droits
   * @param $appli_id  identifiant de l'appli
   * @param $idContTo  identifiant de l'espace recevant l'appli
   */
  public function moveAppli($idContTo) { /** rien à faire */ }

  /**
   * Duplication de la structure et du paramètrage de l'application src à la courante
   * @param appli_id_src  identifiant de l'application source
   * @param iTypeDup      type de duplication : 0 = application vierge (ne fait rien) 
   *                                            1 = structure et paramétrage
   *                                            2 = structure, paramétrage et données  
   */
  public function dupAppli($appli_id_src, $iTypeDup) { /** rien à faire */ }

  /**
   * Transfère de propriété d'un utilisateur à un autre
   *        Méthode à appeler avant suppression définitive d'un utilisateur
   * @param idUserFrom  identifiant de l'utilisateur perdant la propriété des ses données
   * @param idUserTo    identifiant de l'utilisateur récupérant la propriété des données
   */
  public function replaceUser($idUserFrom, $idUserTo)
  {
    $this->oQueryAction->replaceUser($idUserFrom, $idUserTo);
  }

  /**
   * Invitation d'un utilisateur à un espace (tous si cont_id=-1, tous les espaces publics si cont_id=-2)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces. -2 tous les espaces publics
   * @param priv_id  identifiant du privilège
   */
  public function addUserToSpace($user_id, $cont_id, $priv_id) { /** rien à faire */ }

  /**
   * Modification du privilège espace pour l'utilisateur à un espace (tous si cont_id=-1)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   * @param priv_id  identifiant du privilège
   */
  public function updateUserPrivToSpace($user_id, $cont_id, $priv_id) { /** rien à faire */ }

  /**
   * Suppression de l'accès à un espace (ou tous si cont_id=-1) pour un utilisateur
   *        Suppression de la boite de message de l'utilisateur
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   */
  public function removeUserFromSpace($user_id, $cont_id)
  {
    $this->oQueryAction->delBoiteReceptionAgent($this->appli_id, $user_id);
  }

  /**
   * Personnalisation des droits d'un utilisateur
   * @note Appelé en admin. annuaire avec gestion des droits sur un profil sur l'espace courant
   * @param cont_id       identifiant de l'espace
   * @param user_id       identifiant de l'utilisateur sélectionné
   * @param iRight        non utilisé
   * @param iDefaultRight non utilisé
   */
  public function setUserRightsOnSpace($cont_id, $user_id, $iRight=-1, $iDefaultRight=-1) { /** rien à faire */ }
  
  /**
   * Enregistre les droits des profils sur les applications d'un espace
   * @param cont_id       identifiant d'utilisateur
   * @param tabRight      non utilisé dans le cas espace, 
   *                      sinon tableau de type "_".idProfil => droid_id pour les autres applis
   */
  public function setProfilRightsOnSpace($cont_id, $tabRight=array()) { /** rien à faire */ }
    
  /**
   * Application de droits sur les profils pour l'application
   * @note Appelé en config. espace avec gestion des droits sur les profils pour l'appli
   * @param atype_id  type d'application
   * @param appli_id  identifiant de l'application
   */
  public function setRightsOnAppli($atype_id, $appli_id) { /** rien à faire */ }
  
  /**
  * Applique les droits d'un utilisateur par rapport à ses profils
  * @param user_id  identifiant de l'utilisateur 
  */
  public function setProfilRightToUser($user_id){}
  
  /** 
   * Ajout d'un profil sur l'extranet.
   *        Si l'application gère des droits, il faut y associer le droit NONE
   * @param profil_id  identifiant du profil à supprimer
   * @param cont_id    identifiant de l'espace associé, =0 pour tous les espaces (par défaut)
   */
  public function addProfil($profil_id, $cont_id=0) { /** rien à faire */ }

  /** 
   * Suppression du profil sur la gestion des droits interne à l'appli
   * @param profil_id  identifiant du profil à supprimer
   */
  public function delProfil($profil_id) { /** rien à faire */ }
  
  /**
   * Méthode appelée pour créer une liste d'abonnés associée à la donnée
   */
  public function createListeAbonnes($data_id=-1, $mode=-1, $iAbonnement=0) { /** rien à faire */ }
  
  /**
   * Méthode appelée pour autoriser l'abonnement
   */
  public function enableAbonnement($data_id=-1, $mode=-1) { /** rien à faire */ }
  
  /**
   * Méthode appelée pour interdire l'abonnement
   */
  public function disableAbonnement($data_id=-1, $mode=-1) { /** rien à faire */ }
  
  /**
   * Méthode appelée après suppression d'un abonnement
   * @param abonne_id  identifiant de l'abonné, peut contenir une liste d'identifiant
   * @param liste_id   identifiant de la liste de laquelle on souhaite désabonné
   */
  public function delAbonnement($abonne_id, $liste_id=-1)
  {
    $this->oQueryAction->delAbonnement($abonne_id, $this->appli_id, $liste_id);
  }

  /**
   * Méthode appelée avant suppression définitive d'un abonne
   * Attention, si un abonné est propriétaire d'une info, il ne faut pas la supprimer
   * Implémenter les actions effectuant le ménage interne à l'application
   * Retourne true si l'abonné reste supprimable, faux si il est propriétaire d'info
   * @param abonne_id  identifiant de l'abonné, peut contenir une liste d'identifiant
   * @return boolean
   */
  public function delAbonne($abonne_id)
  {
    return $this->oQueryAction->delAbonne($abonne_id);
  }

  /**
   * Méthode appelée avant suppression définitive d'une liste d'abonnés
   * @param liste_id  identifiant de la liste, peut contenir une liste d'identifiant
   */
  public function delListe($liste_id) 
  {
    $this->oQueryAction->delListe($liste_id);
  }

  
  /**
   * Retourne l'objet Panel correspondant au iSheet et iSSheet sélectionné
   * 
   * @param oAppliFrom    AlkAppli   Application appelant cette fonction (principe call services par dérivation)
   * 
   * @return AlkHtmlPanel
   */
  public function getPanel(AlkAppli $oAppliFrom=null)
  {    
    $oPanel = null;
    switch( $this->iTypeSheet ) {
    case ALK_TYPESHEET_CONSULT: // partie administration
      switch ( $this->iSheet ) {
        case ALK_SHEET_RECEPTION : //onglet boite reception
        case ALK_SHEET_ENVOYES : //onglet liste messages envoyés
        case ALK_SHEET_LETTRES : //onglet liste messages envoyés
        case ALK_SHEET_MODELES : //onglet liste messages envoyés
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlformlsdiflist.class.php");
          $oPanel = new AlkHtmlFormLsDifList($this);
          break; 
        
        case ALK_SHEET_FORM : // onglet ecrire
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlformlsdifform.class.php");
          $oPanel = new AlkHtmlFormLsDifForm($this);
          break;
        
        case ALK_SHEET_ABONNELISTE : // onglet fiche abonné
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/".ALK_ROOT_CLASSE."alkhtmllistabonne.class.php");
          $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
          $oPanel = new AlkHtmlListAbonne($oAppliAnnu, $this);
          break; 
        
        case ALK_SHEET_FICHE : // onglet ma fiche
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlformagentform.class.php");
          $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
          $oPanel = new AlkHtmlFormAgentFormLsDif($oAppliAnnu, $this);
          break;
        
        case ALK_SHEET_MODIFIER : // onglet modification fiche
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlformagentform.class.php");
          $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
          $oPanel = new AlkHtmlFormAgentFormLsDif($oAppliAnnu, $this);
          break;
        
        case ALK_SHEET_ABONNEFORM : // onglet fiche abonné
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/".ALK_ROOT_CLASSE."alkhtmlformabonne.class.php");
          $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
          $oPanel = new AlkHtmlFormAbonne($oAppliAnnu, $this);
          break;
        
        case ALK_SHEET_MESLISTES : // onglet mes listes Rq identique dans rep annuaire
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/".ALK_ROOT_CLASSE."alkhtmlformlsdiflist.class.php");
          $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
          //$oPanel = new AlkHtmlFormLsDifList($oAppliAnnu);
          $oPanel = new AlkHtmlFormLsDifList($this);
          break;
        
        case ALK_SHEET_AJAX : // appels ajax
          switch ( $this->iSSheet ) {
            case ALK_SHEET_ABONNE : // abonnement/désabonnement à une information
              $atype_id             = AlkRequest::getToken("atype_id", AlkRequest::_REQUEST("atype_id", "-1"));
              $data_id              = AlkRequest::getToken("data_id", AlkRequest::_REQUEST("data_id", "-1"));
              $mode                 = AlkRequest::getToken("mode", AlkRequest::_REQUEST("mode", "-1"));
              $liste_id             = AlkRequest::getToken("liste_id", AlkRequest::_REQUEST("liste_id", "-1"));
              $iAbonnement          = AlkRequest::getToken("iAbonnement", AlkRequest::_GETint("iAbonnement", 0));
              
              $this->updateAbonnement($atype_id, $data_id, $mode, $liste_id, $iAbonnement);
              exit();
            break;
          }
        break;
      }
      break;//admin     
    
    case ALK_TYPESHEET_POPUP: // partie popup
      switch ( $this->iSheet ){
      case ALK_SHEET_LIST : //affiche la liste des destinataires selectionnés       
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlpopuplsdifdestlist.class.php");
        $oPanel = new AlkHtmlPopupLsDifDestList($this);
        break; 
        
      case ALK_SHEET_USER : //affiche la popup pour sélectionner un agent n'appatrenant pas à l'annuaire
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlpopuplsdifselectuserform.class.php");
        $oPanel = new AlkHtmlPopupLsDifSelectUserForm($this);
        break; 
      
      case ALK_SHEET_AVALIDER : // affiche la popup demandant une vérification d'un envoi de message
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlpopuplsdifverifenvoimessage.class.php");
        $oPanel = new AlkHtmlPopupLsDifVerifMessage($this);
        break; 
     
      case ALK_SHEET_THEME : // affiche la popup sur le sujet des boites de message
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlpopuplsdifsujetform.class.php");
        $oPanel = new AlkHtmlPopupLsDifSujetForm($this);
        break; 
      
      case ALK_SHEET_MESLISTES : // popup gestion de la liste des abonnés à une information
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/".ALK_ROOT_CLASSE."alkhtmlpopuplsdif.class.php");
        $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
        $oPanel = new AlkHtmlPopupLsDif($oAppliAnnu);
        break; 
      
      case ALK_SHEET_ABONNELISTE :  // popup de gestion des abonnés d'une liste associée à une information
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/".ALK_ROOT_CLASSE."alkhtmlpopuplsdif.class.php");
        $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
        $oPanel = new AlkHtmlPopupLsDif($oAppliAnnu);
        break;
      
      case ALK_SHEET_ABONNEFORM : // popup fiche abonné
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/".ALK_ROOT_CLASSE."alkhtmlformabonne.class.php");
        $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
        $oPanel = new AlkHtmlFormAbonne($oAppliAnnu, $this);
        break; 
      
      case ALK_SHEET_LETTER_ABONNE :  // popup de gestion de la notification
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_CLASSE."alkhtmlformlsdifform.class.php");
        $oPanel = new AlkHtmlFormLsDifForm($this);
        break;
      
      case ALK_SHEET_ABONNE: // popup abonné
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/".ALK_ROOT_CLASSE."alkhtmlpopupabonnefiche.class.php");
        $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
        $oPanel = new AlkHtmlPopupAbonneFiche($oAppliAnnu, $this);
        break;
      
      case ALK_SHEET_USERRIGHT: // gestion des abonnements
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/".ALK_ROOT_CLASSE."alkhtmlpopupabonnement.class.php");
        $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
        $oPanel = new AlkHtmlPopUpAbonnementFiche($oAppliAnnu);
        break;   
        
      case ALK_SHEET_RECEPTION :
        $this->writeInternetResponse();
        break;
      }
      
    break; //popup
    
    case ALK_TYPESHEET_ADMIN :
      switch ( $this->iSheet ) {
        
      }
    break;
    
    case ALK_TYPESHEET_PROPRIETE:
      switch($this->iSheet){
        case ALK_SHEET_PARAMETRE:
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."espace/".ALK_ROOT_CLASSE."alkhtmlformparametreform.class.php");
          $oAppliEspace = AlkFactory::getAppli(ALK_ATYPE_ID_ESPACE);
          $oPanel = new AlkHtmlFormParametreForm($this, $oAppliEspace, $this->atype_id);
        break;
      }
      
      break;
    }
    return $oPanel;
  }
  
  /**
   * Fonction virtuelle appelée par le constructeur permettant d'initialiser le tableau this->tabSheets
   */
  public function setTabSheets() 
  { 
    $iTypeSheet = AlkRequest::getToken("iTypeSheet", ALK_TYPESHEET_CONSULT);
    $user_id    = AlkFactory::getSProperty("user_id", -1);
    
    $iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_FORM);
    if( $iTypeSheet == ALK_TYPESHEET_POPUP ) {
      // pas d'onglet en popup de manière générale (cas particulier à traiter ici)
      return;
    }
    
    $abonne_id = AlkRequest::getToken("abonne_id", "-1");
    $strUrl = ALK_ALKANET;
    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE, 
                    "Ecrire", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);

    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE, 
                    "Abonnés", $strUrl, "", "",
                    ALK_APPLI_RIGHT_READ,  ALK_PRIV_SPACE_USER, true);

    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_ABONNEFORM, ALK_SHEET_NONE, 
                    "Fiche abonné", $strUrl, "&iMode=".ALK_FORM_MODE_UPDATE."&abonne_id=".$abonne_id, "", 
                    ALK_APPLI_RIGHT_READ,  ALK_PRIV_ANNU_SERV+ALK_PRIV_ANNU_ALL, ($iSheet==ALK_SHEET_ABONNEFORM));
                                        
    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_MESLISTES, ALK_SHEET_NONE, 
                    "Mes Listes", $strUrl, "", "", 
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);   

    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECEPTION, ALK_SHEET_NONE, 
                    "Boîte de réception", $strUrl, "", "",
                    ALK_APPLI_RIGHT_READ, ALK_PRIV_SPACE_USER, true);

    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_ENVOYES, ALK_SHEET_NONE, 
                    "Courriels envoyés", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);

    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_LETTRES, ALK_SHEET_NONE, 
                    "Lettres envoyées", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);              

    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_MODELES, ALK_SHEET_NONE, 
                    "Modèles", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);    
                    
    // onglet property
    if ($user_id == ALK_USER_ID_ADMINALK)
      $this->addSheet(ALK_TYPESHEET_PROPRIETE, ALK_SHEET_PARAMETRE, ALK_SHEET_LIST, "Paramètres", $strUrl, "",
                    "Gérer les constantes des différentes applications", 
                    ALK_APPLI_RIGHT_READ, ALK_PRIV_SPACE_ANIM+ALK_PRIV_SPACE_ADMIN);          
  }
  
  /**
   * Autorise/interdit l'abonnement sur une information
   * Autorisation : Tous les abonnés des informations parentes dont l'abonnement est autorisé sont abonnés à l'information courante
   * Interdiction : Tous les abonnés de l'information courante sont supprimés
   * @param atype_id                  identifiant du type de l'application à appeler
   * @param data_id                   identifiant de l'information
   * @param mode                      mode permettant d'effectuer des traitements différents par type d'application
   * @param liste_id                  identifiant de la liste d'abonnés de l'information
   * @param iAbonnement               0 : interdit l'abonnement à l'information
   *                                  1 : autorise l'abonnement à l'information
   */
  protected function updateAbonnement($atype_id, $data_id, $mode, $liste_id, $iAbonnement)
  {
    $AppliIdFrom = AlkFactory::getAppli($atype_id);
    if ( $AppliIdFrom ) {
      if ( $iAbonnement == 0 ) {
        $AppliIdFrom->disableAbonnement($data_id, $mode);
      } else {
        $AppliIdFrom->enableAbonnement($data_id, $mode);
      }
    }
  }
  
  /**
   * Ajoute le block abonnés sur le formulaire et l'onglet spécifiés
   * Crée la liste des abonnés et le message associé à l'information s'ils n'existent pas
   * Retourne l'objet block créé, attaché au formulaire et à l'onglet
   * @param oForm       AlkHtmlForm   Formulaire d'agent
   * @param oPanelSheet AlkHtmlPanel  Panel sur lequel chaque application peut ajouter un onglet
   * @param idBlock                   Nom du bloc
   * @param iWidthLabel               largeur en pixel pour le côté label de ctrl
   * @param iWidthCtrl                largeur en pixel pour le côté ctrl de saisie
   * @param atype_id                  identifiant du type de l'application appelante
   * @param data_id                   identifiant de l'information
   * @param mode                      mode permettant d'effectuer des traitements différents par type d'application
   * @param liste_id                  identifiant de la liste des abonnés de l'information
   * @param iAbonnement               0 : abonnement interdit, 1 : abonnement autorisé
   */
  public function getHtmlBlockAbonnement(AlkHtmlForm $oForm, AlkHtmlPanel $oPanelSheet, $idBlock, $iWidthLabel, $iWidthCtrl, $atype_id, $data_id, $mode=-1, $liste_id, $iAbonnement)
  {
    $oForm->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_LIB."alkhtmlformnotificationform.js");
    
    if ( !is_null($oPanelSheet) ) {
      $oBlock = $oPanelSheet->addBlock($idBlock, _t("Abonnés"), "", $iWidthLabel, $iWidthCtrl, false);
      
      $strParam = "&atype_id=".$atype_id."&data_id=".$data_id."&mode=".$mode."&liste_id=".$liste_id;
      $strToken = $this->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_AJAX, ALK_SHEET_ABONNE, $strParam);
      $checkAbonnement = new AlkFormData($oForm, "notification_abonnement", $iAbonnement, ALK_SQL_NUMBER);
      $oCheckAbonnement = AlkHtmlFactory::getHtmlCheckbox($checkAbonnement, _t("Autoriser l'abonnement"));
      $oCheckAbonnement->addEvent("onChange", "onChangeNotificationAbonnement('".$strToken."');");
      
      $strUrl = ALK_ALKANET."?token=".$this->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_ABONNELISTE, ALK_SHEET_NONE,
                                                      "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$liste_id);
      $strLinkGererAbonnes = "javascript:OpenWindow('".$strUrl."', 700, 800, 'popup_abonnes')";
      $oLinkGererAbonnes = AlkHtmlFactory::getHtmlButton($strLinkGererAbonnes, _t("Gérer les abonnés de la liste"), _t("Gérer les abonnés de la liste"));
      $oLinkGererAbonnes->setProperty("guid", "link_gerer_abonnes");
      
      if ( $iAbonnement == 0 ) {
        $oForm->addOnload("var oCtrlLink = document.getElementById('link_gerer_abonnes');if (oCtrlLink) oCtrlLink.style.display = 'none';");
      }
      
      $oBlock->addCtrl($oCheckAbonnement);
      $oCheckAbonnement->addCtrl($oLinkGererAbonnes);
    }
  }
  
  /**
   * retourne la fonction javascript permettant de notifier une action sur une information
   * @param oForm       AlkHtmlForm   Formulaire d'agent
   * @param strFunctionVerifCtrl      fonction javascript à exécuter pour vérifier le formulaire
   * @param strTableName              nom de la table associée à l'information
   * @param strFieldName              nom du champ clé primaire de la table
   * @param strFieldValue             valeur de la clé primaire
   * @param strFunctionJsBefore       fonction javascript à exécuter avant notification
   * @param strFunctionJsAfter        fonction javascript à exécuter après notification
   * @param tabInfo                   tableau contenant les informations de l'information à notifier
   *                                  exemple :
   *                                    array(
   *                                      "<infoTitle>" => array("type" => 0, "value" => "<infoValue>"),
   *                                      "<infoTitle>" => array("type" => 1, "value" => "<fieldId>"),
   *                                    )
   *                                    type 0 : valeur directe à notifier
   *                                    type 1 : identifiant du champ dans le formulaire, valeur à récupérer dans ce champ
   * @param tabEvent                  tableau contenant les informations de l'événement lié à l'information
   *                                  exemple :
   *                                    array(
   *                                      "eventTitle"  => array("type" => <0 ou 1>, "value" => "<eventTitle>"),
   *                                      "eventDesc"   => array("type" => <0 ou 1>, "value" => "<eventDesc>"),
   *                                      "datedeb"     => array("type" => <0 ou 1>, "value" => "<datedeb>"),
   *                                      "heuredeb"    => array("type" => <0 ou 1>, "value" => "<heuredeb>"),
   *                                      "datefin"     => array("type" => <0 ou 1>, "value" => "<datefin>"),
   *                                      "heurefin"    => array("type" => <0 ou 1>, "value" => "<heurefin>"),
   *                                      "timerappel"  => array("type" => <0 ou 1>, "value" => "<timerappel>"),
   *                                    )
   *                                    type 0 : valeur directe à notifier
   *                                    type 1 : identifiant du champ dans le formulaire, valeur à récupérer dans ce champ
   * @param bAbonnesOnly                booléen à true pour notifier uniquement les abonnés de l'information, false sinon (défaut = false)
   * @param strChampCheck               nom du champ du formulaire contenant la case à cocher de publication
   * @aparam atype_id                   atype_id de l'application appelante
   * @return string fonction javascript
   */
  public function getFunctionNotifier($oForm, $strFunctionVerifCtrl, $strTableName, $strFieldName, $strFieldValue, $strFunctionJsBefore, $strFunctionJsAfter, $tabInfo=array(), $tabEvent=array(), $bAbonnesOnly=false, $strChampCheck="", $atype_id="")
  {
    if ( $oForm != null ) {
      $oForm->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_LIB."alkhtmlformnotificationform.js");
    }
    
    $liste_id = -1;
    $msg_id = -1;
    $iAbonnement = 0;
    
    $oDs = $this->oQuery->getInfoAbonnement($strTableName, $strFieldName, $strFieldValue);
    if ( $oDr = $oDs->getRowIter() ) {
      $liste_id       = $oDr->getValueName("LISTE_ID");
      $msg_id         = $oDr->getValueName("MSG_ID");
      $iAbonnement    = $oDr->getValueName("ABONNEMENT");
    }
    
    // construit le paramètre des informations de l'information à notifier
    $strInfo = "";
    foreach ( $tabInfo as $infoTitle => $tabTypeValue ) {
      if ( is_array($tabTypeValue) ) {
        $strInfo.= ( array_key_exists("type", $tabTypeValue) ? $tabTypeValue["type"] : 0 )."__".$infoTitle."__".( array_key_exists("value", $tabTypeValue) ? $tabTypeValue["value"] : "aucune valeur fournie" )."||";
      }
    }
    $strInfo = addslashes(substr($strInfo, 0, -2));
    
    // construit le paramètre des dates de l'événement lié à l'information
    $strEvent = "";
    foreach ( $tabEvent as $eventInfoType => $tabEventValue ) {
      if ( is_array($tabEventValue) ) {
        $strEvent.= ( array_key_exists("type", $tabEventValue) ? $tabEventValue["type"] : 0 )."__".$eventInfoType."__".( array_key_exists("value", $tabEventValue) ? $tabEventValue["value"] : "aucune valeur fournie" )."||";
      }
    }
    $strEvent = addslashes(substr($strEvent, 0, -2));
    
    $strParam = "&bNotification=1&bAbonnesOnly=".( $bAbonnesOnly ? "1" : "0" )."&msg_id=".$msg_id."&atype_id=".$atype_id."&data_id=".$strFieldValue;
    $strTokenNotifier = $this->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_LETTER_ABONNE, ALK_SHEET_NONE, $strParam);
    $strFunctionJs = $strFunctionJsBefore.($strFunctionJsBefore != "" ? ";" : "")."Notifier('".urlencode($strFunctionVerifCtrl)."', '".$strTokenNotifier."', '".urlencode($strFunctionJsAfter.";")."', ".$iAbonnement.", ".$liste_id.", '".$strInfo."', '".$strEvent."', ".( $bAbonnesOnly ? 1 : 0 ).",'".$strChampCheck."')";
    
    return $strFunctionJs;
  }
  
  /** interface GEDIT */

  /**
   * Méthode appelée à l'ajout d'un bloc gedit
   *        Implémenter les actions effectuant l'ajout de ce bloc sur ce type d'application
   * @param bloc_id     identifiant du bloc
   * @param typeIdBloc  type de bloc 
   * @param atypeIdBloc type de l'application associé au type de bloc
   */
  public function addGEditBloc($bloc_id, $typeIdBloc, $atypeIdBloc)
  {
    $this->oQueryAction->addGEditBloc($bloc_id);
  }
  
  /**
   * Méthode appelée avant suppression définitive d'une application de type gedit
   *        ou avant suppression d'une page gedit
   *        ou avant suppression d'un bloc gedit
   *        Implémenter les actions effectuant le ménage interne à l'application
   * @param page_id     identifiant de la page
   * @param bloc_id     identifiant du bloc
   * @param typeIdBloc  type de bloc 
   * @param atypeIdBloc type de l'application associé au type de bloc
   */
  public function delGEditBloc($page_id, $bloc_id, $typeIdBloc, $atypeIdBloc)
  {
    $this->oQueryAction->delGEditBloc($bloc_id);
  }

  /**
   * Recopie les associations d'un bloc à un autre bloc
   * 
   * @param bloc_id_src  identifiant du bloc source
   * @param bloc_id_dest identifiant du bloc destination
   */
  public function dupGEditBloc($bloc_id_src, $bloc_id_dest)
  { 
    $strIntituleChamp = "";
    foreach($this->tabLangue as $key => $tabLg) {
      $strIntituleChamp  .= ( $strIntituleChamp != "" ? ", " : "" ).
        "FORM_TITRE".$tabLg["bdd"].
        ", FORM_DESC".$tabLg["bdd"];
    }
    
    $this->oQueryAction->copyGEditBlocData($bloc_id_src, $bloc_id_dest, "LSDIF_LISTE_BLOC", "LISTE_ID, LISTE_RANG");
    $this->oQueryAction->copyGEditBlocData($bloc_id_src, $bloc_id_dest, "LSDIG_FORM_BLOC", $strIntituleChamp);
  }

  /**
   * Retourne un tableau contenant l'information sélectionnée par cette méthode (appel régulier de getDataContents())
   * @param typeAff         type d'affichage, permet d'établir une conditionnelle dans cette méthode pour gérer plusieurs type d'affichage
   * @param cont_id         Identifiant de l'espace, pris en compte si appli_id vaut -1
   * @param appli_id        Identifiant de l'application, peut valoir =-1 pour toutes les applis de cont_id
   * @param cat_id          Identifiant de la catégorie, peut valoir =-1 pour toutes les infos de appli_id
   * @param data_id         Identifiant de la données, différent de -1 pour afficher la fiche, =-1 sinon par défaut
   * @param lg              langue utilisé, _FR par défaut
   * @param page_typeassoc  Type d'association des données à la page
   * @param page_ordre      Ordre des données dans la page
   * @param page_datedeb    Contient la date de début pour un filtre éventuel en fonction de la valeur de page_typeassoc
   * @param page_datefin    Contient la date de début pour un filtre éventuel en fonction de la valeur de page_typeassoc 
   * @return array
   */
  public function getGEditDataContents($typeAff, $cont_id, $atype_id, $appli_id, $cat_id, $data_id="-1", $lg=ALK_LG_BDD, $page_typeassoc=0, $page_ordre="", $page_datedeb="", $page_datefin="")
  {
    return array(); 
  }

  /**
   * Retourne le contenu raccourci d'un bloc éditorial
   * pour un affichage de gestion ou d'aperçu
   * @apram bloc_id        Identifiant du bloc
   * @param bloc_typeassoc type d'association : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on =4 : filtre publication : news uniquement
   *                       si bit 3 on =8 : filtre publication : infos publiés passés (archivés)
   *                       si bit 4 on =16: filtre publication : infos publiés présents
   *                       si bit 5 on =32: filtre publication : infos non publiés
   *                       bit 6 au bit 12 : anciennes versions de tris prédéfinis 
   *                       si bit 13 on : ordre : champ nouveauté
   *                       si bit 14 on : ordre : champ catégorie
   *                       si bit 15 on : ordre : champ data
   *                       si bit 16 on : ordre : champ date pub décroissant
   *                       si bit 17 on : ordre : champ date pub croissant
   *                       si bit 18 on : ordre : champ date info décroissant
   *                       si bit 19 on : ordre : champ date info croissant
   *                       si bit 20 on : ordre : champ date maj décroissant
   *                       si bit 21 on : ordre : champ date maj croissant
   *                       si bit 22 on : filtre calendaire : date début-fin pub 
   *                       si bit 23 on : filtre calendaire : date début-fin info 
   *                       si bit 24 on : filtre calendaire : date début-fin màj
   *                       si bit 25 on : filtre publication : infos synf 
   *                       si bit 26 on : filtre publication : en cours de validation
   *                       si bit 27 on : filtre publication : 30 derniers jours date pub
   *                       si bit 28 on : filtre publication : 30 derniers jours date info
   *                       si bit 29 on : filtre publication : 30 derniers jours date màj
   *                       si bit 30 on : ordre : champ rang des données décroissant
   *                       si bit 31 on : ordre : champ rang des données croissant
   * @param atypeIdBloc    type de l'application liée, =-1 si non utilisé
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @param bloc_limit     Contient le nbre de résultats à afficher
   * @return array
   */
  public function getGEditBlocShortContents($bloc_id, $bloc_typeassoc, $atypeIdBloc=-1, $bloc_ordre="", $bloc_datedeb="", $bloc_datefin="", $bloc_limit="-1")
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $tabContent = array();
    $i = 0;
    $dsDoc = $this->oQuery->getDsListDataByBlocId($bloc_id, $bloc_typeassoc, $user_id, true, 
                                                  ALK_LG_BDD, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
    while( $drDoc = $dsDoc->getRowIter() ) {
      $tabContent[$i]["data_id"]     = $drDoc->getValueName("DATA_ID");
      $tabContent[$i]["data_rank"]   = $drDoc->getValueName("DATA_RANG");
      $tabContent[$i]["data_title"]  = $drDoc->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_TITRE"));
      $tabContent[$i]["data_desc"]   = $drDoc->getValueName(AlkFactory::getDBCurrentLanguageField("DATA_DESCL"));
      $tabContent[$i]["data_type"]   = $drDoc->getValueName("DATA_TYPE");
      $i++;
    }
    return $tabContent;
  }

  /**
   * Retourne le contenu complet d'un bloc éditorial dans la langue sélectionnée
   * pour un affichage de consultation
   * @param bloc_id        Identifiant du bloc
   * @param lg             clé de la langue sélectionnée
   * @param bloc_typeassoc type d'association : 0=aucune, 1=appli, 2=cat, 3=data
   *                       si bit 2 on =4 : filtre publication : news uniquement
   *                       si bit 3 on =8 : filtre publication : infos publiés passés (archivés)
   *                       si bit 4 on =16: filtre publication : infos publiés présents
   *                       si bit 5 on =32: filtre publication : infos non publiés
   *                       bit 6 au bit 12 : anciennes versions de tris prédéfinis 
   *                       si bit 13 on : ordre : champ nouveauté
   *                       si bit 14 on : ordre : champ catégorie
   *                       si bit 15 on : ordre : champ data
   *                       si bit 16 on : ordre : champ date pub décroissant
   *                       si bit 17 on : ordre : champ date pub croissant
   *                       si bit 18 on : ordre : champ date info décroissant
   *                       si bit 19 on : ordre : champ date info croissant
   *                       si bit 20 on : ordre : champ date maj décroissant
   *                       si bit 21 on : ordre : champ date maj croissant
   *                       si bit 22 on : filtre calendaire : date début-fin pub 
   *                       si bit 23 on : filtre calendaire : date début-fin info 
   *                       si bit 24 on : filtre calendaire : date début-fin màj
   *                       si bit 25 on : filtre publication : infos synf 
   *                       si bit 26 on : filtre publication : en cours de validation
   *                       si bit 27 on : filtre publication : 30 derniers jours date pub
   *                       si bit 28 on : filtre publication : 30 derniers jours date info
   *                       si bit 29 on : filtre publication : 30 derniers jours date màj
   *                       si bit 30 on : ordre : champ rang des données décroissant
   *                       si bit 31 on : ordre : champ rang des données croissant
   * @param atypeIdBloc    type de l'application liée, =-1 si non utilisé
   * @param bloc_ordre     liste de nombres séparés par une virgule. 1 nombre correspond à une puissance de deux. 
   *                       cette liste correspond à l'ordre des champs d'après les champs de bit de bloc_typeassoc
   * @param bloc_datedeb   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc
   * @param bloc_datefin   Contient la date de début pour un filtre éventuel en fonction de la valeur de bloc_typeassoc 
   * @param bloc_limit     Contient le nbre de résultats à afficher
   * @return array
   */
  public function getGEditBlocContents($bloc_id, $lg, $bloc_typeassoc, $atypeIdBloc=-1, $bloc_ordre="", $bloc_datedeb="", $bloc_datefin="", $bloc_limit="-1")
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $tabContent = array();
    $i = 0;
    $dsDoc = $this->oQuery->getDsListDataByBlocId($bloc_id, $bloc_typeassoc, $user_id, false, 
                                                  $lg, $bloc_ordre, $bloc_datedeb, $bloc_datefin, $bloc_limit);
    while( $drDoc = $dsDoc->getRowIter() ) {
      $tabContent[$i]["cont_id"]       = $drDoc->getValueName("CONT_ID");
      $tabContent[$i]["appli_id"]      = $drDoc->getValueName("APPLI_ID");
      $tabContent[$i]["data_id"]       = $drDoc->getValueName("DATA_ID");
      $tabContent[$i]["data_rank"]     = $drDoc->getValueName("DATA_RANG");
      $tabContent[$i]["data_title"]    = $drDoc->getValueName("FORM_TITRE".$lg);
      $tabContent[$i]["data_descl"]    = $drDoc->getValueName("FORM_DESC".$lg);
      $tabContent[$i]["token_submit"]  = ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam("iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_ABONNENONVALIDE."&iSSheet=".ALK_SHEET_FORM."&cont_id=".$tabContent[$i]["cont_id"]."&appli_id=".$tabContent[$i]["appli_id"]."&iMode=10");
      $tabContent[$i]["token_submit_internet"]  = AlkRequest::getEncodeParam("iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_RECEPTION."&cont_id=".$tabContent[$i]["cont_id"]."&appli_id=".$tabContent[$i]["appli_id"]."&iMode=3");
      $tabContent[$i]["data_type"]     = ALK_ATYPE_ID_NEWSLETTER;
      
      $dsNews = $this->oQuery->getDsLastLettreByAppli($tabContent[$i]["appli_id"]);
      if ( $drNews = $dsNews->getRowIter() ){
        $lettre_id = $drNews->getValueName("LETTRE_ID");
        $tabContent[$i]["newsletter_lastletter"] = ALK_ALKANET."?token=".AlkRequest::getEncodeParam("iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_APERCU."&iSSheet=".ALK_SHEET_NONE."&cont_id=".$tabContent[$i]["cont_id"]."&appli_id=".$tabContent[$i]["appli_id"]."&lettre_id=".$lettre_id."");
      } 
      $tabContent[$i]["newsletter_archives"] =  ALK_ALKANET."?token=".AlkRequest::getEncodeParam("iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_LIST."&iSSheet=".ALK_SHEET_LIBRARY."&cont_id=".$tabContent[$i]["cont_id"]."&appli_id=".$tabContent[$i]["appli_id"]."&bloc_id=".$bloc_id);
      if ( !array_key_exists("cat_name", $tabContent[$i]) )
        $tabContent[$i]["cat_name"]      = "";
      $tabContent[$i]["cat_name"]      .= "<select_cat><cat_id>".$drDoc->getValueName("DATA_ID")."</cat_id>" .
                                          "<cat_title>".$drDoc->getValueName("DATA_TITRE".$lg)."</cat_title></select_cat>";
    }
    return $tabContent;
  }

  /**
   * Retourne le type de méthode pour mettre à jour les blocs
   *        Retourne un tableau en fonction du type sélectionné.
   * @param typeIdBloc   type de bloc
   * @param atypeIdBloc  type de l'application associée au type de bloc
   * @return array
   */
  public function getGEditBlocTypeUpdate($typeIdBloc, $atypeIdBloc)
  {
    return array("type"            => ALK_GEDIT_TYPEUPDATE_SELECTEDIT, 
                 "iColumn"         => ( defined("ALK_B_GEDIT_BLOC_COLONNE") && ALK_B_GEDIT_BLOC_COLONNE==false ? 0 : 1),
                 "newsTitle"       => "",
                 "iFilterSpace"    => 1,
                 "iAssocAppli"     => 1,
                 "iAssocAppliPage" => 2, /* selection appli_id newsletter lié à une page gedit, optionnel */
                 "iAssocAType"     => $this->atype_id,
                 "iAssocCat"       => 0,
                 "catTableName"    => "", 
                 "dataTableName"   => "V_GEDIT_LSDIF_DATA",
                 "catTitle"        => "",
                 "dataTitle"       => "Classification de lettre d'informations",
                 "xmltag"          => "lettre",
                 "tablepj"         => "",
                 "fieldpj"         => "",
                 "iFields"         => 0, // pas de filtre de publication, pas de filtre calendaire, par de gestion d'ordre
                 "iFieldsPage"     => 0, // pas de filtre de publication, pas de filtre calendaire, par de gestion d'ordre
                 "uploadDir"       => AlkFactory::getModuleName($this->atype_id)."/",
                 "tokenBlocPerso"  => $this->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_CONT_FORM, ALK_SHEET_NONE,"&applitype_id=".ALK_ATYPE_ID_NEWSLETTER));
  }
  
  /**
   * Associe une catégorie appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param cat_id      Identifiant de la catégorie
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function assocCatToBloc($bloc_id, $cat_id, $atypeIdBloc=-1, $appliIdBloc=-1)
  {
    $this->oQueryAction->assocCatToBloc($bloc_id, $cat_id);
  }
  
  /**
   * Associe un ensemble de données appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc au bloc
   * @param bloc_id     Identifiant du bloc
   * @param tabDataId   Tableau contenant les identifiants des données à associer
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function assocDataToBloc($bloc_id, $tabDataId, $atypeIdBloc=-1, $appliIdBloc=-1)
  {
    $this->oQueryAction->assocDataToBloc($bloc_id, $tabDataId);
  }

  /**
   * Supprime une association entre une catégorie appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param cat_id      Identifiant de la catégorie, =-1 pour supprimer toutes les catégories du bloc
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function removeCatFromBloc($bloc_id, $cat_id, $atypeIdBloc=-1, $appliIdBloc=-1)
  {
    $this->oQueryAction->removeCatFromBloc($bloc_id, $cat_id);
  }
  
  /**
   * Supprime une association entre une donnée appartenant à l'application de type atypeIdBloc 
   * et d'identifiant appliIdBloc et le bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la données à associer, =-1 pour supprimer toutes les données du bloc
   * @param atypeIdBloc type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function removeDataFromBloc($bloc_id, $data_id, $atypeIdBloc=-1, $appliIdBloc=-1)
  {
    $this->oQueryAction->removeDataFromBloc($bloc_id, $data_id);
  }
  
  /**
   * Met à jour le rang d'une donnée dans un bloc
   * @param bloc_id     Identifiant du bloc
   * @param data_id     Identifiant de la donnée
   * @param iRank       Rang actuel de la donnée
   * @param iDelta      Entier : 1 pour descendre d'un rang, -1 pour monter d'un rang
   * @param atypeIdBloc Type de l'application contenant la catégorie, =-1 par défaut si non utile
   * @param appliIdBloc Identifiant de l'application contenant la catégorie, =-1 par défaut si non utile
   */
  public function updateDataRankInBloc($bloc_id, $data_id, $iRank, $iDelta, $atypeIdBloc=-1, $appliIdBloc=-1)
  {
    $this->oQueryAction->updateDataRankInBloc($bloc_id, $data_id, $iRank, $iDelta);
  }
  
  /**
   * Ecrit sur la sortie standard, le flux rss correspondant au token passé
   * Info du token : cont_id, appli_id
   *   - datatype_id   identifiant de type de sous application iedit
   *   - cat_id        >0 identifiant de la catégorie, =-1 (par défaut) pour ne pas filtrer sur la catégorie 
   *   - data_id       >0  pour une fiche info de datatype_id
   *                   =-1 (par défaut) pour la liste des infos de datatype_id de l'application sélectionnée
   *                   =-2 pour la liste des infos de datatype_id de l'application sélectionnée
   *                   =-3 pour la liste des infos de datatype_id de l'espace sélectionné
   *                   =-4 pour la liste des infos de datatype_id de tous les espaces
   *   - pub           =1 (par défaut) pour obtenir les infos publiées, =0 pour obtenir les infos à valider
   *   - une           =1 pour obtenir les infos publiées à la une, =0 (par défaut) pour les toutes les infos publiées
   *   - user_id       identifiant de l'utilisateur, nécessaire si pub=0 pour vérifier les droits, =-1 par défaut pour non vérif des droits
   *   - lg            =_FR par défaut
   */
  public function writeRss()
  {
    $cont_id     = AlkRequest::getToken("cont_id", "-1");
    $appli_id    = AlkRequest::getToken("appli_id", "-1");
    $datatype_id = AlkRequest::getToken("datatype_id", "-1");
    $data_id     = AlkRequest::getToken("data_id", "-1");
    $cat_id      = AlkRequest::getToken("cat_id", "-1");
    $pub         = AlkRequest::getToken("pub", "1"); 
    $une         = AlkRequest::getToken("une", "0");
    $user_id     = AlkRequest::getToken("user_id", "-1");
    $lg          = AlkRequest::getToken("lg", ALK_LG_BDD);

    $strDataTypeName = $this->oQuery->getstrTypeData($datatype_id, $appli_id);
    $bOk = true;
    
    // info publiée = 16, info à la une = 4
    $iFiltre = ( $une == "1" ? 4 : 16 );
    if( $user_id != "-1" && $pub == "0" ) {
      // vérifie que l'utilisateur a le droit de publication sur l'application
      $iRight = $this->getUserAppliRight();
      $bOk = ( $iRight == ALK_APPLI_RIGHT_PUBLI );
      // info à valider
      $iFiltre = 32; 
      if( $data_id > 0 ) $data_id = -1; 
    } else {
      // filtre sur données syndiquée uniquement
      $iFiltre += 128; 
    }
    
    $oFSyndXml = AlkFactory::getFSyndXmlWriter(ALK_RSS2);
    $oFSyndXml->setTitle("Toutes les informations éditoriales".( $pub=="0" ? " à valider" : ( $une == "1" ? " à la une" : "" ))." de type ".$strDataTypeName);
    $oFSyndXml->setLink(ALK_ROOT_URL.$_SERVER["REQUEST_URI"]);
    $oFSyndXml->setDescription("Flux RSS 2.0 provenant de ".ALK_APP_TITLE);
    
    if( $bOk ) {
      $typeAssoc = TASSOC_BYDATA; 
      $object_id = $data_id;
      switch( $data_id ) {
      case -4: $typeAssoc = TASSOC_EMPTY; $object_id = -1;        break;
      case -3: $typeAssoc = TASSOC_EMPTY; $object_id = $cont_id;  break;
      case -2: $typeAssoc = TASSOC_BYAPPLI; $object_id = $appli_id; break;
      case -1: $typeAssoc = TASSOC_BYCATEG; $object_id = $cat_id;   break;
      }
      $typeAssoc += $iFiltre;
      
      // recherche les infos à syndiquer
      $tabData = $this->getDataContents($object_id, $typeAssoc, $user_id, $lg, $datatype_id);
      foreach($tabData as $tabContent ) {
        $newItem = $oFSyndXml->createNewItem();
        
        if( $datatype_id == ALK_ATYPE_ID_FAQS ) {
          // faqs
          $newItem->setTitle($tabContent["data_desc"]);
        } else {
          // actu, lien, glos
          $newItem->setTitle($tabContent["data_title"]);
        }
        
        /**/
        if( $datatype_id == ALK_ATYPE_ID_ACTU ) {
          if( $data_id < 0 ) {
            // en mode liste, uniquement desc courte
            $newItem->setDescription($tabContent["data_desc"]."<br/>".$tabContent["data_descl"]);
          } else {
            // en mode fiche, desc courte + desc longue
            $newItem->setDescription($tabContent["data_desc"]."<br/>".$tabContent["data_descl"]);
          }          
        } else {
          $newItem->setDescription($tabContent["data_descl"]);
        }

        // lien et actu
        if( $tabContent["data_url"] != "" ) {
          $newItem->setLink($tabContent["data_url"]);
        } else {
          $newItem->setLink("#");
        }

        if( $datatype_id == ALK_ATYPE_ID_ACTU ) {
          // actu
          if( $tabContent["data_datedeb"] != "" )
            $newItem->setDate($tabContent["data_datedeb"], "%d/%m/%Y");
          elseif( $tabContent["data_datepdeb"] != "" )
            $newItem->setDate($tabContent["data_datepdeb"], "%d/%m/%Y");
          else
            $newItem->setDate($tabContent["data_datemaj"], "%d/%m/%Y");
        } else {
          $newItem->setDate($tabContent["data_datemaj"], "%d/%m/%Y");
        }
        
        
        
        if( $tabContent["data_visuel"] != "" ) {
           $newItem->setEncloser($tabContent["data_visuel"], $tabContent["data_visuel_size"], $tabContent["data_visuel_typemime"]);
        }
        if ( $tabContent["data_nbpj"]>0 ){
          foreach($tabContent["data_pj"] as $tabPj) {
            $newItem->setEncloser($tabPj["strUrlFile"], filesize($tabPj["strPathFile"]), 
                                  getTypeMime($tabPj["strPathFile"]), $tabPj["strNameAff"]);
          }
        }
        $oFSyndXml->addItem($newItem);
      }

    }

    $oFSyndXml->genarate(); 
  }
  
  /**
   * Création d'un abonné si n'existe pas déjà
   * L'abonne à l'application appli_id si ce n'est pas déjà le cas
   * L'abonné à la classification
   */
  private function writeInternetResponse()
  {
    $cont_id       = AlkRequest::getToken("cont_id", "-1");
    $appli_id      = AlkRequest::getToken("appli_id", "-1");
    $class_id      = AlkRequest::_REQUEST("class_id", "-1");
    $abonne_mail   = AlkRequest::_REQUEST("user_mail", "");
    $abonne_valide = AlkRequest::_REQUEST("user_valide", "0");

    $oAppliAnnu = AlkFactory::getAppli(ALK_ATYPE_ID_ANNU);
    $abonne_id = $oAppliAnnu->addAbonnementInternet($appli_id, $abonne_mail, $abonne_valide);  
   
    $this->oQueryAction->addClassificationAbonne($abonne_id, $class_id);
  }
  
   /**
   * vérifie les liens gérés par l'application et retourne le résultat sous forme de tableau
   * format du tableau retourné : []["cont_id", "appli_id", "cat_id", "data_id", "token", "url", "path", "desc"]
   * @return array
   * 
   */
  public function verifLinks(){
    $tabLink = array();
    
    return $tabLink;
  }
  
  /**
   * Retourne le libellé de la page d'aide associée à l'application
   * @return string
   */
  public function getHelp(){
    return _t("Mailing");
  }
}
?>