<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::LsDif
Module liste de diffusion.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_LsDif
 * @class AlkHtmlFormLsDifList
 * Classe d'affichage de la boite de reception et d'envois de la liste de diffusion
 */
class AlkHtmlFormLsDifList extends AlkHtmlForm
{
 
  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formLsDifList");

    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strAction = "";
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, "");
    $this->iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_RECEPTION);
  }
  
  /**
   * Se charge de récupérer les données soit par request, soit par lecture sgbd
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) { }

  /**
   * Traitement 
   */
  public function doSql() 
  {
    $iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_NONE);
    if( $iSheet == ALK_SHEET_RECEPTION ) {
      // suppression d'un message reçu
      $msg_id   = AlkRequest::getToken("msg_id", "-1");
      $abonne_id = AlkRequest::getToken("abonne_id", "-1");
      $this->oAppli->oQueryAction->delMsgBoiteRecu($msg_id, $abonne_id);
    } 
    else {
      // suppression d'un message envoyé
      $msg_id   = AlkRequest::getToken("msg_id", "-1");
      $liste_id = AlkRequest::getToken("liste_id", "-1");
      $delQueue = AlkRequest::getToken("delQ", "0");
      $strPathUpload = $this->oAppli->getPathUpload();
      
      if( $msg_id!="-1" ) { 
        $this->oAppli->oQueryAction->delMsgBoiteEnv($msg_id, $liste_id, $strPathUpload);
      } elseif( $msg_id!="-1" && $delQueue=="1" && $liste_id=="-1" ) {
        $this->oAppli->oQueryAction->delMsgFromQueue($msg_id);
      }
    }
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, $iSheet, ALK_SHEET_NONE);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Construction de la liste (soit boite de reception soit liste des envois)
   */
  public function setContents()
  {
    if( $this->iSheet == ALK_SHEET_MODELES ) {
      $this->setContentsTemplates();
    } else {
      $this->setContentsMsgs();
    }

    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."lsdif/".ALK_ROOT_LIB."alkhtmlformlsdiflist.js");
  }

  /**
   * Construit le contenu pour les messages et lettres envoyés et les messages réçus
   */
  private function setContentsMsgs()
  {
    $user_id = AlkFactory::getSProperty("user_id", "-1");
    $right_id = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    $page = AlkRequest::_GETint("page", "1");
    $nbEltParPage = AlkRequest::_GETint("nbItemsPerPage", ALK_ITEMS_PER_PAGE);
    $msg_type = "0";
    
    if( $this->iSheet == ALK_SHEET_RECEPTION ) { // cas de l'onglet boite de reception'
       $strTitrePage = "Liste des messages reçus";
       $strTexteIntro = "Cette liste vous permet de visualiser l'ensemble des messages<br>".
        "que vous avez normalement reçus dans votre messagerie bureautique.";
       $tBoite = 0; 
    }  
    elseif( $this->iSheet == ALK_SHEET_ENVOYES ) { //cas de l'onglet liste des message envoyés'
      $strTitrePage = "Liste des messages envoyés";
      $strTexteIntro = "Cette liste vous permet de visualiser l'ensemble des messages<br>".
      "envoyés à partir de cette application en tant que <b>Message public</b> et ceux que vous avez envoyés.";
      $tBoite = 1;
    }
    else /* $this->iSheet == ALK_SHEET_LETTRES */ {//cas de l'onglet liste des lettres envoyées'
      $strTitrePage = "Liste des lettres envoyées";
      $strTexteIntro = "Cette liste vous permet de visualiser l'ensemble des lettres d'informations envoyées.";
      $tBoite = 2; 
      $msg_type = "2, 3"; 
    }

    $dsBoite = $this->oAppli->oQuery->getDsListeBoiteMsg($appli_id, $user_id, $tBoite, $msg_type,
                                                         ($page-1)*$nbEltParPage, $page*$nbEltParPage-1);
    $nbElt = $dsBoite->getCountTotDr();

    $tabQueue = array();
    if( $nbElt > 0 && $tBoite != "0" ) {
      $tabQueue = $this->oAppli->oQuery->getTabMsgQueue();
    }

    $this->setLabel($strTitrePage);
    $this->setLabelDesc($strTexteIntro."<br/>Nombre de messages : ".$nbElt ); 

    $strTokenPagine = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, $this->iSheet, ALK_SHEET_NONE);
    $oTabPage=AlkHtmlFactory::getHtmlList($this, $nbElt, $page, $nbEltParPage, true, 
                                          ALK_ALKANET."?token=".$strTokenPagine, 
                                          "Aucun message.", false, "tabPagine", true);
    if( $tBoite == "0" ) {
      $oTabPage->SetColumns(array("center", "60"),
                            array("left", "190"),
                            array("left", "260"),
                            array("center", "90"),
                            array("center", "90"),
                            array("center", "20"));
                            
      $oTabPage->AddTitleRow("Fichiers", "De", "Sujet", "Date<br/>enregist.", "Date<br/>fin d'envoi", "");   
    } else {
      $oTabPage->SetColumns(array("center", "60"),
                            array("left", "190"),
                            array("left", "190"),
                            array("center", "90"),
                            array("center", "90"),
                            array("center", "25"),
                            array("center", "25"),
                            array("center", "20"),
                            array("center", "20"));
                            
      $oTabPage->AddTitleRow("Fichiers", "De", "Sujet", "Date<br/>enregist.", "Date<br/>fin d'envoi", array("File d'attente", 2), array("", 2));   
    }
    while( $drBoite = $dsBoite->getRowIter() ) {
      $msg_id = $drBoite->getValueName("MSG_ID");
      if( $tBoite == "0" ) {
        $abonne_id = $drBoite->getValueName("ABONNE_ID");
      } else {
        $abonne_id = "-1";
      }
      $msg_public    = $drBoite->getValueName("MSG_PUBLIC");
      $strFilePJ     = $drBoite->getValueName("MSG_PJ");
      $msg_idfrom    = $drBoite->getValueName("MSG_IDFROM");
      $msg_nomfrom   = $drBoite->getValueName("MSG_NOMFROM");
      $msg_mailfrom  = $drBoite->getValueName("MSG_MAILFROM");
      $strSujet      = $drBoite->getValueName("MSG_SUJET");
      $strDateEnv    = $drBoite->getValueName("DATE_ENV");
      $strDateEnr    = $drBoite->getValueName("DATE_ENR");
      $liste_id      = $drBoite->getValueName("LISTE_ID");
      $agent_id      = $drBoite->getValueName("AGENT_ID");
      if( $liste_id == "" ) {
        $liste_id = "-1";
      }
      
      $oBtDel  = AlkHtmlFactory::getHtml("&nbsp;");
      $oBtResend = AlkHtmlFactory::getHtml("&nbsp;");
      $oBtDelQueue = AlkHtmlFactory::getHtml("&nbsp;");
      if( $tBoite == "0" ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECEPTION, ALK_SHEET_NONE, "&msg_id=".$msg_id."&abonne_id=".$abonne_id);
                                                    
        $oBtDel = AlkHtmlFactory::getHtmlButtonIcon("javascript:supprMsg('".$strToken."')", "supprimer", "Retirer ce message");
      } 
      else if( $msg_idfrom == $user_id || $agent_id==$user_id || $right_id==ALK_APPLI_RIGHT_PUBLI ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, $this->iSheet, ALK_SHEET_NONE, "&msg_id=".$msg_id."&liste_id=".$liste_id);
        $oBtDel = AlkHtmlFactory::getHtmlButtonIcon("javascript:supprMsg('".$strToken."')", "supprimer", "Supprimer ce message");
        
        $strTokenResend = ALK_ALKANET."?token=".$this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FORM, ALK_SHEET_NONE, "&msg_id=".$msg_id."&iMode=".ALK_FORM_MODE_UPDATE);
        $oBtResend = AlkHtmlFactory::getHtmlButtonIcon("javascript:AlkGoUrl('".$strTokenResend."')", "envoyer", "Réenvoyer ce message");
      
        $nbLock = ( isset($tabQueue["".$msg_id]) ? $tabQueue["".$msg_id] : 0 );
        // $nbLock=1 : en file d'attente, =2 locké 
        if( $nbLock>0 ) { 
          $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, $this->iSheet, ALK_SHEET_NONE, "&msg_id=".$msg_id."&delQ=1");
          $oBtDelQueue = AlkHtmlFactory::getHtmlButtonIcon("javascript:supprMsgQueue('".$strToken."', ".$nbLock.")", "supprimer", "Retirer de la file d'attente");
          $oBtDelQueue = $oBtDelQueue->getHtml();
        } else {
          $nbLock = "&nbsp;";
        }
      } else {
        $nbLock = "&nbsp;";
      }
    
      $tabFilePJ = explode("|", $strFilePJ);
      $strFilePJ = "";
      $oTelechgt = "&nbsp;";
      for($i=0; $i<count($tabFilePJ); $i++)
        if( $tabFilePJ[$i] != "" ) {
          $strUrl_ =  AlkFactory::getUploadUrl(ALK_ATYPE_ID_LSDIF);
          $strUrl = $strUrl_.$tabFilePJ[$i];
          $strFilePJ .= "<a target='_blank' title=\"Télécharger ".$tabFilePJ[$i]."\" href=\"".$strUrl."\">".
            "<img class\"alkimgicon alkimg".getFileIcon($tabFilePJ[$i], true)."\" src=\"".ALK_MEDIA_URL."images/transp.gif\" border='0' hspace='1'/></a>";
          $oTelechgt = AlkHtmlFactory::getHtml($strFilePJ);
        }
      $strFilePJ = ( $strFilePJ =="" ? "&nbsp;" : $strFilePJ );
      $strDe = " <a href=\"mailto:".$msg_mailfrom."\" title=\"".$msg_mailfrom."\">@</a>&nbsp;".
        ( $msg_idfrom!="" && $msg_idfrom!="-1"
          ? "<a href=\"javascript:OpenPopupFiche('agent', ".$msg_idfrom.");\" title=\"Voir la fiche\">".$msg_nomfrom."</a>"
          : $msg_nomfrom);
      $oDe = AlkHtmlFactory::getHtml($strDe);
      
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_THEME, ALK_SHEET_NONE, "&msg_id=".$msg_id."&tboite=".$tBoite);
      $strSujet = '<a title="'._t("Voir le message").'" href="javascript:OpenMsg(\''.$strToken.'\')">'.$strSujet.'</a>';
    
      if( $tBoite == "0" ) {
        $oTabPage->addRowByArray(array($oTelechgt, $oDe, $strSujet, $strDateEnr, $strDateEnv, $oBtDel));
      } else {
        $oTabPage->addRowByArray(array($oTelechgt, $oDe, $strSujet, $strDateEnr, $strDateEnv, $nbLock, $oBtDelQueue, $oBtDel, $oBtResend));
      }
    }
    
    $this->addPanel($oTabPage);
  }
  
  /**
   * Construit le contenu pour la liste des modèles
   */
  private function setContentsTemplates()
  {
    $user_id  = AlkFactory::getSProperty("user_id", "-1");
    $right_id = AlkFactory::getSProperty("user_right", ALK_APPLI_RIGHT_NONE);
    $appli_id = AlkRequest::getToken("appli_id", "-1");
    $page = AlkRequest::_GETint("page", "1");
    $nbEltParPage = AlkRequest::_GETint("nbItemsPerPage", ALK_ITEMS_PER_PAGE);
    
    $strTitrePage = "Liste des modèles de message";
    $strTexteIntro = "Cette liste affiche les modèles accessibles et vous donne la possibilité de supprimer vos modèles.";
      
    $tBoite = 3;
    $msg_type = "4";

    $dsBoite = $this->oAppli->oQuery->getDsListeModeleMsg($appli_id, $user_id, ($page-1)*$nbEltParPage, $page*$nbEltParPage-1);
    $nbElt = $dsBoite->getCountTotDr();

    $this->setLabel($strTitrePage);
    $this->setLabelDesc($strTexteIntro."<br/>Nombre de messages : ".$nbElt ); 

    $strTokenPagine = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, $this->iSheet, ALK_SHEET_NONE);
    $oTabPage=AlkHtmlFactory::getHtmlList($this, $nbElt, $page, $nbEltParPage, true, 
                                          ALK_ALKANET."?token=".$strTokenPagine, 
                                          "Aucun message.", false, "tabPagine", true);
    $oTabPage->SetColumns(array("left", "250"),
                          array("left", "200"),
                          array("center", "70"),
                          array("center", "100"),
                          array("center", "60"));
                          
    $oTabPage->AddTitleRow("Sujet", "Auteur", "Etat", "Date enregist.", "Action");   
    while( $drBoite = $dsBoite->getRowIter() ) {
      $msg_id     = $drBoite->getValueName("MSG_ID");
      $msg_public = $drBoite->getValueName("MSG_PUBLIC");
      $strSujet   = $drBoite->getValueName("MSG_SUJET");
      $strDateEnr = $drBoite->getValueName("DATE_ENR");
      $strAuteur  = $drBoite->getValueName("AUTEUR");
      $agent_id   = $drBoite->getValueName("AGENT_ID");
      
      $oBtSuppr  = AlkHtmlFactory::getHtml("&nbsp;");
      if( $user_id == $agent_id || $right_id==ALK_APPLI_RIGHT_PUBLI ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_RECEPTION, ALK_SHEET_NONE, "&msg_id=".$msg_id);
        $oBtSuppr = AlkHtmlFactory::getHtmlButtonIcon("javascript:supprMsg('".$strToken."')", "supprimer", "Supprimer ce modèle");
      }
      
      $strAuteur = "<a href=\"javascript:OpenPopupFiche('agent', ".$agent_id.");\" title=\"Voir la fiche\">".$strAuteur."</a>";
      
      $msg_public = ( $msg_public == "0" ? "privé" : "public" );
      //$strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_THEME, ALK_SHEET_NONE, "&msg_id=".$msg_id."&tboite=".$tBoite);
      //$strSujet = "<a href=\"javascript:OpenMsg('".$strToken."')\">".$strSujet."</a>";
    
      $oTabPage->addRowByArray(array($strSujet, $strAuteur, $msg_public, $strDateEnr, $oBtSuppr));
    }
    
    $this->addPanel($oTabPage);
  }

  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    if ($this->iSheet == ALK_SHEET_RECEPTION){
      return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/help/lsdif_01_01_boitemsg_list.htm"); 
    } else if($this->iSheet == ALK_SHEET_ENVOYES) {
    	return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."lsdif/help/lsdif_01_01_boitemsg_list.htm"); 
    } else if($this->iSheet == ALK_SHEET_MESLISTES) {
      return "Ce référer au chapitre 'Mes listes' de l'annuaire."; 
    }
  
  }

}
?>