<xsl:template match="div">
  <div>
    <xsl:if test="@name!=''"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
    <xsl:if test="@id!=''"><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></xsl:if>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </div>
</xsl:template>

<xsl:template match="p">
  <p>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </p>
</xsl:template>

<xsl:template match="strong">
  <strong>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </strong>
</xsl:template>

<xsl:template match="b">
  <strong>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </strong>
</xsl:template>

<xsl:template match="em">
  <em>
    <xsl:apply-templates select="child::*"/>
  </em>
</xsl:template>

<xsl:template match="u">
  <u>
    <xsl:apply-templates select="child::*"/>
  </u>
</xsl:template>

<xsl:template match="sub">
  <sub>
    <xsl:apply-templates select="child::*"/>
  </sub>
</xsl:template>

<xsl:template match="sup">
  <sup>
    <xsl:apply-templates select="child::*"/>
  </sup>
</xsl:template>

<xsl:template match="br">
  <br/>
</xsl:template>

<xsl:template match="marquee">
  <marquee>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@onmouseover!=''"><xsl:attribute name="onmouseover"><xsl:value-of select="@onmouseover"/></xsl:attribute></xsl:if>
    <xsl:if test="@onmouseout!=''"><xsl:attribute name="onmouseout"><xsl:value-of select="@onmouseout"/></xsl:attribute></xsl:if>
    <xsl:if test="@scrollamount!=''"><xsl:attribute name="scrollamount"><xsl:value-of select="@scrollamount"/></xsl:attribute></xsl:if>
    <xsl:if test="@scrolldelay!=''"><xsl:attribute name="scrolldelay"><xsl:value-of select="@scrolldelay"/></xsl:attribute></xsl:if>
    <xsl:if test="@width!=''"><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
    <xsl:if test="@height!=''"><xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </marquee>
</xsl:template>

<xsl:template match="span">
  <span>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </span>
</xsl:template>

<xsl:template match="font">
  <font>
  <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@face!=''"><xsl:attribute name="face"><xsl:value-of select="@face"/></xsl:attribute></xsl:if>
    <xsl:if test="@size!=''"><xsl:attribute name="size"><xsl:value-of select="@size"/></xsl:attribute></xsl:if>
    <xsl:if test="@color!=''"><xsl:attribute name="color"><xsl:value-of select="@color"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </font>
</xsl:template>

<xsl:template match="hr">
  <hr>
    <xsl:if test="@color!=''"><xsl:attribute name="color"><xsl:value-of select="@color"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </hr>
</xsl:template>

<xsl:template match="h1">
  <h1>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </h1>
</xsl:template>

<xsl:template match="h2">
  <h2>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </h2>
</xsl:template>

<xsl:template match="h3">
  <h3>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </h3>
</xsl:template>

<xsl:template match="h4">
  <h4>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </h4>
</xsl:template>

<xsl:template match="h5">
  <h5>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </h5>
</xsl:template>

<xsl:template match="h6">
  <h6>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </h6>
</xsl:template>

<xsl:template match="img">
  <img>
    <xsl:if test="@id!=''"><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></xsl:if>
    <xsl:if test="@name!=''"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
    <xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:attribute name="border">0</xsl:attribute>
    <xsl:if test="@width!=''"><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
    <xsl:if test="@height!=''"><xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
    <xsl:if test="@usemap!=''"><xsl:attribute name="usemap"><xsl:value-of select="@usemap"/></xsl:attribute></xsl:if>
  </img>
</xsl:template>

<xsl:template match="a">
  <a>
    <xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
    <xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
    <xsl:attribute name="target"><xsl:value-of select="@target"/></xsl:attribute>
    <xsl:apply-templates select="child::*"/>
  </a>
</xsl:template>

<xsl:template match="ul">
  <ul>
    <xsl:apply-templates select="child::*"/>
  </ul>
</xsl:template>

<xsl:template match="ol">
  <ol>
    <xsl:apply-templates select="child::*"/>
  </ol>
</xsl:template>

<xsl:template match="li">
  <li>
    <xsl:apply-templates select="child::*"/>
  </li>
</xsl:template>

<xsl:template match="table">
  <table>
    <xsl:if test="@width!=''"><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
    <xsl:if test="@cellpadding!=''"><xsl:attribute name="cellpadding"><xsl:value-of select="@cellpadding"/></xsl:attribute></xsl:if>
    <xsl:if test="@cellspacing!=''"><xsl:attribute name="cellspacing"><xsl:value-of select="@cellspacing"/></xsl:attribute></xsl:if>
    <xsl:if test="@border!=''"><xsl:attribute name="border"><xsl:value-of select="@border"/></xsl:attribute></xsl:if>
    <xsl:if test="@bordercolor!=''"><xsl:attribute name="bordercolor"><xsl:value-of select="@bordercolor"/></xsl:attribute></xsl:if>
    <xsl:if test="@bgcolor!=''"><xsl:attribute name="bgcolor"><xsl:value-of select="@bgcolor"/></xsl:attribute></xsl:if>
    <xsl:if test="@background!=''"><xsl:attribute name="background"><xsl:value-of select="@background"/></xsl:attribute></xsl:if>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </table>
</xsl:template>

<xsl:template match="tr">
  <tr>
    <xsl:if test="@width!=''"><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
    <xsl:if test="@height!=''"><xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
    <xsl:if test="@bgcolor!=''"><xsl:attribute name="bgcolor"><xsl:value-of select="@bgcolor"/></xsl:attribute></xsl:if>
    <xsl:if test="@background!=''"><xsl:attribute name="background"><xsl:value-of select="@background"/></xsl:attribute></xsl:if>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </tr>
</xsl:template>

<xsl:template match="td">
  <td>
    <xsl:if test="@width!=''"><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
    <xsl:if test="@height!=''"><xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
    <xsl:if test="@bgcolor!=''"><xsl:attribute name="bgcolor"><xsl:value-of select="@bgcolor"/></xsl:attribute></xsl:if>
    <xsl:if test="@background!=''"><xsl:attribute name="background"><xsl:value-of select="@background"/></xsl:attribute></xsl:if>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:if test="@align!=''"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:if test="@valign!=''"><xsl:attribute name="valign"><xsl:value-of select="@valign"/></xsl:attribute></xsl:if>
    <xsl:if test="@colspan!=''"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
    <xsl:if test="@rowspan!=''"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </td>
</xsl:template>  

<xsl:template match="form">
  <form>
    <xsl:if test="@name!=''"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
    <xsl:if test="@action!=''"><xsl:attribute name="action"><xsl:value-of select="@action"/></xsl:attribute></xsl:if>
    <xsl:if test="@method!=''"><xsl:attribute name="method"><xsl:value-of select="@method"/></xsl:attribute></xsl:if>
    <xsl:if test="@enctype!=''"><xsl:attribute name="enctype"><xsl:value-of select="@enctype"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </form>
</xsl:template> 
  
<xsl:template match="input">
  <xsl:variable name="formId">
    <xsl:choose>
      <xsl:when test="ancestor::sondage"><xsl:value-of select="ancestor::sondage/@id"/></xsl:when>
      <xsl:when test="ancestor::form">
        <xsl:choose>
          <xsl:when test="ancestor::form/id"><xsl:value-of select="ancestor::form/id"/></xsl:when>
          <xsl:when test="ancestor::form/@id"><xsl:value-of select="ancestor::form/@id"/></xsl:when>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:variable>
  <input>
    <xsl:if test="@id!=''">
      <xsl:attribute name="id">
        form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@id"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@name!=''">
      <xsl:attribute name="name">form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@name"/></xsl:attribute>
    </xsl:if>
    <xsl:if test="@type!=''"><xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute></xsl:if>
    <xsl:if test="@size!=''"><xsl:attribute name="size"><xsl:value-of select="@size"/></xsl:attribute></xsl:if>
    <xsl:if test="@maxlength!=''"><xsl:attribute name="maxlength"><xsl:value-of select="@maxlength"/></xsl:attribute></xsl:if>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@checked!=''"><xsl:attribute name="checked">1</xsl:attribute></xsl:if>
    <xsl:if test="@value!=''"><xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute></xsl:if>
    <xsl:if test="@style!=''"><xsl:attribute name="style"><xsl:value-of select="@style"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </input>
  <xsl:if test="@typejs!=''">
    <script type="text/javascript">
		AlkAddCtrl('formulaire<xsl:value-of select="$formId"/>',
		  'form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@name"/>', 
		  '<xsl:value-of select="@typejs"/>', 
		  <xsl:choose>
		    <xsl:when test="@obligatoire='1'">true</xsl:when>
		    <xsl:otherwise>false</xsl:otherwise>
		  </xsl:choose>,
		  '', '', '', '', '', false, ''
		);
    </script>
  </xsl:if>
</xsl:template>  

<xsl:template match="textarea">
  <xsl:variable name="formId">
    <xsl:choose>
      <xsl:when test="ancestor::sondage"><xsl:value-of select="ancestor::sondage/@id"/></xsl:when>
      <xsl:when test="ancestor::form">
        <xsl:choose>
          <xsl:when test="ancestor::form/id"><xsl:value-of select="ancestor::form/id"/></xsl:when>
          <xsl:when test="ancestor::form/@id"><xsl:value-of select="ancestor::form/@id"/></xsl:when>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:variable>
  <textarea>
    <xsl:if test="@id!=''">
      <xsl:attribute name="id">
        form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@id"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@name!=''">
      <xsl:attribute name="name">form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@name"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@rows!=''"><xsl:attribute name="rows"><xsl:value-of select="@rows"/></xsl:attribute></xsl:if>
    <xsl:if test="@cols!=''"><xsl:attribute name="cols"><xsl:value-of select="@cols"/></xsl:attribute></xsl:if>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </textarea>
  <xsl:if test="@typejs!=''">
    <script type="text/javascript">
		AlkAddCtrl('formulaire<xsl:value-of select="$formId"/>',
		  'form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@name"/>',
		  'memo', 
		  <xsl:choose>
		    <xsl:when test="@obligatoire='1'">true</xsl:when>
		    <xsl:otherwise>false</xsl:otherwise>
		  </xsl:choose>,
		  '', '', '', '', '', false, ''
		);
    </script>
  </xsl:if>
</xsl:template>  

<xsl:template match="select">
  <xsl:variable name="formId">
    <xsl:choose>
      <xsl:when test="ancestor::sondage"><xsl:value-of select="ancestor::sondage/@id"/></xsl:when>
      <xsl:when test="ancestor::form">
        <xsl:choose>
          <xsl:when test="ancestor::form/id"><xsl:value-of select="ancestor::form/id"/></xsl:when>
          <xsl:when test="ancestor::form/@id"><xsl:value-of select="ancestor::form/@id"/></xsl:when>
        </xsl:choose>
      </xsl:when>
    </xsl:choose>
  </xsl:variable>
  <select>
    <xsl:if test="@size!=''">
      <xsl:attribute name="size"><xsl:value-of select="@size"/></xsl:attribute>
    </xsl:if>
    <xsl:if test="@id!=''">
      <xsl:attribute name="id">
        form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@id"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@name!=''">
      <xsl:attribute name="name">form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@name"/>
      </xsl:attribute>
    </xsl:if>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@onchange!=''"><xsl:attribute name="onchange"><xsl:value-of select="@onchange"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </select>
  <xsl:if test="@typejs!=''">
    <script type="text/javascript">
		AlkAddCtrl('formulaire<xsl:value-of select="$formId"/>',
		  'form_<xsl:value-of select="$formId"/>_<xsl:value-of select="@name"/>',
		  'select', 
		  <xsl:choose>
		    <xsl:when test="@obligatoire='1'">true</xsl:when>
		    <xsl:otherwise>false</xsl:otherwise>
		  </xsl:choose>,
		  '', '', '', '', '', false, ''
		);
    </script>
  </xsl:if>
</xsl:template>  

<xsl:template match="option">
  <option>
    <xsl:if test="@id!=''"><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></xsl:if>
    <xsl:if test="@name!=''"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
    <xsl:if test="@value!=''"><xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute></xsl:if>
    <xsl:if test="@class!=''"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if>
    <xsl:if test="@selected!=''"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </option>
</xsl:template> 

<xsl:template match="object">
  <object>
    <xsl:if test="@id!=''"><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></xsl:if>
    <xsl:if test="@codebase!=''"><xsl:attribute name="codebase"><xsl:value-of select="@codebase"/></xsl:attribute></xsl:if>
    <xsl:if test="@width!=''"><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
    <xsl:if test="@height!=''"><xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
    <xsl:if test="@classid!=''"><xsl:attribute name="classid"><xsl:value-of select="@classid"/></xsl:attribute></xsl:if>
    <xsl:if test="@viewastext!=''"><xsl:attribute name="viewastext">1</xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </object>
</xsl:template>  

<xsl:template match="param">
  <param>
    <xsl:if test="@id!=''"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
    <xsl:if test="@value!=''"><xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </param>
</xsl:template>  

<xsl:template match="embed">
  <embed>
    <xsl:if test="@src!=''"><xsl:attribute name="src"><xsl:value-of select="@src"/></xsl:attribute></xsl:if>
    <xsl:if test="@loop!=''"><xsl:attribute name="loop"><xsl:value-of select="@loop"/></xsl:attribute></xsl:if>
    <xsl:if test="@menu!=''"><xsl:attribute name="menu"><xsl:value-of select="@menu"/></xsl:attribute></xsl:if>
    <xsl:if test="@quality!=''"><xsl:attribute name="quality"><xsl:value-of select="@quality"/></xsl:attribute></xsl:if>
    <xsl:if test="@bgcolor!=''"><xsl:attribute name="bgcolor"><xsl:value-of select="@bgcolor"/></xsl:attribute></xsl:if>
    <xsl:if test="@width!=''"><xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute></xsl:if>
    <xsl:if test="@height!=''"><xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute></xsl:if>
    <xsl:if test="@name!=''"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
    <xsl:if test="@type!=''"><xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute></xsl:if>
    <xsl:if test="@pluginspage!=''"><xsl:attribute name="pluginspage"><xsl:value-of select="@pluginspage"/></xsl:attribute></xsl:if>
    <xsl:if test="@autostart!=''"><xsl:attribute name="autostart"><xsl:value-of select="@type"/></xsl:attribute></xsl:if>
    <xsl:if test="@charset!=''"><xsl:attribute name="charset"><xsl:value-of select="@charset"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </embed>
</xsl:template>  

<xsl:template match="map">
  <map>
    <xsl:if test="@id!=''"><xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute></xsl:if>
    <xsl:if test="@name!=''"><xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </map>
</xsl:template>

<xsl:template match="area">
  <area>
    <xsl:if test="@title!=''"><xsl:attribute name="title"><xsl:value-of select="@title"/></xsl:attribute></xsl:if>
    <xsl:if test="@alt!=''"><xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute></xsl:if>
    <xsl:if test="@shape!=''"><xsl:attribute name="shape"><xsl:value-of select="@shape"/></xsl:attribute></xsl:if>
    <xsl:if test="@coords!=''"><xsl:attribute name="coords"><xsl:value-of select="@coords"/></xsl:attribute></xsl:if>
    <xsl:if test="@href!=''"><xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute></xsl:if>
    <xsl:if test="@onmouseover!=''"><xsl:attribute name="onmouseover"><xsl:value-of select="@onmouseover"/></xsl:attribute></xsl:if>
    <xsl:if test="@onmouseout!=''"><xsl:attribute name="onmouseout"><xsl:value-of select="@onmouseout"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </area>
</xsl:template>

<xsl:template match="script">
  <script>
    <xsl:if test="@language!=''"><xsl:attribute name="language"><xsl:value-of select="@language"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </script>
</xsl:template>

<xsl:template match="SCRIPT">
  <script>
    <xsl:if test="@language!=''"><xsl:attribute name="language"><xsl:value-of select="@language"/></xsl:attribute></xsl:if>
    <xsl:apply-templates select="child::*"/>
  </script>
</xsl:template>

<xsl:template match="text">
  <xsl:value-of select="."/>
</xsl:template>
